/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.adapters;

import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import com.spaceman.tport.adapters.V1_21_6_FeatureTPAdapter;
import com.spaceman.tport.biomeTP.BiomePreset;
import com.spaceman.tport.commands.tport.FeatureTP;
import com.spaceman.tport.commands.tport.biomeTP.Accuracy;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;

public abstract class V1_21_6_BiomeTPAdapter
extends V1_21_6_FeatureTPAdapter {
    private IRegistry<BiomeBase> getBiomeRegistry(WorldServer worldServer) {
        return worldServer.K_().f(Registries.aK);
    }

    @Override
    public List<String> availableBiomes() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        World world = (World)Bukkit.getWorlds().get(0);
        WorldServer worldServer = (WorldServer)this.getWorldServer(world);
        IRegistry<BiomeBase> biomeRegistry = this.getBiomeRegistry(worldServer);
        return biomeRegistry.i().stream().map(MinecraftKey::a).map(String::toLowerCase).collect(Collectors.toList());
    }

    @Override
    public List<String> availableBiomes(World world) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        WorldServer worldServer = (WorldServer)this.getWorldServer(world);
        ChunkGenerator chunkGenerator = worldServer.n().g();
        IRegistry<BiomeBase> biomeRegistry = this.getBiomeRegistry(worldServer);
        WorldChunkManager worldChunkManager = chunkGenerator.d();
        return worldChunkManager.c().stream().map(b -> biomeRegistry.b((Object)((BiomeBase)b.a()))).filter(Objects::nonNull).map(MinecraftKey::a).map(String::toLowerCase).collect(Collectors.toList());
    }

    @Override
    public Pair<Location, String> biomeFinder(Player player, List<String> biomes, @Nonnull Location startLocation, Accuracy.AccuracySettings accuracy) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        int startX = startLocation.getBlockX();
        int startY = startLocation.getBlockY();
        int startZ = startLocation.getBlockZ();
        World world = startLocation.getWorld();
        if (world == null) {
            return null;
        }
        Rectangle searchArea = Main.getSearchArea(player);
        int size = accuracy.getRange();
        List<Integer> yLevels = accuracy.getYLevels();
        int increment = accuracy.getIncrement();
        int quartSize = size >> 2;
        int quartX = startX >> 2;
        int quartZ = startZ >> 2;
        WorldServer worldServer = (WorldServer)this.getWorldServer(world);
        ChunkGenerator chunkGenerator = worldServer.n().g();
        WorldChunkManager worldChunkManager = chunkGenerator.d();
        IRegistry<BiomeBase> biomeRegistry = this.getBiomeRegistry(worldServer);
        List<BiomeBase> baseList = biomes.stream().map(biome -> (BiomeBase)biomeRegistry.a(MinecraftKey.b((String)biome.toLowerCase()))).filter(Objects::nonNull).toList();
        Predicate<Holder> predicate = holder -> baseList.stream().anyMatch(biomeBase -> biomeBase.equals(holder.a()));
        Climate.Sampler climateSampler = worldServer.n().h().c().b();
        for (int squareSize = 0; squareSize <= quartSize; squareSize += increment) {
            for (int zOffset = -squareSize; zOffset <= squareSize; zOffset += increment) {
                boolean zEnd = Math.abs(zOffset) == squareSize;
                for (int xOffset = -squareSize; xOffset <= squareSize; xOffset += increment) {
                    boolean xEnd;
                    boolean bl = xEnd = Math.abs(zOffset) == squareSize;
                    if (!zEnd && !xEnd) continue;
                    int newX = quartX + xOffset;
                    int newZ = quartZ + zOffset;
                    if (!searchArea.contains(QuartPos.c((int)newX), QuartPos.c((int)newZ))) continue;
                    for (int y : yLevels) {
                        int newY = QuartPos.a((int)y);
                        Location blockPos = new Location(player.getWorld(), (double)QuartPos.c((int)newX), (double)startY, (double)QuartPos.c((int)newZ));
                        Holder currentBiome = worldChunkManager.getNoiseBiome(newX, newY, newZ, climateSampler);
                        if (!predicate.test(currentBiome)) continue;
                        return new Pair<Location, String>(blockPos, biomeRegistry.b((Object)((BiomeBase)currentBiome.a())).a());
                    }
                }
            }
        }
        return null;
    }

    @Override
    public ArrayList<BiomePreset> loadPresetsFromWorld(World world) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        WorldServer worldServer = (WorldServer)this.getWorldServer(world);
        IRegistry<BiomeBase> biomeRegistry = this.getBiomeRegistry(worldServer);
        ArrayList<BiomePreset> presets = new ArrayList<BiomePreset>();
        biomeRegistry.l().forEach(named -> {
            Material material;
            Stream values = named.a();
            List<String> biomes = values.map(holder -> (BiomeBase)holder.a()).map(arg_0 -> ((IRegistry)biomeRegistry).b(arg_0)).filter(Objects::nonNull).map(key -> key.a().toLowerCase()).toList();
            String tagKeyName = named.h().b().a().toLowerCase();
            if (tagKeyName.startsWith("has_structure/")) {
                material = FeatureTP.getMaterial(tagKeyName.substring(14));
            } else {
                String materialName = BiomePreset.getMaterialName(tagKeyName);
                material = Main.getOrDefault(Material.getMaterial((String)materialName), Material.DIAMOND_BLOCK);
            }
            presets.add(new BiomePreset("#" + tagKeyName, biomes, true, material, true));
        });
        return presets;
    }
}

