/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.adapters;

import com.spaceman.tport.Pair;
import com.spaceman.tport.adapters.TPortAdapter;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public abstract class V1_18_2_FeatureTPAdapter
extends TPortAdapter {
    private IRegistry<StructureFeature<?, ?>> getStructureRegistry(WorldServer worldServer) {
        return worldServer.s().d(IRegistry.aL);
    }

    @Override
    public Pair<Location, String> searchFeature(Player player, Location startLocation, List<String> features) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ArrayList featureList = new ArrayList();
        WorldServer worldServer = (WorldServer)this.getWorldServer(player.getWorld());
        IRegistry<StructureFeature<?, ?>> structureRegistry = this.getStructureRegistry(worldServer);
        for (String feature : features) {
            StructureFeature structure = (StructureFeature)structureRegistry.a(new MinecraftKey(feature));
            Optional optional = structureRegistry.c((Object)structure);
            if (!optional.isPresent()) continue;
            Holder holder = structureRegistry.c((ResourceKey)optional.get());
            featureList.add(holder);
        }
        return this.featureFinder(player, startLocation, featureList);
    }

    private double distToLowCornerSqr(BlockPosition b1, BlockPosition b2) {
        double deltaX = b1.u() - b2.u();
        double deltaY = b1.v() - b2.v();
        double deltaZ = b1.w() - b2.w();
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    private Pair<Location, String> featureFinder(@Nullable Player player, Location startLocation, List<Holder<StructureFeature<?, ?>>> featureList) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        BlockPosition startPosition = new BlockPosition(startLocation.getBlockX(), startLocation.getBlockY(), startLocation.getBlockZ());
        WorldServer worldServer = (WorldServer)this.getWorldServer(startLocation.getWorld());
        IRegistry<StructureFeature<?, ?>> structureRegistry = this.getStructureRegistry(worldServer);
        Set generateInBiomesList = featureList.stream().flatMap(holder -> ((StructureFeature)holder.a()).a().a()).collect(Collectors.toSet());
        if (generateInBiomesList.isEmpty()) {
            ColorTheme.sendErrorTranslation(player, "tport.command.featureTP.search.feature.featuresNotGenerating", new Object[0]);
            return null;
        }
        ChunkGenerator chunkGenerator = worldServer.k().g();
        WorldChunkManager worldChunkManager = chunkGenerator.e();
        Set generatedBiomes = worldChunkManager.b();
        if (Collections.disjoint(generatedBiomes, generateInBiomesList)) {
            ColorTheme.sendErrorTranslation(player, "tport.command.featureTP.search.feature.featuresNotGeneratingInWorld", new Object[0]);
            return null;
        }
        com.mojang.datafixers.util.Pair closestPair = null;
        Object2ObjectArrayMap placementMap = new Object2ObjectArrayMap();
        for (Holder<StructureFeature<?, ?>> structureHolder : featureList) {
            HolderSet generateInBiomes = ((StructureFeature)structureHolder.a()).a();
            if (!generatedBiomes.stream().anyMatch(arg_0 -> ((HolderSet)generateInBiomes).a(arg_0))) continue;
            Method m = ChunkGenerator.class.getDeclaredMethod("b", Holder.class);
            m.setAccessible(true);
            List l = (List)m.invoke((Object)chunkGenerator, structureHolder);
            for (StructurePlacement structureplacement : l) {
                placementMap.computeIfAbsent(structureplacement, unusedStructurePlacement -> new ObjectArraySet()).add(structureHolder);
            }
        }
        ArrayList placementList = new ArrayList(placementMap.size());
        double closestDistance = Double.MAX_VALUE;
        for (Map.Entry entry : placementMap.entrySet()) {
            StructurePlacement structureplacement = (StructurePlacement)entry.getKey();
            if (structureplacement instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)structureplacement;
                Method m = ChunkGenerator.class.getDeclaredMethod("a", BlockPosition.class, ConcentricRingsStructurePlacement.class);
                m.setAccessible(true);
                Object[] objectArray = new Object[]{startPosition, concentricringsstructureplacement};
                BlockPosition blockPosition = (BlockPosition)m.invoke((Object)chunkGenerator, objectArray);
                double distance = this.distToLowCornerSqr(startPosition, blockPosition);
                if (!(distance < closestDistance)) continue;
                closestDistance = distance;
                closestPair = com.mojang.datafixers.util.Pair.of((Object)blockPosition, (Object)((Holder)((Set)entry.getValue()).iterator().next()));
                continue;
            }
            if (!(structureplacement instanceof RandomSpreadStructurePlacement)) continue;
            placementList.add(entry);
        }
        if (!placementList.isEmpty()) {
            int sectionX = startLocation.getBlockX() >> 4;
            int sectionZ = startLocation.getBlockZ() >> 4;
            for (int squareSize = 0; squareSize <= 100; ++squareSize) {
                boolean foundThisRound = false;
                for (Map.Entry entry : placementList) {
                    RandomSpreadStructurePlacement randomspreadstructureplacement = (RandomSpreadStructurePlacement)entry.getKey();
                    Method m = ChunkGenerator.class.getDeclaredMethod("a", Set.class, IWorldReader.class, StructureManager.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Long.TYPE, RandomSpreadStructurePlacement.class);
                    m.setAccessible(true);
                    com.mojang.datafixers.util.Pair pairCandidate = (com.mojang.datafixers.util.Pair)m.invoke((Object)chunkGenerator, entry.getValue(), worldServer, worldServer.a(), sectionX, sectionZ, squareSize, false, worldServer.D(), randomspreadstructureplacement);
                    if (pairCandidate == null) continue;
                    foundThisRound = true;
                    BlockPosition blockPos = (BlockPosition)pairCandidate.getFirst();
                    double distance = this.distToLowCornerSqr(startPosition, blockPos);
                    if (!(distance < closestDistance)) continue;
                    closestDistance = distance;
                    closestPair = pairCandidate;
                }
                if (!foundThisRound) continue;
                if (closestPair == null) {
                    return null;
                }
                BlockPosition blockPos = (BlockPosition)closestPair.getFirst();
                return new Pair<Location, String>(new Location(startLocation.getWorld(), (double)blockPos.u(), 200.0, (double)blockPos.w()), structureRegistry.b((Object)((StructureFeature)((Holder)closestPair.getSecond()).a())).a());
            }
        }
        if (closestPair == null) {
            return null;
        }
        BlockPosition blockPos = (BlockPosition)closestPair.getFirst();
        return new Pair<Location, String>(new Location(startLocation.getWorld(), (double)blockPos.u(), 200.0, (double)blockPos.w()), structureRegistry.b((Object)((StructureFeature)((Holder)closestPair.getSecond()).a())).a());
    }

    @Override
    public List<String> availableFeatures() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        World world = (World)Bukkit.getWorlds().get(0);
        WorldServer worldServer = (WorldServer)this.getWorldServer(world);
        IRegistry<StructureFeature<?, ?>> structureRegistry = this.getStructureRegistry(worldServer);
        ArrayList<String> list = new ArrayList<String>();
        for (MinecraftKey minecraftKey : structureRegistry.d()) {
            String lowerCase = minecraftKey.a().toLowerCase();
            list.add(lowerCase);
        }
        return list;
    }

    @Override
    public List<String> availableFeatures(World world) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        ArrayList<String> returnList = new ArrayList<String>();
        WorldServer worldServer = (WorldServer)this.getWorldServer(world);
        IRegistry<StructureFeature<?, ?>> structureRegistry = this.getStructureRegistry(worldServer);
        ChunkGenerator chunkGenerator = worldServer.k().g();
        WorldChunkManager worldChunkManager = chunkGenerator.e();
        Set generatedBiomes = worldChunkManager.b();
        for (MinecraftKey minecraftKey : structureRegistry.d()) {
            StructureFeature structure = (StructureFeature)structureRegistry.a(minecraftKey);
            HashSet generateInBiomesList = new HashSet();
            HolderSet biomes = structure.a();
            Stream biomeStream = biomes.a();
            biomeStream.forEach(generateInBiomesList::add);
            if (generateInBiomesList.isEmpty() || Collections.disjoint(generatedBiomes, generateInBiomesList)) continue;
            returnList.add(minecraftKey.a());
        }
        return returnList;
    }

    @Override
    public List<Pair<String, List<String>>> getFeatureTags(World world) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException {
        ArrayList<Pair<String, List<String>>> list = new ArrayList<Pair<String, List<String>>>();
        WorldServer worldServer = (WorldServer)this.getWorldServer(world);
        IRegistry<StructureFeature<?, ?>> structureRegistry = this.getStructureRegistry(worldServer);
        List<String> tags = structureRegistry.h().map(tagKey -> tagKey.b().a()).toList();
        for (String tagKeyName : tags) {
            TagKey tagKey2 = TagKey.a((ResourceKey)IRegistry.aL, (MinecraftKey)new MinecraftKey(tagKeyName));
            Optional optional = structureRegistry.c(tagKey2);
            if (!optional.isPresent()) continue;
            HolderSet.Named named = (HolderSet.Named)optional.get();
            Stream values = named.a();
            List<String> features = values.map(holder -> (StructureFeature)holder.a()).map(arg_0 -> structureRegistry.b(arg_0)).filter(Objects::nonNull).map(key -> key.a().toLowerCase()).toList();
            list.add(new Pair<CallSite, List<String>>((CallSite)((Object)("#" + tagKeyName.toLowerCase())), features));
        }
        return list;
    }
}

