/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.adapters;

import com.spaceman.tport.adapters.ReflectionManager;
import com.spaceman.tport.adapters.V1_18_2_BiomeTPAdapter;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.inventories.keyboard.QuickType;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayOutChat;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftContainer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class V1_18_2_FancyMessageAdapter
extends V1_18_2_BiomeTPAdapter {
    private BlockPosition newBlockPosition(Location l) {
        return new BlockPosition(l.getBlockX(), l.getBlockY(), l.getBlockZ());
    }

    @Override
    public void setDisplayName(ItemStack itemStack, @Nonnull Message title, ColorTheme theme) throws IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        String version = ReflectionManager.getServerClassesVersion();
        Class<?> craftItemStack = Class.forName("org.bukkit.craftbukkit." + version + "inventory.CraftItemStack");
        Class<?> isClass = Class.forName("org.bukkit.inventory.ItemStack");
        net.minecraft.world.item.ItemStack nmsStack = (net.minecraft.world.item.ItemStack)craftItemStack.getMethod("asNMSCopy", isClass).invoke(craftItemStack, itemStack);
        Class<?> itemStackClass = nmsStack.getClass();
        NBTTagCompound tag = this.getNBTTag(nmsStack);
        NBTTagCompound display = this.getCompound(tag, "display");
        this.putString(display, "Name", title.translateJSON(theme));
        this.put(tag, "display", display);
        ItemMeta im = (ItemMeta)craftItemStack.getMethod("getItemMeta", itemStackClass).invoke(craftItemStack, nmsStack);
        itemStack.setItemMeta(im);
    }

    @Override
    public void setLore(ItemStack itemStack, @Nonnull Collection<Message> lore, ColorTheme theme) throws ClassNotFoundException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String version = ReflectionManager.getServerClassesVersion();
        Class<?> craftItemStack = Class.forName("org.bukkit.craftbukkit." + version + "inventory.CraftItemStack");
        Class<?> isClass = Class.forName("org.bukkit.inventory.ItemStack");
        net.minecraft.world.item.ItemStack nmsStack = (net.minecraft.world.item.ItemStack)craftItemStack.getMethod("asNMSCopy", isClass).invoke(craftItemStack, itemStack);
        Class<?> itemStackClass = nmsStack.getClass();
        NBTTagCompound tag = this.getNBTTag(nmsStack);
        NBTTagCompound display = this.getCompound(tag, "display");
        NBTTagList loreT = new NBTTagList();
        int id = 0;
        for (Message line : lore) {
            if (line == null) continue;
            this.listTag_addTag(loreT, id++, NBTTagString.a((String)line.translateJSON(theme)));
        }
        this.put(display, "Lore", loreT);
        this.put(tag, "display", display);
        ItemMeta im = (ItemMeta)craftItemStack.getMethod("getItemMeta", itemStackClass).invoke(craftItemStack, nmsStack);
        itemStack.setItemMeta(im);
    }

    public NBTTagCompound getNBTTag(net.minecraft.world.item.ItemStack nmsStack) {
        return nmsStack.u();
    }

    public NBTTagCompound getCompound(NBTTagCompound tag, String name) {
        return tag.p(name);
    }

    public void putString(NBTTagCompound tag, String name, String data) {
        tag.a(name, data);
    }

    public NBTBase put(NBTTagCompound tag, String name, Object tagData) {
        return tag.a(name, (NBTBase)tagData);
    }

    public void listTag_addTag(NBTTagList tagList, int index, Object toAdd) {
        tagList.b(index, (NBTBase)toAdd);
    }

    @Override
    public void sendMessage(Player player, String message) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        IChatMutableComponent chatComponent = IChatBaseComponent.ChatSerializer.a((String)message);
        PacketPlayOutChat packet = new PacketPlayOutChat((IChatBaseComponent)chatComponent, ChatMessageType.a, player.getUniqueId());
        this.sendPlayerPacket(player, packet);
    }

    @Override
    public void sendTitle(Player player, String message, Message.TitleTypes titleType, int fadeIn, int displayTime, int fadeOut) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        IChatMutableComponent text = IChatBaseComponent.ChatSerializer.a((String)message);
        Class<?> packetClass = Class.forName("net.minecraft.network.protocol.game." + titleType.getMCClass());
        Class<?> chatComponent = Class.forName("net.minecraft.network.chat.IChatBaseComponent");
        Packet packetObject = (Packet)packetClass.getConstructor(chatComponent).newInstance(text);
        if (fadeIn != -1 || displayTime != -1 || fadeOut != -1) {
            ClientboundSetTitlesAnimationPacket clientboundSetTitlesAnimationPacket = new ClientboundSetTitlesAnimationPacket(fadeIn, displayTime, fadeOut);
            this.sendPlayerPacket(player, clientboundSetTitlesAnimationPacket);
        }
        this.sendPlayerPacket(player, packetObject);
    }

    @Override
    public void sendInventory(Player player, String stringTitle, Inventory inventory) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException {
        IChatMutableComponent chatSerializer = IChatBaseComponent.ChatSerializer.a((String)stringTitle);
        EntityPlayer entityPlayer = (EntityPlayer)this.getEntityPlayer(player);
        CraftContainer container = new CraftContainer(inventory, (EntityHuman)entityPlayer, entityPlayer.nextContainerCounter());
        Containers windowType = CraftContainer.getNotchInventoryType((Inventory)inventory);
        this.sendPlayerPacket(player, new PacketPlayOutOpenWindow(container.j, windowType, (IChatBaseComponent)chatSerializer));
        entityPlayer.bV = container;
        entityPlayer.a((Container)container);
    }

    @Override
    public void sendSignEditor(Player player, Location loc) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        this.sendPlayerPacket(player, new PacketPlayOutOpenSignEditor(this.newBlockPosition(loc)));
    }

    @Override
    public void setQuickTypeSignHandler(Player player) throws IllegalAccessException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        ChannelDuplexHandler channelDuplexHandler = V1_18_2_FancyMessageAdapter.getChannelDuplexHandler(player);
        PlayerConnection playerConnection = (PlayerConnection)this.getPlayerConnection(player);
        NetworkManager networkManager = ReflectionManager.getPrivateField(NetworkManager.class, playerConnection);
        Channel channel = networkManager.m;
        ChannelPipeline pipeline = channel.pipeline();
        if (pipeline.context("fancyMessage_quickType") != null) {
            this.removeQuickTypeSignHandler(player);
        }
        pipeline.addBefore("packet_handler", "fancyMessage_quickType", (ChannelHandler)channelDuplexHandler);
    }

    @Nonnull
    private static ChannelDuplexHandler getChannelDuplexHandler(Player player) {
        final UUID uuid = player.getUniqueId();
        return new ChannelDuplexHandler(){

            public void channelRead(ChannelHandlerContext ctx, Object packet) throws Exception {
                PacketPlayInUpdateSign inUpdateSign;
                String[] lines;
                if (packet instanceof PacketPlayInUpdateSign && QuickType.onSignEdit(lines = (inUpdateSign = (PacketPlayInUpdateSign)packet).c(), uuid)) {
                    return;
                }
                super.channelRead(ctx, packet);
            }
        };
    }

    @Override
    public void removeQuickTypeSignHandler(Player player) throws IllegalAccessException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException {
        PlayerConnection playerConnection = (PlayerConnection)this.getPlayerConnection(player);
        NetworkManager networkManager = ReflectionManager.getPrivateField(NetworkManager.class, playerConnection);
        Channel channel = networkManager.m;
        channel.eventLoop().submit(() -> channel.pipeline().remove("fancyMessage_quickType"));
    }

    @Override
    public void sendBlockChange(Player player, Location blockLoc, Block block) {
        player.sendBlockChange(blockLoc, block.getBlockData());
    }

    @Override
    public void sendBlockChange(Player player, Location blockLoc, Material material) {
        player.sendBlockChange(blockLoc, material.createBlockData());
    }
}

