/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.adapters;

import com.spaceman.tport.Pair;
import com.spaceman.tport.adapters.ReflectionManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class AdaptiveReflectionManager {
    private static <c> ResourceKey<IRegistry<c>> getResourceKey(Class<c> c) throws IllegalAccessException, ClassNotFoundException {
        for (Field f : AdaptiveReflectionManager.getRegistryClass().getDeclaredFields()) {
            Type resourceKeyType;
            ParameterizedType p;
            Type iRegistryType;
            ParameterizedType pp;
            Type type;
            if (!f.getType().equals(ResourceKey.class) || !(type = (pp = (ParameterizedType)(iRegistryType = (p = (ParameterizedType)(resourceKeyType = f.getGenericType())).getActualTypeArguments()[0])).getActualTypeArguments()[0]).getTypeName().equals(c.getName())) continue;
            return (ResourceKey)f.get(null);
        }
        return null;
    }

    public static ResourceKey<IRegistry<BiomeBase>> getBiomeResourceKey() throws IllegalAccessException, ClassNotFoundException {
        return AdaptiveReflectionManager.getResourceKey(BiomeBase.class);
    }

    public static IRegistry<BiomeBase> getBiomeRegistry(WorldServer worldServer) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        IRegistryCustom i = ReflectionManager.get(IRegistryCustom.class, worldServer);
        return ReflectionManager.get(IRegistry.class, i, AdaptiveReflectionManager.getBiomeResourceKey());
    }

    public static WorldChunkManager getWorldChunkManager(ChunkGenerator chunkGenerator) throws InvocationTargetException, IllegalAccessException {
        return ReflectionManager.get(WorldChunkManager.class, chunkGenerator);
    }

    public static Climate.Sampler getClimateSampler(WorldServer worldServer) throws InvocationTargetException, IllegalAccessException {
        ChunkProviderServer cps = ReflectionManager.get(ChunkProviderServer.class, worldServer);
        try {
            Object cgst = ReflectionManager.get(Class.forName("net.minecraft.world.level.chunk.ChunkGeneratorStructureState"), cps);
            RandomState randomState = ReflectionManager.get(RandomState.class, cgst);
            return ReflectionManager.get(Climate.Sampler.class, randomState);
        }
        catch (ClassNotFoundException e) {
            ChunkGenerator cg = ReflectionManager.get(ChunkGenerator.class, cps);
            return ReflectionManager.get(Climate.Sampler.class, cg);
        }
    }

    public static ChunkGenerator getChunkGenerator(WorldServer worldServer) throws InvocationTargetException, IllegalAccessException {
        ChunkProviderServer cps = ReflectionManager.get(ChunkProviderServer.class, worldServer);
        return ReflectionManager.get(ChunkGenerator.class, cps);
    }

    public static Set<Holder<BiomeBase>> getGeneratedBiomes(WorldChunkManager worldChunkManager) throws InvocationTargetException, IllegalAccessException {
        return ReflectionManager.get(Set.class, worldChunkManager);
    }

    public static <T> Stream<HolderSet.Named<T>> l(IRegistry<T> registry) throws InvocationTargetException, IllegalAccessException {
        for (Method m : registry.getClass().getMethods()) {
            if (!m.getReturnType().equals(Stream.class) || !m.getGenericReturnType().getTypeName().contains("HolderSet") || m.getParameterCount() != 0) continue;
            return (Stream)m.invoke(registry, new Object[0]);
        }
        return Stream.empty();
    }

    public static <T> TagKey<T> key(HolderSet.Named<T> named) throws InvocationTargetException, IllegalAccessException {
        return ReflectionManager.get(TagKey.class, named);
    }

    public static <T> MinecraftKey minecraftKey(TagKey<T> tagKey) throws InvocationTargetException, IllegalAccessException {
        return ReflectionManager.get(MinecraftKey.class, tagKey);
    }

    public static <T> Stream<com.mojang.datafixers.util.Pair<TagKey<T>, HolderSet.Named<T>>> getTags(IRegistry<T> registry) throws InvocationTargetException, IllegalAccessException {
        for (Method m : registry.getClass().getMethods()) {
            if (!m.getReturnType().equals(Stream.class) || !m.getGenericReturnType().getTypeName().contains("Pair") || m.getParameterCount() != 0) continue;
            return (Stream)m.invoke(registry, new Object[0]);
        }
        return Stream.empty();
    }

    public static <T> Optional<HolderSet.Named<T>> getTag(IRegistry<T> biomeRegistry, TagKey<T> tagKey) throws InvocationTargetException, IllegalAccessException {
        return ReflectionManager.get(Optional.class, biomeRegistry, tagKey);
    }

    public static <T> Optional<ResourceKey<T>> getResourceKey(IRegistry<T> registry, T t) throws InvocationTargetException, IllegalAccessException {
        return ReflectionManager.get(Optional.class, registry, t, Object.class);
    }

    public static MinecraftKey getMinecraftKeyFromTag(TagKey<?> tagKey) throws InvocationTargetException, IllegalAccessException {
        return ReflectionManager.get(MinecraftKey.class, tagKey);
    }

    public static <T> Holder<T> wrapAsHolder(IRegistry<T> registry, T t) throws InvocationTargetException, IllegalAccessException {
        return ReflectionManager.get(Holder.class, registry, t, Object.class);
    }

    public static <T> T getValueFromHolder(Holder<T> holder) throws InvocationTargetException, IllegalAccessException {
        return (T)ReflectionManager.get(Object.class, holder);
    }

    public static <T> MinecraftKey getKeyFromRegistry(IRegistry<T> registry, Holder<T> holder) throws InvocationTargetException, IllegalAccessException {
        return ReflectionManager.get(MinecraftKey.class, registry, AdaptiveReflectionManager.getValueFromHolder(holder), Object.class);
    }

    public static <T> T getFromRegistry(IRegistry<T> registry, String value) throws InvocationTargetException, IllegalAccessException {
        MinecraftKey key = AdaptiveReflectionManager.getMinecraftKey(value);
        return AdaptiveReflectionManager.getFromRegistry(registry, key);
    }

    public static <T> T getFromRegistry(IRegistry<T> biomeRegistry, MinecraftKey key) throws InvocationTargetException, IllegalAccessException {
        return (T)ReflectionManager.get(Object.class, biomeRegistry, key);
    }

    public static Set<MinecraftKey> keySet_fromRegistry(IRegistry<?> registry) throws InvocationTargetException, IllegalAccessException {
        for (Method m : registry.getClass().getMethods()) {
            if (!m.getReturnType().equals(Set.class) || !m.getGenericReturnType().getTypeName().contains("MinecraftKey") || m.getParameterCount() != 0) continue;
            return (Set)m.invoke(registry, new Object[0]);
        }
        return new HashSet<MinecraftKey>();
    }

    public static String getPathFromMinecraftKey(MinecraftKey key) {
        return key.toString().split(":")[1];
    }

    public static ChunkGeneratorStructureState getChunkGeneratorStructureState(WorldServer worldServer) throws InvocationTargetException, IllegalAccessException {
        ChunkProviderServer cpd = ReflectionManager.get(ChunkProviderServer.class, worldServer);
        return ReflectionManager.get(ChunkGeneratorStructureState.class, cpd);
    }

    public static ResourceKey<IRegistry<Structure>> getStructureResourceKey() throws IllegalAccessException, ClassNotFoundException {
        return AdaptiveReflectionManager.getResourceKey(Structure.class);
    }

    public static IRegistry<Structure> getStructureRegistry(WorldServer worldServer) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        IRegistryCustom i = ReflectionManager.get(IRegistryCustom.class, worldServer);
        return ReflectionManager.get(IRegistry.class, i, AdaptiveReflectionManager.getStructureResourceKey());
    }

    public static <T> boolean contains(HolderSet<T> holderSet, Holder<T> holderToSearch) {
        try {
            Boolean o = ReflectionManager.get(Boolean.TYPE, holderSet, holderToSearch, Holder.class);
            return Boolean.TRUE.equals(o);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return false;
        }
    }

    public static HolderSet<BiomeBase> getGenerateInBiomes(Holder<Structure> holder) throws InvocationTargetException, IllegalAccessException {
        return AdaptiveReflectionManager.getGenerateInBiomes(AdaptiveReflectionManager.getValueFromHolder(holder));
    }

    public static HolderSet<BiomeBase> getGenerateInBiomes(Structure structure) throws InvocationTargetException, IllegalAccessException {
        return ReflectionManager.get(HolderSet.class, structure);
    }

    public static Set<Holder<BiomeBase>> generateBiomesInListHolder(List<Holder<Structure>> featureList) throws InvocationTargetException, IllegalAccessException {
        HashSet<Holder<BiomeBase>> returnSet = new HashSet<Holder<BiomeBase>>();
        for (Holder<Structure> holder : featureList) {
            HolderSet<BiomeBase> biomes = AdaptiveReflectionManager.getGenerateInBiomes(holder);
            Stream biomeStream = ReflectionManager.get(Stream.class, biomes);
            biomeStream.forEach(returnSet::add);
        }
        return returnSet;
    }

    public static Set<Holder<BiomeBase>> getGenerateBiomesAsSet(Structure structure) throws InvocationTargetException, IllegalAccessException {
        HashSet<Holder<BiomeBase>> returnSet = new HashSet<Holder<BiomeBase>>();
        HolderSet<BiomeBase> biomes = AdaptiveReflectionManager.getGenerateInBiomes(structure);
        Stream biomeStream = ReflectionManager.get(Stream.class, biomes);
        biomeStream.forEach(returnSet::add);
        return returnSet;
    }

    public static List<StructurePlacement> getPlacementsForStructure(ChunkGeneratorStructureState chunkGeneratorStructureState, Holder<Structure> structureHolder) throws InvocationTargetException, IllegalAccessException {
        ReflectionManager.get(List.class, chunkGeneratorStructureState, structureHolder);
        return chunkGeneratorStructureState.a(structureHolder);
    }

    public static StructureManager getStructureManager(WorldServer worldServer) throws InvocationTargetException, IllegalAccessException {
        return ReflectionManager.get(StructureManager.class, worldServer);
    }

    @Nullable
    public static Pair<BlockPosition, Holder<Structure>> getNearestGeneratedStructure(ChunkGenerator chunkGenerator, Set<Holder<Structure>> structureSet, WorldServer worldServer, BlockPosition startPosition, ConcentricRingsStructurePlacement concentricRingsStructurePlacement) throws InvocationTargetException, IllegalAccessException {
        for (Method m : ChunkGenerator.class.getDeclaredMethods()) {
            Parameter[] parameters = m.getParameters();
            if (parameters.length != 6 || !m.getReturnType().equals(com.mojang.datafixers.util.Pair.class)) continue;
            m.setAccessible(true);
            com.mojang.datafixers.util.Pair p = (com.mojang.datafixers.util.Pair)m.invoke((Object)chunkGenerator, structureSet, worldServer, AdaptiveReflectionManager.getStructureManager(worldServer), startPosition, false, concentricRingsStructurePlacement);
            if (p == null) {
                return null;
            }
            return new Pair<BlockPosition, Holder<Structure>>((BlockPosition)p.getFirst(), (Holder)p.getSecond());
        }
        return null;
    }

    @Nullable
    public static Pair<BlockPosition, Holder<Structure>> getNearestGeneratedStructure(ChunkGenerator chunkGenerator, Set<Holder<Structure>> structureSet, WorldServer worldServer, int sectionX, int sectionZ, int squareSize, long seed, RandomSpreadStructurePlacement randomSpreadStructurePlacement) throws InvocationTargetException, IllegalAccessException {
        for (Method m : ChunkGenerator.class.getDeclaredMethods()) {
            Parameter[] parameters = m.getParameters();
            if (parameters.length != 9 || !m.getReturnType().equals(com.mojang.datafixers.util.Pair.class)) continue;
            m.setAccessible(true);
            com.mojang.datafixers.util.Pair p = (com.mojang.datafixers.util.Pair)m.invoke((Object)chunkGenerator, structureSet, worldServer, AdaptiveReflectionManager.getStructureManager(worldServer), sectionX, sectionZ, squareSize, false, seed, randomSpreadStructurePlacement);
            if (p == null) {
                return null;
            }
            return new Pair<BlockPosition, Holder<Structure>>((BlockPosition)p.getFirst(), (Holder)p.getSecond());
        }
        return null;
    }

    public static long getWorldSeed(ChunkGeneratorStructureState chunkGeneratorStructureState) throws InvocationTargetException, IllegalAccessException {
        return ReflectionManager.get(Long.TYPE, chunkGeneratorStructureState);
    }

    public static int[] getPosition(BlockPosition blockPosition) {
        String[] split = blockPosition.toString().split("[=,} ]");
        int x = Integer.parseInt(split[1]);
        int y = Integer.parseInt(split[4]);
        int z = Integer.parseInt(split[7]);
        return new int[]{x, y, z};
    }

    public static MinecraftKey getMinecraftKey(String key) {
        return MinecraftKey.b((String)key);
    }

    public static Class<?> getRegistryClass() throws ClassNotFoundException {
        String version = ReflectionManager.getServerClassesVersion();
        int mainVersion = Integer.parseInt(version.split("_")[1]);
        if (mainVersion > 19) {
            return Class.forName("net.minecraft.core.registries.Registries");
        }
        if (mainVersion == 19) {
            String subVersion = version.split("_")[2];
            if (subVersion.equals("R1") || subVersion.equals("R2")) {
                return Class.forName("net.minecraft.core.IRegistry");
            }
            return Class.forName("net.minecraft.core.registries.Registries");
        }
        return Class.forName("net.minecraft.core.IRegistry");
    }
}

