/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.adapters;

import com.spaceman.tport.Pair;
import com.spaceman.tport.adapters.AdaptiveReflectionManager;
import com.spaceman.tport.adapters.ReflectionManager;
import com.spaceman.tport.adapters.TPortAdapter;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public abstract class AdaptiveFeatureTP
extends TPortAdapter {
    @Override
    public Pair<Location, String> searchFeature(Player player, Location startLocation, List<String> features) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException {
        ArrayList<Holder<Structure>> featureList = new ArrayList<Holder<Structure>>();
        WorldServer worldServer = (WorldServer)this.getWorldServer(player.getWorld());
        IRegistry<Structure> structureRegistry = AdaptiveReflectionManager.getStructureRegistry(worldServer);
        for (String feature : features) {
            Structure structure = AdaptiveReflectionManager.getFromRegistry(structureRegistry, feature);
            Optional<ResourceKey<Structure>> optional = AdaptiveReflectionManager.getResourceKey(structureRegistry, structure);
            if (!optional.isPresent()) continue;
            Holder<Structure> holder = AdaptiveReflectionManager.wrapAsHolder(structureRegistry, structure);
            featureList.add(holder);
        }
        return this.featureFinder(player, startLocation, featureList);
    }

    private double distToLowCornerSqr(BlockPosition b1, BlockPosition b2) {
        int[] loc1 = AdaptiveReflectionManager.getPosition(b1);
        int[] loc2 = AdaptiveReflectionManager.getPosition(b2);
        double deltaX = loc1[0] - loc2[0];
        double deltaY = loc1[1] - loc2[1];
        double deltaZ = loc1[2] - loc2[2];
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    private Pair<Location, String> featureFinder(@Nullable Player player, Location startLocation, List<Holder<Structure>> featureList) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException {
        BlockPosition startPosition = new BlockPosition(startLocation.getBlockX(), startLocation.getBlockY(), startLocation.getBlockZ());
        WorldServer worldServer = (WorldServer)this.getWorldServer(startLocation.getWorld());
        IRegistry<Structure> structureRegistry = AdaptiveReflectionManager.getStructureRegistry(worldServer);
        Set<Holder<BiomeBase>> generateInBiomesList = AdaptiveReflectionManager.generateBiomesInListHolder(featureList);
        if (generateInBiomesList.isEmpty()) {
            ColorTheme.sendErrorTranslation(player, "tport.command.featureTP.search.feature.featuresNotGenerating", new Object[0]);
            return null;
        }
        ChunkGenerator chunkGenerator = AdaptiveReflectionManager.getChunkGenerator(worldServer);
        WorldChunkManager worldChunkManager = AdaptiveReflectionManager.getWorldChunkManager(chunkGenerator);
        Set<Holder<BiomeBase>> generatedBiomes = AdaptiveReflectionManager.getGeneratedBiomes(worldChunkManager);
        if (Collections.disjoint(generatedBiomes, generateInBiomesList)) {
            ColorTheme.sendErrorTranslation(player, "tport.command.featureTP.search.feature.featuresNotGeneratingInWorld", new Object[0]);
            return null;
        }
        Object2ObjectArrayMap placementMap = new Object2ObjectArrayMap();
        ChunkGeneratorStructureState chunkGeneratorStructureState = AdaptiveReflectionManager.getChunkGeneratorStructureState(worldServer);
        for (Holder<Structure> structureHolder : featureList) {
            HolderSet<BiomeBase> generateInBiomes = AdaptiveReflectionManager.getGenerateInBiomes(structureHolder);
            if (!generatedBiomes.stream().anyMatch(biomeHolder -> AdaptiveReflectionManager.contains(generateInBiomes, biomeHolder))) continue;
            List<StructurePlacement> structurePlacements = AdaptiveReflectionManager.getPlacementsForStructure(chunkGeneratorStructureState, structureHolder);
            for (StructurePlacement structurePlacement : structurePlacements) {
                placementMap.computeIfAbsent(structurePlacement, unusedStructurePlacement -> new ObjectArraySet()).add(structureHolder);
            }
        }
        ArrayList placementList = new ArrayList(placementMap.size());
        double closestDistance = Double.MAX_VALUE;
        Pair<BlockPosition, Holder<Structure>> closestPair = null;
        for (Map.Entry entry : placementMap.entrySet()) {
            StructurePlacement structureplacement = (StructurePlacement)entry.getKey();
            if (structureplacement instanceof ConcentricRingsStructurePlacement) {
                BlockPosition blockPos;
                double distance;
                ConcentricRingsStructurePlacement concentricRingsStructurePlacement = (ConcentricRingsStructurePlacement)structureplacement;
                Pair<BlockPosition, Holder<Structure>> pairCandidate = AdaptiveReflectionManager.getNearestGeneratedStructure(chunkGenerator, (Set)entry.getValue(), worldServer, startPosition, concentricRingsStructurePlacement);
                if (pairCandidate == null || !((distance = this.distToLowCornerSqr(startPosition, blockPos = pairCandidate.getLeft())) < closestDistance)) continue;
                closestDistance = distance;
                closestPair = pairCandidate;
                continue;
            }
            if (!(structureplacement instanceof RandomSpreadStructurePlacement)) continue;
            placementList.add(entry);
        }
        if (!placementList.isEmpty()) {
            int sectionX = startLocation.getBlockX() >> 4;
            int sectionZ = startLocation.getBlockZ() >> 4;
            long worldSeed = AdaptiveReflectionManager.getWorldSeed(chunkGeneratorStructureState);
            for (int squareSize = 0; squareSize <= 100; ++squareSize) {
                boolean foundThisRound = false;
                for (Map.Entry entry : placementList) {
                    RandomSpreadStructurePlacement randomspreadstructureplacement = (RandomSpreadStructurePlacement)entry.getKey();
                    Pair<BlockPosition, Holder<Structure>> pairCandidate = AdaptiveReflectionManager.getNearestGeneratedStructure(chunkGenerator, (Set)entry.getValue(), worldServer, sectionX, sectionZ, squareSize, worldSeed, randomspreadstructureplacement);
                    if (pairCandidate == null) continue;
                    foundThisRound = true;
                    BlockPosition blockPos = pairCandidate.getLeft();
                    double distance = this.distToLowCornerSqr(startPosition, blockPos);
                    if (!(distance < closestDistance)) continue;
                    closestDistance = distance;
                    closestPair = pairCandidate;
                }
                if (!foundThisRound) continue;
                if (closestPair == null) {
                    return null;
                }
                int[] loc = AdaptiveReflectionManager.getPosition((BlockPosition)closestPair.getLeft());
                return new Pair<Location, String>(new Location(startLocation.getWorld(), (double)loc[0], 200.0, (double)loc[2]), AdaptiveReflectionManager.getPathFromMinecraftKey(AdaptiveReflectionManager.getKeyFromRegistry(structureRegistry, closestPair.getRight())));
            }
        }
        if (closestPair == null) {
            return null;
        }
        int[] loc = AdaptiveReflectionManager.getPosition((BlockPosition)closestPair.getLeft());
        return new Pair<Location, String>(new Location(startLocation.getWorld(), (double)loc[0], 200.0, (double)loc[2]), AdaptiveReflectionManager.getPathFromMinecraftKey(AdaptiveReflectionManager.getKeyFromRegistry(structureRegistry, (Holder)closestPair.getRight())));
    }

    @Override
    public List<String> availableFeatures() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException {
        World world = (World)Bukkit.getWorlds().get(0);
        WorldServer worldServer = (WorldServer)this.getWorldServer(world);
        IRegistry<Structure> structureRegistry = AdaptiveReflectionManager.getStructureRegistry(worldServer);
        ArrayList<String> list = new ArrayList<String>();
        for (MinecraftKey minecraftKey : AdaptiveReflectionManager.keySet_fromRegistry(structureRegistry)) {
            String lowerCase = AdaptiveReflectionManager.getPathFromMinecraftKey(minecraftKey).toLowerCase();
            list.add(lowerCase);
        }
        return list;
    }

    @Override
    public List<String> availableFeatures(World world) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        ArrayList<String> returnList = new ArrayList<String>();
        WorldServer worldServer = (WorldServer)this.getWorldServer(world);
        IRegistry<Structure> structureRegistry = AdaptiveReflectionManager.getStructureRegistry(worldServer);
        ChunkGenerator chunkGenerator = AdaptiveReflectionManager.getChunkGenerator(worldServer);
        WorldChunkManager worldChunkManager = AdaptiveReflectionManager.getWorldChunkManager(chunkGenerator);
        Set<Holder<BiomeBase>> generatedBiomes = AdaptiveReflectionManager.getGeneratedBiomes(worldChunkManager);
        for (MinecraftKey minecraftKey : AdaptiveReflectionManager.keySet_fromRegistry(structureRegistry)) {
            Structure structure = AdaptiveReflectionManager.getFromRegistry(structureRegistry, minecraftKey);
            Set<Holder<BiomeBase>> generateInBiomesList = AdaptiveReflectionManager.getGenerateBiomesAsSet(structure);
            if (generateInBiomesList.isEmpty() || Collections.disjoint(generatedBiomes, generateInBiomesList)) continue;
            returnList.add(AdaptiveReflectionManager.getPathFromMinecraftKey(minecraftKey));
        }
        return returnList;
    }

    @Override
    public List<Pair<String, List<String>>> getFeatureTags(World world) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException {
        ArrayList<Pair<String, List<String>>> list = new ArrayList<Pair<String, List<String>>>();
        WorldServer worldServer = (WorldServer)this.getWorldServer(world);
        IRegistry<Structure> structureRegistry = AdaptiveReflectionManager.getStructureRegistry(worldServer);
        AdaptiveReflectionManager.l(structureRegistry).forEach(named -> {
            String tagKeyName;
            Stream values;
            try {
                values = ReflectionManager.get(Stream.class, named);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            List<String> features = values.map(holder -> {
                MinecraftKey key;
                try {
                    key = AdaptiveReflectionManager.getKeyFromRegistry(structureRegistry, holder);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                if (key != null) {
                    return AdaptiveReflectionManager.getPathFromMinecraftKey(key).toLowerCase();
                }
                return null;
            }).filter(Objects::nonNull).toList();
            try {
                tagKeyName = AdaptiveReflectionManager.getPathFromMinecraftKey(AdaptiveReflectionManager.minecraftKey(AdaptiveReflectionManager.key(named))).toLowerCase();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            list.add(new Pair<CallSite, List<String>>((CallSite)((Object)("#" + tagKeyName.toLowerCase())), features));
        });
        return list;
    }
}

