/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.adapters;

import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import com.spaceman.tport.adapters.AdaptiveFeatureTP;
import com.spaceman.tport.adapters.AdaptiveReflectionManager;
import com.spaceman.tport.adapters.ReflectionManager;
import com.spaceman.tport.biomeTP.BiomePreset;
import com.spaceman.tport.commands.tport.FeatureTP;
import com.spaceman.tport.commands.tport.biomeTP.Accuracy;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;

public abstract class AdaptiveBiomeTP
extends AdaptiveFeatureTP {
    @Override
    public List<String> availableBiomes() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException {
        World world = (World)Bukkit.getWorlds().get(0);
        WorldServer worldServer = (WorldServer)this.getWorldServer(world);
        IRegistry<BiomeBase> biomeRegistry = AdaptiveReflectionManager.getBiomeRegistry(worldServer);
        ArrayList<String> list = new ArrayList<String>();
        for (MinecraftKey key : AdaptiveReflectionManager.keySet_fromRegistry(biomeRegistry)) {
            String lowerCase = AdaptiveReflectionManager.getPathFromMinecraftKey(key).toLowerCase();
            list.add(lowerCase);
        }
        return list;
    }

    @Override
    public List<String> availableBiomes(World world) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        WorldServer worldServer = (WorldServer)this.getWorldServer(world);
        IRegistry<BiomeBase> biomeRegistry = AdaptiveReflectionManager.getBiomeRegistry(worldServer);
        ChunkGenerator chunkGenerator = AdaptiveReflectionManager.getChunkGenerator(worldServer);
        WorldChunkManager worldChunkManager = AdaptiveReflectionManager.getWorldChunkManager(chunkGenerator);
        ArrayList<String> list = new ArrayList<String>();
        for (Holder<BiomeBase> biomeHolder : AdaptiveReflectionManager.getGeneratedBiomes(worldChunkManager)) {
            MinecraftKey key = AdaptiveReflectionManager.getKeyFromRegistry(biomeRegistry, biomeHolder);
            if (key == null) continue;
            list.add(AdaptiveReflectionManager.getPathFromMinecraftKey(key).toLowerCase());
        }
        return list;
    }

    @Override
    public Pair<Location, String> biomeFinder(Player player, List<String> biomes, @Nonnull Location startLocation, Accuracy.AccuracySettings accuracy) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException {
        int startX = startLocation.getBlockX();
        int startY = startLocation.getBlockY();
        int startZ = startLocation.getBlockZ();
        World world = startLocation.getWorld();
        if (world == null) {
            return null;
        }
        Rectangle searchArea = Main.getSearchArea(player);
        int size = accuracy.getRange();
        List<Integer> yLevels = accuracy.getYLevels();
        int increment = accuracy.getIncrement();
        int quartSize = size >> 2;
        int quartX = startX >> 2;
        int quartZ = startZ >> 2;
        WorldServer worldServer = (WorldServer)this.getWorldServer(world);
        ChunkGenerator chunkGenerator = AdaptiveReflectionManager.getChunkGenerator(worldServer);
        WorldChunkManager worldChunkManager = AdaptiveReflectionManager.getWorldChunkManager(chunkGenerator);
        IRegistry<BiomeBase> biomeRegistry = AdaptiveReflectionManager.getBiomeRegistry(worldServer);
        ArrayList<BiomeBase> baseList = new ArrayList<BiomeBase>();
        for (String biome : biomes) {
            BiomeBase biomeBase = AdaptiveReflectionManager.getFromRegistry(biomeRegistry, biome.toLowerCase());
            if (biomeBase == null) continue;
            baseList.add(biomeBase);
        }
        Predicate<Holder> predicate = holder -> {
            for (BiomeBase biomeBase : baseList) {
                try {
                    if (!biomeBase.equals(AdaptiveReflectionManager.getValueFromHolder(holder))) continue;
                    return true;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        };
        Climate.Sampler climateSampler = AdaptiveReflectionManager.getClimateSampler(worldServer);
        for (int squareSize = 0; squareSize <= quartSize; squareSize += increment) {
            for (int zOffset = -squareSize; zOffset <= squareSize; zOffset += increment) {
                boolean zEnd = Math.abs(zOffset) == squareSize;
                for (int xOffset = -squareSize; xOffset <= squareSize; xOffset += increment) {
                    int newZ;
                    int newX;
                    boolean xEnd;
                    boolean bl = xEnd = Math.abs(zOffset) == squareSize;
                    if (!zEnd && !xEnd || !searchArea.contains((newX = quartX + xOffset) << 2, (newZ = quartZ + zOffset) << 2)) continue;
                    for (int y : yLevels) {
                        int newY = y >> 2;
                        Holder currentBiome = worldChunkManager.getNoiseBiome(newX, newY, newZ, climateSampler);
                        if (!predicate.test(currentBiome)) continue;
                        Location blockPos = new Location(player.getWorld(), (double)(newX << 2), (double)startY, (double)(newZ << 2));
                        MinecraftKey k = AdaptiveReflectionManager.getKeyFromRegistry(biomeRegistry, currentBiome);
                        return new Pair<Location, String>(blockPos, AdaptiveReflectionManager.getPathFromMinecraftKey(k));
                    }
                }
            }
        }
        return null;
    }

    @Override
    public ArrayList<BiomePreset> loadPresetsFromWorld(World world) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException {
        WorldServer worldServer = (WorldServer)this.getWorldServer(world);
        IRegistry<BiomeBase> biomeRegistry = AdaptiveReflectionManager.getBiomeRegistry(worldServer);
        ArrayList<BiomePreset> presets = new ArrayList<BiomePreset>();
        AdaptiveReflectionManager.l(biomeRegistry).forEach(named -> {
            Material material;
            String tagKeyName;
            Stream values;
            try {
                values = ReflectionManager.get(Stream.class, named);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            List<String> biomes = values.map(holder -> {
                MinecraftKey key;
                try {
                    key = AdaptiveReflectionManager.getKeyFromRegistry(biomeRegistry, holder);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                if (key != null) {
                    return AdaptiveReflectionManager.getPathFromMinecraftKey(key).toLowerCase();
                }
                return null;
            }).filter(Objects::nonNull).toList();
            try {
                tagKeyName = AdaptiveReflectionManager.getPathFromMinecraftKey(AdaptiveReflectionManager.minecraftKey(AdaptiveReflectionManager.key(named))).toLowerCase();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            if (tagKeyName.startsWith("has_structure/")) {
                material = FeatureTP.getMaterial(tagKeyName.substring(14));
            } else {
                String materialName = BiomePreset.getMaterialName(tagKeyName);
                material = Main.getOrDefault(Material.getMaterial((String)materialName), Material.DIAMOND_BLOCK);
            }
            presets.add(new BiomePreset("#" + tagKeyName, biomes, true, material, true));
        });
        return presets;
    }
}

