/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.tpEvents.restrictions;

import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.tpEvents.TPEManager;
import com.spaceman.tport.tpEvents.TPRestriction;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class InteractRestriction
extends TPRestriction
implements Listener {
    private UUID uuid = null;

    public InteractRestriction() {
        this.reset();
    }

    private void reset() {
        this.uuid = null;
        this.disable();
    }

    @EventHandler
    public void moveEvent(PlayerInteractEvent e) {
        if (e.getPlayer().getUniqueId().equals(this.uuid)) {
            ColorTheme.sendErrorTranslation(e.getPlayer(), "tport.tpEvents.restrictions.interactRestriction.error", new Object[0]);
            TPEManager.cancelTP(this.uuid);
            this.reset();
        }
    }

    @Override
    public String getRestrictionName() {
        return SubCommand.lowerCaseFirst(this.getClass().getSimpleName());
    }

    @Override
    public void start(Player player, int taskID) {
        this.activate();
        this.uuid = player.getUniqueId();
    }

    @Override
    public void cancel() {
        this.reset();
    }

    @Override
    public Message getDescription() {
        return ColorTheme.formatInfoTranslation("tport.tpEvents.restrictions.interactRestriction.description", new Object[0]);
    }

    @Override
    public boolean shouldTeleport(Player player) {
        this.reset();
        return true;
    }

    @Override
    public void activate() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Main.getInstance());
    }

    @Override
    public void disable() {
        PlayerInteractEvent.getHandlerList().unregister((Listener)this);
    }
}

