/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.tpEvents.animations;

import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.keyValueHelper.ExtendedKey;
import com.spaceman.tport.keyValueHelper.KeyValueError;
import com.spaceman.tport.keyValueHelper.KeyValueHelper;
import com.spaceman.tport.keyValueHelper.KeyValueTabArgument;
import com.spaceman.tport.tpEvents.ParticleAnimation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class SimpleAnimation
extends ParticleAnimation {
    private Particle particle = this.getDefaultParticle();
    private int amount = 10;

    public SimpleAnimation() {
        this.setEnabled(true);
    }

    public SimpleAnimation(boolean b) {
        this.setEnabled(b);
    }

    @Override
    public String getAnimationName() {
        return SubCommand.lowerCaseFirst(this.getClass().getSimpleName());
    }

    @Override
    public void show(Player player, Location location) {
        try {
            if (location.getWorld() != null) {
                location.getWorld().spawnParticle(this.particle, location, this.amount);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setParticle(Particle p) {
        this.particle = p;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    @Override
    public boolean edit(Player player, String[] data) {
        if (data == null || data.length == 0) {
            this.setParticle(this.getDefaultParticle());
        } else {
            try {
                KeyValueHelper.extendedConstructObject(data[0], (Object)this, (ExtendedKey)new ExtendedKey("particle", Particle::valueOf, false, (o, value) -> ((SimpleAnimation)o).setParticle((Particle)value)).setErrorMessageID("tport.tpEvents.animations.simpleAnimation.notAParticle"), (ExtendedKey)new ExtendedKey("amount", Integer::parseInt, true, (o, value) -> ((SimpleAnimation)o).setAmount((Integer)value)).setErrorMessageID("tport.tpEvents.animations.simpleAnimation.notANumber"));
            }
            catch (KeyValueError keyValueError) {
                keyValueError.sendMessage(player);
                return false;
            }
        }
        return true;
    }

    @Override
    public void save(ConfigurationSection section) {
        section.set("p", (Object)this.particle.name());
        section.set("a", (Object)this.amount);
    }

    @Override
    public void load(ConfigurationSection section) {
        this.setParticle(Particle.valueOf((String)section.getString("p", this.getDefaultParticle().name()).toUpperCase()));
        this.setAmount(section.getInt("a", 10));
    }

    @Override
    public List<String> tabList(Player player, String[] args) {
        return KeyValueHelper.constructTab(args[args.length - 1], Arrays.asList(new KeyValueTabArgument("particle", Arrays.stream(Particle.values()).map(Enum::name).collect(Collectors.toList())), new KeyValueTabArgument("amount", Collections.singletonList("<X>"))));
    }

    @Override
    public Message getDescription() {
        return ColorTheme.formatInfoTranslation("tport.tpEvents.animations.simpleAnimation.description", new Object[0]);
    }
}

