/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.tpEvents;

import com.spaceman.tport.Main;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commands.tport.Back;
import com.spaceman.tport.commands.tport.Delay;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.commands.tport.Restriction;
import com.spaceman.tport.commands.tport.pltp.Offset;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.TextType;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.history.TeleportHistory;
import com.spaceman.tport.history.locationSource.PlayerLocationSource;
import com.spaceman.tport.history.locationSource.TPortLocationSource;
import com.spaceman.tport.tpEvents.ParticleAnimation;
import com.spaceman.tport.tpEvents.TPRestriction;
import com.spaceman.tport.tpEvents.animations.SimpleAnimation;
import com.spaceman.tport.tpEvents.restrictions.NoneRestriction;
import com.spaceman.tport.tport.TPort;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

public class TPEManager {
    private static final HashMap<UUID, ParticleAnimation> newLocAnimations = new HashMap();
    private static final HashMap<UUID, ParticleAnimation> oldLocAnimations = new HashMap();
    private static final HashMap<UUID, TPRestriction> tpRestrictions = new HashMap();
    private static final HashMap<UUID, Integer> taskIDs = new HashMap();

    public static void saveTPE(Files file) {
        ParticleAnimation pa;
        for (UUID uuid : newLocAnimations.keySet()) {
            pa = newLocAnimations.get(uuid);
            pa.save(file.getConfig().createSection("ParticleAnimations.players." + uuid.toString() + ".new.data"));
            file.getConfig().set("ParticleAnimations.players." + String.valueOf(uuid) + ".new.name", (Object)pa.getAnimationName());
            file.getConfig().set("ParticleAnimations.players." + String.valueOf(uuid) + ".new.enabled", (Object)pa.isEnabled());
        }
        for (UUID uuid : oldLocAnimations.keySet()) {
            pa = oldLocAnimations.get(uuid);
            pa.save(file.getConfig().createSection("ParticleAnimations.players." + uuid.toString() + ".old.data"));
            file.getConfig().set("ParticleAnimations.players." + String.valueOf(uuid) + ".old.name", (Object)pa.getAnimationName());
            file.getConfig().set("ParticleAnimations.players." + String.valueOf(uuid) + ".old.enabled", (Object)pa.isEnabled());
        }
        for (UUID uuid : tpRestrictions.keySet()) {
            TPRestriction type = tpRestrictions.get(uuid);
            file.getConfig().set("restriction.type." + uuid.toString(), (Object)type.getRestrictionName());
        }
        file.saveConfig();
    }

    public static void loadTPE(Files file) {
        UUID uuid;
        for (String uuidS : file.getKeys("restriction.type")) {
            uuid = UUID.fromString(uuidS);
            TPRestriction type = TPRestriction.getNewRestriction(file.getConfig().getString("restriction.type." + uuidS));
            TPEManager.setTPRestriction(uuid, type);
        }
        for (String uuidS : file.getKeys("ParticleAnimations.players")) {
            uuid = UUID.fromString(uuidS);
            if (file.getConfig().contains("ParticleAnimations.players." + uuidS + ".new")) {
                ParticleAnimation newPA = ParticleAnimation.getNewAnimation(file.getConfig().getString("ParticleAnimations.players." + uuidS + ".new.name"));
                if (newPA != null) {
                    try {
                        newPA.setEnabled(file.getConfig().getBoolean("ParticleAnimations.players." + uuidS + ".new.enabled", true));
                        if (file.getConfig().contains("ParticleAnimations.players." + uuidS + ".new.data")) {
                            newPA.load(file.getConfig().getConfigurationSection("ParticleAnimations.players." + uuidS + ".new.data"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    newLocAnimations.put(uuid, newPA);
                } else {
                    Main.getInstance().getLogger().warning("Could not find particle animation " + file.getConfig().getString("ParticleAnimations.players." + uuidS + ".new.name"));
                }
            }
            if (!file.getConfig().contains("ParticleAnimations.players." + uuidS + ".old")) continue;
            ParticleAnimation oldPA = ParticleAnimation.getNewAnimation(file.getConfig().getString("ParticleAnimations.players." + uuidS + ".old.name"));
            if (oldPA != null) {
                try {
                    oldPA.setEnabled(file.getConfig().getBoolean("ParticleAnimations.players." + uuidS + ".old.enabled", true));
                    if (file.getConfig().contains("ParticleAnimations.players." + uuidS + ".old.data")) {
                        oldPA.load(file.getConfig().getConfigurationSection("ParticleAnimations.players." + uuidS + ".old.data"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                oldLocAnimations.put(uuid, oldPA);
                continue;
            }
            Main.getInstance().getLogger().warning("Could not find particle animation " + file.getConfig().getString("ParticleAnimations.players." + uuidS + ".old.name"));
        }
    }

    public static ParticleAnimation setNewLocAnimation(UUID uuid, ParticleAnimation pa) {
        newLocAnimations.put(uuid, pa);
        return pa;
    }

    public static ParticleAnimation setOldLocAnimation(UUID uuid, ParticleAnimation pa) {
        oldLocAnimations.put(uuid, pa);
        return pa;
    }

    public static TPRestriction setTPRestriction(UUID uuid, @Nullable TPRestriction type) {
        if (type == null) {
            type = new NoneRestriction();
        }
        if (tpRestrictions.containsKey(uuid)) {
            tpRestrictions.get(uuid).disable();
        }
        tpRestrictions.put(uuid, type);
        return type;
    }

    @Nonnull
    public static ParticleAnimation getNewLocAnimation(UUID uuid) {
        if (newLocAnimations.getOrDefault(uuid, null) == null) {
            return TPEManager.setNewLocAnimation(uuid, new SimpleAnimation());
        }
        return newLocAnimations.get(uuid);
    }

    @Nonnull
    public static ParticleAnimation getOldLocAnimation(UUID uuid) {
        if (oldLocAnimations.getOrDefault(uuid, null) == null) {
            return TPEManager.setOldLocAnimation(uuid, new SimpleAnimation(false));
        }
        return oldLocAnimations.get(uuid);
    }

    private static TPRestriction getUnmodifiedTPRestriction(UUID uuid) {
        if (!tpRestrictions.containsKey(uuid)) {
            return TPEManager.setTPRestriction(uuid, null);
        }
        return tpRestrictions.get(uuid);
    }

    public static TPRestriction getTPRestriction(UUID uuid) {
        if (Restriction.isPermissionBased()) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null) {
                for (PermissionAttachmentInfo p : player.getEffectivePermissions()) {
                    if (!p.getPermission().toLowerCase().startsWith("tport.restriction.type.")) continue;
                    TPEManager.setTPRestriction(uuid, TPRestriction.getNewRestriction(p.getPermission().toLowerCase().replace("tport.restriction.type.", "")));
                    break;
                }
            }
            TPEManager.setTPRestriction(uuid, null);
        }
        return TPEManager.getUnmodifiedTPRestriction(uuid);
    }

    public static int registerTP(UUID uuid, int taskID) {
        taskIDs.put(uuid, taskID);
        return taskID;
    }

    public static boolean hasTPRequest(UUID uuid) {
        return taskIDs.containsKey(uuid);
    }

    public static void removeTP(UUID uuid) {
        taskIDs.remove(uuid);
    }

    public static boolean cancelTP(UUID uuid) {
        if (taskIDs.containsKey(uuid)) {
            TPRestriction tpr = TPEManager.getUnmodifiedTPRestriction(uuid);
            if (tpr != null) {
                tpr.cancel();
            }
            Bukkit.getScheduler().cancelTask(taskIDs.remove(uuid).intValue());
            return true;
        }
        return false;
    }

    public static void tpPlayerToPlayer(Player player, Player toPlayer, Runnable postRestrictionMessage, RequestedRunnable requestedRunnable) {
        Back.prevTPorts.put(player.getUniqueId(), new Back.PrevTPort(Back.PrevType.PLAYER, "playerUUID", (Object)toPlayer.getUniqueId().toString(), "prevLoc", (Object)player.getLocation()));
        TeleportHistory.setLocationSource(player.getUniqueId(), new PlayerLocationSource(toPlayer));
        TPEManager.requestTeleportPlayer(player, Offset.getPLTPOffset(toPlayer).applyOffset(toPlayer.getLocation()), postRestrictionMessage, requestedRunnable);
    }

    public static void tpPlayerToTPort(Player player, TPort tport, Runnable postRestrictionMessage, RequestedRunnable requestedRunnable) {
        Back.prevTPorts.put(player.getUniqueId(), new Back.PrevTPort("TPORT", "tportName", tport.getName(), "tportUUID", tport.getTportID(), "tportOwner", tport.getOwner(), "prevLoc", player.getLocation()));
        TeleportHistory.setLocationSource(player.getUniqueId(), new TPortLocationSource(tport));
        TPEManager.requestTeleportPlayer(player, tport.getLocation(), postRestrictionMessage, requestedRunnable);
    }

    public static void requestTeleportPlayer(Player player, Location l, Runnable successRunnable, RequestedRunnable requestedRunnable) {
        TPEManager.requestTeleportPlayer(player, l, false, successRunnable, requestedRunnable);
    }

    public static void requestTeleportPlayer(Player player, Location l, boolean ignore_interdimensionalTeleporting, Runnable successRunnable, RequestedRunnable requestedRunnable) {
        if (!ignore_interdimensionalTeleporting && Features.Feature.InterdimensionalTeleporting.isDisabled() && !player.getWorld().equals((Object)l.getWorld())) {
            ColorTheme.sendErrorTranslation(player, "tport.tpEvents.requestTeleportPlayer.InterdimensionalTeleporting.disabled", player.getWorld(), l.getWorld());
            return;
        }
        if (TPEManager.hasTPRequest(player.getUniqueId())) {
            Message hereMessage = new Message();
            hereMessage.addText(TextComponent.textComponent("tport.events.inventoryClick.alreadyRequested.here", ColorTheme.ColorType.varErrorColor, new HoverEvent(TextComponent.textComponent("/tport cancel", ColorTheme.ColorType.varInfoColor)), ClickEvent.runCommand("/tport cancel")).setType(TextType.TRANSLATE).setInsertion("/tport cancel"));
            ColorTheme.sendErrorTranslation(player, "tport.events.inventoryClick.alreadyRequested", hereMessage);
            return;
        }
        int delay = Delay.delayTime(player);
        if (delay == 0) {
            TPEManager.teleportPlayer(player, l);
            successRunnable.run();
        } else {
            double seconds = (double)delay / 20.0;
            Message secondMessage = seconds == 1.0 ? ColorTheme.formatSuccessTranslation("tport.command.second", new Object[0]) : ColorTheme.formatSuccessTranslation("tport.command.seconds", new Object[0]);
            Message tickMessage = delay == 1 ? ColorTheme.formatSuccessTranslation("tport.command.minecraftTick", new Object[0]) : ColorTheme.formatSuccessTranslation("tport.command.minecraftTicks", new Object[0]);
            TPRestriction tpRestriction = TPEManager.getTPRestriction(player.getUniqueId());
            if (tpRestriction == null) {
                TPEManager.registerTP(player.getUniqueId(), Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> {
                    TPEManager.teleportPlayer(Bukkit.getPlayer((UUID)player.getUniqueId()), l);
                    successRunnable.run();
                }, (long)delay).getTaskId());
            } else {
                tpRestriction.start(player, TPEManager.registerTP(player.getUniqueId(), Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> {
                    if (tpRestriction.shouldTeleport(player)) {
                        TPEManager.teleportPlayer(Bukkit.getPlayer((UUID)player.getUniqueId()), l);
                        successRunnable.run();
                    }
                    TPEManager.cancelTP(player.getUniqueId());
                }, (long)delay).getTaskId()));
            }
            requestedRunnable.send(player, delay, tickMessage, seconds, secondMessage);
        }
    }

    public static void teleportPlayer(@Nullable Player player, Location l) {
        ArrayList<LivingEntity> slaves;
        block21: {
            boolean showAnimation;
            if (player == null) {
                return;
            }
            slaves = new ArrayList<LivingEntity>();
            if (Features.Feature.CompanionTP.isEnabled()) {
                for (Entity e : player.getWorld().getEntities()) {
                    LivingEntity livingEntity;
                    if (!(e instanceof LivingEntity) || !(livingEntity = (LivingEntity)e).isLeashed() || !(livingEntity.getLeashHolder() instanceof Player) || !livingEntity.getLeashHolder().getUniqueId().equals(player.getUniqueId())) continue;
                    slaves.add(livingEntity);
                    livingEntity.setLeashHolder(null);
                }
            }
            LivingEntity horse = null;
            Boat boatEntity = null;
            Entity sailor = null;
            if (Features.Feature.CompanionTP.isEnabled()) {
                if (player.getVehicle() instanceof LivingEntity) {
                    horse = (LivingEntity)player.getVehicle();
                } else {
                    Entity entity = player.getVehicle();
                    if (entity instanceof Boat) {
                        Boat b;
                        boatEntity = b = (Boat)entity;
                        player.leaveVehicle();
                        if (!b.getPassengers().isEmpty()) {
                            sailor = (Entity)b.getPassengers().get(0);
                            sailor.leaveVehicle();
                            sailor.teleport(l);
                        }
                        b.getPassengers().forEach(arg_0 -> ((Boat)b).removePassenger(arg_0));
                    }
                }
            }
            World world = player.getWorld();
            if (player.getLocation().getY() > (double)(world.getMaxHeight() - 10) && l.getY() < (double)(world.getMinHeight() + 10)) {
                TPortAdvancement.Advancement_CavesAndCliffsPartIII.grant(player);
            }
            if (showAnimation = Features.Feature.ParticleAnimation.isEnabled()) {
                TPEManager.getOldLocAnimation(player.getUniqueId()).showIfEnabled(player, player.getLocation().clone());
            }
            if (!player.getWorld().equals((Object)l.getWorld())) {
                player.teleport(l);
            }
            player.teleport(l);
            TPEManager.removeTP(player.getUniqueId());
            if (showAnimation) {
                TPEManager.getNewLocAnimation(player.getUniqueId()).showIfEnabled(player, l.clone());
            }
            try {
                if (horse != null) {
                    horse.teleport((Entity)player);
                    horse.addPassenger((Entity)player);
                } else if (boatEntity != null) {
                    Location boatL = boatEntity.getLocation().clone().add(1000.0, 0.0, 1000.0);
                    boatEntity.teleport(boatL);
                    boatEntity.teleport((Entity)player);
                    boatEntity.addPassenger((Entity)player);
                    if (sailor != null) {
                        sailor.teleport((Entity)player);
                        boatEntity.addPassenger(sailor);
                    }
                }
            }
            catch (Exception ex) {
                Features.Feature.printSmallNMSErrorInConsole("Teleport horse/boat", false);
                if (!Features.Feature.PrintErrorsInConsole.isEnabled()) break block21;
                ex.printStackTrace();
            }
        }
        for (LivingEntity e : slaves) {
            try {
                e.teleport((Entity)player);
                e.setLeashHolder((Entity)player);
            }
            catch (Exception ex) {
                Features.Feature.printSmallNMSErrorInConsole("Teleport leash", false);
                if (!Features.Feature.PrintErrorsInConsole.isEnabled()) continue;
                ex.printStackTrace();
            }
        }
    }

    @FunctionalInterface
    public static interface RequestedRunnable {
        public void send(Player var1, int var2, Message var3, double var4, Message var6);
    }
}

