/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.tpEvents;

import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public abstract class ParticleAnimation {
    private static final HashMap<String, AnimationCreator> animations = new HashMap();
    private boolean enabled = true;

    protected Particle getDefaultParticle() {
        try {
            return Particle.valueOf((String)"EXPLOSION");
        }
        catch (IllegalArgumentException iae) {
            return Particle.valueOf((String)"EXPLOSION_NORMAL");
        }
    }

    public static Set<String> getAnimations() {
        return animations.keySet();
    }

    public static ParticleAnimation getNewAnimation(String animationName) {
        return ParticleAnimation.getNewAnimation(animationName, null, null);
    }

    public static ParticleAnimation getNewAnimation(String animationName, String[] data, Player player) {
        if (animations.containsKey(animationName)) {
            try {
                ParticleAnimation animation = animations.get(animationName).create();
                if (data != null && data.length != 0 && player != null) {
                    animation.edit(player, data);
                }
                return animation;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static boolean registerAnimation(AnimationCreator animation) {
        Validate.notNull((Object)animation, (String)"The given AnimationCreator can not be null");
        return animations.put(animation.create().getAnimationName(), animation) != null;
    }

    public abstract String getAnimationName();

    public abstract void show(Player var1, Location var2);

    public abstract boolean edit(Player var1, String[] var2);

    public abstract void save(ConfigurationSection var1);

    public abstract void load(ConfigurationSection var1);

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean state) {
        this.enabled = state;
    }

    public List<String> tabList(Player player, String[] args) {
        return Collections.emptyList();
    }

    public final void showIfEnabled(Player player, Location location) {
        if (this.isEnabled()) {
            this.show(player, location);
        }
    }

    public Message getDescription() {
        return ColorTheme.formatErrorTranslation("tport.tpEvents.particleAnimation.defaultDescription", new Object[0]);
    }

    @FunctionalInterface
    public static interface AnimationCreator {
        public ParticleAnimation create();
    }
}

