/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.inventories;

import com.google.gson.JsonObject;
import com.spaceman.tport.Glow;
import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commands.TPortCommand;
import com.spaceman.tport.commands.tport.BlueMapCommand;
import com.spaceman.tport.commands.tport.DynmapCommand;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.commands.tport.Tag;
import com.spaceman.tport.commands.tport.edit.Item;
import com.spaceman.tport.commands.tport.log.Read;
import com.spaceman.tport.commands.tport.log.TimeFormat;
import com.spaceman.tport.commands.tport.log.TimeZone;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.MessageUtils;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.fancyMessage.inventories.FancyClickEvent;
import com.spaceman.tport.fancyMessage.inventories.FancyInventory;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.fancyMessage.inventories.keyboard.KeyboardGUI;
import com.spaceman.tport.fancyMessage.language.Language;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.inventories.ItemFactory;
import com.spaceman.tport.inventories.TPortInventories;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import com.spaceman.tport.webMaps.BlueMapHandler;
import com.spaceman.tport.webMaps.DynmapHandler;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class QuickEditInventories {
    public static final InventoryModel quick_edit_private_open_model = new InventoryModel(Material.OAK_BUTTON, TPortInventories.last_model_id + 1, "tport", "quick_edit_private_open", "quick_edit");
    public static final InventoryModel quick_edit_private_private_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_private_open_model, "tport", "quick_edit_private_private", "quick_edit");
    public static final InventoryModel quick_edit_private_online_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_private_private_model, "tport", "quick_edit_private_online", "quick_edit");
    public static final InventoryModel quick_edit_private_private_online_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_private_online_model, "tport", "quick_edit_private_private_online", "quick_edit");
    public static final InventoryModel quick_edit_private_consent_private_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_private_private_online_model, "tport", "quick_edit_private_consent_private", "quick_edit");
    public static final InventoryModel quick_edit_private_consent_close_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_private_consent_private_model, "tport", "quick_edit_private_consent_close", "quick_edit");
    public static final InventoryModel quick_edit_whitelist_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_private_consent_close_model, "tport", "quick_edit_whitelist", "quick_edit");
    public static final InventoryModel quick_edit_whitelist_visibility_on_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_whitelist_model, "tport", "quick_edit_whitelist_visibility_on", "quick_edit");
    public static final InventoryModel quick_edit_whitelist_visibility_off_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_whitelist_visibility_on_model, "tport", "quick_edit_whitelist_visibility_off", "quick_edit");
    public static final InventoryModel quick_edit_whitelist_clone_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_whitelist_visibility_off_model, "tport", "quick_edit_whitelist_clone", "quick_edit");
    public static final InventoryModel quick_edit_range_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_whitelist_clone_model, "tport", "quick_edit_range", "quick_edit");
    public static final InventoryModel quick_edit_range_add_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_range_model, "tport", "quick_edit_range_add", "quick_edit");
    public static final InventoryModel quick_edit_range_remove_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_range_add_model, "tport", "quick_edit_range_remove", "quick_edit");
    public static final InventoryModel quick_edit_move_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_range_remove_model, "tport", "quick_edit_move", "quick_edit");
    public static final InventoryModel quick_edit_move_empty_slot_model = new InventoryModel(Material.GRAY_STAINED_GLASS_PANE, quick_edit_move_model, "tport", "quick_edit_move_empty_slot", "quick_edit");
    public static final InventoryModel quick_edit_log_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_move_empty_slot_model, "tport", "quick_edit_log", "quick_edit");
    public static final InventoryModel quick_edit_log_edit_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_log_model, "tport", "quick_edit_log_edit", "quick_edit");
    public static final InventoryModel quick_edit_log_delete_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_log_edit_model, "tport", "quick_edit_log_delete", "quick_edit");
    public static final InventoryModel quick_edit_log_read_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_log_delete_model, "tport", "quick_edit_log_read", "quick_edit");
    public static final InventoryModel quick_edit_log_read_filter_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_log_read_model, "tport", "quick_edit_log_read_filter", "quick_edit");
    public static final InventoryModel quick_edit_log_read_chat_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_log_read_filter_model, "tport", "quick_edit_log_read_chat", "quick_edit");
    public static final InventoryModel quick_edit_log_clear_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_log_read_chat_model, "tport", "quick_edit_log_clear", "quick_edit");
    public static final InventoryModel quick_edit_log_mode_online_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_log_clear_model, "tport", "quick_edit_log_mode_online", "quick_edit");
    public static final InventoryModel quick_edit_log_mode_offline_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_log_mode_online_model, "tport", "quick_edit_log_mode_offline", "quick_edit");
    public static final InventoryModel quick_edit_log_mode_all_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_log_mode_offline_model, "tport", "quick_edit_log_mode_all", "quick_edit");
    public static final InventoryModel quick_edit_log_mode_none_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_log_mode_all_model, "tport", "quick_edit_log_mode_none", "quick_edit");
    public static final InventoryModel quick_edit_notify_online_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_log_mode_none_model, "tport", "quick_edit_notify_online", "quick_edit");
    public static final InventoryModel quick_edit_notify_log_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_notify_online_model, "tport", "quick_edit_notify_log", "quick_edit");
    public static final InventoryModel quick_edit_notify_none_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_notify_log_model, "tport", "quick_edit_notify_none", "quick_edit");
    public static final InventoryModel quick_edit_preview_on_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_notify_none_model, "tport", "quick_edit_preview_on", "quick_edit");
    public static final InventoryModel quick_edit_preview_off_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_preview_on_model, "tport", "quick_edit_preview_off", "quick_edit");
    public static final InventoryModel quick_edit_preview_notified_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_preview_off_model, "tport", "quick_edit_preview_notified", "quick_edit");
    public static final InventoryModel quick_edit_preview_grayed_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_preview_notified_model, "tport", "quick_edit_preview_grayed", "quick_edit");
    public static final InventoryModel quick_edit_tag_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_preview_grayed_model, "tport", "quick_edit_tag", "quick_edit");
    public static final InventoryModel quick_edit_tag_selection_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_tag_model, "tport", "quick_edit_tag_selection", "quick_edit");
    public static final InventoryModel quick_edit_remove_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_tag_selection_model, "tport", "quick_edit_remove", "quick_edit");
    public static final InventoryModel quick_edit_remove_confirm_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_remove_model, "tport", "quick_edit_remove_confirm", "quick_edit");
    public static final InventoryModel quick_edit_remove_cancel_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_remove_confirm_model, "tport", "quick_edit_remove_cancel", "quick_edit");
    public static final InventoryModel quick_edit_location_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_remove_cancel_model, "tport", "quick_edit_location", "quick_edit");
    public static final InventoryModel quick_edit_location_confirm_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_location_model, "tport", "quick_edit_location_confirm", "quick_edit");
    public static final InventoryModel quick_edit_location_cancel_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_location_confirm_model, "tport", "quick_edit_location_cancel", "quick_edit");
    public static final InventoryModel quick_edit_name_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_location_cancel_model, "tport", "quick_edit_name", "quick_edit");
    public static final InventoryModel quick_edit_description_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_name_model, "tport", "quick_edit_description", "quick_edit");
    public static final InventoryModel quick_edit_public_tp_on_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_description_model, "tport", "quick_edit_public_tp_on", "quick_edit");
    public static final InventoryModel quick_edit_public_tp_off_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_public_tp_on_model, "tport", "quick_edit_public_tp_off", "quick_edit");
    public static final InventoryModel quick_edit_public_tp_grayed_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_public_tp_off_model, "tport", "quick_edit_public_tp_grayed", "quick_edit");
    public static final InventoryModel quick_edit_dynmap_show_on_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_public_tp_grayed_model, "tport", "quick_edit_dynmap_show_on", "quick_edit");
    public static final InventoryModel quick_edit_dynmap_show_off_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_dynmap_show_on_model, "tport", "quick_edit_dynmap_show_off", "quick_edit");
    public static final InventoryModel quick_edit_dynmap_show_grayed_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_dynmap_show_off_model, "tport", "quick_edit_dynmap_show_grayed", "quick_edit");
    public static final InventoryModel quick_edit_dynmap_icon_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_dynmap_show_grayed_model, "tport", "quick_edit_dynmap_icon", "quick_edit");
    public static final InventoryModel quick_edit_dynmap_icon_tport_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_dynmap_icon_model, "tport", "quick_edit_dynmap_icon_tport", "quick_edit");
    public static final InventoryModel quick_edit_dynmap_icon_grayed_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_dynmap_icon_tport_model, "tport", "quick_edit_dynmap_icon_grayed", "quick_edit");
    public static final InventoryModel quick_edit_bluemap_show_on_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_dynmap_icon_grayed_model, "tport", "quick_edit_bluemap_show_on", "quick_edit");
    public static final InventoryModel quick_edit_bluemap_show_off_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_bluemap_show_on_model, "tport", "quick_edit_bluemap_show_off", "quick_edit");
    public static final InventoryModel quick_edit_bluemap_show_grayed_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_bluemap_show_off_model, "tport", "quick_edit_bluemap_show_grayed", "quick_edit");
    public static final InventoryModel quick_edit_bluemap_icon_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_bluemap_show_grayed_model, "tport", "quick_edit_bluemap_icon", "quick_edit");
    public static final InventoryModel quick_edit_bluemap_icon_tport_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_bluemap_icon_model, "tport", "quick_edit_bluemap_icon_tport", "quick_edit");
    public static final InventoryModel quick_edit_bluemap_icon_grayed_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_bluemap_icon_tport_model, "tport", "quick_edit_bluemap_icon_grayed", "quick_edit");
    public static final InventoryModel quick_edit_offer_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_bluemap_icon_grayed_model, "tport", "quick_edit_offer", "quick_edit");
    public static final InventoryModel quick_edit_revoke_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_offer_model, "tport", "quick_edit_revoke", "quick_edit");
    public static final InventoryModel quick_edit_item_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_revoke_model, "tport", "quick_edit_item", "quick_edit");
    public static final InventoryModel quick_edit_item_reload_model = new InventoryModel(Material.OAK_BUTTON, quick_edit_item_model, "tport", "quick_edit_item_reload", "quick_edit");
    public static final int last_model_id = quick_edit_item_reload_model.getCustomModelData();
    private static final FancyInventory.DataName<Boolean> fromQuickEditDataName = new FancyInventory.DataName<Boolean>("fromQuickEdit", Boolean.class, false);
    public static final FancyInventory.DataName<UUID> whitelistCloneToDataName = new FancyInventory.DataName<Object>("whitelistCloneTo", UUID.class, null);
    public static final FancyInventory.DataName<UUID> tportToMoveDataName = new FancyInventory.DataName<Object>("TPortToMove", UUID.class, null);

    public static void openQuickEditSelection(Player player, int page, UUID tportUUID) {
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        TPortAdvancement.Advancement_quickEdit.grant(player);
        QuickEditType currentType = QuickEditType.getForPlayer(player.getUniqueId());
        TPort tport = TPortManager.getTPort(player.getUniqueId(), tportUUID);
        ArrayList<ItemStack> quickEdits = new ArrayList<ItemStack>();
        for (QuickEditType quickEdit : QuickEditType.values()) {
            ItemStack item = new ItemStack(quickEdit.getModel(tport).getItem(player));
            Message itemTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openQuickEditSelection.item.title", quickEdit.getDisplayName());
            Message loreLeft = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openQuickEditSelection.item.click.left", ClickType.LEFT);
            Message loreRight = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openQuickEditSelection.item.click.right", ClickType.RIGHT);
            Message description = quickEdit.getDescription();
            description.translateMessage(playerLang);
            MessageUtils.setCustomItemData(item, colorTheme, itemTitle, Arrays.asList(description, new Message(), loreLeft, loreRight));
            FancyClickEvent.setStringData(item, new NamespacedKey((Plugin)Main.getInstance(), "quickEditType"), quickEdit.name());
            if (quickEdit == currentType) {
                Glow.addGlow(item);
            }
            FancyClickEvent.addFunction(item, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
                NamespacedKey quickEditKey = new NamespacedKey((Plugin)Main.getInstance(), "quickEditType");
                if (pdc.has(quickEditKey, PersistentDataType.STRING)) {
                    String type = (String)pdc.get(quickEditKey, PersistentDataType.STRING);
                    QuickEditType quickEditType = QuickEditType.get(type);
                    ItemFactory.onQuickEdit(whoClicked, pdc, fancyInventory, quickEditType);
                }
            });
            FancyClickEvent.addFunction(item, ClickType.RIGHT, (whoClicked, clickType, pdc, fancyInventory) -> {
                NamespacedKey quickEditKey = new NamespacedKey((Plugin)Main.getInstance(), "quickEditType");
                if (pdc.has(quickEditKey, PersistentDataType.STRING)) {
                    String type = (String)pdc.get(quickEditKey, PersistentDataType.STRING);
                    QuickEditType type_event = QuickEditType.get(type);
                    QuickEditType.setForPlayer(whoClicked.getUniqueId(), type_event);
                    TPortInventories.openTPortGUI(whoClicked.getUniqueId(), whoClicked);
                }
            });
            quickEdits.add(item);
        }
        ItemStack backItem = ItemFactory.createBack(player, ItemFactory.BackType.OWN, ItemFactory.BackType.MAIN, null);
        Message invTitle = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openQuickEditSelection.title", TPortEncapsulation.asTPort(tport));
        FancyInventory inv = FancyInventory.getDynamicScrollableInventory(player, page, QuickEditInventories::openQuickEditSelection, invTitle, quickEdits, backItem);
        inv.setData(TPort.tportUUIDDataName, tportUUID);
        inv.setData(fromQuickEditDataName, true);
        inv.open(player);
    }

    private static void openQuickEditSelection(Player player, int page, FancyInventory prevWindow) {
        QuickEditInventories.openQuickEditSelection(player, page, prevWindow.getData(TPort.tportUUIDDataName));
    }

    private static ItemStack getCornerTPortIcon(TPort tport, Player player) {
        return ItemFactory.toTPortItem(tport, player, List.of(), null);
    }

    public static boolean openTPortTagSelectorGUI(Player player, TPort tport, int page) {
        ArrayList<String> tags = Tag.getTags();
        ArrayList<ItemStack> tagItems = new ArrayList<ItemStack>();
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        for (String tag : tags) {
            Message lore;
            ItemStack is = quick_edit_tag_selection_model.getItem(player);
            ItemMeta im = is.getItemMeta();
            im.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), "tagName"), PersistentDataType.STRING, (Object)tag);
            if (tport.getTags().contains(tag)) {
                Glow.addGlow(im);
                FancyClickEvent.addFunction(im, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
                    NamespacedKey tagNameKey = new NamespacedKey((Plugin)Main.getInstance(), "tagName");
                    if (pdc.has(tagNameKey, PersistentDataType.STRING)) {
                        String tagName = (String)pdc.get(tagNameKey, PersistentDataType.STRING);
                        String tportName = fancyInventory.getData(TPort.tportDataName).getName();
                        TPortCommand.executeTPortCommand((CommandSender)whoClicked, "edit " + tportName + " tag remove " + tagName);
                        QuickEditInventories.openTPortTagSelectorGUI(whoClicked, fancyInventory.getData(FancyInventory.pageDataName), fancyInventory);
                    }
                });
                lore = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortTagSelectionGUI.tag.unselect", ClickType.LEFT);
            } else {
                FancyClickEvent.addFunction(im, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
                    NamespacedKey tagNameKey = new NamespacedKey((Plugin)Main.getInstance(), "tagName");
                    if (pdc.has(tagNameKey, PersistentDataType.STRING)) {
                        String tagName = (String)pdc.get(tagNameKey, PersistentDataType.STRING);
                        String tportName = fancyInventory.getData(TPort.tportDataName).getName();
                        TPortCommand.executeTPortCommand((CommandSender)whoClicked, "edit " + tportName + " tag add " + tagName);
                        QuickEditInventories.openTPortTagSelectorGUI(whoClicked, fancyInventory.getData(FancyInventory.pageDataName), fancyInventory);
                    }
                });
                lore = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortTagSelectionGUI.tag.select", ClickType.LEFT);
            }
            is.setItemMeta(im);
            Message title = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortTagSelectionGUI.tag.name", tag);
            title.translateMessage(playerLang);
            lore.translateMessage(playerLang);
            MessageUtils.setCustomItemData(is, colorTheme, title, Collections.singletonList(lore));
            tagItems.add(is);
        }
        FancyInventory inv = FancyInventory.getDynamicScrollableInventory(player, page, QuickEditInventories::openTPortTagSelectorGUI, ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortTagSelectionGUI.title", TPortEncapsulation.asTPort(tport)), tagItems, ItemFactory.createBack(player, ItemFactory.BackType.QUICK_EDIT, ItemFactory.BackType.OWN, ItemFactory.BackType.MAIN));
        inv.setItem(0, QuickEditInventories.getCornerTPortIcon(tport, player));
        inv.setData(TPort.tportUUIDDataName, tport.getTportID());
        inv.setData(TPort.tportDataName, tport);
        inv.open(player);
        return false;
    }

    private static void openTPortTagSelectorGUI(Player player, int page, FancyInventory fancyInventory) {
        QuickEditInventories.openTPortTagSelectorGUI(player, fancyInventory.getData(TPort.tportDataName), page);
    }

    public static boolean openTPortWhitelistSelectorGUI(Player player, TPort tport, int page, @Nullable FancyInventory prevWindow) {
        List<ItemStack> headItems = ItemFactory.getPlayerList(player, false, true, List.of(ItemFactory.HeadAttributes.TPORT_WHITELIST), List.of(), tport);
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        FancyInventory inv = FancyInventory.getDynamicScrollableInventory(player, page, QuickEditInventories::openTPortWhitelistSelectorGUI, ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortWhitelistSelectionGUI.title", TPortEncapsulation.asTPort(tport)), headItems, ItemFactory.createBack(player, ItemFactory.BackType.QUICK_EDIT, ItemFactory.BackType.OWN, ItemFactory.BackType.MAIN));
        inv.setData("content", headItems);
        inv.setItem(0, QuickEditInventories.getCornerTPortIcon(tport, player));
        inv.setData(TPort.tportDataName, tport);
        inv.setItem(inv.getSize() / 18 * 9, ItemFactory.getSortingItem(player, playerLang, colorTheme, (whoClicked, clickType, pdc, fancyInventory) -> QuickEditInventories.openTPortWhitelistSelectorGUI(whoClicked, fancyInventory.getData(TPort.tportDataName), 0, null)));
        inv.setData(TPort.tportUUIDDataName, tport.getTportID());
        inv.open(player);
        return false;
    }

    public static void openTPortWhitelistSelectorGUI(Player player, int page, FancyInventory fancyInventory) {
        QuickEditInventories.openTPortWhitelistSelectorGUI(player, fancyInventory.getData(TPort.tportDataName), page, fancyInventory);
    }

    private static boolean onWhitelistClone(TPort toCloneTPort, Player player, FancyInventory fancyInventory) {
        UUID cloneToTPortUUID = fancyInventory.getData(whitelistCloneToDataName);
        if (cloneToTPortUUID == null) {
            QuickEditType.setForPlayer(player.getUniqueId(), QuickEditType.WHITELIST_CLONE);
            fancyInventory.setData(whitelistCloneToDataName, toCloneTPort.getTportID());
            ColorTheme.sendInfoTranslation(player, "tport.quickEditInventories.onWhitelistClone.firstSelection", toCloneTPort);
        } else {
            TPort cloneTo;
            fancyInventory.setData(whitelistCloneToDataName, null);
            if (!cloneToTPortUUID.equals(toCloneTPort.getTportID()) && (cloneTo = TPortManager.getTPort(cloneToTPortUUID)) != null) {
                TPortCommand.executeTPortCommand((CommandSender)player, new String[]{"edit", cloneTo.getName(), "whitelist", "clone", toCloneTPort.getName()});
            }
        }
        TPortInventories.openTPortGUI(player.getUniqueId(), player, fancyInventory);
        return false;
    }

    private static boolean openTPortRemoveGUI(Player player, TPort tport, FancyInventory prevWindow) {
        ItemFactory.BackType rightBackType;
        ItemFactory.BackType leftBackType;
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        Message title = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortRemoveGUI.title", TPortEncapsulation.asTPort(tport));
        FancyInventory inv = new FancyInventory(27, title);
        inv.setItem(13, QuickEditInventories.getCornerTPortIcon(tport, player));
        ItemStack confirm = quick_edit_remove_confirm_model.getItem(player);
        FancyClickEvent.addCommand(confirm, ClickType.LEFT, "tport remove " + tport.getName(), "tport own");
        Message confirmTitle = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortRemoveGUI.confirm.title", ClickType.LEFT, TPortEncapsulation.asTPort(tport));
        confirmTitle.translateMessage(playerLang);
        MessageUtils.setCustomItemData(confirm, colorTheme, confirmTitle, null);
        inv.setItem(11, confirm);
        ItemStack cancel = quick_edit_remove_cancel_model.getItem(player);
        ArrayList<Message> cancelLore = new ArrayList<Message>();
        cancelLore.add(new Message());
        ItemFactory.BackType shift_rightBackType = null;
        if (prevWindow.getData(fromQuickEditDataName).booleanValue()) {
            leftBackType = ItemFactory.BackType.QUICK_EDIT;
            rightBackType = ItemFactory.BackType.MAIN;
            shift_rightBackType = ItemFactory.BackType.OWN;
        } else {
            leftBackType = ItemFactory.BackType.OWN;
            rightBackType = ItemFactory.BackType.MAIN;
        }
        Message leftClickMessage = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLocationGUI.cancel.left", ClickType.LEFT, leftBackType.getName());
        leftClickMessage.translateMessage(playerLang);
        FancyClickEvent.addFunction(cancel, ClickType.LEFT, leftBackType.getFunction());
        cancelLore.add(leftClickMessage);
        Message rightClickMessage = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLocationGUI.cancel.right", ClickType.RIGHT, rightBackType.getName());
        rightClickMessage.translateMessage(playerLang);
        FancyClickEvent.addFunction(cancel, ClickType.RIGHT, rightBackType.getFunction());
        cancelLore.add(rightClickMessage);
        if (shift_rightBackType != null) {
            FancyClickEvent.addFunction(cancel, ClickType.SHIFT_RIGHT, shift_rightBackType.getFunction());
            Message shift_rightClickMessage = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLocationGUI.cancel.shiftRight", ClickType.SHIFT_RIGHT, shift_rightBackType.getName());
            shift_rightClickMessage.translateMessage(playerLang);
            cancelLore.add(shift_rightClickMessage);
        }
        Message cancelTitle = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortRemoveGUI.cancel.title", TPortEncapsulation.asTPort(tport));
        cancelTitle.translateMessage(playerLang);
        MessageUtils.setCustomItemData(cancel, colorTheme, cancelTitle, cancelLore);
        inv.setItem(15, cancel);
        inv.setData(TPort.tportUUIDDataName, tport.getTportID());
        inv.open(player);
        return false;
    }

    private static boolean openTPortLocationGUI(Player player, TPort tport, FancyInventory prevWindow) {
        ItemFactory.BackType rightBackType;
        ItemFactory.BackType leftBackType;
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        Message title = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLocationGUI.title", TPortEncapsulation.asTPort(tport));
        FancyInventory inv = new FancyInventory(27, title);
        inv.setItem(13, QuickEditInventories.getCornerTPortIcon(tport, player));
        ItemStack confirm = quick_edit_location_confirm_model.getItem(player);
        FancyClickEvent.addCommand(confirm, ClickType.LEFT, "tport edit " + tport.getName() + " location", "tport own");
        Message confirmTitle = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLocationGUI.confirm.title", ClickType.LEFT, TPortEncapsulation.asTPort(tport));
        confirmTitle.translateMessage(playerLang);
        MessageUtils.setCustomItemData(confirm, colorTheme, confirmTitle, null);
        inv.setItem(11, confirm);
        ItemStack cancel = quick_edit_location_cancel_model.getItem(player);
        ArrayList<Message> cancelLore = new ArrayList<Message>();
        cancelLore.add(new Message());
        ItemFactory.BackType shift_rightBackType = null;
        if (prevWindow.getData(fromQuickEditDataName).booleanValue()) {
            leftBackType = ItemFactory.BackType.QUICK_EDIT;
            rightBackType = ItemFactory.BackType.MAIN;
            shift_rightBackType = ItemFactory.BackType.OWN;
        } else {
            leftBackType = ItemFactory.BackType.OWN;
            rightBackType = ItemFactory.BackType.MAIN;
        }
        Message leftClickMessage = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLocationGUI.cancel.left", ClickType.LEFT, leftBackType.getName());
        leftClickMessage.translateMessage(playerLang);
        FancyClickEvent.addFunction(cancel, ClickType.LEFT, leftBackType.getFunction());
        cancelLore.add(leftClickMessage);
        Message rightClickMessage = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLocationGUI.cancel.right", ClickType.RIGHT, rightBackType.getName());
        rightClickMessage.translateMessage(playerLang);
        FancyClickEvent.addFunction(cancel, ClickType.RIGHT, rightBackType.getFunction());
        cancelLore.add(rightClickMessage);
        if (shift_rightBackType != null) {
            FancyClickEvent.addFunction(cancel, ClickType.SHIFT_RIGHT, shift_rightBackType.getFunction());
            Message shift_rightClickMessage = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLocationGUI.cancel.shiftRight", ClickType.SHIFT_RIGHT, shift_rightBackType.getName());
            shift_rightClickMessage.translateMessage(playerLang);
            cancelLore.add(shift_rightClickMessage);
        }
        Message cancelTitle = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLocationGUI.cancel.title", TPortEncapsulation.asTPort(tport));
        cancelTitle.translateMessage(playerLang);
        MessageUtils.setCustomItemData(cancel, colorTheme, cancelTitle, cancelLore);
        inv.setItem(15, cancel);
        inv.setData(TPort.tportUUIDDataName, tport.getTportID());
        inv.open(player);
        return false;
    }

    private static boolean openTPortPrivateGUI(Player player, TPort tport, FancyInventory prevWindow) {
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        Message title = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortPrivateGUI.title", TPortEncapsulation.asTPort(tport));
        FancyInventory inv = new FancyInventory(27, title);
        int itemIndex = 10;
        for (TPort.PrivateState privateState : TPort.PrivateState.values()) {
            ItemStack is = privateState.getInventoryModel().getItem(player);
            if (tport.getPrivateState().equals(privateState)) {
                Glow.addGlow(is);
            }
            Message leftClickMessage = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortPrivateGUI.privateState.leftClick", ClickType.LEFT);
            Message rightClickMessage = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortPrivateGUI.privateState.rightClick", ClickType.RIGHT);
            MessageUtils.setCustomItemData(is, colorTheme, privateState.getName(null, null), Arrays.asList(leftClickMessage, rightClickMessage));
            FancyClickEvent.setStringData(is, new NamespacedKey((Plugin)Main.getInstance(), "privateState"), privateState.name());
            FancyClickEvent.addCommand(is, ClickType.LEFT, "tport edit " + tport.getName() + " private " + privateState.name(), "tport own");
            FancyClickEvent.addFunction(is, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> QuickEditInventories.openTPortPrivateGUI(whoClicked, fancyInventory.getData(TPort.tportDataName), fancyInventory));
            FancyClickEvent.addFunction(is, ClickType.RIGHT, (whoClicked, clickType, pdc, fancyInventory) -> {
                String ps = (String)pdc.get(new NamespacedKey((Plugin)Main.getInstance(), "privateState"), PersistentDataType.STRING);
                TPort.PrivateState.get(ps, TPort.PrivateState.OPEN).getDescription().sendAndTranslateMessage(whoClicked);
            });
            inv.setItem(itemIndex++, is);
        }
        inv.setItem(17, ItemFactory.createBack(player, ItemFactory.BackType.QUICK_EDIT, ItemFactory.BackType.OWN, ItemFactory.BackType.MAIN));
        inv.setData(TPort.tportUUIDDataName, tport.getTportID());
        inv.setData(TPort.tportDataName, tport);
        inv.setItem(0, QuickEditInventories.getCornerTPortIcon(tport, player));
        inv.open(player);
        return false;
    }

    private static int newRange(TPort tport, int add) {
        return Math.max(0, tport.getRange() + add);
    }

    private static boolean openTPortRangeGUI(Player player, TPort tport) {
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        ItemStack rangeDisplay = quick_edit_range_model.getItem(player);
        Message rangeMessage = tport.getRange() == 0 ? ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "tport.command.edit.range.off", new Object[0]) : ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "%s", tport.getRange());
        Message rangeDisplayTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortRangeGUI.rangeDisplay", rangeMessage);
        MessageUtils.setCustomItemData(rangeDisplay, colorTheme, rangeDisplayTitle, null);
        ItemStack rangeAdd = quick_edit_range_add_model.getItem(player);
        Message rangeAddTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortRangeGUI.rangeAdd.title", new Object[0]);
        Message rangeAdd_1 = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortRangeGUI.rangeAdd.value", ClickType.LEFT, 1);
        Message rangeAdd_10 = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortRangeGUI.rangeAdd.value", ClickType.RIGHT, 10);
        Message rangeAdd_25 = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortRangeGUI.rangeAdd.value", ClickType.SHIFT_LEFT, 25);
        Message rangeAdd_100 = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortRangeGUI.rangeAdd.value", ClickType.SHIFT_RIGHT, 100);
        MessageUtils.setCustomItemData(rangeAdd, colorTheme, rangeAddTitle, Arrays.asList(rangeAdd_1, rangeAdd_10, rangeAdd_25, rangeAdd_100));
        FancyClickEvent.addCommand(rangeAdd, ClickType.LEFT, "tport edit " + tport.getName() + " range " + QuickEditInventories.newRange(tport, 1));
        FancyClickEvent.addCommand(rangeAdd, ClickType.RIGHT, "tport edit " + tport.getName() + " range " + QuickEditInventories.newRange(tport, 10));
        FancyClickEvent.addCommand(rangeAdd, ClickType.SHIFT_LEFT, "tport edit " + tport.getName() + " range " + QuickEditInventories.newRange(tport, 25));
        FancyClickEvent.addCommand(rangeAdd, ClickType.SHIFT_RIGHT, "tport edit " + tport.getName() + " range " + QuickEditInventories.newRange(tport, 100));
        FancyClickEvent.addFunction(rangeAdd, (whoClicked, clickType, pdc, fancyInventory) -> {
            UUID tportUUID = fancyInventory.getData(TPort.tportUUIDDataName);
            QuickEditInventories.openTPortRangeGUI(whoClicked, TPortManager.getTPort(whoClicked.getUniqueId(), tportUUID));
        }, ClickType.LEFT, ClickType.RIGHT, ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT);
        ItemStack rangeRemove = quick_edit_range_remove_model.getItem(player);
        Message rangeRemoveTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortRangeGUI.rangeRemove.title", new Object[0]);
        Message rangeRemove_1 = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortRangeGUI.rangeRemove.value", ClickType.LEFT, 1);
        Message rangeRemove_10 = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortRangeGUI.rangeRemove.value", ClickType.RIGHT, 10);
        Message rangeRemove_25 = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortRangeGUI.rangeRemove.value", ClickType.SHIFT_LEFT, 25);
        Message rangeRemove_100 = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortRangeGUI.rangeRemove.value", ClickType.SHIFT_RIGHT, 100);
        MessageUtils.setCustomItemData(rangeRemove, colorTheme, rangeRemoveTitle, Arrays.asList(rangeRemove_1, rangeRemove_10, rangeRemove_25, rangeRemove_100));
        FancyClickEvent.addCommand(rangeRemove, ClickType.LEFT, "tport edit " + tport.getName() + " range " + QuickEditInventories.newRange(tport, -1));
        FancyClickEvent.addCommand(rangeRemove, ClickType.RIGHT, "tport edit " + tport.getName() + " range " + QuickEditInventories.newRange(tport, -10));
        FancyClickEvent.addCommand(rangeRemove, ClickType.SHIFT_LEFT, "tport edit " + tport.getName() + " range " + QuickEditInventories.newRange(tport, -25));
        FancyClickEvent.addCommand(rangeRemove, ClickType.SHIFT_RIGHT, "tport edit " + tport.getName() + " range " + QuickEditInventories.newRange(tport, -100));
        FancyClickEvent.addFunction(rangeRemove, (whoClicked, clickType, pdc, fancyInventory) -> {
            UUID tportUUID = fancyInventory.getData(TPort.tportUUIDDataName);
            QuickEditInventories.openTPortRangeGUI(whoClicked, TPortManager.getTPort(whoClicked.getUniqueId(), tportUUID));
        }, ClickType.LEFT, ClickType.RIGHT, ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT);
        FancyInventory inv = new FancyInventory(27, ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortRangeGUI.title", tport));
        inv.setData(TPort.tportUUIDDataName, tport.getTportID());
        inv.setItem(0, QuickEditInventories.getCornerTPortIcon(tport, player));
        inv.setItem(11, rangeRemove);
        inv.setItem(13, rangeDisplay);
        inv.setItem(15, rangeAdd);
        inv.setItem(17, ItemFactory.createBack(player, ItemFactory.BackType.QUICK_EDIT, ItemFactory.BackType.OWN, ItemFactory.BackType.MAIN));
        inv.open(player);
        return false;
    }

    private static void openTPortDynmapIconGUI(Player player, TPort tport, int page) {
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        List<Pair<String, String>> icons = DynmapHandler.getIcons();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (icons != null) {
            icons.sort(Comparator.comparing(Pair::getLeft));
            for (Pair<String, String> icon : icons) {
                ItemStack is = (icon.getLeft().equals("tport_icon") ? quick_edit_dynmap_icon_tport_model : quick_edit_dynmap_icon_model).getItem(player);
                Message markerTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortDynmapIconGUI.icon.title", icon.getRight());
                Message markerLeft = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortDynmapIconGUI.icon.leftClick", ClickType.LEFT);
                MessageUtils.setCustomItemData(is, colorTheme, markerTitle, List.of(markerLeft));
                FancyClickEvent.addCommand(is, ClickType.LEFT, "tport edit " + tport.getName() + " dynmap icon " + icon.getRight());
                if (icon.getLeft().equals("tport_icon")) {
                    items.add(0, is);
                    continue;
                }
                items.add(is);
            }
        }
        FancyInventory inv = FancyInventory.getDynamicScrollableInventory(player, page, QuickEditInventories::openTPortDynmapIconGUI, ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortDynmapIconGUI.title", tport), items, ItemFactory.createBack(player, ItemFactory.BackType.QUICK_EDIT, ItemFactory.BackType.OWN, ItemFactory.BackType.MAIN));
        inv.setData(TPort.tportDataName, tport);
        inv.setData(TPort.tportUUIDDataName, tport.getTportID());
        inv.setItem(0, QuickEditInventories.getCornerTPortIcon(tport, player));
        inv.open(player);
    }

    private static void openTPortDynmapIconGUI(Player player, int page, FancyInventory prevWindow) {
        QuickEditInventories.openTPortDynmapIconGUI(player, prevWindow.getData(TPort.tportDataName), page);
    }

    private static void openTPortBlueMapIconGUI(Player player, TPort tport, int page) {
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        try {
            ArrayList<String> icons = BlueMapHandler.getBlueMapImages();
            if (icons != null) {
                for (String icon : icons) {
                    ItemStack is = (icon.equals("tport_tport.png") ? quick_edit_bluemap_icon_tport_model : quick_edit_bluemap_icon_model).getItem(player);
                    Message markerTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortBlueMapIconGUI.icon.title", icon);
                    Message markerLeft = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortBlueMapIconGUI.icon.leftClick", ClickType.LEFT);
                    MessageUtils.setCustomItemData(is, colorTheme, markerTitle, List.of(markerLeft));
                    FancyClickEvent.addCommand(is, ClickType.LEFT, "tport edit " + tport.getName() + " blueMap icon " + icon);
                    if (icon.equals("tport_tport.png")) {
                        items.add(0, is);
                        continue;
                    }
                    items.add(is);
                }
            }
        }
        catch (Throwable icons) {
            // empty catch block
        }
        FancyInventory inv = FancyInventory.getDynamicScrollableInventory(player, page, QuickEditInventories::openTPortBlueMapIconGUI, ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortBlueMapIconGUI.title", tport), items, ItemFactory.createBack(player, ItemFactory.BackType.QUICK_EDIT, ItemFactory.BackType.OWN, ItemFactory.BackType.MAIN));
        inv.setData(TPort.tportDataName, tport);
        inv.setData(TPort.tportUUIDDataName, tport.getTportID());
        inv.setItem(0, QuickEditInventories.getCornerTPortIcon(tport, player));
        inv.open(player);
    }

    private static void openTPortBlueMapIconGUI(Player player, int page, FancyInventory prevWindow) {
        QuickEditInventories.openTPortBlueMapIconGUI(player, prevWindow.getData(TPort.tportDataName), page);
    }

    private static void openTPortLogRead_filterGUI(Player player, int page, FancyInventory prevWindow) {
        QuickEditInventories.openTPortLogRead_filterGUI(player, prevWindow.getData(TPort.tportDataName), prevWindow.getData("filterUUID", UUID.class), page, prevWindow);
    }

    private static void openTPortLogRead_filterGUI(Player player, TPort tport, @Nullable UUID oldFilterUUID, int page, @Nullable FancyInventory prevWindow) {
        List<ItemStack> rawHeadItems = prevWindow == null ? ItemFactory.getPlayerList(player, true, true, List.of(ItemFactory.HeadAttributes.TPORT_LOG_READ_FILTER), List.of(), null) : prevWindow.getData("content", List.class);
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        Message title = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLogRead_filterGUI.title", tport);
        FancyInventory inv = FancyInventory.getDynamicScrollableInventory(player, page, QuickEditInventories::openTPortLogRead_filterGUI, title, rawHeadItems, ItemFactory.createBack(player, ItemFactory.BackType.LOG_SETTINGS_READ, ItemFactory.BackType.OWN, ItemFactory.BackType.MAIN));
        inv.setData("content", rawHeadItems);
        inv.setData(TPort.tportDataName, tport);
        inv.setData(TPort.tportUUIDDataName, tport.getTportID());
        inv.setData("filterUUID", oldFilterUUID);
        inv.setItem(0, QuickEditInventories.getCornerTPortIcon(tport, player));
        inv.setItem(inv.getSize() / 18 * 9, ItemFactory.getSortingItem(player, playerLang, colorTheme, (whoClicked, clickType, pdc, fancyInventory) -> QuickEditInventories.openTPortLogRead_filterGUI(whoClicked, fancyInventory.getData(TPort.tportDataName), fancyInventory.getData("filterUUID", UUID.class), 0, null)));
        inv.open(player);
    }

    public static void openTPortLogReadGUI(Player player, TPort tport) {
        QuickEditInventories.openTPortLogReadGUI(player, tport, null, 0);
    }

    public static void openTPortLogReadGUI(Player player, TPort tport, @Nullable UUID filterUUID) {
        QuickEditInventories.openTPortLogReadGUI(player, tport, filterUUID, 0);
    }

    private static void openTPortLogReadGUI(Player player, TPort tport, @Nullable UUID filterUUID, int page) {
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        ArrayList<TPort.LogEntry> logbook = tport.getLogBook();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(logbook.size());
        String format = TimeFormat.getTimeFormat(player);
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(TimeZone.getTimeZone(player));
        for (TPort.LogEntry log : logbook) {
            if (filterUUID != null && !log.teleportedUUID().equals(filterUUID)) continue;
            ItemStack is = ItemFactory.getHead(log.teleportedUUID(), player, List.of(ItemFactory.HeadAttributes.TPORT_LOG_READ), (Object)new ImmutableTriple((Object)tport, (Object)log, (Object)sdf));
            items.add(is);
        }
        Message invTitle = filterUUID == null ? ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLogReadGUI.all.title", tport) : ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLogReadGUI.filtered.title", tport, PlayerEncapsulation.asPlayer(filterUUID));
        FancyInventory inv = FancyInventory.getDynamicScrollableInventory(player, page, QuickEditInventories::openTPortLogReadGUI, invTitle, items, ItemFactory.createBack(player, ItemFactory.BackType.TPORT_LOG, ItemFactory.BackType.OWN, ItemFactory.BackType.MAIN));
        inv.setData(TPort.tportDataName, tport);
        if (filterUUID != null) {
            inv.setData("filterUUID", filterUUID);
        }
        ItemStack chatMode = quick_edit_log_read_chat_model.getItem(player);
        Message chatModeTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortLogReadGUI.chatMode", ClickType.LEFT);
        MessageUtils.setCustomItemData(chatMode, colorTheme, chatModeTitle, null);
        FancyClickEvent.addFunction(chatMode, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> Read.readLog_chat(whoClicked, fancyInventory.getData(TPort.tportDataName), fancyInventory.getData("filterUUID", UUID.class, null)));
        inv.setItem(18, chatMode);
        ItemStack filterSelection = quick_edit_log_read_filter_model.getItem(player);
        Message filterSelectionTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortLogReadGUI.filterSelection.title", new Object[0]);
        Message filterSelect = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortLogReadGUI.filterSelection.select", ClickType.LEFT);
        Message filterReset = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortLogReadGUI.filterSelection.reset", ClickType.RIGHT);
        MessageUtils.setCustomItemData(filterSelection, colorTheme, filterSelectionTitle, List.of(new Message(), filterSelect, filterReset));
        FancyClickEvent.addFunction(filterSelection, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> QuickEditInventories.openTPortLogRead_filterGUI(whoClicked, fancyInventory.getData(TPort.tportDataName), fancyInventory.getData("filterUUID", UUID.class), 0, null));
        FancyClickEvent.addFunction(filterSelection, ClickType.RIGHT, (whoClicked, clickType, pdc, fancyInventory) -> QuickEditInventories.openTPortLogReadGUI(whoClicked, fancyInventory.getData(TPort.tportDataName)));
        inv.setItem(9, filterSelection);
        inv.setItem(0, QuickEditInventories.getCornerTPortIcon(tport, player));
        inv.open(player);
    }

    private static void openTPortLogReadGUI(Player player, int page, FancyInventory prevWindow) {
        QuickEditInventories.openTPortLogReadGUI(player, prevWindow.getData(TPort.tportDataName), prevWindow.getData("filterUUID", UUID.class), page);
    }

    private static void openTPortLogSelectorGUI(Player player, TPort tport, int page, @Nullable FancyInventory prevWindow) {
        List<ItemStack> headItems = ItemFactory.getPlayerList(player, true, true, List.of(ItemFactory.HeadAttributes.TPORT_LOG_SELECTION), List.of(), tport);
        FancyInventory inv = FancyInventory.getDynamicScrollableInventory(player, page, QuickEditInventories::openTPortLogSelectorGUI, ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLogSelectionGUI.title", TPortEncapsulation.asTPort(tport)), headItems, ItemFactory.createBack(player, ItemFactory.BackType.TPORT_LOG, ItemFactory.BackType.OWN, ItemFactory.BackType.MAIN));
        inv.setData("content", headItems);
        inv.setItem(0, QuickEditInventories.getCornerTPortIcon(tport, player));
        inv.setData(TPort.tportDataName, tport);
        inv.setData(TPort.tportUUIDDataName, tport.getTportID());
        inv.setItem(inv.getSize() / 18 * 9, ItemFactory.getSortingItem(player, Language.getPlayerLang(player.getUniqueId()), ColorTheme.getTheme(player), (whoClicked, clickType, pdc, fancyInventory) -> QuickEditInventories.openTPortLogSelectorGUI(whoClicked, fancyInventory.getData(TPort.tportDataName), 0, null)));
        inv.open(player);
    }

    static void openTPortLogSelectorGUI(Player player, int page, FancyInventory prevWindow) {
        QuickEditInventories.openTPortLogSelectorGUI(player, prevWindow.getData(TPort.tportDataName), page, prevWindow);
    }

    public static boolean openTPortLogGUI(Player player, TPort tport) {
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        ItemStack editItem = quick_edit_log_edit_model.getItem(player);
        Message editTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortLogGUI.edit.title", new Object[0]);
        MessageUtils.setCustomItemData(editItem, colorTheme, editTitle, null);
        FancyClickEvent.addFunction(editItem, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> QuickEditInventories.openTPortLogSelectorGUI(whoClicked, fancyInventory.getData(TPort.tportDataName), 0, null));
        ItemStack deleteItem = quick_edit_log_delete_model.getItem(player);
        Message deleteTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortLogGUI.delete.title", ClickType.SHIFT_LEFT);
        MessageUtils.setCustomItemData(deleteItem, colorTheme, deleteTitle, null);
        FancyClickEvent.addCommand(deleteItem, ClickType.SHIFT_LEFT, "tport log delete " + tport.getName());
        FancyClickEvent.addFunction(deleteItem, ClickType.SHIFT_LEFT, (whoClicked, clickType, pdc, fancyInventory) -> QuickEditInventories.openTPortLogGUI(whoClicked, fancyInventory.getData(TPort.tportDataName)));
        ItemStack readItem = quick_edit_log_read_model.getItem(player);
        Message readTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortLogGUI.read.title", new Object[0]);
        Message readInventory = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortLogGUI.read.inventory", ClickType.LEFT);
        Message readChat = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortLogGUI.read.chat", ClickType.SHIFT_LEFT);
        MessageUtils.setCustomItemData(readItem, colorTheme, readTitle, List.of(readInventory, readChat));
        FancyClickEvent.addFunction(readItem, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> QuickEditInventories.openTPortLogReadGUI(whoClicked, fancyInventory.getData(TPort.tportDataName)));
        FancyClickEvent.addFunction(readItem, ClickType.SHIFT_LEFT, (whoClicked, clickType, pdc, fancyInventory) -> Read.readLog_chat(whoClicked, fancyInventory.getData(TPort.tportDataName)));
        ItemStack clearItem = quick_edit_log_clear_model.getItem(player);
        Message clearTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortLogGUI.clear.title", ClickType.SHIFT_RIGHT);
        MessageUtils.setCustomItemData(clearItem, colorTheme, clearTitle, null);
        FancyClickEvent.addCommand(clearItem, ClickType.SHIFT_RIGHT, "tport log clear " + tport.getName());
        ItemStack defaultItem = tport.getDefaultLogMode().getModel().getItem(player);
        Message defaultTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortLogGUI.default.title", tport.getDefaultLogMode());
        Message defaultLore = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortLogGUI.default.lore", ClickType.LEFT, tport.getDefaultLogMode().getNext());
        MessageUtils.setCustomItemData(defaultItem, colorTheme, defaultTitle, List.of(defaultLore));
        FancyClickEvent.addCommand(defaultItem, ClickType.LEFT, "tport log default " + tport.getName() + " " + String.valueOf(tport.getDefaultLogMode().getNext()));
        FancyClickEvent.addFunction(defaultItem, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> QuickEditInventories.openTPortLogGUI(whoClicked, fancyInventory.getData(TPort.tportDataName)));
        FancyInventory inv = new FancyInventory(27, ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLogGUI.title", tport));
        inv.setData(TPort.tportUUIDDataName, tport.getTportID());
        inv.setData(TPort.tportDataName, tport);
        inv.setItem(0, QuickEditInventories.getCornerTPortIcon(tport, player));
        inv.setItem(10, defaultItem);
        inv.setItem(11, editItem);
        inv.setItem(13, deleteItem);
        inv.setItem(15, readItem);
        inv.setItem(16, clearItem);
        inv.setItem(17, ItemFactory.createBack(player, ItemFactory.BackType.QUICK_EDIT, ItemFactory.BackType.OWN, ItemFactory.BackType.MAIN));
        inv.open(player);
        return false;
    }

    private static void openTPortOfferGUI(Player player, TPort tport, boolean fromQuickEdit) {
        QuickEditInventories.openTPortOfferGUI(player, tport, 0, fromQuickEdit, null);
    }

    private static void openTPortOfferGUI(Player player, TPort tport, int page, boolean fromQuickEdit, @Nullable FancyInventory prevWindow) {
        List<ItemStack> rawHeadItems = prevWindow == null ? ItemFactory.getPlayerList(player, false, true, List.of(ItemFactory.HeadAttributes.OFFER_TO_PLAYER), List.of(), new Pair<TPort, Boolean>(tport, fromQuickEdit)) : prevWindow.getData("offerContent", List.class);
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        Message title = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortOfferGUI.title", tport);
        FancyInventory inv = FancyInventory.getDynamicScrollableInventory(player, page, QuickEditInventories::openTPortOfferGUI, title, rawHeadItems, ItemFactory.createBack(player, ItemFactory.BackType.QUICK_EDIT, ItemFactory.BackType.OWN, ItemFactory.BackType.MAIN));
        inv.setData("offerContent", rawHeadItems);
        inv.setItem(0, QuickEditInventories.getCornerTPortIcon(tport, player));
        inv.setData(TPort.tportDataName, tport);
        inv.setItem(inv.getSize() / 18 * 9, ItemFactory.getSortingItem(player, playerLang, colorTheme, (whoClicked, clickType, pdc, fancyInventory) -> QuickEditInventories.openTPortOfferGUI(whoClicked, fancyInventory.getData(TPort.tportDataName), fancyInventory.getData(fromQuickEditDataName))));
        inv.setData(TPort.tportUUIDDataName, tport.getTportID());
        inv.setData(fromQuickEditDataName, fromQuickEdit);
        inv.open(player);
    }

    private static void openTPortOfferGUI(Player player, int page, FancyInventory prevWindow) {
        QuickEditInventories.openTPortOfferGUI(player, prevWindow.getData(TPort.tportDataName), page, prevWindow.getData(fromQuickEditDataName), prevWindow);
    }

    private static boolean openTPortItemGUI(Player player, TPort tport) {
        QuickEditInventories.openTPortItemGUI(player, tport, 0, null);
        return false;
    }

    private static void openTPortItemGUI(Player player, TPort tport, int page, @Nullable FancyInventory prevWindow) {
        ArrayList<ItemStack> items;
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player);
        if (prevWindow == null) {
            items = new ArrayList();
            for (ItemStack dontToutchItemStack : player.getInventory().getContents()) {
                ItemMeta itemMeta;
                if (dontToutchItemStack == null) continue;
                ItemStack is = dontToutchItemStack.clone();
                FancyClickEvent.setStringData(is, new NamespacedKey((Plugin)Main.getInstance(), "itemData"), is.toString());
                Message itemTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortItemGUI.item.title", new Object[0]);
                Message all = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortItemGUI.item.select.all", ClickType.LEFT);
                Message one = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortItemGUI.item.select.one", ClickType.RIGHT);
                Message tportTakesItem = Features.Feature.TPortTakesItem.isEnabled() ? ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortItemGUI.item.tportTakesItem.enabled", new Object[0]) : ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortItemGUI.item.tportTakesItem.disabled", new Object[0]);
                Message returnItem = tport.shouldReturnItem() ? ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortItemGUI.item.returnItem.true", tport.getItem(), tport.getItem().getAmount()) : ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortItemGUI.item.returnItem.false", new Object[0]);
                MessageUtils.setCustomItemData(is, colorTheme, itemTitle, List.of(new Message(), all, one, new Message(), tportTakesItem, returnItem));
                ItemMeta im = is.getItemMeta();
                if (im == null) continue;
                FancyClickEvent.removeAllFunctions(im);
                im.getEnchants().keySet().forEach(arg_0 -> ((ItemMeta)im).removeEnchant(arg_0));
                Stream<ItemFlag> stream = Arrays.stream(ItemFlag.values());
                Objects.requireNonNull(im);
                stream.forEach(xva$0 -> itemMeta.addItemFlags(new ItemFlag[]{xva$0}));
                try {
                    im.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_LORE});
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                is.setItemMeta(im);
                FancyClickEvent.addFunction(is, (whoClicked, clickType, pdc, fancyInventory) -> {
                    String innerItemData = (String)pdc.get(new NamespacedKey((Plugin)Main.getInstance(), "itemData"), PersistentDataType.STRING);
                    for (ItemStack innerDontToutchItemStack : whoClicked.getInventory().getContents()) {
                        ItemStack innerItem;
                        if (innerDontToutchItemStack == null || !(innerItem = innerDontToutchItemStack.clone()).toString().equals(innerItemData)) continue;
                        Item.setTPortDisplayItem(whoClicked, fancyInventory.getData(TPort.tportDataName), innerItem, clickType == ClickType.RIGHT);
                        QuickEditInventories.openQuickEditSelection(whoClicked, 0, fancyInventory.getData(TPort.tportDataName).getTportID());
                        return;
                    }
                    ColorTheme.sendErrorTranslation(whoClicked, "tport.quickEditInventories.openTPortItemGUI.itemNotFound", new Object[0]);
                    QuickEditInventories.openTPortItemGUI(whoClicked, fancyInventory.getData(TPort.tportDataName));
                }, ClickType.LEFT, ClickType.RIGHT);
                items.add(is);
            }
        } else {
            items = prevWindow.getData("content", List.class);
        }
        Message title = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortItemGUI.title", new Object[0]);
        FancyInventory inv = FancyInventory.getDynamicScrollableInventory(player, page, QuickEditInventories::openTPortItemGUI, title, items, ItemFactory.createBack(player, ItemFactory.BackType.QUICK_EDIT, ItemFactory.BackType.OWN, ItemFactory.BackType.MAIN));
        inv.setData("content", items);
        inv.setData(TPort.tportUUIDDataName, tport.getTportID());
        inv.setData(TPort.tportDataName, tport);
        ItemStack reload = quick_edit_item_reload_model.getItem(player);
        Message reloadTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.quickEditInventories.openTPortItemGUI.reload.title", ClickType.LEFT);
        MessageUtils.setCustomItemData(reload, colorTheme, reloadTitle, null);
        FancyClickEvent.addFunction(reload, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> QuickEditInventories.openTPortItemGUI(whoClicked, fancyInventory.getData(TPort.tportDataName)));
        inv.setItem(inv.getSize() - 9, reload);
        inv.open(player);
    }

    private static void openTPortItemGUI(Player player, int page, FancyInventory prevWindow) {
        QuickEditInventories.openTPortItemGUI(player, prevWindow.getData(TPort.tportDataName), page, prevWindow);
    }

    private static boolean onMove(TPort moveToTPort, Player player, FancyInventory fancyInventory) {
        UUID toMoveTPort = fancyInventory.getData(tportToMoveDataName);
        if (toMoveTPort == null) {
            QuickEditType.setForPlayer(player.getUniqueId(), QuickEditType.MOVE);
            fancyInventory.setData(tportToMoveDataName, moveToTPort.getTportID());
        } else {
            TPort tmpTPort;
            fancyInventory.setData(tportToMoveDataName, null);
            if (!toMoveTPort.equals(moveToTPort.getTportID()) && (tmpTPort = TPortManager.getTPort(toMoveTPort)) != null) {
                TPortCommand.executeTPortCommand((CommandSender)player, new String[]{"edit", tmpTPort.getName(), "move", moveToTPort.getName()});
            }
        }
        TPortInventories.openTPortGUI(player.getUniqueId(), player, fancyInventory);
        return false;
    }

    public static enum QuickEditType {
        ITEM(quick_edit_item_model, (tport, player, fancyInventory) -> QuickEditInventories.openTPortItemGUI(player, tport)),
        PRIVATE(tport -> tport.getPrivateState().getInventoryModel(), (tport, player, fancyInventory) -> QuickEditInventories.openTPortPrivateGUI(player, tport, fancyInventory)),
        WHITELIST(quick_edit_whitelist_model, (tport, player, fancyInventory) -> QuickEditInventories.openTPortWhitelistSelectorGUI(player, tport, 0, null)),
        WHITELIST_VISIBILITY(tport -> tport.getWhitelistVisibility().getModel(), (tport, player, fancyInventory) -> {
            TPortCommand.executeTPortCommand((CommandSender)player, new String[]{"edit", tport.getName(), "whitelist", "visibility", tport.getWhitelistVisibility().getNext().name()});
            return true;
        }),
        WHITELIST_CLONE(quick_edit_whitelist_clone_model, QuickEditInventories::onWhitelistClone),
        RANGE(quick_edit_range_model, (tport, player, fancyInventory) -> QuickEditInventories.openTPortRangeGUI(player, tport)),
        MOVE(quick_edit_move_model, QuickEditInventories::onMove),
        LOG(quick_edit_log_model, (tport, player, fancyInventory) -> QuickEditInventories.openTPortLogGUI(player, tport)),
        NOTIFY(tport -> tport.getNotifyMode().getModel(), (tport, player, fancyInventory) -> {
            TPortCommand.executeTPortCommand((CommandSender)player, new String[]{"log", "notify", tport.getName(), tport.getNotifyMode().getNext().name()});
            return true;
        }),
        PREVIEW(tport -> tport.getPreviewState().getModel(), (tport, player, fancyInventory) -> {
            if (Features.Feature.Preview.isEnabled()) {
                TPortCommand.executeTPortCommand((CommandSender)player, new String[]{"edit", tport.getName(), "preview", tport.getPreviewState().getNext().name()});
                return true;
            }
            Features.Feature.Preview.sendDisabledMessage(player);
            return false;
        }),
        TAG(quick_edit_tag_model, (tport, player, fancyInventory) -> QuickEditInventories.openTPortTagSelectorGUI(player, tport, 0)),
        REMOVE(quick_edit_remove_model, (tport, player, fancyInventory) -> QuickEditInventories.openTPortRemoveGUI(player, tport, fancyInventory)),
        LOCATION(quick_edit_location_model, (tport, player, fancyInventory) -> QuickEditInventories.openTPortLocationGUI(player, tport, fancyInventory)),
        NAME(quick_edit_name_model, (tport, player, fancyInventory) -> {
            FancyClickEvent.FancyClickRunnable onAccept = (whoClicked, clickType, pdc, keyboardInventory) -> {
                String newTPortName = KeyboardGUI.getKeyboardOutput(keyboardInventory);
                String tportName = keyboardInventory.getData(TPort.tportNameDataName);
                TPortCommand.executeTPortCommand((CommandSender)whoClicked, new String[]{"edit", tportName, "name", newTPortName});
                if (keyboardInventory.getData(fromQuickEditDataName).booleanValue()) {
                    QuickEditInventories.openQuickEditSelection(whoClicked, 0, keyboardInventory.getData(TPort.tportUUIDDataName));
                } else {
                    TPortInventories.openTPortGUI(whoClicked.getUniqueId(), whoClicked);
                }
            };
            FancyClickEvent.FancyClickRunnable onReject = (whoClicked, clickType, pdc, keyboardInventory) -> {
                if (keyboardInventory.getData(fromQuickEditDataName).booleanValue()) {
                    QuickEditInventories.openQuickEditSelection(whoClicked, 0, keyboardInventory.getData(TPort.tportUUIDDataName));
                } else {
                    TPortInventories.openTPortGUI(whoClicked.getUniqueId(), whoClicked);
                }
            };
            FancyInventory inv = KeyboardGUI.openKeyboard(player, onAccept, onReject, 88);
            inv.setData(TPort.tportNameDataName, tport.getName());
            inv.setData(TPort.tportUUIDDataName, tport.getTportID());
            inv.setData(fromQuickEditDataName, fancyInventory.getData(fromQuickEditDataName));
            return false;
        }),
        DESCRIPTION(quick_edit_description_model, (tport, player, fancyInventory) -> {
            FancyClickEvent.FancyClickRunnable onAccept = (whoClicked, clickType, pdc, keyboardInventory) -> {
                String description = KeyboardGUI.getKeyboardOutput(keyboardInventory);
                description = description.replace("\n", "\\n");
                String tportName = keyboardInventory.getData(TPort.tportNameDataName);
                TPortCommand.executeTPortCommand((CommandSender)whoClicked, new String[]{"edit", tportName, "description", "set", description});
                if (keyboardInventory.getData(fromQuickEditDataName).booleanValue()) {
                    QuickEditInventories.openQuickEditSelection(whoClicked, 0, keyboardInventory.getData(TPort.tportUUIDDataName));
                } else {
                    TPortInventories.openTPortGUI(whoClicked.getUniqueId(), whoClicked);
                }
            };
            FancyClickEvent.FancyClickRunnable onReject = (whoClicked, clickType, pdc, keyboardInventory) -> {
                if (keyboardInventory.getData(fromQuickEditDataName).booleanValue()) {
                    QuickEditInventories.openQuickEditSelection(whoClicked, 0, keyboardInventory.getData(TPort.tportUUIDDataName));
                } else {
                    TPortInventories.openTPortGUI(whoClicked.getUniqueId(), whoClicked);
                }
            };
            FancyInventory inv = KeyboardGUI.openKeyboard(player, onAccept, onReject, tport.getRawDescription(), "#5555ff", 127);
            inv.setData(TPort.tportNameDataName, tport.getName());
            inv.setData(TPort.tportUUIDDataName, tport.getTportID());
            inv.setData(fromQuickEditDataName, fancyInventory.getData(fromQuickEditDataName));
            return false;
        }),
        PUBLIC_TP(QuickEditType::getPublicTPortModel, (tport, player, fancyInventory) -> {
            if (Features.Feature.PublicTP.isEnabled()) {
                if (tport.isPublicTPort()) {
                    TPortCommand.executeTPortCommand((CommandSender)player, new String[]{"public", "remove", tport.getName()});
                } else {
                    TPortCommand.executeTPortCommand((CommandSender)player, new String[]{"public", "add", tport.getName()});
                }
                return true;
            }
            Features.Feature.PublicTP.sendDisabledMessage(player);
            return false;
        }),
        DYNMAP_SHOW(QuickEditType::getDynmapShowModel, (tport, player, fancyInventory) -> {
            if (DynmapCommand.checkDynmapState(player)) {
                TPortCommand.executeTPortCommand((CommandSender)player, new String[]{"edit", tport.getName(), "dynmap", "show", String.valueOf(!tport.showOnDynmap())});
                return true;
            }
            return false;
        }),
        DYNMAP_ICON(DynmapHandler.isEnabled() ? quick_edit_dynmap_icon_model : quick_edit_dynmap_icon_grayed_model, (tport, player, fancyInventory) -> {
            if (DynmapCommand.checkDynmapState(player)) {
                QuickEditInventories.openTPortDynmapIconGUI(player, tport, 0);
            }
            return false;
        }),
        BLUEMAP_SHOW(QuickEditType::getBlueMapShowModel, (tport, player, fancyInventory) -> {
            if (BlueMapCommand.checkBlueMapState(player)) {
                TPortCommand.executeTPortCommand((CommandSender)player, new String[]{"edit", tport.getName(), "blueMap", "show", String.valueOf(!tport.showOnBlueMap())});
                return true;
            }
            return false;
        }),
        BLUEMAP_ICON(QuickEditType::getBlueMapIconModel, (tport, player, fancyInventory) -> {
            if (BlueMapCommand.checkBlueMapState(player)) {
                QuickEditInventories.openTPortBlueMapIconGUI(player, tport, 0);
            }
            return false;
        }),
        OFFER(tport -> tport.isOffered() ? quick_edit_revoke_model : quick_edit_offer_model, (tport, player, fancyInventory) -> {
            if (tport.isOffered()) {
                TPortCommand.executeTPortCommand((CommandSender)player, new String[]{"transfer", "revoke", tport.getName()});
                return true;
            }
            QuickEditInventories.openTPortOfferGUI(player, tport, fancyInventory.getData(fromQuickEditDataName));
            return false;
        });

        private final QuickEditor editor;
        private final ModelSelector modelSelector;
        public static HashMap<UUID, QuickEditType> map;

        private QuickEditType(ModelSelector modelSelector, QuickEditor run) {
            this.editor = run;
            this.modelSelector = modelSelector;
        }

        private QuickEditType(InventoryModel model, QuickEditor run) {
            this.editor = run;
            this.modelSelector = TPort2 -> model;
        }

        public static QuickEditType getForPlayer(UUID uuid) {
            return QuickEditType.get(Files.tportData.getConfig().getString("tport." + String.valueOf(uuid) + ".editState", null));
        }

        public static void setForPlayer(UUID uuid, QuickEditType type) {
            Files.tportData.getConfig().set("tport." + String.valueOf(uuid) + ".editState", (Object)type.name());
            Files.tportData.saveConfig();
        }

        public static QuickEditType get(@Nullable String name) {
            if (name == null) {
                return PRIVATE;
            }
            try {
                return QuickEditType.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                return PRIVATE;
            }
        }

        public boolean edit(TPort tport, Player player, FancyInventory fancyInventory) {
            return this.editor.edit(tport, player, fancyInventory);
        }

        public InventoryModel getModel(TPort tport) {
            return this.modelSelector.selectModel(tport);
        }

        public Message getDisplayName() {
            return ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "tport.quickEditInventories.quickEditType." + this.name() + ".displayName", new Object[0]);
        }

        public Message getDescription() {
            return ColorTheme.formatInfoTranslation("tport.quickEditInventories.quickEditType." + this.name() + ".description", new Object[0]);
        }

        public QuickEditType getNext() {
            boolean next = false;
            boolean ignoreDynmap = !DynmapHandler.isEnabled();
            for (QuickEditType type : QuickEditType.values()) {
                if (type.equals((Object)this)) {
                    next = true;
                    continue;
                }
                if (!next || !Features.Feature.Preview.isEnabled() && type == PREVIEW || ignoreDynmap && (type == DYNMAP_ICON || type == DYNMAP_SHOW)) continue;
                return type;
            }
            return Arrays.asList(QuickEditType.values()).get(0);
        }

        private static InventoryModel getDynmapShowModel(TPort tport) {
            if (!DynmapHandler.isEnabled()) {
                return quick_edit_dynmap_show_grayed_model;
            }
            return tport.showOnDynmap() ? quick_edit_dynmap_show_on_model : quick_edit_dynmap_show_off_model;
        }

        private static InventoryModel getBlueMapShowModel(TPort tport) {
            boolean blueMapState = false;
            try {
                blueMapState = BlueMapHandler.isEnabled();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!blueMapState) {
                return quick_edit_bluemap_show_grayed_model;
            }
            return tport.showOnBlueMap() ? quick_edit_bluemap_show_on_model : quick_edit_bluemap_show_off_model;
        }

        private static InventoryModel getBlueMapIconModel(TPort ignored) {
            boolean blueMapState = false;
            try {
                blueMapState = BlueMapHandler.isEnabled();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return blueMapState ? quick_edit_bluemap_icon_model : quick_edit_bluemap_icon_grayed_model;
        }

        public static InventoryModel getPublicTPortModel(TPort tport) {
            if (Features.Feature.PublicTP.isDisabled()) {
                return quick_edit_public_tp_grayed_model;
            }
            return tport.isPublicTPort() ? quick_edit_public_tp_on_model : quick_edit_public_tp_off_model;
        }

        static {
            map = new HashMap();
        }

        @FunctionalInterface
        private static interface QuickEditor {
            public boolean edit(TPort var1, Player var2, FancyInventory var3);
        }

        @FunctionalInterface
        private static interface ModelSelector {
            public InventoryModel selectModel(TPort var1);
        }
    }
}

