/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.history.locationSource;

import com.spaceman.tport.commands.tport.FeatureTP;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.WorldEncapsulation;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.history.locationSource.LocationSource;
import com.spaceman.tport.inventories.TPortInventories;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WorldLocationSource
extends WorldEncapsulation
implements LocationSource {
    public WorldLocationSource(World world) {
        super(world);
    }

    @Override
    @Nullable
    public Location getLocation(Player player) {
        Location location = FeatureTP.setSafeY(this.world, this.world.getSpawnLocation().getBlockX(), this.world.getSpawnLocation().getBlockZ());
        if (location != null) {
            location.add(0.5, 0.1, 0.5);
        }
        return location;
    }

    @Override
    public void setLocation(Location location) {
    }

    @Override
    public void teleportToLocation(Player player) {
        String command = "tport world " + this.world.getName();
        Bukkit.dispatchCommand((CommandSender)player, (String)command);
    }

    @Override
    public void notSafeToTeleport(Player player) {
        ColorTheme.sendErrorTranslation(player, "tport.history.locationSource.WorldLocationSource.notSafeToTeleport", new Object[0]);
    }

    @Override
    public InventoryModel getInventoryModel() {
        return TPortInventories.history_element_world_tp_model;
    }

    @Override
    @Nullable
    public String getType() {
        return "WorldTP";
    }

    @Override
    public boolean getSafetyCheckState(Player player) {
        return false;
    }
}

