/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.history.locationSource;

import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.history.locationSource.LocationSource;
import com.spaceman.tport.inventories.TPortInventories;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlayerLocationSource
extends PlayerEncapsulation
implements LocationSource {
    public PlayerLocationSource(@Nonnull UUID uuid) {
        super(uuid);
    }

    public PlayerLocationSource(@Nonnull Player player) {
        super(player);
    }

    @Override
    @Nullable
    public Location getLocation(Player player) {
        Player toPlayer = Bukkit.getPlayer((String)this.name);
        if (toPlayer == null) {
            return null;
        }
        return toPlayer.getLocation();
    }

    @Override
    public void setLocation(Location location) {
    }

    @Override
    public void teleportToLocation(Player player) {
        String command = "tport pltp tp " + this.name;
        Bukkit.dispatchCommand((CommandSender)player, (String)command);
    }

    @Override
    public void notSafeToTeleport(Player player) {
        ColorTheme.sendErrorTranslation(player, "tport.history.locationSource.PlayerLocationSource.notSafeToTeleport", new Object[0]);
    }

    @Override
    public InventoryModel getInventoryModel() {
        return TPortInventories.history_element_player_model;
    }

    @Override
    @Nullable
    public String getType() {
        return "PLTP";
    }

    @Override
    public boolean getSafetyCheckState(Player player) {
        return SafetyCheck.SafetyCheckSource.PLTP.getState(player);
    }
}

