/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.history.locationSource;

import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.history.locationSource.LocationSource;
import com.spaceman.tport.inventories.TPortInventories;
import com.spaceman.tport.tpEvents.TPEManager;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class LookLocationSource
implements LocationSource {
    private final Material lookedMaterial;
    private final EntityType entityType;
    private Location location;

    public LookLocationSource(Material material) {
        this.lookedMaterial = material;
        this.entityType = null;
    }

    public LookLocationSource(EntityType entityType) {
        this.entityType = entityType;
        this.lookedMaterial = null;
    }

    @Override
    public String asString() {
        if (this.entityType != null) {
            return "look-" + this.entityType.name();
        }
        if (this.lookedMaterial != null) {
            return "look-" + this.lookedMaterial.name();
        }
        return "look";
    }

    @Override
    @Nonnull
    public Message toMessage(String color, String varColor) {
        return new Message(new TextComponent(this.asString(), varColor));
    }

    @Override
    @Nullable
    public HoverEvent getHoverEvent() {
        return null;
    }

    @Override
    @Nullable
    public ClickEvent getClickEvent() {
        return null;
    }

    @Override
    public String getInsertion() {
        return this.asString();
    }

    @Override
    @Nullable
    public Location getLocation(Player player) {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public void teleportToLocation(Player player) {
        TPEManager.requestTeleportPlayer(player, this.location, () -> ColorTheme.sendSuccessTranslation(Bukkit.getPlayer((UUID)player.getUniqueId()), "tport.history.locationSource.LookLocationSource.teleportToLocation.succeeded", this.asString()), (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.history.locationSource.LookLocationSource.teleportToLocation.tpRequested", this.asString(), delay, tickMessage, seconds, secondMessage));
    }

    @Override
    public void notSafeToTeleport(Player player) {
        ColorTheme.sendErrorTranslation(player, "tport.history.locationSource.LookLocationSource.notSafeToTeleport", this.asString());
    }

    @Override
    public InventoryModel getInventoryModel() {
        return TPortInventories.history_element_look_model;
    }

    @Override
    @Nullable
    public String getType() {
        return "LookTP";
    }

    @Override
    public boolean getSafetyCheckState(Player player) {
        return SafetyCheck.SafetyCheckSource.TPORT_BACK.getState(player);
    }
}

