/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.history.locationSource;

import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.BiomeEncapsulation;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.history.locationSource.LocationSource;
import com.spaceman.tport.inventories.TPortInventories;
import com.spaceman.tport.tpEvents.TPEManager;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class BiomeLocationSource
extends BiomeEncapsulation
implements LocationSource {
    private Location biomeLoc = null;

    public BiomeLocationSource(String biome) {
        super(biome);
    }

    @Override
    @Nullable
    public Location getLocation(Player player) {
        return this.biomeLoc;
    }

    @Override
    public void setLocation(Location location) {
        this.biomeLoc = location;
    }

    @Override
    public void teleportToLocation(Player player) {
        TPEManager.requestTeleportPlayer(player, this.biomeLoc, () -> ColorTheme.sendSuccessTranslation(Bukkit.getPlayer((UUID)player.getUniqueId()), "tport.history.locationSource.BiomeLocationSource.teleportToLocation.succeeded", this.biome), (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.history.locationSource.BiomeLocationSource.teleportToLocation.tpRequested", this.biome, delay, tickMessage, seconds, secondMessage));
    }

    @Override
    public void notSafeToTeleport(Player player) {
        ColorTheme.sendErrorTranslation(player, "tport.history.locationSource.BiomeLocationSource.notSafeToTeleport", this.biome);
    }

    @Override
    public InventoryModel getInventoryModel() {
        return TPortInventories.history_element_biome_tp_model;
    }

    @Override
    @Nullable
    public String getType() {
        return "BiomeTP";
    }

    @Override
    public boolean getSafetyCheckState(Player player) {
        return SafetyCheck.SafetyCheckSource.TPORT_BACK.getState(player);
    }
}

