/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.history;

import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.history.HistoryElement;
import com.spaceman.tport.history.locationSource.CraftLocationSource;
import com.spaceman.tport.history.locationSource.IgnoreLocationSource;
import com.spaceman.tport.history.locationSource.LocationSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TeleportHistory {
    public static HashMap<UUID, ArrayList<HistoryElement>> teleportHistory = new HashMap();
    public static HashMap<String, InventoryModel> pluginFilterModels = new HashMap();
    private static final HashMap<UUID, Pair<LocationSource, InventoryModel>> locationSources = new HashMap();

    public static void setHistorySize(int size) {
        Files.tportConfig.getConfig().set("history.size", (Object)size);
        Files.tportConfig.saveConfig();
    }

    public static int getHistorySize() {
        return Files.tportConfig.getConfig().getInt("history.size", 20);
    }

    public static boolean registerPluginFilterModel(String pluginName, InventoryModel model) {
        return pluginFilterModels.put(pluginName, model) != null;
    }

    public static boolean registerPluginFilterModel(Plugin plugin, InventoryModel model) {
        return TeleportHistory.registerPluginFilterModel(plugin.getName(), model);
    }

    static Pair<LocationSource, InventoryModel> getTeleportData(UUID uuid) {
        return Main.getOrDefault(locationSources.remove(uuid), new Pair<CraftLocationSource, Object>(new CraftLocationSource(), null));
    }

    public static void setLocationSource(UUID uuid, LocationSource data) {
        TeleportHistory.setLocationSource(uuid, data, data.getInventoryModel());
    }

    public static void setLocationSource(UUID uuid, LocationSource data, @Nullable InventoryModel inventoryModel) {
        locationSources.put(uuid, new Pair<LocationSource, InventoryModel>(data, inventoryModel));
    }

    public static void ignoreTeleport(UUID uuid) {
        TeleportHistory.setLocationSource(uuid, new IgnoreLocationSource(), null);
    }

    static void addHistory(Player player, HistoryElement historyElement) {
        Location newLoc = historyElement.newLocation().getLocation(player);
        if (Objects.equals(historyElement.oldLocation().getWorld(), newLoc.getWorld()) && historyElement.oldLocation().distance(newLoc) < 1.0) {
            return;
        }
        ArrayList<HistoryElement> history = teleportHistory.getOrDefault(player.getUniqueId(), new ArrayList(TeleportHistory.getHistorySize() + 1));
        history.add(historyElement);
        while (history.size() > TeleportHistory.getHistorySize()) {
            history.remove(0);
        }
        teleportHistory.put(player.getUniqueId(), history);
    }
}

