/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.history;

import com.spaceman.tport.history.HistoryElement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.event.player.PlayerTeleportEvent;

public class HistoryFilter {
    public static final String PLUGIN_PREFIX = "PLUGIN:";

    public static List<String> getFilters() {
        ArrayList<String> filters = new ArrayList<String>();
        for (PlayerTeleportEvent.TeleportCause teleportCause : PlayerTeleportEvent.TeleportCause.values()) {
            filters.add(teleportCause.name());
        }
        filters.add("BOAT");
        filters.add("CHEST_BOAT");
        filters.add("MINECART");
        for (PlayerTeleportEvent.TeleportCause teleportCause : Bukkit.getPluginManager().getPlugins()) {
            filters.add(PLUGIN_PREFIX + teleportCause.getName());
        }
        return filters;
    }

    @Nullable
    public static String exist(String filter) {
        return HistoryFilter.getFilters().stream().filter(f -> f.equalsIgnoreCase(filter)).findFirst().orElse(null);
    }

    public static boolean fits(HistoryElement element, @Nullable String filter) {
        if (filter == null) {
            return true;
        }
        if (filter.startsWith(PLUGIN_PREFIX)) {
            if (element.cause().equals("PLUGIN")) {
                String plugin = filter.substring(PLUGIN_PREFIX.length());
                return element.application() != null && element.application().equals(plugin);
            }
        } else {
            return element.cause().equals(filter);
        }
        return false;
    }
}

