/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.history;

import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.history.HistoryElement;
import com.spaceman.tport.history.TeleportHistory;
import com.spaceman.tport.history.locationSource.CraftLocationSource;
import com.spaceman.tport.history.locationSource.IgnoreLocationSource;
import com.spaceman.tport.history.locationSource.LocationSource;
import com.spaceman.tport.inventories.TPortInventories;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Boat;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;

public class HistoryEvents
implements Listener {
    private static final HistoryEvents instance = new HistoryEvents();
    private final HashMap<UUID, Location> vehicleHistories = new HashMap();

    public static HistoryEvents getInstance() {
        return instance;
    }

    public static void load() {
        if (Features.Feature.History.isEnabled()) {
            HistoryEvents.onStateChange(true);
        }
    }

    public static void onStateChange(boolean newState) {
        if (newState) {
            Bukkit.getPluginManager().registerEvents((Listener)HistoryEvents.getInstance(), (Plugin)Main.getInstance());
        } else {
            HandlerList.unregisterAll((Listener)HistoryEvents.getInstance());
        }
    }

    @EventHandler
    public void vehicleEnterEvent(VehicleEnterEvent e) {
        if (!e.getEntered().getType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        Vehicle vehicle = e.getVehicle();
        this.vehicleHistories.put(e.getEntered().getUniqueId(), vehicle.getLocation());
    }

    @EventHandler
    public void vehicleExitEvent(VehicleExitEvent e) {
        if (!e.getExited().getType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        Vehicle vehicle = e.getVehicle();
        InventoryModel inventoryModel = null;
        if (vehicle instanceof Boat) {
            inventoryModel = TPortInventories.history_element_boat_model;
        } else if (vehicle instanceof Minecart) {
            inventoryModel = TPortInventories.history_element_minecart_model;
        }
        Location vehicleHistory = this.vehicleHistories.remove(e.getExited().getUniqueId());
        if (vehicleHistory != null) {
            Player player = (Player)e.getExited();
            HistoryElement element = new HistoryElement(vehicleHistory, new CraftLocationSource(vehicle.getLocation()), vehicle.getType().name(), null, inventoryModel);
            TeleportHistory.addHistory(player, element);
        }
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent e) {
        InventoryModel inventoryModel;
        Pair<LocationSource, InventoryModel> teleportData = TeleportHistory.getTeleportData(e.getPlayer().getUniqueId());
        if (teleportData.getLeft() instanceof IgnoreLocationSource) {
            return;
        }
        teleportData.getLeft().setLocation(e.getTo());
        String plugin = null;
        if (e.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.PLUGIN)) {
            plugin = this.findPlugin(this.searchStack());
        }
        if ((inventoryModel = teleportData.getRight()) == null) {
            inventoryModel = switch (e.getCause()) {
                default -> throw new IncompatibleClassChangeError();
                case PlayerTeleportEvent.TeleportCause.ENDER_PEARL -> TPortInventories.history_element_ender_pearl_model;
                case PlayerTeleportEvent.TeleportCause.COMMAND -> TPortInventories.history_element_command_model;
                case PlayerTeleportEvent.TeleportCause.PLUGIN -> TPortInventories.history_element_plugin_model;
                case PlayerTeleportEvent.TeleportCause.NETHER_PORTAL -> TPortInventories.history_element_nether_portal_model;
                case PlayerTeleportEvent.TeleportCause.END_PORTAL -> TPortInventories.history_element_end_portal_model;
                case PlayerTeleportEvent.TeleportCause.SPECTATE -> TPortInventories.history_element_spectate_model;
                case PlayerTeleportEvent.TeleportCause.END_GATEWAY -> TPortInventories.history_element_end_gateway_model;
                case PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT -> TPortInventories.history_element_chorus_fruit_model;
                case PlayerTeleportEvent.TeleportCause.DISMOUNT -> TPortInventories.history_element_dismount_model;
                case PlayerTeleportEvent.TeleportCause.EXIT_BED -> TPortInventories.history_element_exit_bed_model;
                case PlayerTeleportEvent.TeleportCause.UNKNOWN -> TPortInventories.history_element_model;
            };
        }
        HistoryElement element = new HistoryElement(e.getFrom(), teleportData.getLeft(), e.getCause().name(), plugin, inventoryModel);
        TeleportHistory.addHistory(e.getPlayer(), element);
    }

    @Nullable
    private String searchStack() {
        boolean foundCraftPlayer = false;
        for (StackTraceElement stackTraceElement : new Throwable().getStackTrace()) {
            String stackClassName = stackTraceElement.getClassName();
            if (stackClassName.endsWith("entity.CraftPlayer")) {
                foundCraftPlayer = true;
                continue;
            }
            if (!foundCraftPlayer || stackClassName.endsWith("entity.CraftEntity")) continue;
            return stackClassName;
        }
        return null;
    }

    @Nullable
    private String findPlugin(@Nullable String className) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> executedClass = Class.forName(className);
            Class<?> pluginClassLoaderClass = Class.forName("org.bukkit.plugin.java.PluginClassLoader");
            Field descriptionField = pluginClassLoaderClass.getDeclaredField("description");
            descriptionField.setAccessible(true);
            ClassLoader classLoader = executedClass.getClassLoader();
            PluginDescriptionFile description = (PluginDescriptionFile)descriptionField.get(classLoader);
            return description.getName();
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

