/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fileHander;

import com.spaceman.tport.Main;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Files {
    public static Files tportData;
    public static Files tportConfig;
    private final JavaPlugin plugin;
    private final File configFile;
    private FileConfiguration fileConfiguration = null;

    public static void reloadFiles() {
        tportData = new Files(Main.getInstance(), "TPortData.yml");
        tportConfig = new Files(Main.getInstance(), "TPortConfig.yml");
    }

    public Files(JavaPlugin plugin, String fileName) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), fileName + (fileName.toLowerCase().endsWith(".yml") ? "" : ".yml"));
    }

    public Files(JavaPlugin plugin, String extraPath, String fileName) {
        this.plugin = plugin;
        File f = new File(plugin.getDataFolder(), extraPath);
        this.configFile = new File(f, fileName + (fileName.toLowerCase().endsWith(".yml") ? "" : ".yml"));
    }

    private void reloadConfig() {
        this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public FileConfiguration getConfig() {
        if (this.fileConfiguration == null) {
            this.reloadConfig();
        }
        return this.fileConfiguration;
    }

    public Collection<String> getKeys(String path) {
        if (this.getConfig().contains(path)) {
            return this.getConfig().getConfigurationSection(path).getKeys(false);
        }
        return Collections.emptyList();
    }

    public void saveConfig() {
        if (this.fileConfiguration != null && this.configFile != null) {
            try {
                this.getConfig().save(this.configFile);
            }
            catch (IOException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save config to " + String.valueOf(this.configFile), ex);
            }
        } else {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save config to " + String.valueOf(this.configFile));
        }
    }
}

