/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.markdown;

import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commandHandler.HelpCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Attribute;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Link;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.commonmark.renderer.NodeRenderer;

public class FancyNodeRenderer
extends AbstractVisitor
implements NodeRenderer {
    private ArrayList<Message> list = null;
    private ArrayList<String> chapters = null;
    private Message message;
    private String chapterTitle;
    private final ArrayList<CommandTemplate> templates = new ArrayList();
    private boolean isHeading = false;
    private boolean isItalic = false;
    private boolean isBold = false;
    private int listLevel = 0;
    private boolean isLink = false;
    private String url = "";
    private String urlTitle = "";
    private final ListData[] listDataList = new ListData[10];
    private int blockQuoteLevel = 0;

    public FancyNodeRenderer(Message output) {
        this.message = output;
        this.chapterTitle = "";
    }

    public FancyNodeRenderer(ArrayList<String> chapterOutput, ArrayList<Message> messagesOutput) {
        this.chapters = chapterOutput;
        this.list = messagesOutput;
        this.message = new Message();
        this.list.add(this.message);
    }

    public void addCommandLookup(@Nonnull CommandTemplate commandTemplate) {
        this.templates.add(commandTemplate);
    }

    @Override
    public Set<Class<? extends Node>> getNodeTypes() {
        return new HashSet<Class<? extends Node>>(Arrays.asList(Heading.class, BulletList.class, ThematicBreak.class, Link.class, ListItem.class, OrderedList.class, Image.class, Emphasis.class, StrongEmphasis.class, Text.class, Code.class, SoftLineBreak.class, HardLineBreak.class));
    }

    @Override
    public void render(Node node) {
        node.accept(this);
    }

    private void parseText(TextComponent component) {
        if (this.isHeading) {
            component.setColor(ColorTheme.ColorType.titleColor);
            component.addAttribute(Attribute.BOLD);
            this.chapterTitle = this.chapterTitle + component.getText();
        }
        if (this.isItalic) {
            component.addAttribute(Attribute.ITALIC);
            component.setColor(ColorTheme.ColorType.varInfo2Color);
        }
        if (this.isBold) {
            component.addAttribute(Attribute.BOLD);
            component.setColor(ColorTheme.ColorType.varInfo2Color);
        }
        if (this.isLink) {
            component.addAttribute(Attribute.UNDERLINED);
            component.setColor(ColorTheme.ColorType.varInfoColor);
            HoverEvent hoverEvent = new HoverEvent();
            if (this.urlTitle != null) {
                hoverEvent.addText(new TextComponent(this.urlTitle, ColorTheme.ColorType.varInfoColor));
                hoverEvent.addText(new TextComponent("\n"));
            }
            hoverEvent.addText(new TextComponent("URL: ", ColorTheme.ColorType.infoColor));
            hoverEvent.addText(new TextComponent(this.url, ColorTheme.ColorType.varInfoColor));
            ClickEvent urlEvent = ClickEvent.openUrl(this.url);
            component.addTextEvent(urlEvent);
            component.addTextEvent(hoverEvent);
            component.setInsertion(this.url);
        }
    }

    @Override
    public void visit(Heading heading) {
        if (this.list != null && !this.message.isEmpty()) {
            this.message = new Message();
            this.list.add(this.message);
            this.chapters.add(this.chapterTitle);
            this.chapterTitle = "";
        }
        if (!this.message.isEmpty()) {
            this.message.addNewLine();
        }
        this.isHeading = true;
        this.visitChildren(heading);
        this.isHeading = false;
        this.message.addNewLine();
    }

    @Override
    public void visit(Link link) {
        this.isLink = true;
        this.url = link.getDestination();
        this.urlTitle = link.getTitle();
        this.visitChildren(link);
        this.isLink = false;
    }

    @Override
    public void visit(HtmlInline htmlInline) {
        String html = htmlInline.getLiteral();
        if (html.startsWith("<img")) {
            String destination = this.infoFromImage(html, "src");
            String altText = this.infoFromImage(html, "alt");
            String title = this.infoFromImage(html, "title");
            this.writeImage(title, altText, destination);
        }
    }

    @Nullable
    private String infoFromImage(String htmlImage, String info) {
        int index = htmlImage.indexOf(info + "=");
        if (index == -1) {
            return null;
        }
        for (int i = index + info.length() + 2; i < htmlImage.length(); ++i) {
            if (htmlImage.charAt(i) != '\"') continue;
            return htmlImage.substring(index + info.length() + 2, i);
        }
        return null;
    }

    private void writeImage(String title, String altText, String destination) {
        TextComponent textComponent = null;
        if (altText != null && !altText.isBlank()) {
            textComponent = new TextComponent(altText, ColorTheme.ColorType.varInfoColor).addAttribute(Attribute.UNDERLINED).addAttribute(Attribute.ITALIC);
        } else if (title != null) {
            textComponent = new TextComponent(title, ColorTheme.ColorType.varInfoColor).addAttribute(Attribute.UNDERLINED).addAttribute(Attribute.ITALIC);
        }
        if (textComponent == null) {
            return;
        }
        this.parseText(textComponent);
        ClickEvent urlEvent = ClickEvent.openUrl(destination);
        HoverEvent hoverEvent = new HoverEvent();
        if (altText != null && !altText.isBlank() && title != null) {
            hoverEvent.addText(new TextComponent(title, ColorTheme.ColorType.varInfoColor));
            hoverEvent.addText(new TextComponent("\n"));
        }
        hoverEvent.addText(new TextComponent("Image: ", ColorTheme.ColorType.infoColor));
        hoverEvent.addText(new TextComponent(destination, ColorTheme.ColorType.varInfoColor));
        textComponent.addTextEvent(urlEvent);
        textComponent.addTextEvent(hoverEvent);
        textComponent.setInsertion(this.url);
        this.message.addText(textComponent);
    }

    @Override
    public void visit(Image image) {
        AltTextVisitor altTextVisitor = new AltTextVisitor();
        image.accept(altTextVisitor);
        String altText = altTextVisitor.getAltText();
        String title = image.getTitle();
        this.writeImage(title, altText, image.getDestination());
    }

    @Override
    public void visit(Code code) {
        TextComponent textComponent = new TextComponent(code.getLiteral(), ColorTheme.ColorType.varInfoColor);
        this.parseText(textComponent);
        block0: for (CommandTemplate template : this.templates) {
            if (!code.getLiteral().startsWith("/" + template.getName())) continue;
            LinkedHashMap<String, SubCommand> commandMap = template.collectActions();
            for (Map.Entry tmpCommand : ((HashMap)commandMap).entrySet()) {
                if (!HelpCommand.commandMatches((String)tmpCommand.getKey(), code.getLiteral(), "/" + template.getName(), true)) continue;
                HoverEvent hoverEvent = new HoverEvent();
                hoverEvent.addMessage(((SubCommand)tmpCommand.getValue()).getCommandDescription());
                textComponent.addTextEvent(hoverEvent);
                break block0;
            }
        }
        textComponent.setInsertion(code.getLiteral());
        this.message.addText(textComponent);
    }

    @Override
    public void visit(FencedCodeBlock fencedCodeBlock) {
        this.message.addNewLine();
        String code = fencedCodeBlock.getLiteral();
        if (code.charAt(code.length() - 1) == '\n') {
            code = code.substring(0, code.length() - 1);
        }
        TextComponent component = new TextComponent(code, ColorTheme.ColorType.varInfoColor);
        component.setInsertion(code);
        this.message.addText(component);
    }

    @Override
    public void visit(IndentedCodeBlock indentedCodeBlock) {
        this.message.addNewLine();
        String code = indentedCodeBlock.getLiteral();
        if (code.charAt(code.length() - 1) == '\n') {
            code = code.substring(0, code.length() - 1);
        }
        TextComponent component = new TextComponent(code, ColorTheme.ColorType.varInfoColor);
        component.setInsertion(code);
        this.message.addText(component);
    }

    @Override
    public void visit(Emphasis emphasis) {
        this.isItalic = true;
        this.visitChildren(emphasis);
        this.isItalic = false;
    }

    @Override
    public void visit(StrongEmphasis strongEmphasis) {
        this.isBold = true;
        this.visitChildren(strongEmphasis);
        this.isBold = false;
    }

    @Override
    public void visit(SoftLineBreak softLineBreak) {
        this.message.addText(" ");
    }

    @Override
    public void visit(ThematicBreak thematicBreak) {
        this.message.addNewLine();
        this.message.addText(new TextComponent("-------", ColorTheme.ColorType.varInfoColor));
        this.message.addNewLine();
    }

    @Override
    public void visit(BlockQuote blockQuote) {
        ++this.blockQuoteLevel;
        this.visitChildren(blockQuote);
        --this.blockQuoteLevel;
    }

    @Override
    public void visit(BulletList bulletList) {
        ++this.listLevel;
        this.listDataList[this.listLevel] = new ListData(false, 0);
        this.visitChildren(bulletList);
        --this.listLevel;
    }

    @Override
    public void visit(OrderedList orderedList) {
        ++this.listLevel;
        this.listDataList[this.listLevel] = new ListData(true, orderedList.getStartNumber());
        this.visitChildren(orderedList);
        --this.listLevel;
    }

    @Override
    public void visit(ListItem listItem) {
        this.message.addNewLine();
        this.message.addText(new TextComponent("  ".repeat(this.listLevel - 1), ColorTheme.ColorType.varInfo2Color));
        ListData listData = this.listDataList[this.listLevel];
        if (listData.isOrderedList) {
            this.message.addText(new TextComponent(listData.orderedListIndex + ". ", ColorTheme.ColorType.varInfo2Color));
            ++listData.orderedListIndex;
        } else {
            char bullet = (new char[]{'\u2022', '\u25e6', '\uf0a7'})[(this.listLevel - 1) % 3];
            this.message.addText(new TextComponent(bullet + " ", ColorTheme.ColorType.varInfo2Color));
        }
        this.visitChildren(listItem);
    }

    @Override
    public void visit(Paragraph paragraph) {
        if (this.listLevel == 0) {
            this.message.addNewLine();
        }
        if (this.blockQuoteLevel > 0) {
            this.message.addText(new TextComponent(">".repeat(this.blockQuoteLevel) + " ", ColorTheme.ColorType.varInfo2Color));
        }
        this.visitChildren(paragraph);
    }

    @Override
    public void visit(Text text) {
        TextComponent textComponent = new TextComponent(text.getLiteral(), ColorTheme.ColorType.infoColor);
        this.parseText(textComponent);
        this.message.addText(textComponent);
    }

    @Override
    public void visit(HardLineBreak hardLineBreak) {
        this.message.addNewLine();
        if (this.listLevel > 0) {
            this.message.addText(new TextComponent("  ".repeat(this.listLevel), ColorTheme.ColorType.varInfo2Color));
        }
        if (this.blockQuoteLevel > 0) {
            this.message.addText(new TextComponent(">".repeat(this.blockQuoteLevel) + " ", ColorTheme.ColorType.varInfo2Color));
        }
    }

    private static class ListData {
        private final boolean isOrderedList;
        private int orderedListIndex;

        ListData(boolean isOrderedList, int orderedListIndex) {
            this.isOrderedList = isOrderedList;
            this.orderedListIndex = orderedListIndex;
        }
    }

    private static class AltTextVisitor
    extends AbstractVisitor {
        private final StringBuilder sb = new StringBuilder();

        private AltTextVisitor() {
        }

        String getAltText() {
            return this.sb.toString();
        }

        @Override
        public void visit(Text text) {
            this.sb.append(text.getLiteral());
        }

        @Override
        public void visit(SoftLineBreak softLineBreak) {
            this.sb.append(' ');
        }

        @Override
        public void visit(HardLineBreak hardLineBreak) {
            this.sb.append('\n');
        }
    }
}

