/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.language.subCommands;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.TextType;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fancyMessage.language.Language;
import java.util.Collection;
import java.util.Collections;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Server
extends SubCommand {
    private final EmptyCommand emptyServerLanguage = new EmptyCommand();

    public Server() {
        this.emptyServerLanguage.setCommandName("language", ArgumentType.OPTIONAL);
        this.emptyServerLanguage.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.language.server.language.commandDescription", new Object[0]));
        this.emptyServerLanguage.setPermissions("TPort.language.setServerLanguage", "TPort.admin.language");
        this.addAction(this.emptyServerLanguage);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.language.server.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyServerLanguage.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Language.getAvailableLang();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            ColorTheme.sendInfoTranslation(player, "tport.command.language.server.succeeded", Language.getServerLangName());
        } else if (args.length == 3) {
            if (!this.emptyServerLanguage.hasPermissionToRun(player, true)) {
                return;
            }
            String currentServerLanguage = Language.getServerLangName();
            if (currentServerLanguage.equals(args[2])) {
                ColorTheme.sendErrorTranslation(player, "tport.command.language.server.language.alreadySet", currentServerLanguage);
                return;
            }
            if (Language.getAvailableLang().stream().noneMatch(args[2]::equals)) {
                ColorTheme.sendErrorTranslation(player, "tport.command.language.server.language.languageNotExist", args[2]);
                return;
            }
            Message hereMessage = new Message();
            hereMessage.addText(TextComponent.textComponent("tport.command.language.server.language.here", ColorTheme.ColorType.varErrorColor, new HoverEvent(TextComponent.textComponent("/tport language set " + currentServerLanguage, ColorTheme.ColorType.varInfoColor)), ClickEvent.runCommand("/tport language set " + currentServerLanguage)).setType(TextType.TRANSLATE).setInsertion("/tport language set " + currentServerLanguage));
            for (Player p : Bukkit.getOnlinePlayers()) {
                ColorTheme.sendInfoTranslation(p, "tport.command.language.server.language.succeededOtherPlayers", player, args[2], hereMessage);
            }
            if (Language.setServerLang(args[2])) {
                ColorTheme.sendSuccessTranslation(player, "tport.command.language.server.language.succeeded", Language.getServerLangName());
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.language.server.language.languageNotExist", args[2]);
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport language server [language]");
        }
    }
}

