/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.language.subCommands;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.language.Language;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;

public class Repair
extends SubCommand {
    private final EmptyCommand emptyRepairLanguageRepairWith;

    public Repair() {
        EmptyCommand emptyRepairLanguageRepairWithDump = new EmptyCommand();
        emptyRepairLanguageRepairWithDump.setCommandName("dump", ArgumentType.OPTIONAL);
        emptyRepairLanguageRepairWithDump.setPermissions("TPort.language.repair", "TPort.admin.language");
        emptyRepairLanguageRepairWithDump.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.language.repair.language.repairWith.dump.commandDescription", new Object[0]));
        this.emptyRepairLanguageRepairWith = new EmptyCommand();
        this.emptyRepairLanguageRepairWith.setCommandName("repair with", ArgumentType.OPTIONAL);
        this.emptyRepairLanguageRepairWith.setPermissions("TPort.language.repair", "TPort.admin.language");
        this.emptyRepairLanguageRepairWith.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.language.repair.language.repairWith.commandDescription", new Object[0]));
        this.emptyRepairLanguageRepairWith.setTabRunnable((args, player) -> emptyRepairLanguageRepairWithDump.hasPermissionToRun(player, false) ? List.of("true", "false") : Collections.emptyList());
        this.emptyRepairLanguageRepairWith.addAction(emptyRepairLanguageRepairWithDump);
        EmptyCommand emptyRepairLanguage = new EmptyCommand();
        emptyRepairLanguage.setCommandName("language", ArgumentType.REQUIRED);
        emptyRepairLanguage.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.language.repair.language.commandDescription", new Object[0]));
        emptyRepairLanguage.setTabRunnable((args, player) -> {
            if (this.emptyRepairLanguageRepairWith.hasPermissionToRun(player, false)) {
                return Language.getAvailableLang().stream().filter(s -> !s.equalsIgnoreCase(args[2])).toList();
            }
            return Collections.emptyList();
        });
        emptyRepairLanguage.setPermissions(this.emptyRepairLanguageRepairWith.getPermissions());
        emptyRepairLanguage.addAction(this.emptyRepairLanguageRepairWith);
        this.addAction(emptyRepairLanguage);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyRepairLanguageRepairWith.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Language.getAvailableLang();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 3) {
            if (!this.emptyRepairLanguageRepairWith.hasPermissionToRun(player, true)) {
                return;
            }
            File langFile = new File(Language.getLangDir(), args[2]);
            if (!langFile.exists()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.language.repair.language.languageFileNotExist", args[2]);
                return;
            }
            try {
                JsonObject oldJSON = (JsonObject)JsonParser.parseReader((Reader)new FileReader(langFile));
                Pair<JsonObject, Integer> newJSON = Language.repairLanguage(oldJSON, Language.getLang("en_us.json"));
                if (newJSON == null) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.language.repair.language.couldNotRepair", args[2]);
                    return;
                }
                if (newJSON.getRight() == 0) {
                    ColorTheme.sendInfoTranslation(player, "tport.command.language.repair.language.succeeded.none", args[2]);
                }
                Language.saveLanguage(newJSON.getLeft(), langFile);
                if (newJSON.getRight() == 1) {
                    ColorTheme.sendSuccessTranslation(player, "tport.command.language.repair.language.succeeded.singular", args[2], newJSON.getRight());
                } else if (newJSON.getRight() > 1) {
                    ColorTheme.sendSuccessTranslation(player, "tport.command.language.repair.language.succeeded.multiple", args[2], newJSON.getRight());
                }
            }
            catch (FileNotFoundException e) {
                ColorTheme.sendErrorTranslation(player, "tport.command.language.repair.language.couldNotRepair", args[2]);
            }
        } else if (args.length == 4 || args.length == 5) {
            if (!this.emptyRepairLanguageRepairWith.hasPermissionToRun(player, true)) {
                return;
            }
            File langFile = new File(Language.getLangDir(), args[2]);
            if (!langFile.exists()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.language.repair.language.repairWith.languageFileNotExist", args[2]);
                return;
            }
            JsonObject repairWith = Language.getLang(args[3]);
            if (repairWith == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.language.repair.language.repairWith.languageNotExist", args[3]);
                return;
            }
            if (args[2].equalsIgnoreCase(args[3])) {
                ColorTheme.sendErrorTranslation(player, "tport.command.language.repair.language.repairWith.repairWithSame", args[2], args[3]);
                return;
            }
            Boolean dump = false;
            if (args.length == 5 && (dump = Main.toBoolean(args[4])) == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport language repair <language> [repair with] [true|false]");
                return;
            }
            try {
                JsonObject oldJSON = (JsonObject)JsonParser.parseReader((Reader)new FileReader(langFile));
                Pair<JsonObject, Integer> newJSON = Language.repairLanguage(oldJSON, repairWith, dump);
                if (newJSON == null) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.language.repair.language.repairWith.couldNotRepair", args[2]);
                    return;
                }
                if (newJSON.getRight() == 0) {
                    ColorTheme.sendInfoTranslation(player, "tport.command.language.repair.language.repairWith.succeeded.none", args[2]);
                }
                Language.saveLanguage(newJSON.getLeft(), langFile);
                if (newJSON.getRight() == 1) {
                    ColorTheme.sendSuccessTranslation(player, "tport.command.language.repair.language.repairWith.succeeded.singular", args[2], args[3], newJSON.getRight());
                } else if (newJSON.getRight() > 1) {
                    ColorTheme.sendSuccessTranslation(player, "tport.command.language.repair.language.repairWith.succeeded.multiple", args[2], args[3], newJSON.getRight());
                }
            }
            catch (FileNotFoundException e) {
                ColorTheme.sendErrorTranslation(player, "tport.command.language.repair.language.repairWith.couldNotRepair", args[2]);
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport language repair <language> [repair with]");
        }
    }
}

