/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.inventories.keyboard;

import com.google.gson.JsonObject;
import com.spaceman.tport.Main;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.MessageUtils;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.colorTheme.MultiColor;
import com.spaceman.tport.fancyMessage.inventories.FancyClickEvent;
import com.spaceman.tport.fancyMessage.inventories.FancyInventory;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.fancyMessage.inventories.keyboard.QuickType;
import com.spaceman.tport.fancyMessage.language.Language;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class KeyboardGUI {
    public static final int ALL = 127;
    public static final int TEXT_ONLY = 120;
    public static final int SPACE = 1;
    public static final int NEWLINE = 2;
    public static final int COLOR = 4;
    public static final int NUMBERS = 8;
    public static final int CHARS = 16;
    public static final int SPECIAL = 32;
    public static final int LINES = 64;
    private static final FancyInventory.DataName<String> outputStorage = new FancyInventory.DataName<String>("typedString", String.class, "");
    private static final FancyInventory.DataName<String> layoutDataType = new FancyInventory.DataName<String>("layout", String.class);
    private static final FancyInventory.DataName<String> acceptFuncNameDataType = new FancyInventory.DataName<String>("acceptFuncName", String.class);
    private static final FancyInventory.DataName<String> rejectFuncNameDataType = new FancyInventory.DataName<String>("rejectFuncName", String.class);
    private static final FancyInventory.DataName<Integer> keyboardSettingsDataType = new FancyInventory.DataName<Integer>("keyboardSettings", Integer.class, 0);
    private static final FancyInventory.DataName<Boolean> formatTitleDataType = new FancyInventory.DataName<Boolean>("formatTitle", Boolean.class, true);
    private static final FancyInventory.DataName<Integer> cursorIndexDataType = new FancyInventory.DataName<Integer>("cursorIndex", Integer.class, 0);
    private static final FancyInventory.DataName<Color> colorDataType = new FancyInventory.DataName<Color>("color", Color.class, new Color(255, 255, 255));
    private static final FancyInventory.DataName<Boolean> editColorDataTye = new FancyInventory.DataName<Boolean>("editColor", Boolean.class);
    private static final FancyInventory.DataName<String> defColorDataType = new FancyInventory.DataName<String>("defColor", String.class, "#ffffff");
    private static final FancyInventory.DataName<ArrayList> colorFadeColorsDataType = new FancyInventory.DataName("colorFadeColors", ArrayList.class, new ArrayList());
    private static final FancyInventory.DataName<String> colorFadeStringDataType = new FancyInventory.DataName<String>("colorFadeString", String.class, "");
    private static final HashMap<Character, InventoryModel> keyModels = new HashMap();
    public static final InventoryModel keyboard_accept_model = new InventoryModel(Material.OAK_BUTTON, FancyInventory.previous_model, "tport", "keyboard_accept", "keyboard");
    public static final InventoryModel keyboard_reject_model = new InventoryModel(Material.OAK_BUTTON, keyboard_accept_model, "tport", "keyboard_reject", "keyboard");
    public static final InventoryModel keyboard_change_layout_model = new InventoryModel(Material.OAK_BUTTON, keyboard_reject_model, "tport", "keyboard_change_layout", "keyboard");
    public static final InventoryModel keyboard_quick_type_model = new InventoryModel(Material.OAK_BUTTON, keyboard_change_layout_model, "tport", "keyboard_quick_type", "keyboard");
    public static final InventoryModel keyboard_format_on_model = new InventoryModel(Material.OAK_BUTTON, keyboard_quick_type_model, "tport", "keyboard_format_on", "keyboard");
    public static final InventoryModel keyboard_format_off_model = new InventoryModel(Material.OAK_BUTTON, keyboard_format_on_model, "tport", "keyboard_format_off", "keyboard");
    public static final InventoryModel keyboard_cursor_model = new InventoryModel(Material.OAK_BUTTON, keyboard_format_off_model, "tport", "keyboard_cursor", "keyboard");
    public static final InventoryModel keyboard_color_model = new InventoryModel(Material.OAK_BUTTON, keyboard_cursor_model, "tport", "keyboard_color", "keyboard");
    public static final InventoryModel keyboard_color_grayed_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_model, "tport", "keyboard_color_grayed", "keyboard");
    public static final InventoryModel keyboard_color_accept_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_grayed_model, "tport", "keyboard_color_accept", "keyboard");
    public static final InventoryModel keyboard_color_reject_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_accept_model, "tport", "keyboard_color_reject", "keyboard");
    public static final InventoryModel keyboard_color_red_add_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_reject_model, "tport", "keyboard_color_red_add", "keyboard");
    public static final InventoryModel keyboard_color_red_remove_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_red_add_model, "tport", "keyboard_color_red_remove", "keyboard");
    public static final InventoryModel keyboard_color_green_add_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_red_remove_model, "tport", "keyboard_color_green_add", "keyboard");
    public static final InventoryModel keyboard_color_green_remove_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_green_add_model, "tport", "keyboard_color_green_remove", "keyboard");
    public static final InventoryModel keyboard_color_blue_add_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_green_remove_model, "tport", "keyboard_color_blue_add", "keyboard");
    public static final InventoryModel keyboard_color_blue_remove_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_blue_add_model, "tport", "keyboard_color_blue_remove", "keyboard");
    public static final InventoryModel keyboard_color_fade_accept_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_blue_remove_model, "tport", "keyboard_color_fade_accept", "keyboard");
    public static final InventoryModel keyboard_color_fade_reject_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_fade_accept_model, "tport", "keyboard_color_fade_reject", "keyboard");
    public static final InventoryModel keyboard_color_fade_edit_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_fade_reject_model, "tport", "keyboard_color_fade_edit", "keyboard");
    public static final InventoryModel keyboard_color_fade_red_add_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_fade_edit_model, "tport", "keyboard_color_fade_red_add", "keyboard");
    public static final InventoryModel keyboard_color_fade_red_remove_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_fade_red_add_model, "tport", "keyboard_color_fade_red_remove", "keyboard");
    public static final InventoryModel keyboard_color_fade_green_add_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_fade_red_remove_model, "tport", "keyboard_color_fade_green_add", "keyboard");
    public static final InventoryModel keyboard_color_fade_green_remove_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_fade_green_add_model, "tport", "keyboard_color_fade_green_remove", "keyboard");
    public static final InventoryModel keyboard_color_fade_blue_add_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_fade_green_remove_model, "tport", "keyboard_color_fade_blue_add", "keyboard");
    public static final InventoryModel keyboard_color_fade_blue_remove_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_fade_blue_add_model, "tport", "keyboard_color_fade_blue_remove", "keyboard");
    public static final InventoryModel keyboard_color_fade_chat_color_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_fade_blue_remove_model, "tport", "keyboard_color_fade_chat_color", "keyboard");
    public static final InventoryModel char_not_found_model = new InventoryModel(Material.OAK_BUTTON, keyboard_color_fade_chat_color_model, "tport", "char_not_found", "keyboard");
    public static final InventoryModel char_a_model = KeyboardGUI.registerKeyModel('a', Material.OAK_BUTTON, "char_a", char_not_found_model);
    public static final InventoryModel char_b_model = KeyboardGUI.registerKeyModel('b', Material.OAK_BUTTON, "char_b", char_a_model);
    public static final InventoryModel char_c_model = KeyboardGUI.registerKeyModel('c', Material.OAK_BUTTON, "char_c", char_b_model);
    public static final InventoryModel char_d_model = KeyboardGUI.registerKeyModel('d', Material.OAK_BUTTON, "char_d", char_c_model);
    public static final InventoryModel char_e_model = KeyboardGUI.registerKeyModel('e', Material.OAK_BUTTON, "char_e", char_d_model);
    public static final InventoryModel char_f_model = KeyboardGUI.registerKeyModel('f', Material.OAK_BUTTON, "char_f", char_e_model);
    public static final InventoryModel char_g_model = KeyboardGUI.registerKeyModel('g', Material.OAK_BUTTON, "char_g", char_f_model);
    public static final InventoryModel char_h_model = KeyboardGUI.registerKeyModel('h', Material.OAK_BUTTON, "char_h", char_g_model);
    public static final InventoryModel char_i_model = KeyboardGUI.registerKeyModel('i', Material.OAK_BUTTON, "char_i", char_h_model);
    public static final InventoryModel char_j_model = KeyboardGUI.registerKeyModel('j', Material.OAK_BUTTON, "char_j", char_i_model);
    public static final InventoryModel char_k_model = KeyboardGUI.registerKeyModel('k', Material.OAK_BUTTON, "char_k", char_j_model);
    public static final InventoryModel char_l_model = KeyboardGUI.registerKeyModel('l', Material.OAK_BUTTON, "char_l", char_k_model);
    public static final InventoryModel char_m_model = KeyboardGUI.registerKeyModel('m', Material.OAK_BUTTON, "char_m", char_l_model);
    public static final InventoryModel char_n_model = KeyboardGUI.registerKeyModel('n', Material.OAK_BUTTON, "char_n", char_m_model);
    public static final InventoryModel char_o_model = KeyboardGUI.registerKeyModel('o', Material.OAK_BUTTON, "char_o", char_n_model);
    public static final InventoryModel char_p_model = KeyboardGUI.registerKeyModel('p', Material.OAK_BUTTON, "char_p", char_o_model);
    public static final InventoryModel char_q_model = KeyboardGUI.registerKeyModel('q', Material.OAK_BUTTON, "char_q", char_p_model);
    public static final InventoryModel char_r_model = KeyboardGUI.registerKeyModel('r', Material.OAK_BUTTON, "char_r", char_q_model);
    public static final InventoryModel char_s_model = KeyboardGUI.registerKeyModel('s', Material.OAK_BUTTON, "char_s", char_r_model);
    public static final InventoryModel char_t_model = KeyboardGUI.registerKeyModel('t', Material.OAK_BUTTON, "char_t", char_s_model);
    public static final InventoryModel char_u_model = KeyboardGUI.registerKeyModel('u', Material.OAK_BUTTON, "char_u", char_t_model);
    public static final InventoryModel char_v_model = KeyboardGUI.registerKeyModel('v', Material.OAK_BUTTON, "char_v", char_u_model);
    public static final InventoryModel char_w_model = KeyboardGUI.registerKeyModel('w', Material.OAK_BUTTON, "char_w", char_v_model);
    public static final InventoryModel char_x_model = KeyboardGUI.registerKeyModel('x', Material.OAK_BUTTON, "char_x", char_w_model);
    public static final InventoryModel char_y_model = KeyboardGUI.registerKeyModel('y', Material.OAK_BUTTON, "char_y", char_x_model);
    public static final InventoryModel char_z_model = KeyboardGUI.registerKeyModel('z', Material.OAK_BUTTON, "char_z", char_y_model);
    public static final InventoryModel char_0_model = KeyboardGUI.registerKeyModel('0', Material.OAK_BUTTON, "char_0", char_z_model);
    public static final InventoryModel char_1_model = KeyboardGUI.registerKeyModel('1', Material.OAK_BUTTON, "char_1", char_0_model);
    public static final InventoryModel char_2_model = KeyboardGUI.registerKeyModel('2', Material.OAK_BUTTON, "char_2", char_1_model);
    public static final InventoryModel char_3_model = KeyboardGUI.registerKeyModel('3', Material.OAK_BUTTON, "char_3", char_2_model);
    public static final InventoryModel char_4_model = KeyboardGUI.registerKeyModel('4', Material.OAK_BUTTON, "char_4", char_3_model);
    public static final InventoryModel char_5_model = KeyboardGUI.registerKeyModel('5', Material.OAK_BUTTON, "char_5", char_4_model);
    public static final InventoryModel char_6_model = KeyboardGUI.registerKeyModel('6', Material.OAK_BUTTON, "char_6", char_5_model);
    public static final InventoryModel char_7_model = KeyboardGUI.registerKeyModel('7', Material.OAK_BUTTON, "char_7", char_6_model);
    public static final InventoryModel char_8_model = KeyboardGUI.registerKeyModel('8', Material.OAK_BUTTON, "char_8", char_7_model);
    public static final InventoryModel char_9_model = KeyboardGUI.registerKeyModel('9', Material.OAK_BUTTON, "char_9", char_8_model);
    public static final InventoryModel char_minus_model = KeyboardGUI.registerKeyModel('-', Material.OAK_BUTTON, "char_minus", char_9_model);
    public static final InventoryModel char_equals_model = KeyboardGUI.registerKeyModel('=', Material.OAK_BUTTON, "char_equals", char_minus_model);
    public static final InventoryModel char_square_open_model = KeyboardGUI.registerKeyModel('[', Material.OAK_BUTTON, "char_square_open", char_equals_model);
    public static final InventoryModel char_square_close_model = KeyboardGUI.registerKeyModel(']', Material.OAK_BUTTON, "char_square_close", char_square_open_model);
    public static final InventoryModel char_semicolon_model = KeyboardGUI.registerKeyModel(';', Material.OAK_BUTTON, "char_semicolon", char_square_close_model);
    public static final InventoryModel char_apostrophe_model = KeyboardGUI.registerKeyModel('\'', Material.OAK_BUTTON, "char_apostrophe", char_semicolon_model);
    public static final InventoryModel char_slash_model = KeyboardGUI.registerKeyModel('/', Material.OAK_BUTTON, "char_slash", char_apostrophe_model);
    public static final InventoryModel char_dot_model = KeyboardGUI.registerKeyModel('.', Material.OAK_BUTTON, "char_dot", char_slash_model);
    public static final InventoryModel char_comma_model = KeyboardGUI.registerKeyModel(',', Material.OAK_BUTTON, "char_comma", char_dot_model);
    public static final InventoryModel char_space_model = KeyboardGUI.registerKeyModel(' ', Material.OAK_BUTTON, "char_space", char_comma_model);
    public static final InventoryModel char_backspace_model = KeyboardGUI.registerKeyModel('\b', Material.OAK_BUTTON, "char_backspace", char_space_model);
    public static final InventoryModel char_newline_model = KeyboardGUI.registerKeyModel('\n', Material.OAK_BUTTON, "char_newline", char_backspace_model);
    public static final InventoryModel keyboard_chat_color_model = new InventoryModel(Material.OAK_BUTTON, char_newline_model, "tport", "keyboard_chat_color", "keyboard");
    public static final InventoryModel keyboard_chat_color_reject_model = new InventoryModel(Material.OAK_BUTTON, keyboard_chat_color_model, "tport", "keyboard_chat_color_reject", "keyboard");
    public static final InventoryModel keyboard_chat_color_dark_blue_model = new InventoryModel(Material.OAK_BUTTON, keyboard_chat_color_reject_model, "tport", "keyboard_chat_color_dark_blue", "keyboard");
    public static final InventoryModel keyboard_chat_color_dark_green_model = new InventoryModel(Material.OAK_BUTTON, keyboard_chat_color_dark_blue_model, "tport", "keyboard_chat_color_dark_green", "keyboard");
    public static final InventoryModel keyboard_chat_color_dark_aqua_model = new InventoryModel(Material.OAK_BUTTON, keyboard_chat_color_dark_green_model, "tport", "keyboard_chat_color_dark_aqua", "keyboard");
    public static final InventoryModel keyboard_chat_color_dark_red_model = new InventoryModel(Material.OAK_BUTTON, keyboard_chat_color_dark_aqua_model, "tport", "keyboard_chat_color_dark_red", "keyboard");
    public static final InventoryModel keyboard_chat_color_dark_purple_model = new InventoryModel(Material.OAK_BUTTON, keyboard_chat_color_dark_red_model, "tport", "keyboard_chat_color_dark_purple", "keyboard");
    public static final InventoryModel keyboard_chat_color_gold_model = new InventoryModel(Material.OAK_BUTTON, keyboard_chat_color_dark_purple_model, "tport", "keyboard_chat_color_gold", "keyboard");
    public static final InventoryModel keyboard_chat_color_gray_model = new InventoryModel(Material.OAK_BUTTON, keyboard_chat_color_gold_model, "tport", "keyboard_chat_color_gray", "keyboard");
    public static final InventoryModel keyboard_chat_color_dark_gray_model = new InventoryModel(Material.OAK_BUTTON, keyboard_chat_color_gray_model, "tport", "keyboard_chat_color_dark_gray", "keyboard");
    public static final InventoryModel keyboard_chat_color_blue_model = new InventoryModel(Material.OAK_BUTTON, keyboard_chat_color_dark_gray_model, "tport", "keyboard_chat_color_blue", "keyboard");
    public static final InventoryModel keyboard_chat_color_green_model = new InventoryModel(Material.OAK_BUTTON, keyboard_chat_color_blue_model, "tport", "keyboard_chat_color_green", "keyboard");
    public static final InventoryModel keyboard_chat_color_aqua_model = new InventoryModel(Material.OAK_BUTTON, keyboard_chat_color_green_model, "tport", "keyboard_chat_color_aqua", "keyboard");
    public static final InventoryModel keyboard_chat_color_red_model = new InventoryModel(Material.OAK_BUTTON, keyboard_chat_color_aqua_model, "tport", "keyboard_chat_color_red", "keyboard");
    public static final InventoryModel keyboard_chat_color_light_purple_model = new InventoryModel(Material.OAK_BUTTON, keyboard_chat_color_red_model, "tport", "keyboard_chat_color_light_purple", "keyboard");
    public static final InventoryModel keyboard_chat_color_yellow_model = new InventoryModel(Material.OAK_BUTTON, keyboard_chat_color_light_purple_model, "tport", "keyboard_chat_color_yellow", "keyboard");
    public static final InventoryModel keyboard_chat_color_white_model = new InventoryModel(Material.OAK_BUTTON, keyboard_chat_color_yellow_model, "tport", "keyboard_chat_color_white", "keyboard");
    public static final InventoryModel keyboard_chat_color_black_model = new InventoryModel(Material.OAK_BUTTON, keyboard_chat_color_white_model, "tport", "keyboard_chat_color_black", "keyboard");
    public static final int last_model_id = keyboard_chat_color_black_model.getCustomModelData();
    private static final TextComponent cursor = new TextComponent("|", ChatColor.DARK_RED);

    public static String getKeyboardOutput(FancyInventory inv) {
        return inv.getData(outputStorage);
    }

    private static InventoryModel registerKeyModel(char forChar, Material material, String nameSpaceKey, InventoryModel previousModel) {
        InventoryModel p = new InventoryModel(material, previousModel, "tport", nameSpaceKey, "keyboard");
        keyModels.put(Character.valueOf(forChar), p);
        return p;
    }

    private static InventoryModel getModel(char key) {
        return keyModels.getOrDefault(Character.valueOf(key), char_not_found_model);
    }

    private static Message getKeyTitle(char key) {
        return switch (key) {
            case ' ' -> ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "tport.fancyMessage.inventories.KeyboardGUI.key.space", new Object[0]);
            case '\b' -> ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "tport.fancyMessage.inventories.KeyboardGUI.key.backspace", new Object[0]);
            case '\n' -> ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "tport.fancyMessage.inventories.KeyboardGUI.key.newline", new Object[0]);
            case '\u007f' -> ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "tport.fancyMessage.inventories.KeyboardGUI.key.delete", new Object[0]);
            default -> ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "tport.fancyMessage.inventories.KeyboardGUI.key.other", Character.valueOf(key));
        };
    }

    private static ItemStack getKey(char key, char alternate, ColorTheme colorTheme, JsonObject playerLang, UUID playerUUID, int keyboardSettings) {
        InventoryModel model = KeyboardGUI.getModel(Character.toLowerCase(key));
        ItemStack item = model.getItem(playerUUID);
        boolean numbers = (keyboardSettings & 8) == 8;
        boolean chars = (keyboardSettings & 0x10) == 16;
        boolean specials = (keyboardSettings & 0x20) == 32;
        boolean space = (keyboardSettings & 1) == 1;
        boolean newLine = (keyboardSettings & 2) == 2;
        boolean lines = (keyboardSettings & 0x40) == 64;
        boolean keyAccepted = false;
        boolean alternateAccepted = false;
        if (numbers) {
            if (key >= '0' && key <= '9') {
                keyAccepted = true;
            }
            if (alternate >= '0' && alternate <= '9') {
                alternateAccepted = true;
            }
        }
        if (chars) {
            if (key >= 'A' && key <= 'Z' || key >= 'a' && key <= 'z') {
                keyAccepted = true;
            }
            if (alternate >= 'A' && alternate <= 'Z' || alternate >= 'a' && alternate <= 'z') {
                alternateAccepted = true;
            }
        }
        if (specials) {
            if (key >= '!' && key <= '/' || key >= ':' && key <= '@' || key >= '[' && key <= '`' || key >= '{' && key <= '~') {
                keyAccepted = true;
            }
            if (alternate >= '!' && alternate <= '/' || alternate >= ':' && alternate <= '@' || alternate >= '[' && alternate <= '`' || alternate >= '{' && alternate <= '~') {
                alternateAccepted = true;
            }
        }
        if (space) {
            if (key == ' ') {
                keyAccepted = true;
            }
            if (alternate == ' ') {
                alternateAccepted = true;
            }
        }
        if (newLine) {
            if (key == '\n') {
                keyAccepted = true;
            }
            if (alternate == '\n') {
                alternateAccepted = true;
            }
        }
        if (lines) {
            if (key == '-' || key == '_') {
                keyAccepted = true;
            }
            if (alternate == '-' || alternate == '_') {
                alternateAccepted = true;
            }
        }
        if (key == '\b' || key == '\u007f') {
            keyAccepted = true;
        }
        if (alternate == '\b' || alternate == '\u007f') {
            alternateAccepted = true;
        }
        Message leftClick = !keyAccepted ? null : ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.key.normal.click", ClickType.LEFT, KeyboardGUI.getKeyTitle(key));
        Message rightClick = !alternateAccepted ? null : ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.key.alternate.click", ClickType.RIGHT, KeyboardGUI.getKeyTitle(alternate));
        Message title = alternate != '\u0000' ? ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.key.title.withAlternate", KeyboardGUI.getKeyTitle(key), KeyboardGUI.getKeyTitle(alternate)) : ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.key.title.withoutAlternate", KeyboardGUI.getKeyTitle(key));
        Message clearTextNewLine = null;
        Message clearText = null;
        if (key == '\b') {
            clearTextNewLine = new Message();
            clearText = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.key.clear.click", ClickType.CONTROL_DROP);
            FancyClickEvent.addFunction(item, ClickType.CONTROL_DROP, (whoClicked, clickType, pdc, fancyInventory) -> {
                fancyInventory.setData(cursorIndexDataType, 0);
                fancyInventory.setData(outputStorage, "");
                KeyboardGUI.updateKeyboardTitle(whoClicked, fancyInventory);
            });
        }
        MessageUtils.setCustomItemData(item, colorTheme, title, Arrays.asList(new Message(), leftClick, rightClick, clearTextNewLine, clearText));
        NamespacedKey currentKey_normal = new NamespacedKey((Plugin)Main.getInstance(), "keyValue_normal");
        NamespacedKey currentKey_alternate = new NamespacedKey((Plugin)Main.getInstance(), "keyValue_alternate");
        FancyClickEvent.setStringData(item, currentKey_normal, String.valueOf(key));
        FancyClickEvent.setStringData(item, currentKey_alternate, String.valueOf(alternate));
        FancyClickEvent.FancyClickRunnable onClick = (whoClicked, clickType, pdc, fancyInventory) -> {
            NamespacedKey clickedCurrentKey = new NamespacedKey((Plugin)Main.getInstance(), clickType == ClickType.LEFT ? "keyValue_normal" : "keyValue_alternate");
            Object typedString = KeyboardGUI.getKeyboardOutput(fancyInventory);
            if (pdc.has(clickedCurrentKey, PersistentDataType.STRING)) {
                String clickedKey = Main.getOrDefault((String)pdc.get(clickedCurrentKey, PersistentDataType.STRING), "");
                if (clickedKey.charAt(0) == '\n') {
                    clickedKey = "\n";
                }
                int cursorIndex = fancyInventory.getData(cursorIndexDataType);
                cursorIndex = Math.min(((String)typedString).length(), cursorIndex);
                if (clickedKey.equals("\b")) {
                    if (cursorIndex != 0) {
                        typedString = cursorIndex >= ((String)typedString).length() ? ((String)typedString).substring(0, Math.max(((String)typedString).length() - 1, 0)) : ((String)typedString).substring(0, cursorIndex - 1) + ((String)typedString).substring(cursorIndex);
                    }
                    fancyInventory.setData(cursorIndexDataType, Math.max(cursorIndex - 1, 0));
                } else if (clickedKey.equals(String.valueOf('\u007f'))) {
                    if (cursorIndex < ((String)typedString).length()) {
                        typedString = cursorIndex <= 0 ? ((String)typedString).substring(1) : ((String)typedString).substring(0, cursorIndex) + ((String)typedString).substring(cursorIndex + 1);
                    }
                } else {
                    typedString = cursorIndex == 0 ? clickedKey + (String)typedString : (cursorIndex >= ((String)typedString).length() ? (String)typedString + clickedKey : ((String)typedString).substring(0, cursorIndex) + clickedKey + ((String)typedString).substring(cursorIndex));
                    fancyInventory.setData(cursorIndexDataType, cursorIndex + 1);
                }
                fancyInventory.setData(outputStorage, typedString);
                KeyboardGUI.updateKeyboardTitle(whoClicked, fancyInventory);
            }
        };
        if (keyAccepted) {
            FancyClickEvent.addFunction(item, ClickType.LEFT, onClick);
        }
        if (alternateAccepted) {
            FancyClickEvent.addFunction(item, ClickType.RIGHT, onClick);
        }
        return item;
    }

    private static void updateKeyboardTitle(Player player, @Nonnull FancyInventory inv) {
        int currentCursorIndex;
        String typedString = KeyboardGUI.getKeyboardOutput(inv);
        boolean showColors = inv.getData(formatTitleDataType);
        String defColor = inv.getData(defColorDataType, null);
        ArrayList<Message> coloredMessage = MessageUtils.transformColoredTextToMessage(typedString, defColor);
        ArrayList<String> typedArray = MessageUtils.transformColoredTextToArray(typedString);
        Message coloredTitle = new Message();
        int cursorIndex = inv.getData(cursorIndexDataType);
        if (showColors) {
            coloredMessage.stream().flatMap(m -> Stream.of(new Message("\n"), (Message)m.clone())).skip(1L).forEachOrdered(coloredTitle::addMessage);
            currentCursorIndex = 0;
            int textCursor = 0;
            for (String element : typedArray) {
                if ((currentCursorIndex += element.length()) >= cursorIndex) {
                    if (MultiColor.isColor(element)) break;
                    int subCursorIndex = element.length() - (currentCursorIndex - cursorIndex);
                    textCursor += subCursorIndex;
                    break;
                }
                if (MultiColor.isColor(element)) continue;
                textCursor += element.length();
            }
            cursorIndex = textCursor;
        } else {
            coloredTitle = new Message(typedString);
        }
        currentCursorIndex = 0;
        Message newTitleMessage = new Message();
        int totalAfterCursor = 15;
        int totalLength = 25;
        TextComponent cutOffText = new TextComponent("...", ChatColor.DARK_RED);
        ArrayList<TextComponent> coloredTitleText = coloredTitle.getText();
        block1: for (int i = 0; i < coloredTitleText.size(); ++i) {
            TextComponent t = coloredTitleText.get(i);
            String text = t.getText();
            if ((currentCursorIndex += text.length()) < cursorIndex) continue;
            int subCursorIndex = text.length() - (currentCursorIndex - cursorIndex);
            newTitleMessage.addText(cursor);
            TextComponent t2 = (TextComponent)t.clone();
            t2.setText(text.substring(subCursorIndex, Math.min(text.length(), subCursorIndex + 15)));
            newTitleMessage.addText(t2);
            int currentAfterCursor = t2.getText().length();
            int charsPrintedAfter = t2.getText().length();
            if (15 < text.length() - subCursorIndex) {
                newTitleMessage.addText(cutOffText);
            } else {
                for (int j = i + 1; j < coloredTitleText.size(); ++j) {
                    TextComponent tAfter = coloredTitleText.get(j);
                    String sAfter = tAfter.getText();
                    if (currentAfterCursor + sAfter.length() <= 15) {
                        newTitleMessage.addText(tAfter);
                        charsPrintedAfter += sAfter.length();
                        if ((currentAfterCursor += sAfter.length()) != 15) continue;
                        if (j + 1 >= coloredTitleText.size()) break;
                        newTitleMessage.addText(cutOffText);
                        break;
                    }
                    if (currentAfterCursor + sAfter.length() <= 15) continue;
                    int cutOff = 15 - charsPrintedAfter;
                    tAfter.setText(sAfter.substring(0, cutOff));
                    newTitleMessage.addText(tAfter);
                    newTitleMessage.addText(cutOffText);
                    charsPrintedAfter += tAfter.getText().length();
                    break;
                }
            }
            TextComponent t1 = t.setText(text.substring(Math.max(0, subCursorIndex - (25 - charsPrintedAfter)), subCursorIndex));
            newTitleMessage.getText().add(0, t1);
            int charsToPrintBefore = 25 - charsPrintedAfter - t1.getText().length();
            int charsPrintedBefore = 0;
            if (subCursorIndex > 25 - charsPrintedAfter) {
                newTitleMessage.getText().add(0, cutOffText);
                break;
            }
            for (int j = i - 1; j >= 0; --j) {
                TextComponent tBefore = coloredTitleText.get(j);
                String sBefore = tBefore.getText();
                if ((charsToPrintBefore -= sBefore.length()) >= 0) {
                    newTitleMessage.getText().add(0, tBefore);
                    charsPrintedBefore += tBefore.getText().length();
                    if (charsToPrintBefore != 0) continue;
                    if (j <= 0) break block1;
                    newTitleMessage.getText().add(0, cutOffText);
                    break block1;
                }
                int cutoff = 25 - charsPrintedAfter - t1.getText().length() - charsPrintedBefore;
                tBefore.setText(sBefore.substring(sBefore.length() - cutoff));
                newTitleMessage.getText().add(0, tBefore);
                newTitleMessage.getText().add(0, cutOffText);
                break block1;
            }
            break;
        }
        Message invTitle = ColorTheme.formatInfoTranslation("tport.fancyMessage.inventories.KeyboardGUI.title", newTitleMessage);
        inv.setTitle(invTitle);
        ColorTheme theme = ColorTheme.getTheme(player);
        ItemStack acceptItem = inv.getItem(inv.getSize() - 1);
        MessageUtils.setCustomItemData(acceptItem, theme, null, coloredMessage);
        KeyboardGUI.setFormatButton(inv, player, theme, null);
        KeyboardGUI.updateColorButton(inv, player, theme, null);
        inv.open(player);
    }

    private static void populateQWERTY(FancyInventory inv, ColorTheme colorTheme, JsonObject playerLang, UUID uuid, int keyboardSettings) {
        inv.setItem(0, KeyboardGUI.getKey('1', '!', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(1, KeyboardGUI.getKey('2', '@', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(2, KeyboardGUI.getKey('3', '#', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(3, KeyboardGUI.getKey('4', '$', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(4, KeyboardGUI.getKey('5', '%', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(5, KeyboardGUI.getKey('6', '^', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(6, KeyboardGUI.getKey('7', '&', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(7, KeyboardGUI.getKey('8', '*', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(8, KeyboardGUI.getKey('9', '(', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(9, KeyboardGUI.getKey('0', ')', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(10, KeyboardGUI.getKey('-', '_', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(11, KeyboardGUI.getKey('=', '+', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(12, KeyboardGUI.getKey('[', '{', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(13, KeyboardGUI.getKey(']', '}', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(14, KeyboardGUI.getKey(';', ':', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(15, KeyboardGUI.getKey('\'', '\"', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(16, KeyboardGUI.getKey('/', '?', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(17, KeyboardGUI.getKey('P', 'p', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(18, KeyboardGUI.getKey('Q', 'q', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(19, KeyboardGUI.getKey('W', 'w', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(20, KeyboardGUI.getKey('E', 'e', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(21, KeyboardGUI.getKey('R', 'r', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(22, KeyboardGUI.getKey('T', 't', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(23, KeyboardGUI.getKey('Y', 'y', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(24, KeyboardGUI.getKey('U', 'u', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(25, KeyboardGUI.getKey('I', 'i', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(26, KeyboardGUI.getKey('O', 'o', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(27, KeyboardGUI.getKey('A', 'a', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(28, KeyboardGUI.getKey('S', 's', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(29, KeyboardGUI.getKey('D', 'd', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(30, KeyboardGUI.getKey('F', 'f', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(31, KeyboardGUI.getKey('G', 'g', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(32, KeyboardGUI.getKey('H', 'h', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(33, KeyboardGUI.getKey('J', 'j', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(34, KeyboardGUI.getKey('K', 'k', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(35, KeyboardGUI.getKey('L', 'l', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(36, KeyboardGUI.getKey('Z', 'z', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(37, KeyboardGUI.getKey('X', 'x', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(38, KeyboardGUI.getKey('C', 'c', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(39, KeyboardGUI.getKey('V', 'v', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(40, KeyboardGUI.getKey('B', 'b', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(41, KeyboardGUI.getKey('N', 'n', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(42, KeyboardGUI.getKey('M', 'm', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(43, KeyboardGUI.getKey(',', '<', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(44, KeyboardGUI.getKey('.', '>', colorTheme, playerLang, uuid, keyboardSettings));
    }

    private static void populateAlphabet(FancyInventory inv, ColorTheme colorTheme, JsonObject playerLang, UUID uuid, int keyboardSettings) {
        inv.setItem(0, KeyboardGUI.getKey('1', '!', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(1, KeyboardGUI.getKey('2', '@', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(2, KeyboardGUI.getKey('3', '#', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(3, KeyboardGUI.getKey('4', '$', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(4, KeyboardGUI.getKey('5', '%', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(5, KeyboardGUI.getKey('6', '^', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(6, KeyboardGUI.getKey('7', '&', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(7, KeyboardGUI.getKey('8', '*', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(8, KeyboardGUI.getKey('9', '(', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(9, KeyboardGUI.getKey('0', ')', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(10, KeyboardGUI.getKey('-', '_', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(11, KeyboardGUI.getKey('=', '+', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(12, KeyboardGUI.getKey('[', '{', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(13, KeyboardGUI.getKey(']', '}', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(14, KeyboardGUI.getKey(';', ':', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(15, KeyboardGUI.getKey('\'', '\"', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(16, KeyboardGUI.getKey('/', '?', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(17, KeyboardGUI.getKey('J', 'j', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(18, KeyboardGUI.getKey('A', 'a', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(19, KeyboardGUI.getKey('B', 'b', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(20, KeyboardGUI.getKey('C', 'c', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(21, KeyboardGUI.getKey('D', 'd', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(22, KeyboardGUI.getKey('E', 'e', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(23, KeyboardGUI.getKey('F', 'f', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(24, KeyboardGUI.getKey('G', 'g', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(25, KeyboardGUI.getKey('H', 'h', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(26, KeyboardGUI.getKey('I', 'i', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(27, KeyboardGUI.getKey('K', 'k', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(28, KeyboardGUI.getKey('L', 'l', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(29, KeyboardGUI.getKey('M', 'm', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(30, KeyboardGUI.getKey('N', 'n', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(31, KeyboardGUI.getKey('O', 'o', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(32, KeyboardGUI.getKey('P', 'p', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(33, KeyboardGUI.getKey('Q', 'q', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(34, KeyboardGUI.getKey('R', 'r', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(35, KeyboardGUI.getKey('T', 's', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(36, KeyboardGUI.getKey('S', 't', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(37, KeyboardGUI.getKey('U', 'u', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(38, KeyboardGUI.getKey('V', 'v', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(39, KeyboardGUI.getKey('W', 'w', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(40, KeyboardGUI.getKey('X', 'x', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(41, KeyboardGUI.getKey('Y', 'y', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(42, KeyboardGUI.getKey('Z', 'z', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(43, KeyboardGUI.getKey(',', '<', colorTheme, playerLang, uuid, keyboardSettings));
        inv.setItem(44, KeyboardGUI.getKey('.', '>', colorTheme, playerLang, uuid, keyboardSettings));
    }

    private static int valueToEdit(ClickType clickType) {
        return switch (clickType) {
            case ClickType.LEFT -> 1;
            case ClickType.RIGHT -> 10;
            case ClickType.SHIFT_LEFT -> 25;
            case ClickType.SHIFT_RIGHT -> 100;
            default -> 0;
        };
    }

    private static int constrain(int value, int max, int min) {
        return Math.max(Math.min(value, max), min);
    }

    private static void openColorKeyboard(Player player, @Nonnull FancyInventory keyboard) {
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        Color color = keyboard.getData(colorDataType);
        MultiColor multiColor = new MultiColor(color);
        Message colorTitle = ColorTheme.formatTranslation(multiColor, multiColor, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.title.color", new Object[0]);
        FancyInventory colorKeyboard = new FancyInventory(27, ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.title", colorTitle));
        colorKeyboard.setData(colorDataType, color);
        colorKeyboard.transferData(keyboard);
        colorKeyboard.setData(outputStorage, KeyboardGUI.getKeyboardOutput(keyboard));
        ItemStack acceptColor = keyboard_color_accept_model.getItem(player);
        MessageUtils.setCustomItemData(acceptColor, colorTheme, ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.acceptColor", new Object[0]), null);
        FancyClickEvent.addFunction(acceptColor, ClickType.LEFT, (whoClicked, clickType, pdc, fancyColorInventory) -> {
            String rejFuncName;
            FancyClickEvent.FancyClickRunnable rejFunc;
            String accFuncName = fancyColorInventory.getData(acceptFuncNameDataType);
            FancyClickEvent.FancyClickRunnable accFunc = FancyClickEvent.getFunction(accFuncName);
            if (accFunc == null) {
                accFunc = (whoClicked1, clickType1, pdc1, fancyInventory1) -> {};
            }
            if ((rejFunc = FancyClickEvent.getFunction(rejFuncName = fancyColorInventory.getData(rejectFuncNameDataType))) == null) {
                rejFunc = (whoClicked1, clickType1, pdc1, fancyInventory1) -> {};
            }
            Object typedString = KeyboardGUI.getKeyboardOutput(fancyColorInventory);
            int cursorIndex = fancyColorInventory.getData(cursorIndexDataType);
            cursorIndex = Math.min(((String)typedString).length(), cursorIndex);
            Color c = fancyColorInventory.getData(colorDataType);
            if (fancyColorInventory.getData(editColorDataTye).booleanValue()) {
                int currentCursorIndex = 0;
                ArrayList<String> typedArray = MessageUtils.transformColoredTextToArray((String)typedString);
                for (int i = 0; i < typedArray.size(); ++i) {
                    String element = typedArray.get(i);
                    if ((currentCursorIndex += element.length()) < cursorIndex) continue;
                    String addedColor = new MultiColor(c).getColorAsValue();
                    if (MultiColor.isColor(element)) {
                        String originalColor = typedArray.get(i);
                        typedArray.set(i, addedColor);
                        cursorIndex += -originalColor.length() + addedColor.length();
                    } else if (element.equals("\n")) {
                        typedArray.add(i + 1, addedColor);
                        cursorIndex += addedColor.length();
                    } else if (i > 0) {
                        String originalColor = typedArray.get(i - 1);
                        if (originalColor.equals("\n")) {
                            typedArray.add(i, addedColor);
                            cursorIndex += addedColor.length();
                        } else {
                            typedArray.set(i - 1, addedColor);
                            cursorIndex += -originalColor.length() + addedColor.length();
                        }
                    } else {
                        typedArray.add(0, addedColor);
                        cursorIndex += addedColor.length();
                    }
                    typedString = String.join((CharSequence)"", typedArray);
                    break;
                }
            } else {
                typedString = cursorIndex == 0 ? new MultiColor(c).getColorAsValue() + (String)typedString : (cursorIndex >= ((String)typedString).length() ? (String)typedString + new MultiColor(c).getColorAsValue() : ((String)typedString).substring(0, cursorIndex) + new MultiColor(c).getColorAsValue() + ((String)typedString).substring(cursorIndex));
                cursorIndex += 7;
            }
            fancyColorInventory.setData(cursorIndexDataType, cursorIndex);
            int keyboardSettings = fancyColorInventory.getData(keyboardSettingsDataType);
            String defColor = fancyColorInventory.getData(defColorDataType);
            FancyInventory newKeyboard = KeyboardGUI.openKeyboard(whoClicked, accFunc, rejFunc, (String)typedString, defColor, keyboardSettings);
            newKeyboard.transferData(fancyColorInventory);
            newKeyboard.setData(outputStorage, typedString);
            KeyboardGUI.updateKeyboardTitle(whoClicked, newKeyboard);
        });
        colorKeyboard.setItem(colorKeyboard.getSize() - 1, acceptColor);
        ItemStack rejectColor = keyboard_color_reject_model.getItem(player);
        MessageUtils.setCustomItemData(rejectColor, colorTheme, ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.cancel", new Object[0]), null);
        FancyClickEvent.addFunction(rejectColor, ClickType.LEFT, (whoClicked, clickType, pdc, fancyColorInventory) -> {
            String rejFuncName;
            FancyClickEvent.FancyClickRunnable rejFunc;
            String accFuncName = fancyColorInventory.getData(acceptFuncNameDataType);
            FancyClickEvent.FancyClickRunnable accFunc = FancyClickEvent.getFunction(accFuncName);
            if (accFunc == null) {
                accFunc = (whoClicked1, clickType1, pdc1, fancyInventory1) -> {};
            }
            if ((rejFunc = FancyClickEvent.getFunction(rejFuncName = fancyColorInventory.getData(rejectFuncNameDataType))) == null) {
                rejFunc = (whoClicked1, clickType1, pdc1, fancyInventory1) -> {};
            }
            String typedString = KeyboardGUI.getKeyboardOutput(fancyColorInventory);
            int keyboardSettings = fancyColorInventory.getData(keyboardSettingsDataType);
            String defColor = fancyColorInventory.getData(defColorDataType);
            FancyInventory newKeyboard = KeyboardGUI.openKeyboard(whoClicked, accFunc, rejFunc, typedString, defColor, keyboardSettings);
            newKeyboard.transferData(fancyColorInventory);
            KeyboardGUI.updateKeyboardTitle(whoClicked, newKeyboard);
        });
        colorKeyboard.setItem(colorKeyboard.getSize() - 9, rejectColor);
        Message valueHEXMessage = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.value.hex", new MultiColor(color).getColorAsValue());
        Message valueRGBMessage = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.value.rgb", color.getRed(), color.getGreen(), color.getBlue());
        Message valueAdd1 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.value.add", ClickType.LEFT, KeyboardGUI.valueToEdit(ClickType.LEFT));
        Message valueAdd10 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.value.add", ClickType.RIGHT, KeyboardGUI.valueToEdit(ClickType.RIGHT));
        Message valueAdd25 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.value.add", ClickType.SHIFT_LEFT, KeyboardGUI.valueToEdit(ClickType.SHIFT_LEFT));
        Message valueAdd100 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.value.add", ClickType.SHIFT_RIGHT, KeyboardGUI.valueToEdit(ClickType.SHIFT_RIGHT));
        Message valueRemove1 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.value.remove", ClickType.LEFT, KeyboardGUI.valueToEdit(ClickType.LEFT));
        Message valueRemove10 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.value.remove", ClickType.RIGHT, KeyboardGUI.valueToEdit(ClickType.RIGHT));
        Message valueRemove25 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.value.remove", ClickType.SHIFT_LEFT, KeyboardGUI.valueToEdit(ClickType.SHIFT_LEFT));
        Message valueRemove100 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.value.remove", ClickType.SHIFT_RIGHT, KeyboardGUI.valueToEdit(ClickType.SHIFT_RIGHT));
        FancyClickEvent.FancyClickRunnable onColorClick = (whoClicked, clickType, pdc, fancyColorInventory) -> {
            int valueToAdd = KeyboardGUI.valueToEdit(clickType);
            if (pdc.has(new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_remove"))) {
                valueToAdd *= -1;
            }
            Color c = fancyColorInventory.getData(colorDataType);
            Color newColor = null;
            if (pdc.has(new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_red"))) {
                newColor = new Color(KeyboardGUI.constrain(c.getRed() + valueToAdd, 255, 0), c.getGreen(), c.getBlue());
            } else if (pdc.has(new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_green"))) {
                newColor = new Color(c.getRed(), KeyboardGUI.constrain(c.getGreen() + valueToAdd, 255, 0), c.getBlue());
            } else if (pdc.has(new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_blue"))) {
                newColor = new Color(c.getRed(), c.getGreen(), KeyboardGUI.constrain(c.getBlue() + valueToAdd, 255, 0));
            }
            fancyColorInventory.setData(colorDataType, newColor);
            KeyboardGUI.openColorKeyboard(whoClicked, fancyColorInventory);
        };
        ItemStack redAdd = keyboard_color_red_add_model.getItem(player);
        Message redAddTitle = ColorTheme.formatTranslation(multiColor, multiColor, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.red.add", new Object[0]).translateMessage(playerLang);
        MessageUtils.setCustomItemData(redAdd, colorTheme, redAddTitle, Arrays.asList(valueHEXMessage, valueRGBMessage, new Message(), valueAdd1, valueAdd10, valueAdd25, valueAdd100));
        FancyClickEvent.setBooleanData(redAdd, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_red"), true);
        FancyClickEvent.addFunction(redAdd, onColorClick, ClickType.LEFT, ClickType.RIGHT, ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT);
        colorKeyboard.setItem(10, redAdd);
        ItemStack redRem = keyboard_color_red_remove_model.getItem(player);
        Message redRemTitle = ColorTheme.formatTranslation(multiColor, multiColor, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.red.remove", new Object[0]).translateMessage(playerLang);
        MessageUtils.setCustomItemData(redRem, colorTheme, redRemTitle, Arrays.asList(valueHEXMessage, valueRGBMessage, new Message(), valueRemove1, valueRemove10, valueRemove25, valueRemove100));
        FancyClickEvent.setBooleanData(redRem, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_red"), true);
        FancyClickEvent.setBooleanData(redRem, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_remove"), true);
        FancyClickEvent.addFunction(redRem, onColorClick, ClickType.LEFT, ClickType.RIGHT, ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT);
        colorKeyboard.setItem(11, redRem);
        ItemStack greenAdd = keyboard_color_green_add_model.getItem(player);
        Message greenAddTitle = ColorTheme.formatTranslation(multiColor, multiColor, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.green.add", new Object[0]).translateMessage(playerLang);
        MessageUtils.setCustomItemData(greenAdd, colorTheme, greenAddTitle, Arrays.asList(valueHEXMessage, valueRGBMessage, new Message(), valueAdd1, valueAdd10, valueAdd25, valueAdd100));
        FancyClickEvent.setBooleanData(greenAdd, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_green"), true);
        FancyClickEvent.addFunction(greenAdd, onColorClick, ClickType.LEFT, ClickType.RIGHT, ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT);
        colorKeyboard.setItem(12, greenAdd);
        ItemStack greenRem = keyboard_color_green_remove_model.getItem(player);
        Message greenRemTitle = ColorTheme.formatTranslation(multiColor, multiColor, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.green.remove", new Object[0]).translateMessage(playerLang);
        MessageUtils.setCustomItemData(greenRem, colorTheme, greenRemTitle, Arrays.asList(valueHEXMessage, valueRGBMessage, new Message(), valueRemove1, valueRemove10, valueRemove25, valueRemove100));
        FancyClickEvent.setBooleanData(greenRem, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_green"), true);
        FancyClickEvent.setBooleanData(greenRem, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_remove"), true);
        FancyClickEvent.addFunction(greenRem, onColorClick, ClickType.LEFT, ClickType.RIGHT, ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT);
        colorKeyboard.setItem(13, greenRem);
        ItemStack blueAdd = keyboard_color_blue_add_model.getItem(player);
        Message blueAddTitle = ColorTheme.formatTranslation(multiColor, multiColor, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.blue.add", new Object[0]).translateMessage(playerLang);
        MessageUtils.setCustomItemData(blueAdd, colorTheme, blueAddTitle, Arrays.asList(valueHEXMessage, valueRGBMessage, new Message(), valueAdd1, valueAdd10, valueAdd25, valueAdd100));
        FancyClickEvent.setBooleanData(blueAdd, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_blue"), true);
        FancyClickEvent.addFunction(blueAdd, onColorClick, ClickType.LEFT, ClickType.RIGHT, ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT);
        colorKeyboard.setItem(14, blueAdd);
        ItemStack blueRem = keyboard_color_blue_remove_model.getItem(player);
        Message blueRemTitle = ColorTheme.formatTranslation(multiColor, multiColor, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.blue.remove", new Object[0]).translateMessage(playerLang);
        MessageUtils.setCustomItemData(blueRem, colorTheme, blueRemTitle, Arrays.asList(valueHEXMessage, valueRGBMessage, new Message(), valueRemove1, valueRemove10, valueRemove25, valueRemove100));
        FancyClickEvent.setBooleanData(blueRem, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_blue"), true);
        FancyClickEvent.setBooleanData(blueRem, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_remove"), true);
        FancyClickEvent.addFunction(blueRem, onColorClick, ClickType.LEFT, ClickType.RIGHT, ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT);
        colorKeyboard.setItem(15, blueRem);
        ItemStack builtInColorSelector = keyboard_chat_color_model.getItem(player);
        Message builtInColorSelectorTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorKeyboard.openBuiltInColorSelector", new Object[0]);
        MessageUtils.setCustomItemData(builtInColorSelector, colorTheme, builtInColorSelectorTitle, null);
        FancyClickEvent.addFunction(builtInColorSelector, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> KeyboardGUI.openBuiltInColorSelector(whoClicked, 0, fancyInventory));
        colorKeyboard.setItem(16, builtInColorSelector);
        colorKeyboard.open(player);
    }

    private static void openBuiltInColorSelector(Player player, int page, @Nonnull FancyInventory colorKeyboard) {
        Message clickToSelect;
        Message valueRGBMessage;
        Message valueHEXMessage;
        Message title;
        MultiColor chatMultiColor;
        ItemStack is;
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ChatColor chatColor : ChatColor.values()) {
            if (!chatColor.isColor()) continue;
            is = KeyboardGUI.getChatColorStack(chatColor, player);
            chatMultiColor = new MultiColor(chatColor);
            title = ColorTheme.formatTranslation(colorTheme.getInfoColor(), chatMultiColor, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector.chatColor", chatColor.name(), "&", Character.valueOf(chatColor.getChar())).translateMessage(playerLang);
            valueHEXMessage = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector.chatColor.hex", chatMultiColor.getColorAsValue());
            valueRGBMessage = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector.chatColor.rgb", chatMultiColor.getRed(), chatMultiColor.getGreen(), chatMultiColor.getBlue());
            clickToSelect = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector.clickToSelect", ClickType.LEFT);
            MessageUtils.setCustomItemData(is, colorTheme, title, List.of(new Message(), valueHEXMessage, valueRGBMessage, new Message(), clickToSelect));
            FancyClickEvent.setStringData(is, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_chat_color"), chatColor.name());
            FancyClickEvent.addFunction(is, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
                ChatColor c = ChatColor.valueOf((String)((String)pdc.get(new NamespacedKey((Plugin)Main.getInstance(), "keyboard_chat_color"), PersistentDataType.STRING)));
                fancyInventory.setData(colorDataType, new MultiColor(c).getColor());
                KeyboardGUI.openColorKeyboard(whoClicked, fancyInventory);
            });
            items.add(is);
        }
        for (ChatColor chatColor : DyeColor.values()) {
            is = KeyboardGUI.getDyeStack((DyeColor)chatColor);
            chatMultiColor = new MultiColor((DyeColor)chatColor);
            title = ColorTheme.formatTranslation(colorTheme.getInfoColor(), chatMultiColor, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector.dyeColor", chatColor.name()).translateMessage(playerLang);
            valueHEXMessage = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector.dyeColor.hex", chatMultiColor.getColorAsValue());
            valueRGBMessage = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector.dyeColor.rgb", chatMultiColor.getRed(), chatMultiColor.getGreen(), chatMultiColor.getBlue());
            clickToSelect = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector.clickToSelect", ClickType.LEFT);
            MessageUtils.setCustomItemData(is, colorTheme, title, List.of(new Message(), valueHEXMessage, valueRGBMessage, new Message(), clickToSelect));
            FancyClickEvent.setStringData(is, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_dye_color"), chatColor.name());
            FancyClickEvent.addFunction(is, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
                DyeColor c = DyeColor.valueOf((String)((String)pdc.get(new NamespacedKey((Plugin)Main.getInstance(), "keyboard_dye_color"), PersistentDataType.STRING)));
                fancyInventory.setData(colorDataType, new MultiColor(c).getColor());
                KeyboardGUI.openColorKeyboard(whoClicked, fancyInventory);
            });
            items.add(is);
        }
        ItemStack backButton = keyboard_chat_color_reject_model.getItem(player);
        Message backTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector.cancel", new Object[0]);
        MessageUtils.setCustomItemData(backButton, colorTheme, backTitle, null);
        FancyClickEvent.addFunction(backButton, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> KeyboardGUI.openColorKeyboard(whoClicked, fancyInventory));
        Message title2 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector.title", new Object[0]);
        FancyInventory fancyInventory2 = FancyInventory.getDynamicScrollableInventory(player, page, KeyboardGUI::openBuiltInColorSelector, title2, items, backButton);
        fancyInventory2.transferData(colorKeyboard, false);
        fancyInventory2.setData(outputStorage, KeyboardGUI.getKeyboardOutput(colorKeyboard));
        fancyInventory2.open(player);
    }

    public static ItemStack getDyeStack(DyeColor dyeColor) {
        Material m = switch (dyeColor) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> Material.WHITE_DYE;
            case DyeColor.ORANGE -> Material.ORANGE_DYE;
            case DyeColor.MAGENTA -> Material.MAGENTA_DYE;
            case DyeColor.LIGHT_BLUE -> Material.LIGHT_BLUE_DYE;
            case DyeColor.YELLOW -> Material.YELLOW_DYE;
            case DyeColor.LIME -> Material.LIME_DYE;
            case DyeColor.PINK -> Material.PINK_DYE;
            case DyeColor.GRAY -> Material.GRAY_DYE;
            case DyeColor.LIGHT_GRAY -> Material.LIGHT_GRAY_DYE;
            case DyeColor.CYAN -> Material.CYAN_DYE;
            case DyeColor.PURPLE -> Material.PURPLE_DYE;
            case DyeColor.BLUE -> Material.BLUE_DYE;
            case DyeColor.BROWN -> Material.BROWN_DYE;
            case DyeColor.GREEN -> Material.GREEN_DYE;
            case DyeColor.RED -> Material.RED_DYE;
            case DyeColor.BLACK -> Material.BLACK_DYE;
        };
        return new ItemStack(m);
    }

    public static ItemStack getChatColorStack(ChatColor chatColor, Player player) {
        return switch (chatColor) {
            case ChatColor.DARK_BLUE -> keyboard_chat_color_dark_blue_model.getItem(player);
            case ChatColor.DARK_GREEN -> keyboard_chat_color_dark_green_model.getItem(player);
            case ChatColor.DARK_AQUA -> keyboard_chat_color_dark_aqua_model.getItem(player);
            case ChatColor.DARK_RED -> keyboard_chat_color_dark_red_model.getItem(player);
            case ChatColor.DARK_PURPLE -> keyboard_chat_color_dark_purple_model.getItem(player);
            case ChatColor.GOLD -> keyboard_chat_color_gold_model.getItem(player);
            case ChatColor.GRAY -> keyboard_chat_color_gray_model.getItem(player);
            case ChatColor.DARK_GRAY -> keyboard_chat_color_dark_gray_model.getItem(player);
            case ChatColor.BLUE -> keyboard_chat_color_blue_model.getItem(player);
            case ChatColor.GREEN -> keyboard_chat_color_green_model.getItem(player);
            case ChatColor.AQUA -> keyboard_chat_color_aqua_model.getItem(player);
            case ChatColor.RED -> keyboard_chat_color_red_model.getItem(player);
            case ChatColor.LIGHT_PURPLE -> keyboard_chat_color_light_purple_model.getItem(player);
            case ChatColor.YELLOW -> keyboard_chat_color_yellow_model.getItem(player);
            case ChatColor.WHITE -> keyboard_chat_color_white_model.getItem(player);
            case ChatColor.BLACK -> keyboard_chat_color_black_model.getItem(player);
            default -> keyboard_chat_color_black_model.getItem(player);
        };
    }

    private static void setFormatButton(FancyInventory keyboard, Player player, @Nullable ColorTheme colorTheme, @Nullable JsonObject playerLang) {
        boolean showColors;
        if (colorTheme == null) {
            colorTheme = ColorTheme.getTheme(player);
        }
        if (playerLang == null) {
            playerLang = Language.getPlayerLang(player.getUniqueId());
        }
        ItemStack formatTitleButton = (showColors = keyboard.getData(formatTitleDataType).booleanValue()) ? keyboard_format_on_model.getItem(player) : keyboard_format_off_model.getItem(player);
        Message formatTitleTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.formatTitle.title", ClickType.LEFT);
        MessageUtils.setCustomItemData(formatTitleButton, colorTheme, formatTitleTitle, null);
        FancyClickEvent.addFunction(formatTitleButton, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
            boolean innerShowColors = fancyInventory.getData(formatTitleDataType);
            fancyInventory.setData(formatTitleDataType, !innerShowColors);
            KeyboardGUI.updateKeyboardTitle(whoClicked, fancyInventory);
        });
        keyboard.setItem(46, formatTitleButton);
    }

    private static Color getColorFromCursor(FancyInventory fancyInventory, ArrayList<String> typedArray) {
        String defColor = fancyInventory.getData(defColorDataType);
        Color color = new MultiColor(defColor).getColor();
        int cursorIndex = fancyInventory.getData(cursorIndexDataType);
        int currentCursorIndex = 0;
        for (int i = 0; i < typedArray.size(); ++i) {
            String element = typedArray.get(i);
            if ((currentCursorIndex += element.length()) < cursorIndex) continue;
            if (MultiColor.isColor(element)) {
                color = new MultiColor(element).getColor();
                break;
            }
            if (i <= 0 || typedArray.get(i - 1).equals("\n") || element.equals("\n")) break;
            color = new MultiColor(typedArray.get(i - 1)).getColor();
            break;
        }
        return color;
    }

    private static void updateColorButton(FancyInventory keyboard, Player player, @Nullable ColorTheme colorTheme, @Nullable JsonObject playerLang) {
        boolean hasColors;
        int keyboardSettings = keyboard.getData(keyboardSettingsDataType);
        boolean bl = hasColors = (keyboardSettings & 4) == 4;
        if (colorTheme == null) {
            colorTheme = ColorTheme.getTheme(player);
        }
        if (playerLang == null) {
            playerLang = Language.getPlayerLang(player.getUniqueId());
        }
        ItemStack openColor = (hasColors ? keyboard_color_model : keyboard_color_grayed_model).getItem(player);
        Message openColorTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.colorEditor.title", new Object[0]);
        ArrayList<Message> lore = new ArrayList<Message>();
        if (hasColors) {
            lore.add(new Message());
            lore.add(ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.insertColor.title", ClickType.LEFT));
            String typedString = KeyboardGUI.getKeyboardOutput(keyboard);
            if (!typedString.isEmpty()) {
                ArrayList<String> typedArray = MessageUtils.transformColoredTextToArray(typedString);
                Color color = KeyboardGUI.getColorFromCursor(keyboard, typedArray);
                Message thisMessage = ColorTheme.formatTranslation(new MultiColor(color), new MultiColor(color), "tport.fancyMessage.inventories.KeyboardGUI.editColor.this", new Object[0]);
                thisMessage = MessageUtils.translateMessage(thisMessage, playerLang);
                lore.add(ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.editColor.title", ClickType.RIGHT, thisMessage));
                FancyClickEvent.addFunction(openColor, ClickType.RIGHT, (whoClicked, clickType, pdc, fancyInventory) -> {
                    String innerTypedString = KeyboardGUI.getKeyboardOutput(fancyInventory);
                    ArrayList<String> innerTypedArray = MessageUtils.transformColoredTextToArray(innerTypedString);
                    Color innerColor = KeyboardGUI.getColorFromCursor(fancyInventory, innerTypedArray);
                    fancyInventory.setData(colorDataType, innerColor);
                    fancyInventory.setData(editColorDataTye, true);
                    KeyboardGUI.openColorKeyboard(whoClicked, fancyInventory);
                });
                lore.add(ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.removeColor.title", ClickType.SHIFT_RIGHT, thisMessage));
                FancyClickEvent.addFunction(openColor, ClickType.SHIFT_RIGHT, (whoClicked, clickType, pdc, fancyInventory) -> {
                    String innerTypedString = KeyboardGUI.getKeyboardOutput(fancyInventory);
                    ArrayList<String> innerTypedArray = MessageUtils.transformColoredTextToArray(innerTypedString);
                    int cursorIndex = fancyInventory.getData(cursorIndexDataType);
                    int currentCursorIndex = 0;
                    int colorLength = 0;
                    for (int i = 0; i < innerTypedArray.size(); ++i) {
                        String element = innerTypedArray.get(i);
                        if ((currentCursorIndex += element.length()) < cursorIndex) continue;
                        if (MultiColor.isColor(element)) {
                            colorLength = innerTypedArray.remove(i).length() - (currentCursorIndex - cursorIndex);
                            break;
                        }
                        if (i <= 0 || innerTypedArray.get(i - 1).equals("\n") || element.equals("\n")) break;
                        colorLength = innerTypedArray.remove(i - 1).length();
                        break;
                    }
                    fancyInventory.setData(cursorIndexDataType, Math.max(0, cursorIndex - colorLength));
                    fancyInventory.setData(outputStorage, String.join((CharSequence)"", innerTypedArray));
                    KeyboardGUI.updateKeyboardTitle(whoClicked, fancyInventory);
                });
                lore.add(ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.removeAllColor.title", ClickType.SHIFT_LEFT, thisMessage));
                FancyClickEvent.addFunction(openColor, ClickType.SHIFT_LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
                    String innerTypedString = KeyboardGUI.getKeyboardOutput(fancyInventory);
                    ArrayList<String> innerTypedArray = MessageUtils.transformColoredTextToArray(innerTypedString);
                    int cursorIndex = fancyInventory.getData(cursorIndexDataType);
                    int removeFromCursorIndex = 0;
                    int charIndex = 0;
                    StringBuilder typedText = new StringBuilder();
                    for (String s : innerTypedArray) {
                        charIndex += s.length();
                        if (!MultiColor.isColor(s)) {
                            typedText.append(s);
                            continue;
                        }
                        if (charIndex > cursorIndex) continue;
                        removeFromCursorIndex += s.length();
                    }
                    fancyInventory.setData(cursorIndexDataType, Math.max(0, cursorIndex - removeFromCursorIndex));
                    fancyInventory.setData(outputStorage, typedText.toString());
                    KeyboardGUI.updateKeyboardTitle(whoClicked, fancyInventory);
                });
                lore.add(ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.colorFade.createNew", ClickType.DROP, thisMessage));
                FancyClickEvent.addFunction(openColor, ClickType.DROP, (whoClicked, clickType, pdc, fancyInventory) -> {
                    String innerTypedString = KeyboardGUI.getKeyboardOutput(fancyInventory);
                    ArrayList<String> innerTypedArray = MessageUtils.transformColoredTextToArray(innerTypedString);
                    StringBuilder typedText = new StringBuilder();
                    for (String s : innerTypedArray) {
                        if (MultiColor.isColor(s)) continue;
                        typedText.append(s);
                    }
                    KeyboardGUI.openColorFadeKeyboard(whoClicked, null, typedText.toString(), 0, fancyInventory);
                });
                lore.add(ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.colorFade.create", ClickType.CONTROL_DROP, thisMessage));
                FancyClickEvent.addFunction(openColor, ClickType.CONTROL_DROP, (whoClicked, clickType, pdc, fancyInventory) -> {
                    String innerTypedString = KeyboardGUI.getKeyboardOutput(fancyInventory);
                    ArrayList<String> innerTypedArray = MessageUtils.transformColoredTextToArray(innerTypedString);
                    ArrayList<MultiColor> colors = new ArrayList<MultiColor>();
                    StringBuilder typedText = new StringBuilder();
                    for (String s : innerTypedArray) {
                        if (MultiColor.isColor(s)) {
                            colors.add(new MultiColor(s));
                            continue;
                        }
                        typedText.append(s);
                    }
                    KeyboardGUI.openColorFadeKeyboard(whoClicked, colors, typedText.toString(), 0, fancyInventory);
                });
            }
            FancyClickEvent.addFunction(openColor, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
                fancyInventory.setData(editColorDataTye, false);
                KeyboardGUI.openColorKeyboard(whoClicked, fancyInventory);
            });
        }
        MessageUtils.setCustomItemData(openColor, colorTheme, openColorTitle, lore);
        keyboard.setItem(48, openColor);
    }

    private static void openBuiltInColorSelector2(Player player, int page, @Nonnull FancyInventory prevKeyboard) {
        Message clickToSelect;
        Message valueRGBMessage;
        Message valueHEXMessage;
        Message title;
        MultiColor chatMultiColor;
        ItemStack is;
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ChatColor chatColor : ChatColor.values()) {
            if (!chatColor.isColor()) continue;
            is = KeyboardGUI.getChatColorStack(chatColor, player);
            chatMultiColor = new MultiColor(chatColor);
            title = ColorTheme.formatTranslation(colorTheme.getInfoColor(), chatMultiColor, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector2.chatColor", chatColor.name(), "&", Character.valueOf(chatColor.getChar())).translateMessage(playerLang);
            valueHEXMessage = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector2.chatColor.hex", chatMultiColor.getColorAsValue());
            valueRGBMessage = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector2.chatColor.rgb", chatMultiColor.getRed(), chatMultiColor.getGreen(), chatMultiColor.getBlue());
            clickToSelect = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector2.clickToSelect", ClickType.LEFT);
            MessageUtils.setCustomItemData(is, colorTheme, title, List.of(new Message(), valueHEXMessage, valueRGBMessage, new Message(), clickToSelect));
            FancyClickEvent.setStringData(is, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_chat_color"), chatColor.name());
            FancyClickEvent.addFunction(is, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
                ChatColor c = ChatColor.valueOf((String)((String)pdc.get(new NamespacedKey((Plugin)Main.getInstance(), "keyboard_chat_color"), PersistentDataType.STRING)));
                int innerPage = (Integer)fancyInventory.getData("colorFadePage");
                String innerTypedText = fancyInventory.getData(colorFadeStringDataType);
                ArrayList innerColors = fancyInventory.getData(colorFadeColorsDataType);
                int colorIndex = (Integer)fancyInventory.getData("colorFadeColorIndex");
                innerColors.set(colorIndex, new MultiColor(c));
                KeyboardGUI.openColorFadeKeyboard(whoClicked, innerColors, innerTypedText, innerPage, fancyInventory);
            });
            items.add(is);
        }
        for (ChatColor chatColor : DyeColor.values()) {
            is = KeyboardGUI.getDyeStack((DyeColor)chatColor);
            chatMultiColor = new MultiColor((DyeColor)chatColor);
            title = ColorTheme.formatTranslation(colorTheme.getInfoColor(), chatMultiColor, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector2.dyeColor", chatColor.name()).translateMessage(playerLang);
            valueHEXMessage = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector2.dyeColor.hex", chatMultiColor.getColorAsValue());
            valueRGBMessage = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector2.dyeColor.rgb", chatMultiColor.getRed(), chatMultiColor.getGreen(), chatMultiColor.getBlue());
            clickToSelect = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector2.clickToSelect", ClickType.LEFT);
            MessageUtils.setCustomItemData(is, colorTheme, title, List.of(new Message(), valueHEXMessage, valueRGBMessage, new Message(), clickToSelect));
            FancyClickEvent.setStringData(is, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_dye_color"), chatColor.name());
            FancyClickEvent.addFunction(is, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
                DyeColor c = DyeColor.valueOf((String)((String)pdc.get(new NamespacedKey((Plugin)Main.getInstance(), "keyboard_dye_color"), PersistentDataType.STRING)));
                int innerPage = (Integer)fancyInventory.getData("colorFadePage");
                String innerTypedText = fancyInventory.getData(colorFadeStringDataType);
                ArrayList innerColors = fancyInventory.getData(colorFadeColorsDataType);
                int colorIndex = (Integer)fancyInventory.getData("colorFadeColorIndex");
                innerColors.set(colorIndex, new MultiColor(c));
                KeyboardGUI.openColorFadeKeyboard(whoClicked, innerColors, innerTypedText, innerPage, fancyInventory);
            });
            items.add(is);
        }
        ItemStack backButton = keyboard_chat_color_reject_model.getItem(player);
        Message backTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector2.cancel", new Object[0]);
        MessageUtils.setCustomItemData(backButton, colorTheme, backTitle, null);
        FancyClickEvent.addFunction(backButton, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
            int innerPage = (Integer)fancyInventory.getData("colorFadePage");
            KeyboardGUI.openColorFadeKeyboard(whoClicked, innerPage, fancyInventory);
        });
        Message title2 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openBuiltInColorSelector2.title", new Object[0]);
        FancyInventory fancyInventory2 = FancyInventory.getDynamicScrollableInventory(player, page, KeyboardGUI::openBuiltInColorSelector2, title2, items, backButton);
        fancyInventory2.transferData(prevKeyboard, false);
        fancyInventory2.setData(outputStorage, KeyboardGUI.getKeyboardOutput(prevKeyboard));
        fancyInventory2.open(player);
    }

    private static void openColorFadeKeyboard(Player player, int page, @Nonnull FancyInventory keyboard) {
        KeyboardGUI.openColorFadeKeyboard(player, keyboard.getData(colorFadeColorsDataType), keyboard.getData(colorFadeStringDataType), page, keyboard);
    }

    public static void openColorFadeKeyboard(Player player, @Nullable ArrayList<MultiColor> colors, String typedText, int page, @Nonnull FancyInventory keyboard) {
        if (colors == null) {
            colors = new ArrayList();
        }
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player);
        Message valueAdd1 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.value.add", ClickType.LEFT, KeyboardGUI.valueToEdit(ClickType.LEFT));
        Message valueAdd10 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.value.add", ClickType.RIGHT, KeyboardGUI.valueToEdit(ClickType.RIGHT));
        Message valueAdd25 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.value.add", ClickType.SHIFT_LEFT, KeyboardGUI.valueToEdit(ClickType.SHIFT_LEFT));
        Message valueAdd100 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.value.add", ClickType.SHIFT_RIGHT, KeyboardGUI.valueToEdit(ClickType.SHIFT_RIGHT));
        Message valueRemove1 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.value.remove", ClickType.LEFT, KeyboardGUI.valueToEdit(ClickType.LEFT));
        Message valueRemove10 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.value.remove", ClickType.RIGHT, KeyboardGUI.valueToEdit(ClickType.RIGHT));
        Message valueRemove25 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.value.remove", ClickType.SHIFT_LEFT, KeyboardGUI.valueToEdit(ClickType.SHIFT_LEFT));
        Message valueRemove100 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.value.remove", ClickType.SHIFT_RIGHT, KeyboardGUI.valueToEdit(ClickType.SHIFT_RIGHT));
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(colors.size() * 7);
        int editColorIndex = -1;
        FancyClickEvent.FancyClickRunnable onColorClick = (whoClicked, clickType, pdc, fancyColorInventory) -> {
            int valueToAdd = KeyboardGUI.valueToEdit(clickType);
            if (pdc.has(new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_remove"))) {
                valueToAdd *= -1;
            }
            int innerPage = fancyColorInventory.getData(FancyInventory.pageDataName);
            String innerTypedText = fancyColorInventory.getData(colorFadeStringDataType);
            ArrayList innerColors = fancyColorInventory.getData(colorFadeColorsDataType);
            int colorIndex = (Integer)pdc.get(new NamespacedKey((Plugin)Main.getInstance(), "colorIndex"), PersistentDataType.INTEGER);
            Color c = ((MultiColor)innerColors.get(colorIndex)).getColor();
            Color newColor = null;
            if (pdc.has(new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_red"))) {
                newColor = new Color(KeyboardGUI.constrain(c.getRed() + valueToAdd, 255, 0), c.getGreen(), c.getBlue());
            } else if (pdc.has(new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_green"))) {
                newColor = new Color(c.getRed(), KeyboardGUI.constrain(c.getGreen() + valueToAdd, 255, 0), c.getBlue());
            } else if (pdc.has(new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_blue"))) {
                newColor = new Color(c.getRed(), c.getGreen(), KeyboardGUI.constrain(c.getBlue() + valueToAdd, 255, 0));
            }
            innerColors.set(colorIndex, new MultiColor(newColor));
            KeyboardGUI.openColorFadeKeyboard(whoClicked, innerColors, innerTypedText, innerPage, fancyColorInventory);
        };
        for (MultiColor multiColor : colors) {
            ++editColorIndex;
            Message valueHEXMessage = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.value.hex", multiColor.getColorAsValue());
            Message valueRGBMessage = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.value.rgb", multiColor.getRed(), multiColor.getGreen(), multiColor.getBlue());
            ItemStack redAdd = keyboard_color_fade_red_add_model.getItem(player);
            Message redAddTitle = ColorTheme.formatTranslation(multiColor, multiColor, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.red.add", new Object[0]).translateMessage(playerLang);
            MessageUtils.setCustomItemData(redAdd, colorTheme, redAddTitle, Arrays.asList(valueHEXMessage, valueRGBMessage, new Message(), valueAdd1, valueAdd10, valueAdd25, valueAdd100));
            FancyClickEvent.setBooleanData(redAdd, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_red"), true);
            FancyClickEvent.addFunction(redAdd, onColorClick, ClickType.LEFT, ClickType.RIGHT, ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT);
            FancyClickEvent.setIntData(redAdd, new NamespacedKey((Plugin)Main.getInstance(), "colorIndex"), editColorIndex);
            items.add(redAdd);
            ItemStack redRem = keyboard_color_fade_red_remove_model.getItem(player);
            Message redRemTitle = ColorTheme.formatTranslation(multiColor, multiColor, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.red.remove", new Object[0]).translateMessage(playerLang);
            MessageUtils.setCustomItemData(redRem, colorTheme, redRemTitle, Arrays.asList(valueHEXMessage, valueRGBMessage, new Message(), valueRemove1, valueRemove10, valueRemove25, valueRemove100));
            FancyClickEvent.setBooleanData(redRem, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_red"), true);
            FancyClickEvent.setBooleanData(redRem, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_remove"), true);
            FancyClickEvent.addFunction(redRem, onColorClick, ClickType.LEFT, ClickType.RIGHT, ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT);
            FancyClickEvent.setIntData(redRem, new NamespacedKey((Plugin)Main.getInstance(), "colorIndex"), editColorIndex);
            items.add(redRem);
            ItemStack greenAdd = keyboard_color_fade_green_add_model.getItem(player);
            Message greenAddTitle = ColorTheme.formatTranslation(multiColor, multiColor, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.green.add", new Object[0]).translateMessage(playerLang);
            MessageUtils.setCustomItemData(greenAdd, colorTheme, greenAddTitle, Arrays.asList(valueHEXMessage, valueRGBMessage, new Message(), valueAdd1, valueAdd10, valueAdd25, valueAdd100));
            FancyClickEvent.setBooleanData(greenAdd, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_green"), true);
            FancyClickEvent.addFunction(greenAdd, onColorClick, ClickType.LEFT, ClickType.RIGHT, ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT);
            FancyClickEvent.setIntData(greenAdd, new NamespacedKey((Plugin)Main.getInstance(), "colorIndex"), editColorIndex);
            items.add(greenAdd);
            ItemStack greenRem = keyboard_color_fade_green_remove_model.getItem(player);
            Message greenRemTitle = ColorTheme.formatTranslation(multiColor, multiColor, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.green.remove", new Object[0]).translateMessage(playerLang);
            MessageUtils.setCustomItemData(greenRem, colorTheme, greenRemTitle, Arrays.asList(valueHEXMessage, valueRGBMessage, new Message(), valueRemove1, valueRemove10, valueRemove25, valueRemove100));
            FancyClickEvent.setBooleanData(greenRem, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_green"), true);
            FancyClickEvent.setBooleanData(greenRem, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_remove"), true);
            FancyClickEvent.addFunction(greenRem, onColorClick, ClickType.LEFT, ClickType.RIGHT, ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT);
            FancyClickEvent.setIntData(greenRem, new NamespacedKey((Plugin)Main.getInstance(), "colorIndex"), editColorIndex);
            items.add(greenRem);
            ItemStack blueAdd = keyboard_color_fade_blue_add_model.getItem(player);
            Message blueAddTitle = ColorTheme.formatTranslation(multiColor, multiColor, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.blue.add", new Object[0]).translateMessage(playerLang);
            MessageUtils.setCustomItemData(blueAdd, colorTheme, blueAddTitle, Arrays.asList(valueHEXMessage, valueRGBMessage, new Message(), valueAdd1, valueAdd10, valueAdd25, valueAdd100));
            FancyClickEvent.setBooleanData(blueAdd, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_blue"), true);
            FancyClickEvent.addFunction(blueAdd, onColorClick, ClickType.LEFT, ClickType.RIGHT, ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT);
            FancyClickEvent.setIntData(blueAdd, new NamespacedKey((Plugin)Main.getInstance(), "colorIndex"), editColorIndex);
            items.add(blueAdd);
            ItemStack blueRem = keyboard_color_fade_blue_remove_model.getItem(player);
            Message blueRemTitle = ColorTheme.formatTranslation(multiColor, multiColor, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.blue.remove", new Object[0]).translateMessage(playerLang);
            MessageUtils.setCustomItemData(blueRem, colorTheme, blueRemTitle, Arrays.asList(valueHEXMessage, valueRGBMessage, new Message(), valueRemove1, valueRemove10, valueRemove25, valueRemove100));
            FancyClickEvent.setBooleanData(blueRem, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_blue"), true);
            FancyClickEvent.setBooleanData(blueRem, new NamespacedKey((Plugin)Main.getInstance(), "keyboard_color_remove"), true);
            FancyClickEvent.addFunction(blueRem, onColorClick, ClickType.LEFT, ClickType.RIGHT, ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT);
            FancyClickEvent.setIntData(blueRem, new NamespacedKey((Plugin)Main.getInstance(), "colorIndex"), editColorIndex);
            items.add(blueRem);
            ItemStack builtInColorSelector = keyboard_color_fade_chat_color_model.getItem(player);
            Message builtInColorSelectorTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.openBuiltInColorSelector", new Object[0]);
            MessageUtils.setCustomItemData(builtInColorSelector, colorTheme, builtInColorSelectorTitle, null);
            FancyClickEvent.setIntData(builtInColorSelector, new NamespacedKey((Plugin)Main.getInstance(), "colorIndex"), editColorIndex);
            FancyClickEvent.addFunction(builtInColorSelector, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
                fancyInventory.setData("colorFadePage", fancyInventory.getData(FancyInventory.pageDataName));
                fancyInventory.setData("colorFadeColorIndex", pdc.get(new NamespacedKey((Plugin)Main.getInstance(), "colorIndex"), PersistentDataType.INTEGER));
                KeyboardGUI.openBuiltInColorSelector2(whoClicked, 0, fancyInventory);
            });
            items.add(builtInColorSelector);
        }
        FancyInventory inv = FancyInventory.getDynamicScrollableInventory(player, page, KeyboardGUI::openColorFadeKeyboard, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.title", items, null);
        inv.transferData(keyboard, false);
        inv.setData(colorFadeStringDataType, typedText);
        inv.setData(colorFadeColorsDataType, colors);
        if (page == 0) {
            ItemStack addFirstColor = keyboard_color_fade_edit_model.getItem(player);
            FancyClickEvent.addFunction(addFirstColor, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
                int innerPage = fancyInventory.getData(FancyInventory.pageDataName);
                String innerTypedText = fancyInventory.getData(colorFadeStringDataType);
                ArrayList innerColors = fancyInventory.getData(colorFadeColorsDataType);
                innerColors.add(0, new MultiColor("#ffffff"));
                KeyboardGUI.openColorFadeKeyboard(whoClicked, innerColors, innerTypedText, innerPage, fancyInventory);
            });
            Message addFirstColorTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.addFirst.title", ClickType.LEFT);
            MessageUtils.setCustomItemData(addFirstColor, colorTheme, addFirstColorTitle, null);
            inv.setItem(0, addFirstColor);
        }
        for (int i = 0; i < 3 && i < colors.size(); ++i) {
            ItemStack is = keyboard_color_fade_edit_model.getItem(player);
            ItemMeta im = is.getItemMeta();
            FancyClickEvent.setIntData(im, new NamespacedKey((Plugin)Main.getInstance(), "colorIndex"), i + inv.getData(FancyInventory.pageDataName));
            Message addTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.add.title", ClickType.LEFT);
            FancyClickEvent.addFunction(im, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
                int colorIndex = (Integer)pdc.get(new NamespacedKey((Plugin)Main.getInstance(), "colorIndex"), PersistentDataType.INTEGER);
                int innerPage = fancyInventory.getData(FancyInventory.pageDataName);
                String innerTypedText = fancyInventory.getData(colorFadeStringDataType);
                ArrayList innerColors = fancyInventory.getData(colorFadeColorsDataType);
                innerColors.add(colorIndex + 1, new MultiColor("#ffffff"));
                KeyboardGUI.openColorFadeKeyboard(whoClicked, innerColors, innerTypedText, innerPage, fancyInventory);
            });
            Message remTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.remove.title", ClickType.RIGHT);
            FancyClickEvent.addFunction(im, ClickType.RIGHT, (whoClicked, clickType, pdc, fancyInventory) -> {
                int colorIndex = (Integer)pdc.get(new NamespacedKey((Plugin)Main.getInstance(), "colorIndex"), PersistentDataType.INTEGER);
                int innerPage = fancyInventory.getData(FancyInventory.pageDataName);
                String innerTypedText = fancyInventory.getData(colorFadeStringDataType);
                ArrayList innerColors = fancyInventory.getData(colorFadeColorsDataType);
                innerColors.remove(colorIndex);
                KeyboardGUI.openColorFadeKeyboard(whoClicked, innerColors, innerTypedText, innerPage, fancyInventory);
            });
            Message moveUpTitle = null;
            if (i + inv.getData(FancyInventory.pageDataName) != 0) {
                moveUpTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.moveUp.title", ClickType.SHIFT_LEFT);
                FancyClickEvent.addFunction(im, ClickType.SHIFT_LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
                    int colorIndex = (Integer)pdc.get(new NamespacedKey((Plugin)Main.getInstance(), "colorIndex"), PersistentDataType.INTEGER);
                    int innerPage = fancyInventory.getData(FancyInventory.pageDataName);
                    String innerTypedText = fancyInventory.getData(colorFadeStringDataType);
                    ArrayList innerColors = fancyInventory.getData(colorFadeColorsDataType);
                    MultiColor currentColor = (MultiColor)innerColors.get(colorIndex);
                    MultiColor swapColor = (MultiColor)innerColors.get(colorIndex - 1);
                    innerColors.set(colorIndex - 1, currentColor);
                    innerColors.set(colorIndex, swapColor);
                    KeyboardGUI.openColorFadeKeyboard(whoClicked, innerColors, innerTypedText, innerPage, fancyInventory);
                });
            }
            Message moveDownTitle = null;
            if (i + inv.getData(FancyInventory.pageDataName) != colors.size() - 1) {
                moveDownTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.moveDown.title", ClickType.SHIFT_RIGHT);
                FancyClickEvent.addFunction(im, ClickType.SHIFT_RIGHT, (whoClicked, clickType, pdc, fancyInventory) -> {
                    int colorIndex = (Integer)pdc.get(new NamespacedKey((Plugin)Main.getInstance(), "colorIndex"), PersistentDataType.INTEGER);
                    int innerPage = fancyInventory.getData(FancyInventory.pageDataName);
                    String innerTypedText = fancyInventory.getData(colorFadeStringDataType);
                    ArrayList innerColors = fancyInventory.getData(colorFadeColorsDataType);
                    MultiColor currentColor = (MultiColor)innerColors.get(colorIndex);
                    MultiColor swapColor = (MultiColor)innerColors.get(colorIndex + 1);
                    innerColors.set(colorIndex + 1, currentColor);
                    innerColors.set(colorIndex, swapColor);
                    KeyboardGUI.openColorFadeKeyboard(whoClicked, innerColors, innerTypedText, innerPage, fancyInventory);
                });
            }
            is.setItemMeta(im);
            Message editColorTitle = ColorTheme.formatTranslation(colors.get(i + inv.getData(FancyInventory.pageDataName)), colors.get(i + inv.getData(FancyInventory.pageDataName)), "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.color.edit.title", new Object[0]).translateMessage(playerLang);
            MessageUtils.setCustomItemData(is, colorTheme, editColorTitle, Arrays.asList(addTitle, remTitle, moveUpTitle, moveDownTitle));
            inv.setItem(i * 9 + 9, is);
        }
        ItemStack accept = keyboard_color_fade_accept_model.getItem(player);
        FancyClickEvent.addFunction(accept, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
            String rejFuncName;
            FancyClickEvent.FancyClickRunnable rejFunc;
            ArrayList innerColors = fancyInventory.getData(colorFadeColorsDataType);
            String innerTypedText = fancyInventory.getData(colorFadeStringDataType);
            Message newText = MessageUtils.createColorGradient(innerTypedText, innerColors);
            String fadedText = newText.getText().stream().map(textComponent -> textComponent.getColor() + textComponent.getText()).collect(Collectors.joining());
            String accFuncName = fancyInventory.getData(acceptFuncNameDataType);
            FancyClickEvent.FancyClickRunnable accFunc = FancyClickEvent.getFunction(accFuncName);
            if (accFunc == null) {
                accFunc = (whoClicked1, clickType1, pdc1, fancyInventory1) -> {};
            }
            if ((rejFunc = FancyClickEvent.getFunction(rejFuncName = fancyInventory.getData(rejectFuncNameDataType))) == null) {
                rejFunc = (whoClicked1, clickType1, pdc1, fancyInventory1) -> {};
            }
            int keyboardSettings = fancyInventory.getData(keyboardSettingsDataType);
            String defColor = fancyInventory.getData(defColorDataType);
            FancyInventory newKeyboard = KeyboardGUI.openKeyboard(whoClicked, accFunc, rejFunc, fadedText, defColor, keyboardSettings);
            newKeyboard.transferData(fancyInventory);
            newKeyboard.setData(outputStorage, fadedText);
            KeyboardGUI.updateKeyboardTitle(whoClicked, newKeyboard);
        });
        Message acceptTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.accept.title", new Object[0]);
        MessageUtils.setCustomItemData(accept, colorTheme, acceptTitle, null);
        inv.setItem(inv.getSize() - 2, accept);
        ItemStack reject = keyboard_color_fade_reject_model.getItem(player);
        FancyClickEvent.addFunction(reject, ClickType.LEFT, (whoClicked, clickType, pdc, fancyColorInventory) -> {
            String rejFuncName;
            FancyClickEvent.FancyClickRunnable rejFunc;
            String accFuncName = fancyColorInventory.getData(acceptFuncNameDataType);
            FancyClickEvent.FancyClickRunnable accFunc = FancyClickEvent.getFunction(accFuncName);
            if (accFunc == null) {
                accFunc = (whoClicked1, clickType1, pdc1, fancyInventory1) -> {};
            }
            if ((rejFunc = FancyClickEvent.getFunction(rejFuncName = fancyColorInventory.getData(rejectFuncNameDataType))) == null) {
                rejFunc = (whoClicked1, clickType1, pdc1, fancyInventory1) -> {};
            }
            String typedString = KeyboardGUI.getKeyboardOutput(fancyColorInventory);
            int keyboardSettings = fancyColorInventory.getData(keyboardSettingsDataType);
            String defColor = fancyColorInventory.getData(defColorDataType);
            FancyInventory newKeyboard = KeyboardGUI.openKeyboard(whoClicked, accFunc, rejFunc, typedString, defColor, keyboardSettings);
            newKeyboard.transferData(fancyColorInventory);
            KeyboardGUI.updateKeyboardTitle(whoClicked, newKeyboard);
        });
        Message rejectTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.openColorFadeKeyboard.cancel.title", new Object[0]);
        MessageUtils.setCustomItemData(reject, colorTheme, rejectTitle, null);
        inv.setItem(inv.getSize() - 9, reject);
        inv.open(player);
    }

    public static FancyInventory openKeyboard(Player player, @Nonnull FancyClickEvent.FancyClickRunnable onAccept, @Nullable FancyClickEvent.FancyClickRunnable onReject) {
        return KeyboardGUI.openKeyboard(player, onAccept, onReject, 127);
    }

    public static FancyInventory openKeyboard(Player player, @Nonnull FancyClickEvent.FancyClickRunnable onAccept, @Nullable FancyClickEvent.FancyClickRunnable onReject, int keyboardSettings) {
        return KeyboardGUI.openKeyboard(player, onAccept, onReject, "", null, keyboardSettings);
    }

    public static FancyInventory openKeyboard(Player player, @Nonnull FancyClickEvent.FancyClickRunnable onAccept, @Nullable FancyClickEvent.FancyClickRunnable onReject, @Nullable String startInput, @Nullable String defColor) {
        return KeyboardGUI.openKeyboard(player, onAccept, onReject, startInput, defColor, 127);
    }

    public static FancyInventory openKeyboard(Player player, @Nonnull FancyClickEvent.FancyClickRunnable onAccept, @Nullable FancyClickEvent.FancyClickRunnable onReject, @Nullable String startInput, @Nullable String defColor, int keyboardSettings) {
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        startInput = Main.getOrDefault(startInput, "");
        startInput = startInput.replace("\\n", "\n");
        Message invTitle = ColorTheme.formatInfoTranslation("tport.fancyMessage.inventories.KeyboardGUI.title", cursor);
        FancyInventory inv = new FancyInventory(54, invTitle);
        inv.setData(outputStorage, startInput);
        inv.setData(layoutDataType, "qwerty");
        inv.setData(keyboardSettingsDataType, keyboardSettings);
        inv.setData(formatTitleDataType, true);
        inv.setData(cursorIndexDataType, startInput.length());
        inv.setData(defColorDataType, defColor);
        KeyboardGUI.populateQWERTY(inv, colorTheme, playerLang, player.getUniqueId(), keyboardSettings);
        KeyboardGUI.setFormatButton(inv, player, colorTheme, playerLang);
        ItemStack changeLayout = keyboard_change_layout_model.getItem(player);
        Message changeLayoutTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.changeLayout.title", ClickType.LEFT);
        MessageUtils.setCustomItemData(changeLayout, colorTheme, changeLayoutTitle, null);
        FancyClickEvent.addFunction(changeLayout, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
            int innerKeyboardSettings = fancyInventory.getData(keyboardSettingsDataType);
            if (fancyInventory.getData(layoutDataType).equals("qwerty")) {
                KeyboardGUI.populateAlphabet(fancyInventory, ColorTheme.getTheme(whoClicked), Language.getPlayerLang(whoClicked.getUniqueId()), whoClicked.getUniqueId(), innerKeyboardSettings);
                fancyInventory.setData(layoutDataType, "alphabet");
            } else {
                KeyboardGUI.populateQWERTY(fancyInventory, ColorTheme.getTheme(whoClicked), Language.getPlayerLang(whoClicked.getUniqueId()), whoClicked.getUniqueId(), innerKeyboardSettings);
                fancyInventory.setData(layoutDataType, "qwerty");
            }
            fancyInventory.open(whoClicked);
        });
        inv.setItem(47, changeLayout);
        KeyboardGUI.updateColorButton(inv, player, colorTheme, playerLang);
        inv.setItem(49, KeyboardGUI.getKey(' ', '\n', colorTheme, playerLang, player.getUniqueId(), keyboardSettings));
        inv.setItem(50, KeyboardGUI.getKey('\b', '\u007f', colorTheme, playerLang, player.getUniqueId(), keyboardSettings));
        ItemStack quickType = keyboard_quick_type_model.getItem(player);
        Message quickTypeTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.quickType.title", ClickType.LEFT);
        Message quickTypeRight = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.quickType.right", ClickType.RIGHT);
        Message quickTypeShiftRight = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.quickType.shiftRight", ClickType.SHIFT_RIGHT);
        MessageUtils.setCustomItemData(quickType, colorTheme, quickTypeTitle, List.of(quickTypeRight, quickTypeShiftRight));
        FancyClickEvent.addFunction(quickType, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
            QuickType.Callback c = lines -> {
                Object typedString = KeyboardGUI.getKeyboardOutput(fancyInventory);
                String signOutput = String.join((CharSequence)"\n", lines).stripTrailing().replace("\\", "");
                int cursorIndex = fancyInventory.getData(cursorIndexDataType);
                cursorIndex = Math.min(((String)typedString).length(), cursorIndex);
                typedString = cursorIndex == 0 ? signOutput + (String)typedString : (cursorIndex >= ((String)typedString).length() ? (String)typedString + signOutput : ((String)typedString).substring(0, cursorIndex) + signOutput + ((String)typedString).substring(cursorIndex));
                fancyInventory.setData(cursorIndexDataType, cursorIndex + signOutput.length());
                fancyInventory.setData(outputStorage, typedString);
                KeyboardGUI.updateKeyboardTitle(whoClicked, fancyInventory);
            };
            QuickType.open(whoClicked, c);
        });
        FancyClickEvent.addFunction(quickType, ClickType.RIGHT, (whoClicked, clickType, pdc, fancyInventory) -> {
            QuickType.Callback c = lines -> {
                Object typedString = KeyboardGUI.getKeyboardOutput(fancyInventory);
                String signOutput = String.join((CharSequence)" ", lines).stripTrailing().replace("\\", "");
                int cursorIndex = fancyInventory.getData(cursorIndexDataType);
                cursorIndex = Math.min(((String)typedString).length(), cursorIndex);
                typedString = cursorIndex == 0 ? signOutput + (String)typedString : (cursorIndex >= ((String)typedString).length() ? (String)typedString + signOutput : ((String)typedString).substring(0, cursorIndex) + signOutput + ((String)typedString).substring(cursorIndex));
                fancyInventory.setData(cursorIndexDataType, cursorIndex + signOutput.length());
                fancyInventory.setData(outputStorage, typedString);
                KeyboardGUI.updateKeyboardTitle(whoClicked, fancyInventory);
            };
            QuickType.open(whoClicked, c);
        });
        FancyClickEvent.addFunction(quickType, ClickType.SHIFT_RIGHT, (whoClicked, clickType, pdc, fancyInventory) -> {
            QuickType.Callback c = lines -> {
                Object typedString = KeyboardGUI.getKeyboardOutput(fancyInventory);
                String signOutput = String.join((CharSequence)"", lines).stripTrailing().replace("\\", "");
                int cursorIndex = fancyInventory.getData(cursorIndexDataType);
                cursorIndex = Math.min(((String)typedString).length(), cursorIndex);
                typedString = cursorIndex == 0 ? signOutput + (String)typedString : (cursorIndex >= ((String)typedString).length() ? (String)typedString + signOutput : ((String)typedString).substring(0, cursorIndex) + signOutput + ((String)typedString).substring(cursorIndex));
                fancyInventory.setData(cursorIndexDataType, cursorIndex + signOutput.length());
                fancyInventory.setData(outputStorage, typedString);
                KeyboardGUI.updateKeyboardTitle(whoClicked, fancyInventory);
            };
            QuickType.open(whoClicked, c);
        });
        inv.setItem(51, quickType);
        ItemStack cursor = keyboard_cursor_model.getItem(player);
        FancyClickEvent.addFunction(cursor, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
            int cursorIndex = fancyInventory.getData(cursorIndexDataType);
            String typedString = KeyboardGUI.getKeyboardOutput(fancyInventory);
            boolean showColors = fancyInventory.getData(formatTitleDataType);
            if (showColors) {
                ArrayList<String> elements = MessageUtils.transformColoredTextToArray(typedString);
                int searchCursorIndex = 0;
                for (int i = 0; i < elements.size(); ++i) {
                    String element = elements.get(i);
                    if ((searchCursorIndex += element.length()) < cursorIndex) continue;
                    int subCursorIndex = element.length() - (searchCursorIndex - cursorIndex);
                    if (MultiColor.isColor(element)) {
                        cursorIndex -= subCursorIndex - 1;
                        break;
                    }
                    if (subCursorIndex != 0 || i - 1 < 0) break;
                    cursorIndex -= elements.get(i - 1).length() - 1;
                    break;
                }
            }
            fancyInventory.setData(cursorIndexDataType, Math.max(0, cursorIndex - 1));
            KeyboardGUI.updateKeyboardTitle(whoClicked, fancyInventory);
        });
        FancyClickEvent.addFunction(cursor, ClickType.RIGHT, (whoClicked, clickType, pdc, fancyInventory) -> {
            int cursorIndex = fancyInventory.getData(cursorIndexDataType);
            String typedString = KeyboardGUI.getKeyboardOutput(fancyInventory);
            boolean showColors = fancyInventory.getData(formatTitleDataType);
            if (showColors) {
                ArrayList<String> elements = MessageUtils.transformColoredTextToArray(typedString);
                int searchCursorIndex = 0;
                for (int i = 0; i < elements.size(); ++i) {
                    String element = elements.get(i);
                    if ((searchCursorIndex += element.length()) < cursorIndex) continue;
                    int subCursorIndex = element.length() - (searchCursorIndex - cursorIndex);
                    if (subCursorIndex == element.length()) {
                        if (i + 1 >= elements.size() || !MultiColor.isColor(elements.get(i + 1))) break;
                        cursorIndex += elements.get(i + 1).length() - 1;
                        break;
                    }
                    if (!MultiColor.isColor(element)) break;
                    cursorIndex += element.length() - subCursorIndex - 1;
                    break;
                }
            }
            fancyInventory.setData(cursorIndexDataType, Math.min(typedString.length(), cursorIndex + 1));
            KeyboardGUI.updateKeyboardTitle(whoClicked, fancyInventory);
        });
        FancyClickEvent.addFunction(cursor, ClickType.SHIFT_LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
            fancyInventory.setData(cursorIndexDataType, 0);
            KeyboardGUI.updateKeyboardTitle(whoClicked, fancyInventory);
        });
        FancyClickEvent.addFunction(cursor, ClickType.SHIFT_RIGHT, (whoClicked, clickType, pdc, fancyInventory) -> {
            String typedString = KeyboardGUI.getKeyboardOutput(fancyInventory);
            fancyInventory.setData(cursorIndexDataType, typedString.length());
            KeyboardGUI.updateKeyboardTitle(whoClicked, fancyInventory);
        });
        Message cursorTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.cursor.title", new Object[0]);
        Message cursorLeft = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.cursor.moveLeft", ClickType.LEFT);
        Message cursorRight = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.cursor.moveRight", ClickType.RIGHT);
        Message cursorStart = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.cursor.moveStart", ClickType.SHIFT_LEFT);
        Message cursorEnd = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.cursor.moveEnd", ClickType.SHIFT_RIGHT);
        MessageUtils.setCustomItemData(cursor, colorTheme, cursorTitle, List.of(new Message(), cursorLeft, cursorRight, cursorStart, cursorEnd));
        inv.setItem(52, cursor);
        ItemStack acceptButton = keyboard_accept_model.getItem(player);
        Message acceptTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.accept.title", new Object[0]);
        MessageUtils.setCustomItemData(acceptButton, colorTheme, acceptTitle, null);
        FancyClickEvent.addFunction(acceptButton, ClickType.LEFT, onAccept);
        inv.setData(acceptFuncNameDataType, FancyClickEvent.getFunctionName(acceptButton, ClickType.LEFT));
        inv.setItem(inv.getSize() - 1, acceptButton);
        ItemStack rejectButton = keyboard_reject_model.getItem(player);
        Message rejectTitle = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.KeyboardGUI.reject.title", new Object[0]);
        MessageUtils.setCustomItemData(rejectButton, colorTheme, rejectTitle, null);
        if (onReject == null) {
            onReject = (whoClicked, clickType, pdc, fancyInventory) -> whoClicked.closeInventory();
        }
        FancyClickEvent.addFunction(rejectButton, ClickType.LEFT, onReject);
        inv.setData(rejectFuncNameDataType, FancyClickEvent.getFunctionName(rejectButton, ClickType.LEFT));
        inv.setItem(inv.getSize() - 9, rejectButton);
        if (startInput.isEmpty()) {
            inv.open(player);
        } else {
            KeyboardGUI.updateKeyboardTitle(player, inv);
        }
        return inv;
    }
}

