/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.inventories;

import com.spaceman.tport.Main;
import com.spaceman.tport.fancyMessage.inventories.FancyInventory;
import java.util.Arrays;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class FancyClickEvent
implements Listener {
    private static final HashMap<String, FancyClickRunnable> functionsMap = new HashMap();

    public static void setStringData(ItemStack item, NamespacedKey key, String value) {
        ItemMeta im = item.getItemMeta();
        if (im != null) {
            FancyClickEvent.setStringData(im, key, value);
        }
        item.setItemMeta(im);
    }

    public static void setStringData(ItemMeta im, NamespacedKey key, String value) {
        im.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)value);
    }

    public static void setBooleanData(ItemStack item, NamespacedKey key, boolean value) {
        ItemMeta im = item.getItemMeta();
        if (im != null) {
            FancyClickEvent.setBooleanData(im, key, value);
        }
        item.setItemMeta(im);
    }

    public static void setBooleanData(ItemMeta im, NamespacedKey key, boolean value) {
        im.getPersistentDataContainer().set(key, PersistentDataType.BOOLEAN, (Object)value);
    }

    public static void setIntData(ItemStack item, NamespacedKey key, int value) {
        ItemMeta im = item.getItemMeta();
        if (im != null) {
            FancyClickEvent.setIntData(im, key, value);
        }
        item.setItemMeta(im);
    }

    public static void setIntData(ItemMeta im, NamespacedKey key, int value) {
        im.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)value);
    }

    public static ItemStack addCommand(ItemStack is, ClickType clickType, String command) {
        ItemMeta im = is.getItemMeta();
        if (im != null) {
            is.setItemMeta(FancyClickEvent.addCommand(im, clickType, command, null));
        }
        return is;
    }

    public static ItemMeta addCommand(@Nonnull ItemMeta im, ClickType clickType, String command) {
        return FancyClickEvent.addCommand(im, clickType, command, null);
    }

    public static ItemStack addCommand(ItemStack is, ClickType clickType, String command, @Nullable String secondary) {
        ItemMeta im = is.getItemMeta();
        if (im != null) {
            is.setItemMeta(FancyClickEvent.addCommand(im, clickType, command, secondary));
        }
        return is;
    }

    public static ItemMeta addCommand(@Nonnull ItemMeta im, ClickType clickType, String command, @Nullable String secondary) {
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        im.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), "runCommand_" + clickType.name()), PersistentDataType.STRING, (Object)command);
        if (secondary != null && !secondary.isBlank()) {
            if (secondary.startsWith("/")) {
                secondary = secondary.substring(1);
            }
            im.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), "runCommand_" + clickType.name() + "_secondary"), PersistentDataType.STRING, (Object)secondary);
        }
        return im;
    }

    public static ItemStack addFunction(ItemStack is, FancyClickRunnable runnable, ClickType ... clickTypes) {
        for (ClickType clickType : clickTypes) {
            FancyClickEvent.addFunction(is, clickType, runnable);
        }
        return is;
    }

    public static ItemMeta addFunction(ItemMeta im, FancyClickRunnable runnable, ClickType ... clickTypes) {
        for (ClickType clickType : clickTypes) {
            FancyClickEvent.addFunction(im, clickType, runnable);
        }
        return im;
    }

    public static ItemStack addFunction(ItemStack is, ClickType clickType, FancyClickRunnable runnable) {
        ItemMeta im = is.getItemMeta();
        if (im != null) {
            is.setItemMeta(FancyClickEvent.addFunction(im, clickType, runnable));
        }
        return is;
    }

    public static ItemMeta addFunction(ItemMeta im, ClickType clickType, FancyClickRunnable runnable) {
        if (im == null) {
            return null;
        }
        String funcName = runnable.toString();
        im.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), "runFunc_" + clickType.name()), PersistentDataType.STRING, (Object)funcName);
        functionsMap.putIfAbsent(funcName, runnable);
        return im;
    }

    public static ItemMeta removeFunction(ItemMeta im, ClickType clickType) {
        if (im == null) {
            return null;
        }
        im.getPersistentDataContainer().remove(new NamespacedKey((Plugin)Main.getInstance(), "runFunc_" + clickType.name()));
        return im;
    }

    public static ItemMeta removeCommand(ItemMeta im, ClickType clickType) {
        if (im == null) {
            return null;
        }
        im.getPersistentDataContainer().remove(new NamespacedKey((Plugin)Main.getInstance(), "runCommand_" + clickType.name()));
        return im;
    }

    public static String getFunctionName(ItemStack is, ClickType clickType) {
        ItemMeta im = is.getItemMeta();
        if (im != null) {
            return FancyClickEvent.getFunctionName(im, clickType);
        }
        return null;
    }

    public static String getFunctionName(ItemMeta im, ClickType clickType) {
        return (String)im.getPersistentDataContainer().get(new NamespacedKey((Plugin)Main.getInstance(), "runFunc_" + clickType.name()), PersistentDataType.STRING);
    }

    @Nullable
    public static FancyClickRunnable getFunction(String funcName) {
        return functionsMap.get(funcName);
    }

    public static ItemMeta removeAllFunctions(ItemMeta im) {
        if (im == null) {
            return null;
        }
        Arrays.stream(ClickType.values()).forEach(clickType -> FancyClickEvent.removeFunction(im, clickType));
        return im;
    }

    public static ItemMeta removeAllCommands(ItemMeta im) {
        if (im == null) {
            return null;
        }
        Arrays.stream(ClickType.values()).forEach(clickType -> FancyClickEvent.removeCommand(im, clickType));
        return im;
    }

    @EventHandler
    public void onFancyClose(InventoryCloseEvent e) {
        FancyInventory.ensureOriginalContent((Player)e.getPlayer(), e.getInventory());
    }

    @EventHandler
    public void onFancyClick(InventoryClickEvent e) {
        NamespacedKey runFuncKey;
        InventoryHolder inventoryHolder = e.getInventory().getHolder();
        if (!(inventoryHolder instanceof FancyInventory)) {
            return;
        }
        FancyInventory fancyInventory = (FancyInventory)inventoryHolder;
        Player player = (Player)e.getWhoClicked();
        ClickType clickType = e.getClick();
        if (e.getRawSlot() > e.getInventory().getSize()) {
            return;
        }
        ItemStack item = e.getCurrentItem();
        if (item == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        e.setCancelled(true);
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        NamespacedKey runCommandKey = new NamespacedKey((Plugin)Main.getInstance(), "runCommand_" + clickType.name());
        if (pdc.has(runCommandKey, PersistentDataType.STRING)) {
            Bukkit.dispatchCommand((CommandSender)player, (String)((String)pdc.getOrDefault(runCommandKey, PersistentDataType.STRING, (Object)"")));
            runCommandKey = new NamespacedKey((Plugin)Main.getInstance(), "runCommand_" + clickType.name() + "_secondary");
            if (pdc.has(runCommandKey, PersistentDataType.STRING)) {
                Bukkit.dispatchCommand((CommandSender)player, (String)((String)pdc.getOrDefault(runCommandKey, PersistentDataType.STRING, (Object)"")));
            }
        }
        if (pdc.has(runFuncKey = new NamespacedKey((Plugin)Main.getInstance(), "runFunc_" + clickType.name()), PersistentDataType.STRING)) {
            functionsMap.getOrDefault(pdc.getOrDefault(runFuncKey, PersistentDataType.STRING, (Object)"null"), (whoClicked, clickType1, pdc1, fancyInventory1) -> {}).run(player, clickType, pdc, fancyInventory);
        }
    }

    @FunctionalInterface
    public static interface FancyClickRunnable {
        public void run(Player var1, ClickType var2, PersistentDataContainer var3, FancyInventory var4);
    }
}

