/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.events;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.spaceman.tport.Main;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.MessageUtils;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.colorTheme.MultiColor;
import com.spaceman.tport.fancyMessage.events.TextEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.inventory.ItemStack;

@TextEvent.InteractiveTextEvent
public class HoverEvent
implements TextEvent {
    private final ArrayList<TextComponent> text = new ArrayList();
    private ItemStack item = null;
    public static final String SHOW_TEXT = "show_text";
    public static final String SHOW_ITEM = "show_item";
    private String type = "show_text";

    public HoverEvent() {
    }

    public HoverEvent(String type) {
        this.type = type;
    }

    public HoverEvent(TextComponent ... textComponents) {
        this.addText(textComponents);
    }

    public HoverEvent(Message message) {
        this.addMessage(message);
    }

    public String toString() {
        return this.text.stream().map(TextComponent::toString).collect(Collectors.joining());
    }

    public static HoverEvent hoverEvent(String simpleText) {
        return HoverEvent.hoverEvent(TextComponent.textComponent(simpleText));
    }

    public static HoverEvent hoverEvent(String simpleText, ChatColor color) {
        return HoverEvent.hoverEvent(TextComponent.textComponent(simpleText, color));
    }

    public static HoverEvent hoverEvent(String simpleText, String color) {
        return HoverEvent.hoverEvent(TextComponent.textComponent(simpleText, color));
    }

    public static HoverEvent hoverEvent(String simpleText, Color color) {
        return HoverEvent.hoverEvent(TextComponent.textComponent(simpleText, color));
    }

    public static HoverEvent hoverEvent(String simpleText, MultiColor color) {
        return HoverEvent.hoverEvent(TextComponent.textComponent(simpleText, color));
    }

    public static HoverEvent hoverEvent(String simpleText, ColorTheme.ColorType type) {
        return HoverEvent.hoverEvent(TextComponent.textComponent(simpleText, type));
    }

    public static HoverEvent hoverEvent(TextComponent ... textComponent) {
        HoverEvent hEvent = new HoverEvent();
        for (TextComponent text : textComponent) {
            hEvent.addText(text);
        }
        return hEvent;
    }

    public static HoverEvent hoverEvent(ItemStack is) {
        HoverEvent hoverEvent = new HoverEvent(SHOW_ITEM);
        hoverEvent.item = is;
        return hoverEvent;
    }

    @Override
    public JsonObject translateJSON(ColorTheme theme) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("action", this.type);
        if (this.type.equals(SHOW_TEXT)) {
            JsonArray jsonArray = new JsonArray();
            this.text.stream().map(t -> t.translateJSON(theme)).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
            if (Main.getInstance().adapter.JSONVersion() == 0 || Main.getInstance().adapter.JSONVersion() == -1) {
                jsonObject.add("contents", (JsonElement)jsonArray);
            }
            if (Main.getInstance().adapter.JSONVersion() == 1 || Main.getInstance().adapter.JSONVersion() == -1) {
                jsonObject.add("value", (JsonElement)jsonArray);
            }
        }
        if (this.type.equals(SHOW_ITEM)) {
            JsonObject jsonItem = MessageUtils.toString(this.item);
            if (Main.getInstance().adapter.JSONVersion() == 0 || Main.getInstance().adapter.JSONVersion() == -1) {
                jsonObject.addProperty("value", jsonItem.toString());
            }
            if (Main.getInstance().adapter.JSONVersion() == 1 || Main.getInstance().adapter.JSONVersion() == -1) {
                for (Map.Entry entry : jsonItem.asMap().entrySet()) {
                    jsonObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }
        return jsonObject;
    }

    @Override
    public String[] name() {
        String[] stringArray;
        switch (Main.getInstance().adapter.JSONVersion()) {
            case -1: {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "hoverEvent";
                stringArray = stringArray2;
                stringArray2[1] = "hover_event";
                break;
            }
            case 0: {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "hoverEvent";
                break;
            }
            case 1: {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = "hover_event";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + Main.getInstance().adapter.JSONVersion());
            }
        }
        return stringArray;
    }

    public void addMessage(Message message) {
        if (message != null) {
            for (TextComponent textComponent : message.getText()) {
                this.addText(textComponent);
            }
        }
    }

    public void addText(TextComponent ... text) {
        this.type = SHOW_TEXT;
        for (TextComponent textComponent : text) {
            textComponent.clearInteractiveEvents();
            this.text.add(textComponent);
        }
    }

    public void addText(String simpleText) {
        this.addText(TextComponent.textComponent(simpleText));
    }

    public void addText(String simpleText, ChatColor color) {
        this.addText(TextComponent.textComponent(simpleText, color));
    }

    public ArrayList<TextComponent> getText() {
        return this.text;
    }

    public void removeLast() {
        if (!this.text.isEmpty()) {
            this.text.remove(this.text.size() - 1);
        }
    }

    public void setItem(ItemStack is) {
        this.type = SHOW_ITEM;
        this.item = is;
    }
}

