/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.events;

import com.google.gson.JsonObject;
import com.spaceman.tport.Main;
import com.spaceman.tport.fancyMessage.book.BookPage;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.TextEvent;

@TextEvent.InteractiveTextEvent
public class ClickEvent
implements TextEvent {
    public static final String RUN_COMMAND = "run_command";
    public static final String CHANGE_PAGE = "change_page";
    public static final String OPEN_URL = "open_url";
    public static final String SUGGEST_COMMAND = "suggest_command";
    public static final String COPY_TO_CLIPBOARD = "copy_to_clipboard";
    private String action;
    private String value;
    private BookPage pageNumber = null;

    public ClickEvent(String action, String value) {
        this.action = action;
        this.value = value;
    }

    public ClickEvent(String event, BookPage page) {
        this.action = event;
        this.value = "{APN}";
        this.pageNumber = page;
    }

    public String toString() {
        return "ClickEvent{action='" + this.action + "', value='" + this.value + "', pageNumber=" + String.valueOf(this.pageNumber) + "}";
    }

    public static ClickEvent clickEvent(String event, String value) {
        return new ClickEvent(event, value);
    }

    public static ClickEvent clickEvent(String event, int value) {
        return new ClickEvent(event, String.valueOf(value));
    }

    public static ClickEvent clickEvent(String event, BookPage page) {
        return new ClickEvent(event, page);
    }

    public static ClickEvent runCommand(String value) {
        return new ClickEvent(RUN_COMMAND, value);
    }

    public static ClickEvent changePage(String value) {
        return new ClickEvent(CHANGE_PAGE, value);
    }

    public static ClickEvent changePage(int value) {
        return new ClickEvent(CHANGE_PAGE, String.valueOf(value));
    }

    public static ClickEvent openUrl(String value) {
        return new ClickEvent(OPEN_URL, value);
    }

    public static ClickEvent suggestCommand(String value) {
        return new ClickEvent(SUGGEST_COMMAND, value);
    }

    public static ClickEvent copyToClipboard(String value) {
        return new ClickEvent(COPY_TO_CLIPBOARD, value);
    }

    public static ClickEvent copyToClipBoard(String value) {
        return new ClickEvent(COPY_TO_CLIPBOARD, value);
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getValue() {
        if (this.pageNumber != null) {
            return this.value.replace(BookPage.getActivePageReplacer(), String.valueOf(this.pageNumber.getPageNumber()));
        }
        return this.value;
    }

    public void setPageNumber(BookPage pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public JsonObject translateJSON(ColorTheme theme) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("action", this.action);
        if (Main.getInstance().adapter.JSONVersion() == 0 || Main.getInstance().adapter.JSONVersion() == -1) {
            jsonObject.addProperty("value", this.value.replace(BookPage.getActivePageReplacer(), this.pageNumber == null ? "" : String.valueOf(this.pageNumber.getPageNumber())));
        }
        if (Main.getInstance().adapter.JSONVersion() == 1 || Main.getInstance().adapter.JSONVersion() == -1) {
            switch (this.action) {
                case "open_url": {
                    jsonObject.addProperty("url", this.value.replace(BookPage.getActivePageReplacer(), this.pageNumber == null ? "" : String.valueOf(this.pageNumber.getPageNumber())));
                    break;
                }
                case "run_command": 
                case "suggest_command": {
                    jsonObject.addProperty("command", this.value.replace(BookPage.getActivePageReplacer(), this.pageNumber == null ? "" : String.valueOf(this.pageNumber.getPageNumber())));
                    break;
                }
                case "change_page": {
                    if (this.value.equals(BookPage.getActivePageReplacer())) {
                        jsonObject.addProperty("page", (Number)this.pageNumber.getPageNumber());
                        break;
                    }
                    try {
                        jsonObject.addProperty("page", (Number)Integer.parseInt(this.value));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        return jsonObject;
    }

    @Override
    public String[] name() {
        String[] stringArray;
        switch (Main.getInstance().adapter.JSONVersion()) {
            case -1: {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "clickEvent";
                stringArray = stringArray2;
                stringArray2[1] = "click_event";
                break;
            }
            case 0: {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "clickEvent";
                break;
            }
            case 1: {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = "click_event";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + Main.getInstance().adapter.JSONVersion());
            }
        }
        return stringArray;
    }
}

