/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.encapsulation;

import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.Encapsulation;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.World;

public class WorldEncapsulation
implements Encapsulation {
    protected final World world;

    public WorldEncapsulation(World world) {
        this.world = world;
    }

    @Override
    public String asString() {
        return this.world.getName();
    }

    @Override
    @Nonnull
    public Message toMessage(String color, String varColor) {
        return new Message(new TextComponent(this.asString(), varColor));
    }

    protected String command(boolean withSlash) {
        return (withSlash ? "/" : "") + "tport world " + this.world.getName();
    }

    @Override
    public HoverEvent getHoverEvent() {
        return HoverEvent.hoverEvent(this.command(true), ColorTheme.ColorType.infoColor);
    }

    @Override
    public ClickEvent getClickEvent() {
        return ClickEvent.runCommand(this.command(true));
    }

    @Override
    @Nullable
    public String getInsertion() {
        return this.asString();
    }
}

