/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.encapsulation;

import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.Encapsulation;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TPortEncapsulation
implements Encapsulation {
    protected TPort tport = null;
    private String tportName = null;

    public static TPortEncapsulation asTPort(UUID tportUUID) {
        return new TPortEncapsulation(tportUUID, null);
    }

    public static TPortEncapsulation asTPort(UUID tportUUID, UUID ownerUUID) {
        return new TPortEncapsulation(tportUUID, ownerUUID);
    }

    public static TPortEncapsulation asTPort(TPort tport) {
        return new TPortEncapsulation(tport);
    }

    public static TPortEncapsulation asTPort(TPort tport, String tportName) {
        return new TPortEncapsulation(tport, tportName);
    }

    public static TPortEncapsulation asTPort(TPort tport, UUID tportUUID, UUID ownerUUID) {
        return new TPortEncapsulation(tport, tportUUID, ownerUUID);
    }

    public static TPortEncapsulation asTPort(TPort tport, UUID tportUUID, UUID ownerUUID, String tportName) {
        return new TPortEncapsulation(tport, tportUUID, ownerUUID, tportName);
    }

    public TPortEncapsulation(UUID tportUUID, @Nullable UUID ownerUUID) {
        this.tport = ownerUUID != null ? TPortManager.getTPort(ownerUUID, tportUUID) : TPortManager.getTPort(tportUUID);
    }

    public TPortEncapsulation(TPort tport) {
        this.tport = tport;
    }

    public TPortEncapsulation(TPort tport, String tportName) {
        if (tport == null) {
            this.tportName = tportName;
        } else {
            this.tport = tport;
        }
    }

    public TPortEncapsulation(TPort tport, UUID tportUUID, UUID ownerUUID) {
        this.tport = tport != null ? tport : TPortManager.getTPort(tportUUID, ownerUUID);
    }

    public TPortEncapsulation(TPort tport, UUID tportUUID, UUID ownerUUID, String tportName) {
        if (tport != null) {
            this.tport = tport;
        } else {
            this.tport = TPortManager.getTPort(tportUUID, ownerUUID);
            if (this.tport == null) {
                this.tportName = tportName;
            }
        }
    }

    @Override
    public String asString() {
        if (this.tport == null) {
            return this.tportName;
        }
        return this.tport.getName();
    }

    @Override
    @Nonnull
    public Message toMessage(String color, String varColor) {
        return new Message(new TextComponent(this.asString(), varColor));
    }

    private String getCommand() {
        String command = this.tport.parseAsPublic() ? "/tport public open " + this.tport.getName() : "/tport open " + PlayerUUID.getPlayerName(this.tport.getOwner()) + " " + this.tport.getName();
        return command;
    }

    @Override
    public HoverEvent getHoverEvent() {
        if (this.tport == null) {
            return null;
        }
        HoverEvent hEvent = new HoverEvent();
        hEvent.addText(TextComponent.textComponent(this.getCommand(), ColorTheme.ColorType.infoColor));
        hEvent.addText("\n");
        for (Message message : this.tport.getHoverData(true)) {
            hEvent.addText("\n");
            hEvent.addMessage(message);
        }
        return hEvent;
    }

    @Override
    public ClickEvent getClickEvent() {
        if (this.tport == null) {
            return null;
        }
        return ClickEvent.runCommand(this.getCommand());
    }

    @Override
    public String getInsertion() {
        if (this.tport == null) {
            return this.tportName;
        }
        return this.tport.getName();
    }
}

