/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.encapsulation;

import com.spaceman.tport.Main;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.Encapsulation;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlayerEncapsulation
implements Encapsulation {
    private final UUID uuid;
    protected final String name;

    public static PlayerEncapsulation asPlayer(@Nonnull UUID uuid) {
        return new PlayerEncapsulation(uuid);
    }

    public static PlayerEncapsulation asPlayer(@Nonnull OfflinePlayer op) {
        return new PlayerEncapsulation(op.getUniqueId(), op.getName());
    }

    public static PlayerEncapsulation asPlayer(@Nonnull Player player) {
        return new PlayerEncapsulation(player);
    }

    public static PlayerEncapsulation asPlayer(UUID uuid, String name) {
        return new PlayerEncapsulation(uuid, name);
    }

    public static PlayerEncapsulation asPlayer(@Nullable Player player, UUID uuid) {
        if (player != null) {
            return new PlayerEncapsulation(player.getUniqueId(), player.getName());
        }
        return new PlayerEncapsulation(uuid);
    }

    public PlayerEncapsulation(@Nonnull UUID uuid) {
        this.name = Main.getOrDefault(PlayerUUID.getPlayerName(uuid), uuid.toString());
        this.uuid = uuid;
    }

    public PlayerEncapsulation(@Nonnull Player player) {
        this.uuid = player.getUniqueId();
        this.name = player.getName();
    }

    public PlayerEncapsulation(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public PlayerEncapsulation(@Nullable Player player, UUID uuid, String name) {
        if (player == null) {
            this.uuid = uuid;
            this.name = name;
        } else {
            this.uuid = player.getUniqueId();
            this.name = player.getName();
        }
    }

    @Override
    public String asString() {
        return this.name;
    }

    @Override
    @Nonnull
    public Message toMessage(String color, String varColor) {
        return new Message(new TextComponent(this.asString(), varColor));
    }

    @Override
    public String getInsertion() {
        return this.name;
    }

    @Override
    public ClickEvent getClickEvent() {
        return ClickEvent.runCommand("/tport pltp tp " + this.name);
    }

    public static List<Message> getPlayerData(UUID uuid) {
        ArrayList<Message> hoverData = new ArrayList<Message>();
        hoverData.add(ColorTheme.formatInfoTranslation("tport.command.getPlayerData.tportAmount", TPortManager.getTPortList(uuid).size()));
        return hoverData;
    }

    @Override
    public HoverEvent getHoverEvent() {
        HoverEvent hEvent = new HoverEvent();
        hEvent.addText(TextComponent.textComponent("/tport pltp tp " + this.name, ColorTheme.ColorType.infoColor));
        hEvent.addText("\n");
        for (Message message : PlayerEncapsulation.getPlayerData(this.uuid)) {
            hEvent.addText("\n");
            hEvent.addMessage(message);
        }
        return hEvent;
    }

    public String getName() {
        return this.name;
    }
}

