/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.colorTheme;

import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import java.awt.Color;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.configuration.serialization.ConfigurationSerializable;

public class MultiColor
implements ConfigurationSerializable,
Serializable {
    private String hexColor;

    protected static MultiColor fromString(String color) {
        MultiColor multiColor = new MultiColor("");
        try {
            multiColor.setColor(ChatColor.valueOf((String)color.toUpperCase()));
            return multiColor;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            multiColor.hexColor = color;
            return multiColor;
        }
    }

    public static boolean isColor(String color) {
        return MultiColor.isHexColor(color) || MultiColor.isColorCode(color) || MultiColor.isRGBColor(color);
    }

    public static boolean isHexColor(String color) {
        return color.matches("#[0-9a-fA-F]{6}");
    }

    public static boolean isColorCode(String color) {
        return color.matches("&[0-9a-fA-F]");
    }

    public static boolean isRGBColor(String color) {
        if (color.length() < 6) {
            return false;
        }
        char[] charArray = color.toCharArray();
        if (charArray[0] == '$') {
            int j;
            int redIndex = 0;
            int greenIndex = -1;
            int blueIndex = -1;
            int endIndex = -1;
            for (j = 1; j < 5 && redIndex + j < charArray.length; ++j) {
                char greenDollar = charArray[redIndex + j];
                if (greenDollar != '$') continue;
                greenIndex = redIndex + j;
                break;
            }
            if (greenIndex == -1) {
                return false;
            }
            for (j = 1; j < 5 && greenIndex + j < charArray.length; ++j) {
                char blueDollar = charArray[greenIndex + j];
                if (blueDollar != '$') continue;
                blueIndex = greenIndex + j;
                break;
            }
            if (blueIndex == -1) {
                return false;
            }
            for (j = 1; j < 5; ++j) {
                if (blueIndex + j >= charArray.length) {
                    endIndex = blueIndex + j;
                    break;
                }
                char end = charArray[blueIndex + j];
                if (String.valueOf(end).matches("\\d")) continue;
                endIndex = blueIndex + j;
                break;
            }
            if (endIndex == -1) {
                return false;
            }
            String redString = color.substring(redIndex, greenIndex);
            String greenString = color.substring(greenIndex, blueIndex);
            String blueString = color.substring(blueIndex, endIndex);
            for (String colorString : List.of(redString, greenString, blueString)) {
                try {
                    int numericColor = Integer.parseInt(colorString.substring(1));
                    if (numericColor <= 255) continue;
                    return false;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public MultiColor(String color) {
        this.setColor(color);
    }

    public MultiColor(ChatColor color) {
        this.setColor(color);
    }

    public MultiColor(DyeColor color) {
        this.setColor(color);
    }

    public MultiColor(org.bukkit.Color color) {
        this.setColor(color);
    }

    public MultiColor(Color color) {
        this.setColor(color);
    }

    public void setColor(String color) {
        if (MultiColor.isHexColor(color)) {
            this.hexColor = color;
        } else if (color.matches("[0-9a-fA-F]{6}")) {
            this.hexColor = "#" + color;
        } else if (MultiColor.isColorCode(color)) {
            this.setColor(Main.getOrDefault(ChatColor.getByChar((char)color.charAt(1)), ChatColor.WHITE));
        } else if (MultiColor.isRGBColor(color)) {
            String[] s = color.split("\\$");
            this.setColor(new Color(Integer.parseInt(s[1]), Integer.parseInt(s[2]), Integer.parseInt(s[3])));
        } else {
            try {
                ChatColor c = ChatColor.valueOf((String)color.toUpperCase());
                this.setColor(c);
            }
            catch (IllegalArgumentException iae) {
                this.hexColor = "#ffffff";
            }
        }
    }

    public void setColor(ChatColor color) {
        this.hexColor = switch (color) {
            case ChatColor.DARK_BLUE -> "#0000aa";
            case ChatColor.DARK_GREEN -> "#00aa00";
            case ChatColor.DARK_AQUA -> "#00aaaa";
            case ChatColor.DARK_RED -> "#aa0000";
            case ChatColor.DARK_PURPLE -> "#aa00aa";
            case ChatColor.GOLD -> "#ffaa00";
            case ChatColor.GRAY -> "#aaaaaa";
            case ChatColor.DARK_GRAY -> "#555555";
            case ChatColor.BLUE -> "#5555ff";
            case ChatColor.GREEN -> "#55ff55";
            case ChatColor.AQUA -> "#55ffff";
            case ChatColor.RED -> "#ff5555";
            case ChatColor.LIGHT_PURPLE -> "#ff55ff";
            case ChatColor.YELLOW -> "#ffff55";
            case ChatColor.WHITE -> "#ffffff";
            case ChatColor.BLACK -> "#000000";
            default -> "#000000";
        };
    }

    public void setColor(DyeColor color) {
        this.setColor(color.getColor());
    }

    public void setColor(org.bukkit.Color color) {
        this.setColor(new Color(color.asRGB()));
    }

    public void setColor(Color color) {
        this.hexColor = "#" + Integer.toHexString(color.getRGB()).substring(2);
    }

    public String getColorAsValue() {
        return this.hexColor;
    }

    public Color getColor() {
        return new Color(Integer.parseInt(this.hexColor.substring(1, 7), 16));
    }

    public String getStringColor() {
        StringBuilder color = new StringBuilder("\u00a7x");
        for (char c : this.hexColor.substring(1).toCharArray()) {
            color.append('\u00a7').append(c);
        }
        return color.toString();
    }

    public int getRed() {
        return this.getColor().getRed();
    }

    public int getGreen() {
        return this.getColor().getGreen();
    }

    public int getBlue() {
        return this.getColor().getBlue();
    }

    public String toString() {
        return this.getColorAsValue();
    }

    @Nonnull
    public Map<String, Object> serialize() {
        return Main.asMap(new Pair<String, String>("color", this.hexColor));
    }

    public static MultiColor deserialize(Map<String, Object> args) {
        return new MultiColor((String)args.get("color"));
    }
}

