/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.book;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.spaceman.tport.adapters.ReflectionManager;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.book.BookPage;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Book {
    private final String title;
    private final String author;
    private final ArrayList<BookPage> pages = new ArrayList();

    public Book(String title, String author) {
        this.title = title;
        this.author = author;
    }

    public String toString() {
        return this.pages.stream().map(BookPage::toString).collect(Collectors.joining());
    }

    public BookPage createPage(TextComponent textComponent) {
        BookPage page = new BookPage(textComponent);
        this.addPage(page);
        return page;
    }

    public BookPage createPage() {
        BookPage page = new BookPage();
        this.addPage(page);
        return page;
    }

    public ItemStack getWritableBook() {
        ItemStack stack = new ItemStack(Material.WRITABLE_BOOK);
        try {
            return Bukkit.getUnsafe().modifyItemStack(stack, this.translateString());
        }
        catch (Throwable localThrowable) {
            return stack;
        }
    }

    public ItemStack getWrittenBook(@Nullable Player player) {
        ItemStack stack = new ItemStack(Material.WRITTEN_BOOK);
        try {
            return Bukkit.getUnsafe().modifyItemStack(stack, this.translateJSON(player == null ? ColorTheme.getDefaultTheme(ColorTheme.getDefaultThemes().get(0)) : ColorTheme.getTheme(player)));
        }
        catch (Throwable localThrowable) {
            return stack;
        }
    }

    public static void openBook(ItemStack book, Player player) {
        if (!book.getType().equals((Object)Material.WRITTEN_BOOK)) {
            throw new IllegalArgumentException("Given item is not a written book");
        }
        int slot = player.getInventory().getHeldItemSlot();
        ItemStack old = player.getInventory().getItem(slot);
        player.getInventory().setItem(slot, book);
        ByteBuf buf = Unpooled.buffer((int)256);
        buf.setByte(0, 0);
        buf.writerIndex(1);
        try {
            String version = ReflectionManager.getServerClassesVersion();
            Object nmsPlayer = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            Object connection = nmsPlayer.getClass().getField("b").get(nmsPlayer);
            if (Integer.parseInt(version.split("_")[1]) >= 18) {
                Class<?> enumHandClass = Class.forName("net.minecraft.world.EnumHand");
                Field mainHand = enumHandClass.getDeclaredField("a");
                mainHand.setAccessible(true);
                Object openBook = Class.forName("net.minecraft.network.protocol.game.PacketPlayOutOpenBook").getConstructor(enumHandClass).newInstance(mainHand.get(null));
                connection.getClass().getMethod("a", Class.forName("net.minecraft.network.protocol.Packet")).invoke(connection, openBook);
            } else if (Integer.parseInt(version.split("_")[1]) >= 17) {
                Class<?> enumHandClass = Class.forName("net.minecraft.world.EnumHand");
                Field mainHand = enumHandClass.getDeclaredField("a");
                mainHand.setAccessible(true);
                Object openBook = Class.forName("net.minecraft.network.protocol.game.PacketPlayOutOpenBook").getConstructor(enumHandClass).newInstance(mainHand.get(null));
                connection.getClass().getMethod("sendPacket", Class.forName("net.minecraft.network.protocol.Packet")).invoke(connection, openBook);
            } else if (Integer.parseInt(version.split("_")[1]) >= 14) {
                Field mainHand = Class.forName("net.minecraft.server." + version + "EnumHand").getDeclaredField("MAIN_HAND");
                mainHand.setAccessible(true);
                Object openBook = Class.forName("net.minecraft.server." + version + "PacketPlayOutOpenBook").getConstructor(Class.forName("net.minecraft.server." + version + "EnumHand")).newInstance(mainHand.get(null));
                connection.getClass().getMethod("sendPacket", Class.forName("net.minecraft.server." + version + "Packet")).invoke(connection, openBook);
            } else if (Integer.parseInt(version.split("_")[1]) > 12) {
                Class<?> packetDataSerializer = Class.forName("net.minecraft.server." + version + "PacketDataSerializer");
                Constructor<?> packetDataSerializerConstructor = packetDataSerializer.getConstructor(ByteBuf.class);
                Class<?> packetPlayOutCustomPayload = Class.forName("net.minecraft.server." + version + "PacketPlayOutCustomPayload");
                Constructor<?> minecraftKeyConstructor = Class.forName("net.minecraft.server." + version + "MinecraftKey").getConstructor(String.class);
                Constructor<?> packetPlayOutCustomPayloadConstructor = packetPlayOutCustomPayload.getConstructor(Class.forName("net.minecraft.server." + version + "MinecraftKey"), Class.forName("net.minecraft.server." + version + "PacketDataSerializer"));
                connection.getClass().getMethod("sendPacket", Class.forName("net.minecraft.server." + version + "Packet")).invoke(connection, packetPlayOutCustomPayloadConstructor.newInstance(minecraftKeyConstructor.newInstance("minecraft:book_open"), packetDataSerializerConstructor.newInstance(buf)));
            } else {
                Class<?> packetDataSerializer = Class.forName("net.minecraft.server." + version + "PacketDataSerializer");
                Constructor<?> packetDataSerializerConstructor = packetDataSerializer.getConstructor(ByteBuf.class);
                Class<?> packetPlayOutCustomPayload = Class.forName("net.minecraft.server." + version + "PacketPlayOutCustomPayload");
                Constructor<?> packetPlayOutCustomPayloadConstructor = packetPlayOutCustomPayload.getConstructor(String.class, Class.forName("net.minecraft.server." + version + "PacketDataSerializer"));
                connection.getClass().getMethod("sendPacket", Class.forName("net.minecraft.server." + version + "Packet")).invoke(connection, packetPlayOutCustomPayloadConstructor.newInstance("MC|BOpen", packetDataSerializerConstructor.newInstance(buf)));
            }
        }
        catch (Exception ex) {
            player.getInventory().setItem(slot, old);
            player.getInventory().addItem(new ItemStack[]{book});
            ex.printStackTrace();
            return;
        }
        player.getInventory().setItem(slot, old);
    }

    public void openBook(Player player) {
        Book.openBook(this.getWrittenBook(player), player);
    }

    public String translateString() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("title", this.title);
        jsonObject.addProperty("author", this.author);
        JsonArray jsonArray = new JsonArray();
        this.pages.stream().map(BookPage::translateString).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        jsonObject.add("pages", (JsonElement)jsonArray);
        return jsonObject.toString().replaceAll("\\\\/", "/").replace("\\n", "\n");
    }

    public String translateJSON(Player player) {
        return this.translateJSON(ColorTheme.getTheme(player));
    }

    public String translateJSON(ColorTheme theme) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("title", this.title);
        jsonObject.addProperty("author", this.author);
        JsonArray jsonArray = new JsonArray();
        this.pages.stream().map(p -> p.translateJSON(theme)).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        jsonObject.add("pages", (JsonElement)jsonArray);
        return jsonObject.toString().replaceAll("\\\\{3}/", "/");
    }

    public ArrayList<BookPage> getPages() {
        return this.pages;
    }

    public int getPageNumber(BookPage page) {
        int i = 1;
        for (BookPage tmpPage : this.pages) {
            if (tmpPage.equals(page)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addBook(Book book) {
        for (BookPage page : book.getPages()) {
            this.addPage(page);
        }
    }

    public void setPage(int page, BookPage bookPage) {
        this.pages.remove(bookPage);
        if (page > this.pages.size()) {
            this.pages.add(bookPage);
            bookPage.setPageNumber(this.pages.size());
        } else {
            if (page < 1) {
                page = 1;
            }
            BookPage newPage = bookPage;
            for (int i = page; i <= this.pages.size(); ++i) {
                BookPage tmpPage = this.pages.get(i - 1);
                newPage.setPageNumber(i);
                this.pages.set(i - 1, newPage);
                newPage = tmpPage;
            }
            this.addPage(newPage);
        }
    }

    public void addPage(BookPage bookPage) {
        this.setPage(this.pages.size() + 1, bookPage);
    }
}

