/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage;

import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.spaceman.tport.fancyMessage.Attribute;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextType;
import com.spaceman.tport.fancyMessage.book.BookPage;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.colorTheme.MultiColor;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fancyMessage.events.ScoreEvent;
import com.spaceman.tport.fancyMessage.events.TextEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.Color;

public class TextComponent
implements Cloneable {
    public static final String APOSTROPHE = "\"";
    public static final String NEW_LINE = "\n";
    public static final String PLACE_HOLDER = "%s";
    private String type = "text";
    private BookPage pageNumber = null;
    private String text;
    private String color;
    private String insertion = null;
    private ArrayList<Attribute> attributes;
    private ArrayList<TextEvent> textEvents;
    public ArrayList<Message> translateWith = new ArrayList();
    public Message separator = new Message();
    private boolean ignoreTranslator = false;
    private String shadowColor = null;

    public static String indexedPlaceHolder(int index) {
        return "%" + index + "$s";
    }

    public TextComponent() {
        this("", new MultiColor("#ffffff").getColorAsValue(), new ArrayList<TextEvent>(), new ArrayList<Attribute>());
    }

    public TextComponent(String text) {
        this(text, new MultiColor("#ffffff").getColorAsValue());
    }

    public TextComponent(String text, String color) {
        this(text, color, new ArrayList<TextEvent>(), new ArrayList<Attribute>());
    }

    public TextComponent(String text, ChatColor color) {
        this(text, color, new ArrayList<TextEvent>(), new ArrayList<Attribute>());
    }

    public TextComponent(String text, ColorTheme.ColorType color) {
        this(text, color.name(), new ArrayList<TextEvent>(), new ArrayList<Attribute>());
    }

    public TextComponent(String text, Color color) {
        this(text, new MultiColor(color).getColorAsValue(), new ArrayList<TextEvent>(), new ArrayList<Attribute>());
    }

    public TextComponent(String text, MultiColor color) {
        this(text, color.getColorAsValue(), new ArrayList<TextEvent>(), new ArrayList<Attribute>());
    }

    public TextComponent(String text, String color, List<TextEvent> textEvents, List<Attribute> attribute) {
        this.text = text;
        this.setColor(color);
        this.textEvents = textEvents != null ? new ArrayList<TextEvent>(textEvents) : new ArrayList();
        this.attributes = attribute != null ? new ArrayList<Attribute>(attribute) : new ArrayList();
    }

    public TextComponent(String text, ChatColor color, List<TextEvent> textEvents, List<Attribute> attribute) {
        this(text, color.name().toLowerCase(), textEvents, attribute);
    }

    public String toString() {
        return this.getRawText();
    }

    public static TextComponent textComponent() {
        return new TextComponent("", new MultiColor("#ffffff").getColorAsValue(), null, null);
    }

    public static TextComponent textComponent(String text) {
        return new TextComponent(text, new MultiColor("#ffffff").getColorAsValue());
    }

    public static TextComponent textComponent(String text, String color) {
        return new TextComponent(text, color);
    }

    public static TextComponent textComponent(String text, ChatColor color) {
        return new TextComponent(text, new MultiColor(color).getColorAsValue());
    }

    public static TextComponent textComponent(String text, ColorTheme.ColorType type) {
        return new TextComponent(text, type.name());
    }

    public static TextComponent textComponent(String text, Color color) {
        return new TextComponent(text, new MultiColor(color).getColorAsValue());
    }

    public static TextComponent textComponent(String text, MultiColor color) {
        return new TextComponent(text, color.getColorAsValue());
    }

    public static TextComponent textComponent(String text, String color, String insertion) {
        return new TextComponent(text, color).setInsertion(insertion);
    }

    public static TextComponent textComponent(String text, ChatColor color, String insertion) {
        return new TextComponent(text, new MultiColor(color).getColorAsValue()).setInsertion(insertion);
    }

    public static TextComponent textComponent(String text, ColorTheme.ColorType type, String insertion) {
        return new TextComponent(text, type.name()).setInsertion(insertion);
    }

    public static TextComponent textComponent(String text, Color color, String insertion) {
        return new TextComponent(text, new MultiColor(color).getColorAsValue()).setInsertion(insertion);
    }

    public static TextComponent textComponent(String text, MultiColor color, String insertion) {
        return new TextComponent(text, color.getColorAsValue()).setInsertion(insertion);
    }

    public static TextComponent textComponent(String text, String color, TextEvent ... textEvents) {
        return new TextComponent(text, color, Arrays.asList(textEvents), new ArrayList<Attribute>());
    }

    public static TextComponent textComponent(String text, ChatColor color, TextEvent ... textEvents) {
        return new TextComponent(text, new MultiColor(color).getColorAsValue(), Arrays.asList(textEvents), new ArrayList<Attribute>());
    }

    public static TextComponent textComponent(String text, ColorTheme.ColorType type, TextEvent ... textEvents) {
        return new TextComponent(text, type.name(), Arrays.asList(textEvents), new ArrayList<Attribute>());
    }

    public static TextComponent textComponent(String text, Color color, TextEvent ... textEvents) {
        return new TextComponent(text, new MultiColor(color).getColorAsValue(), Arrays.asList(textEvents), new ArrayList<Attribute>());
    }

    public static TextComponent textComponent(String text, MultiColor color, TextEvent ... textEvents) {
        return new TextComponent(text, color.getColorAsValue(), Arrays.asList(textEvents), new ArrayList<Attribute>());
    }

    public static TextComponent textComponent(String text, String color, Attribute ... attributes) {
        return new TextComponent(text, color, new ArrayList<TextEvent>(), Arrays.asList(attributes));
    }

    public static TextComponent textComponent(String text, ChatColor color, Attribute ... attributes) {
        return new TextComponent(text, new MultiColor(color).getColorAsValue(), new ArrayList<TextEvent>(), Arrays.asList(attributes));
    }

    public static TextComponent textComponent(String text, ColorTheme.ColorType type, Attribute ... attributes) {
        return new TextComponent(text, type.name(), new ArrayList<TextEvent>(), Arrays.asList(attributes));
    }

    public static TextComponent textComponent(String text, Color color, Attribute ... attributes) {
        return new TextComponent(text, new MultiColor(color).getColorAsValue(), new ArrayList<TextEvent>(), Arrays.asList(attributes));
    }

    public static TextComponent textComponent(String text, MultiColor color, Attribute ... attributes) {
        return new TextComponent(text, color.getColorAsValue(), new ArrayList<TextEvent>(), Arrays.asList(attributes));
    }

    public static TextComponent textComponent(String text, String color, List<TextEvent> textEvents, List<Attribute> attributes) {
        return new TextComponent(text, color, textEvents, attributes);
    }

    public static TextComponent textComponent(String text, ChatColor color, List<TextEvent> textEvents, List<Attribute> attributes) {
        return new TextComponent(text, color, textEvents, attributes);
    }

    public static TextComponent textComponent(String text, ColorTheme.ColorType type, List<TextEvent> textEvents, List<Attribute> attributes) {
        return new TextComponent(text, type.name(), textEvents, attributes);
    }

    public static TextComponent textComponent(String text, Color color, List<TextEvent> textEvents, List<Attribute> attributes) {
        return new TextComponent(text, new MultiColor(color).getColorAsValue(), textEvents, attributes);
    }

    public static TextComponent textComponent(String text, MultiColor color, List<TextEvent> textEvents, List<Attribute> attributes) {
        return new TextComponent(text, color.getColorAsValue(), textEvents, attributes);
    }

    public JsonObject translateJSON(ColorTheme theme) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(this.type, this.getText());
        jsonObject.addProperty("color", this.translateColor(theme, this.color));
        if (!Strings.isNullOrEmpty((String)this.insertion)) {
            jsonObject.addProperty("insertion", this.insertion);
        }
        Arrays.stream(Attribute.values()).forEach(attribute -> jsonObject.addProperty(attribute.name().toLowerCase(), Boolean.valueOf(this.attributes.contains(attribute))));
        this.textEvents.forEach(e -> Arrays.stream(e.name()).forEach(name -> jsonObject.add(name, (JsonElement)e.translateJSON(theme))));
        if (!this.translateWith.isEmpty()) {
            JsonArray withMessages = new JsonArray();
            for (Message m : this.translateWith) {
                JsonArray withMessageComponents = new JsonArray();
                m.getText().stream().map(t -> t.translateJSON(theme)).forEach(arg_0 -> ((JsonArray)withMessageComponents).add(arg_0));
                withMessages.add((JsonElement)withMessageComponents);
            }
            jsonObject.add("with", (JsonElement)withMessages);
        }
        if (!this.separator.isEmpty()) {
            JsonArray separatorMessage = new JsonArray();
            this.separator.getText().stream().map(t -> t.translateJSON(theme)).forEach(arg_0 -> ((JsonArray)separatorMessage).add(arg_0));
            jsonObject.add("separator", (JsonElement)separatorMessage);
        }
        if (this.shadowColor != null) {
            JsonArray colorsArray = new JsonArray();
            MultiColor shadowMulti = new MultiColor(this.translateColor(theme, this.shadowColor));
            colorsArray.add((Number)shadowMulti.getColor().getAlpha());
            colorsArray.add((Number)shadowMulti.getColor().getRed());
            colorsArray.add((Number)shadowMulti.getColor().getGreen());
            colorsArray.add((Number)shadowMulti.getColor().getBlue());
            jsonObject.add("shadow_color", (JsonElement)colorsArray);
        }
        return jsonObject;
    }

    public String translateColor(ColorTheme theme, String color) {
        return Arrays.stream(ColorTheme.ColorType.values()).filter(type -> type.name().equalsIgnoreCase(color)).findFirst().map(type -> type.getColor(theme).getColorAsValue()).orElse(color);
    }

    public String translateColor(ColorTheme theme) {
        return Arrays.stream(ColorTheme.ColorType.values()).filter(type -> type.name().equalsIgnoreCase(this.color)).findFirst().map(type -> type.getColor(theme).getColorAsValue()).orElse(this.color);
    }

    public void clearEvents() {
        this.textEvents = new ArrayList();
    }

    public void clearInteractiveEvents() {
        if (this.textEvents != null) {
            this.textEvents = this.textEvents.stream().filter(event -> event.getClass().getAnnotation(TextEvent.InteractiveTextEvent.class) == null).collect(Collectors.toCollection(ArrayList::new));
        }
    }

    public String getText() {
        if (this.pageNumber != null) {
            return this.text.replace(BookPage.getActivePageReplacer(), String.valueOf(this.pageNumber.getPageNumber()));
        }
        if (this.text == null) {
            return "null";
        }
        return this.text;
    }

    public String getRawText() {
        return this.text;
    }

    public TextComponent setText(String text) {
        this.text = text;
        return this;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(ChatColor color) {
        this.color = new MultiColor(color).getColorAsValue();
    }

    public void setColor(String color) {
        this.color = Arrays.stream(ColorTheme.ColorType.values()).anyMatch(type -> type.name().equalsIgnoreCase(color)) ? color : new MultiColor(color).getColorAsValue();
    }

    public void setColor(Color color) {
        this.color = new MultiColor(color).getColorAsValue();
    }

    public void setColor(MultiColor color) {
        this.color = color.getColorAsValue();
    }

    public void setColor(ColorTheme.ColorType type) {
        this.color = type.name();
    }

    public String getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(ChatColor color) {
        this.shadowColor = new MultiColor(color).getColorAsValue();
    }

    public void setShadowColor(String color) {
        this.shadowColor = Arrays.stream(ColorTheme.ColorType.values()).anyMatch(type -> type.name().equalsIgnoreCase(color)) ? color : new MultiColor(color).getColorAsValue();
    }

    public void setShadowColor(Color color) {
        this.shadowColor = new MultiColor(color).getColorAsValue();
    }

    public void setShadowColor(MultiColor color) {
        this.shadowColor = color.getColorAsValue();
    }

    public void setShadowColor(ColorTheme.ColorType type) {
        this.shadowColor = type.name();
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        for (Attribute attribute : attributes) {
            this.addAttribute(attribute);
        }
    }

    public TextComponent addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
        return this;
    }

    public void removeAttribute(Attribute attribute) {
        this.attributes.remove((Object)attribute);
    }

    public List<TextEvent> getTextEvents() {
        return this.textEvents;
    }

    public <E extends TextEvent> E getTextEvent(Class<E> textEvent) {
        return (E)((TextEvent)this.textEvents.stream().filter(textEvent::isInstance).findFirst().orElse(null));
    }

    public ScoreEvent getScoreEvent() {
        return this.getTextEvent(ScoreEvent.class);
    }

    public ClickEvent getClickEvent() {
        return this.getTextEvent(ClickEvent.class);
    }

    public HoverEvent getHoverEvent() {
        return this.getTextEvent(HoverEvent.class);
    }

    public boolean hasTextEvent(Class<? extends TextEvent> textEvent) {
        return this.textEvents.stream().anyMatch(textEvent::isInstance);
    }

    public boolean hasScoreEvent() {
        return this.hasTextEvent(ScoreEvent.class);
    }

    public boolean hasClickEvent() {
        return this.hasTextEvent(ClickEvent.class);
    }

    public boolean hasHoverEvent() {
        return this.hasTextEvent(HoverEvent.class);
    }

    public <E extends TextEvent> E removeTextEvent(Class<E> textEvent) {
        TextEvent toRemove = this.textEvents.stream().filter(textEvent::isInstance).findFirst().orElse(null);
        if (toRemove != null) {
            this.textEvents.remove(toRemove);
        }
        return (E)toRemove;
    }

    public TextComponent addTextEvent(@Nullable TextEvent textEvent) {
        if (textEvent == null) {
            return this;
        }
        this.removeTextEvent(textEvent.getClass());
        this.textEvents.add(textEvent);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public TextComponent setType(String type) {
        this.type = type.toLowerCase();
        return this;
    }

    public TextComponent setType(TextType type) {
        this.type = type.name().toLowerCase();
        return this;
    }

    public String getInsertion() {
        return this.insertion;
    }

    public TextComponent setInsertion(String insertion) {
        this.insertion = insertion;
        return this;
    }

    public TextComponent setTextAsInsertion() {
        this.insertion = this.getText();
        return this;
    }

    public BookPage getBookPage() {
        return this.pageNumber;
    }

    public TextComponent setBookPage(BookPage pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    public TextComponent resetTranslateWith() {
        this.translateWith = new ArrayList();
        return this;
    }

    public TextComponent addTranslateWith(TextComponent ... text) {
        for (TextComponent component : text) {
            this.addTranslateWith(new Message(component));
        }
        return this;
    }

    public TextComponent addTranslateWith(Message ... messages) {
        this.translateWith.addAll(Arrays.asList(messages));
        return this;
    }

    public TextComponent removeTranslateWith(Message message) {
        this.translateWith.remove(message);
        return this;
    }

    public ArrayList<Message> getTranslateWith() {
        return this.translateWith;
    }

    public TextComponent resetSeparator() {
        this.separator = new Message();
        return this;
    }

    public Message getSeparator() {
        return this.separator;
    }

    public TextComponent setSeparator(Message separator) {
        this.separator = separator;
        return this;
    }

    public boolean ignoreTranslator() {
        return this.ignoreTranslator;
    }

    public TextComponent ignoreTranslator(boolean ignore) {
        this.ignoreTranslator = ignore;
        return this;
    }

    public Object clone() {
        TextComponent textComponent = new TextComponent(this.text, this.color);
        for (Attribute attribute : this.attributes) {
            textComponent.addAttribute(attribute);
        }
        for (Message message : this.translateWith) {
            textComponent.translateWith.add((Message)message.clone());
        }
        textComponent.pageNumber = this.pageNumber;
        textComponent.insertion = this.insertion;
        textComponent.type = this.type;
        textComponent.textEvents = this.textEvents;
        textComponent.ignoreTranslator = this.ignoreTranslator;
        textComponent.separator = (Message)this.separator.clone();
        return textComponent;
    }
}

