/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.spaceman.tport.Main;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.fancyMessage.Attribute;
import com.spaceman.tport.fancyMessage.MessageUtils;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.TextType;
import com.spaceman.tport.fancyMessage.book.Book;
import com.spaceman.tport.fancyMessage.book.BookPage;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.colorTheme.MultiColor;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fancyMessage.events.ScoreEvent;
import com.spaceman.tport.fancyMessage.events.TextEvent;
import com.spaceman.tport.fancyMessage.language.Language;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class Message
implements Cloneable {
    private ArrayList<TextComponent> components = new ArrayList();
    private boolean translated = false;

    public Message() {
    }

    public Message(TextComponent text) {
        this.components.add(text);
    }

    public Message(TextComponent ... text) {
        this.components.addAll(Arrays.asList(text));
    }

    public Message(List<TextComponent> message) {
        this.components.addAll(message);
    }

    public Message(String simpleText, ChatColor color) {
        this.components.add(TextComponent.textComponent(simpleText, color));
    }

    public Message(String simpleText) {
        this.components.add(TextComponent.textComponent(simpleText));
    }

    public static Message fromList(List<Message> list) {
        Message m = new Message();
        list.forEach(m::addMessage);
        return m;
    }

    public String toString() {
        return this.components.stream().map(TextComponent::toString).collect(Collectors.joining());
    }

    public String toColoredString(ColorTheme theme) {
        return this.components.stream().map(component -> new MultiColor(component.translateColor(theme)).getStringColor() + component.getText()).collect(Collectors.joining());
    }

    public String translateString() {
        return this.components.stream().map(TextComponent::getText).collect(Collectors.joining());
    }

    public String translateHTML(ColorTheme theme) {
        StringBuilder str = new StringBuilder();
        for (TextComponent component : this.components) {
            str.append("<span style='color: ").append(component.translateColor(theme)).append(";'>").append(component.getText()).append("</span>");
        }
        return str.toString();
    }

    public static void testAll(Player player) {
        Message message = new Message();
        TextComponent newLine = new TextComponent("\n");
        TextComponent color1 = new TextComponent("c", ChatColor.GREEN);
        TextComponent color2 = new TextComponent("o", ChatColor.RED);
        TextComponent color3 = new TextComponent("l", ChatColor.BLUE);
        TextComponent color4 = new TextComponent("o", ChatColor.LIGHT_PURPLE);
        TextComponent color5 = new TextComponent("r", ChatColor.YELLOW);
        color1.addAttribute(Attribute.BOLD);
        color2.addAttribute(Attribute.ITALIC);
        color3.addAttribute(Attribute.OBFUSCATED);
        color4.addAttribute(Attribute.STRIKETHROUGH);
        color5.addAttribute(Attribute.UNDERLINED);
        TextComponent color1RGB = new TextComponent("c", Color.fromBGR((int)100, (int)100, (int)100));
        TextComponent color2RGB = new TextComponent("o", Color.TEAL);
        TextComponent color3RGB = new TextComponent("l", Color.OLIVE);
        TextComponent color4RGB = new TextComponent("o", Color.fromRGB((int)696969));
        TextComponent color5RGB = new TextComponent("r", Color.fromRGB((int)123456));
        color1RGB.addAttribute(Attribute.BOLD);
        color2RGB.addAttribute(Attribute.ITALIC);
        color3RGB.addAttribute(Attribute.OBFUSCATED);
        color4RGB.addAttribute(Attribute.STRIKETHROUGH);
        color5RGB.addAttribute(Attribute.UNDERLINED);
        TextComponent hover = new TextComponent("hover event", ChatColor.RED);
        HoverEvent hoverEvent = new HoverEvent();
        hoverEvent.addText(color1, color2, color3, color4, color5);
        hover.addTextEvent(hoverEvent);
        TextComponent runCommand = new TextComponent("run command say hi", ChatColor.BLUE);
        runCommand.addTextEvent(new ClickEvent("run_command", "say hi"));
        TextComponent openURL = new TextComponent("open url https://noot.space", ChatColor.DARK_RED);
        openURL.addTextEvent(new ClickEvent("open_url", "https://noot.space"));
        TextComponent suggestCommand = new TextComponent("suggest command say hi", ChatColor.DARK_PURPLE);
        suggestCommand.addTextEvent(new ClickEvent("suggest_command", "say hi"));
        TextComponent changePage = new TextComponent("open page 2", ChatColor.GREEN);
        changePage.addTextEvent(new ClickEvent("change_page", "2"));
        TextComponent copyText = new TextComponent("click to copy this", ChatColor.GREEN);
        copyText.addTextEvent(new ClickEvent("copy_to_clipboard", "copied this"));
        TextComponent scoreText = new TextComponent("score: ", ChatColor.DARK_GREEN);
        TextComponent score = new TextComponent();
        score.setColor(ChatColor.GREEN);
        score.addTextEvent(new ScoreEvent("The_Spaceman", "dummyObjective"));
        TextComponent keybind = new TextComponent("key.drop", ChatColor.DARK_AQUA);
        keybind.setType(TextType.KEYBIND);
        TextComponent keybindText = new TextComponent(" is your drop key", ChatColor.AQUA);
        TextComponent diamond_sword = new TextComponent("hover for leather_helmet", ChatColor.GREEN);
        ItemStack swordItem = new ItemStack(Material.LEATHER_HELMET, 2);
        ItemMeta swordMeta = swordItem.getItemMeta();
        swordMeta.setDisplayName("helmet");
        Damageable d = (Damageable)swordMeta;
        d.setDamage(100);
        ((LeatherArmorMeta)swordMeta).setColor(Color.fromRGB((int)12, (int)34, (int)45));
        swordMeta.addEnchant(Enchantment.FIRE_ASPECT, 1, true);
        swordMeta.addEnchant(Enchantment.MENDING, 3, true);
        swordMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GREEN) + "line 1", "line 2", new MultiColor("#123456").getStringColor() + "line 3"));
        swordItem.setItemMeta(swordMeta);
        diamond_sword.addTextEvent(HoverEvent.hoverEvent(swordItem));
        TextComponent selector = new TextComponent("@p", ChatColor.GRAY).setType(TextType.SELECTOR);
        TextComponent selectorText = new TextComponent(" should be your name", ChatColor.DARK_GRAY);
        TextComponent translateTitle = new TextComponent("gui.toTitle", ChatColor.GOLD).setType(TextType.TRANSLATE);
        TextComponent translateWith = new TextComponent("translate with 1 '%s', with 2 '%s'", ChatColor.RED).setType(TextType.TRANSLATE);
        translateWith.addTranslateWith(new TextComponent("1", ChatColor.BLUE), new TextComponent("2", ChatColor.BLACK));
        message.addText(color1, color2, color3, color4, color5, newLine, color1RGB, color2RGB, color3RGB, color4RGB, color5RGB, newLine, hover, newLine, runCommand, newLine, openURL, newLine, suggestCommand, newLine, changePage, newLine, copyText, newLine, scoreText, score, newLine, keybind, keybindText, newLine, diamond_sword, newLine, selector, selectorText, newLine, translateTitle, newLine, translateWith);
        message.sendMessage(player);
        ItemStack is = new ItemStack(Material.STONE);
        Message displayName = new Message();
        displayName.addText(TextComponent.textComponent("key of forward: ", ChatColor.RED));
        displayName.addText(TextComponent.textComponent("key.forward", ChatColor.BLUE).setType(TextType.KEYBIND));
        MessageUtils.setCustomItemData(is, ColorTheme.getTheme(player), displayName, null);
        Message lore1 = new Message();
        lore1.addText(TextComponent.textComponent("line 1, component 1", ChatColor.DARK_AQUA), TextComponent.textComponent("line 1, component 2", ChatColor.BLUE));
        Message lore2 = new Message();
        lore2.addText(TextComponent.textComponent("line 2", ChatColor.AQUA));
        MessageUtils.setCustomLore(is, ColorTheme.getTheme(player), lore1, lore2);
        player.getInventory().addItem(new ItemStack[]{is});
        Message title = new Message();
        title.addText(TextComponent.textComponent("title", ChatColor.GREEN));
        title.sendTitle(player, TitleTypes.TITLE);
        title.removeLast();
        title.addText(TextComponent.textComponent("actionbar", ChatColor.GREEN));
        title.sendTitle(player, TitleTypes.ACTIONBAR);
        title.removeLast();
        title.addText(TextComponent.textComponent("subtitle", ChatColor.GREEN));
        title.sendTitle(player, TitleTypes.SUBTITLE);
        Book book = new Book("All functions", "The_Spaceman");
        BookPage page = book.createPage();
        page.addMessage(message);
        BookPage page2 = book.createPage();
        page2.addText(scoreText, score, newLine, keybind, keybindText, newLine, diamond_sword, newLine, selector, selectorText, newLine, translateTitle, newLine, translateWith);
        book.openBook(player);
        player.getInventory().addItem(new ItemStack[]{book.getWritableBook()});
        player.getInventory().addItem(new ItemStack[]{book.getWrittenBook(player)});
    }

    public void removeLast() {
        if (!this.components.isEmpty()) {
            this.components.remove(this.components.size() - 1);
        }
    }

    public void addText(TextComponent ... text) {
        this.components.addAll(Arrays.asList(text));
    }

    public void addText(String simpleText) {
        this.addText(TextComponent.textComponent(simpleText));
    }

    public void addText(String simpleText, ChatColor color) {
        this.addText(TextComponent.textComponent(simpleText, color));
    }

    public void addText(String simpleText, String color) {
        this.addText(TextComponent.textComponent(simpleText, color));
    }

    public void addText(String simpleText, Color color) {
        this.addText(TextComponent.textComponent(simpleText, color));
    }

    public void addText(String simpleText, MultiColor color) {
        this.addText(TextComponent.textComponent(simpleText, color));
    }

    public void addText(String simpleText, ColorTheme.ColorType color) {
        this.addText(TextComponent.textComponent(simpleText, color));
    }

    public void removeText(String simpleText) {
        ArrayList<TextComponent> toRemove = new ArrayList<TextComponent>();
        for (TextComponent component : this.components) {
            if (!component.getText().equals(simpleText)) continue;
            toRemove.add(component);
        }
        this.components.removeAll(toRemove);
    }

    public void removeText(TextComponent textComponent) {
        this.components.remove(textComponent);
    }

    public void addMessage(Message message) {
        if (message != null) {
            this.components.addAll(message.getText());
        }
    }

    public void removeMessage(Message message) {
        for (TextComponent textComponent : message.getText()) {
            this.removeText(textComponent);
        }
    }

    public void addWhiteSpace() {
        this.addText(" ");
    }

    public void addNewLine() {
        this.addText("\n");
    }

    public boolean isTranslated() {
        return this.translated;
    }

    public void setTranslated(boolean translated) {
        this.translated = translated;
    }

    public ArrayList<TextComponent> getText() {
        return this.components;
    }

    public void clearMessage() {
        this.components.clear();
    }

    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    public void setInsertion(String insertion) {
        for (TextComponent component : this.components) {
            component.setInsertion(insertion);
        }
    }

    public void addTextEvent(TextEvent event) {
        for (TextComponent component : this.components) {
            component.addTextEvent(event);
        }
    }

    public Message translateMessage(@Nullable JsonObject translateFile) {
        if (translateFile != null) {
            this.components = MessageUtils.translateMessage(this, translateFile).getText();
        }
        return this;
    }

    public void sendTitle(Player player, TitleTypes titleTypes) {
        this.sendTitle(player, titleTypes, -1, -1, -1);
    }

    public void sendTitle(Player player, TitleTypes titleType, int fadeIn, int displayTime, int fadeOut) {
        String message = this.translateJSON(ColorTheme.getTheme(player));
        try {
            Main.getInstance().adapter.sendTitle(player, message, titleType, fadeIn, displayTime, fadeOut);
        }
        catch (Exception ex) {
            Features.Feature.printSmallNMSErrorInConsole("Messaging-title", true);
            if (Features.Feature.PrintErrorsInConsole.isEnabled()) {
                ex.printStackTrace();
            }
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("title " + player.getName() + " " + titleType.name().toLowerCase() + " " + message));
        }
    }

    public void sendAndTranslateMessage(Player player) {
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        if (playerLang == null) {
            this.sendMessage(player);
        } else {
            this.translateMessage(playerLang);
            this.sendMessage(player);
        }
    }

    public void sendMessage(Player player) {
        if (player == null) {
            return;
        }
        String message = this.translateJSON(ColorTheme.getTheme(player));
        try {
            Main.getInstance().adapter.sendMessage(player, message);
        }
        catch (Throwable ex) {
            Features.Feature.printSmallNMSErrorInConsole("Messaging", true);
            if (Features.Feature.PrintErrorsInConsole.isEnabled()) {
                ex.printStackTrace();
            }
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + player.getName() + " " + message));
        }
    }

    public void broadcast() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.sendMessage(player);
        }
    }

    public void broadcastTranslation() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.sendAndTranslateMessage(player);
        }
    }

    public String translateJSON(Player player) {
        return this.translateJSON(ColorTheme.getTheme(player));
    }

    public String translateJSON(ColorTheme theme) {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add("");
        this.components.stream().map(t -> t.translateJSON(theme)).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        return jsonArray.toString();
    }

    public Object clone() {
        Message message = new Message();
        Stream<TextComponent> stream = this.components.stream().map(component -> (TextComponent)component.clone());
        Message message2 = message;
        Objects.requireNonNull(message2);
        Message message3 = message2;
        stream.forEach(xva$0 -> message3.addText((TextComponent)xva$0));
        return message;
    }

    public static enum TitleTypes {
        TITLE("ClientboundSetTitleTextPacket"),
        ACTIONBAR("ClientboundSetActionBarTextPacket"),
        SUBTITLE("ClientboundSetSubtitleTextPacket");

        private final String mcClass;

        private TitleTypes(String mcClass) {
            this.mcClass = mcClass;
        }

        public String getMCClass() {
            return this.mcClass;
        }
    }
}

