/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.events;

import com.spaceman.tport.Main;
import com.spaceman.tport.commands.tport.pltp.Offset;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.history.TeleportHistory;
import com.spaceman.tport.tport.TPort;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class PreviewEvents
implements Listener {
    private static final PreviewEvents instance = new PreviewEvents();
    private static final HashMap<UUID, PreviewObject> previews = new HashMap();

    private PreviewEvents() {
    }

    public static PreviewEvents getInstance() {
        return instance;
    }

    public static void register() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)instance, (Plugin)Main.getInstance());
    }

    public static void unregister() {
        PlayerMoveEvent.getHandlerList().unregister((Listener)instance);
        PlayerInteractEvent.getHandlerList().unregister((Listener)instance);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        if (e.getTo() != null) {
            if (this.locationEquals(e.getFrom(), e.getTo())) {
                return;
            }
            if (PreviewEvents.isPreviewing(e.getPlayer().getUniqueId())) {
                PreviewEvents.cancelPreview(e.getPlayer());
            }
        }
    }

    private boolean locationEquals(Location l1, Location l2) {
        return l1.getX() == l2.getX() && l1.getY() == l2.getY() && l1.getZ() == l2.getZ();
    }

    @EventHandler
    public void onWorldInteract(PlayerInteractEvent e) {
        if (PreviewEvents.isPreviewing(e.getPlayer().getUniqueId())) {
            PreviewEvents.cancelPreview(e.getPlayer());
            e.setCancelled(true);
        }
    }

    public static boolean isPreviewing(UUID uuid) {
        return previews.containsKey(uuid);
    }

    public static boolean cancelPreview(Player player) {
        return PreviewEvents.cancelPreview(player, true);
    }

    public static boolean cancelPreview(Player player, boolean sendMessage) {
        PreviewObject p = previews.remove(player.getUniqueId());
        if (p != null) {
            player.teleport(p.oldLocation());
            player.setGameMode(p.oldGameMode());
            if (sendMessage) {
                if (p.tport() == null) {
                    ColorTheme.sendSuccessTranslation(player, "tport.tport.tport.cancelPreview.succeeded.player", PlayerEncapsulation.asPlayer(p.player()));
                } else {
                    ColorTheme.sendSuccessTranslation(player, "tport.tport.tport.cancelPreview.succeeded.tport", TPortEncapsulation.asTPort(p.tport()));
                }
            }
            return true;
        }
        return false;
    }

    public static void cancelAllPreviews() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!PreviewEvents.cancelPreview(player, false)) continue;
            ColorTheme.sendInfoTranslation(player, "tport.tport.tport.cancelPreview.reload", new Object[0]);
        }
    }

    private static void createPreviewObject(Player player, TPort tport, UUID previewUUID) {
        GameMode gameMode = player.getGameMode();
        Location location = player.getLocation();
        if (PreviewEvents.isPreviewing(player.getUniqueId())) {
            PreviewObject po = previews.get(player.getUniqueId());
            gameMode = po.oldGameMode;
            location = po.oldLocation;
        }
        previews.put(player.getUniqueId(), new PreviewObject(location, tport, previewUUID, gameMode));
    }

    public static void preview(Player player, TPort tport) {
        PreviewEvents.createPreviewObject(player, tport, null);
        player.setGameMode(GameMode.SPECTATOR);
        TeleportHistory.ignoreTeleport(player.getUniqueId());
        player.teleport(tport.getLocation());
        ColorTheme.sendSuccessTranslation(player, "tport.tport.tport.preview.succeeded.tport", TPortEncapsulation.asTPort(tport));
    }

    public static void preview(Player player, Player preview) {
        PreviewEvents.createPreviewObject(player, null, preview.getUniqueId());
        player.setGameMode(GameMode.SPECTATOR);
        TeleportHistory.ignoreTeleport(player.getUniqueId());
        player.teleport(Offset.getPLTPOffset(preview).applyOffset(preview.getLocation()));
        ColorTheme.sendSuccessTranslation(player, "tport.tport.tport.preview.succeeded.player", PlayerEncapsulation.asPlayer(preview));
    }

    private record PreviewObject(Location oldLocation, TPort tport, UUID player, GameMode oldGameMode) {
    }
}

