/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.cooldown;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.cooldown.CooldownManager;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.Player;

public class CooldownCommand
extends SubCommand {
    private static final CooldownCommand instance = new CooldownCommand();
    protected final EmptyCommand emptyCooldownCooldownValue = new EmptyCommand();

    public static CooldownCommand getInstance() {
        return instance;
    }

    public CooldownCommand() {
        this.emptyCooldownCooldownValue.setCommandName("value", ArgumentType.OPTIONAL);
        this.emptyCooldownCooldownValue.setCommandDescription(ColorTheme.formatInfoTranslation("tport.cooldown.cooldownCommand.value.commandDescription", new Object[0]));
        this.emptyCooldownCooldownValue.setPermissions("TPort.cooldown.set", "TPort.admin.cooldown");
        EmptyCommand emptyCooldownCooldown = new EmptyCommand();
        emptyCooldownCooldown.setCommandName("cooldown", ArgumentType.REQUIRED);
        emptyCooldownCooldown.setCommandDescription(ColorTheme.formatInfoTranslation("tport.cooldown.cooldownCommand.commandDescription", new Object[0]));
        emptyCooldownCooldown.setTabRunnable((args, player) -> {
            if (!this.emptyCooldownCooldownValue.hasPermissionToRun(player, false)) {
                return new ArrayList();
            }
            ArrayList originalList = new ArrayList();
            Arrays.stream(CooldownManager.values()).map(Enum::name).forEach(originalList::add);
            if (originalList.contains(args[1])) {
                ArrayList<String> list = new ArrayList<String>(originalList);
                list.add("permission");
                list.remove(args[1]);
                return list;
            }
            return new ArrayList();
        });
        emptyCooldownCooldown.addAction(this.emptyCooldownCooldownValue);
        this.addAction(emptyCooldownCooldown);
    }

    @Override
    public String getName(String arg) {
        return "cooldown";
    }

    public List<String> tabList(Player player, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        Arrays.stream(CooldownManager.values()).map(Enum::name).forEach(list::add);
        return list;
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            if (CooldownManager.contains(args[1])) {
                CooldownManager.get(args[1]).printValue(player);
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.cooldown.cooldownCommand.get.error", args[1]);
            }
        } else if (args.length == 3) {
            if (!this.emptyCooldownCooldownValue.hasPermissionToRun(player, true)) {
                return;
            }
            if (CooldownManager.contains(args[1])) {
                try {
                    Long.parseLong(args[2]);
                }
                catch (NumberFormatException nfe) {
                    if (!args[2].equalsIgnoreCase("permission")) {
                        if (!CooldownManager.contains(args[2])) {
                            ColorTheme.sendErrorTranslation(player, "tport.cooldown.cooldownCommand.set.invalidEntry", args[2], "permission");
                            return;
                        }
                        if (args[1].equalsIgnoreCase(args[2])) {
                            ColorTheme.sendErrorTranslation(player, "tport.cooldown.cooldownCommand.set.setToSelf", new Object[0]);
                            return;
                        }
                    }
                    ColorTheme.sendInfoTranslation(player, "tport.cooldown.cooldownCommand.set.permissionInfo", "TPort.cooldown." + args[1] + ".<X>");
                }
                CooldownManager.get(args[1]).edit(args[2]);
                ColorTheme.sendSuccessTranslation(player, "tport.cooldown.cooldownCommand.set.succeeded", args[1], args[2]);
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.cooldown.cooldownCommand.set.error", args[1]);
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport cooldown <cooldown> [value]");
        }
    }
}

