/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.transfer;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.transfer.Accept;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Offer
extends SubCommand {
    private final EmptyCommand emptyPlayerTPort = new EmptyCommand();

    public Offer() {
        this.emptyPlayerTPort.setCommandName("TPort name", ArgumentType.REQUIRED);
        this.emptyPlayerTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.transfer.accept.player.tportName.commandDescription", new Object[0]));
        this.emptyPlayerTPort.setPermissions("TPort.transfer.offer", "TPort.basic");
        EmptyCommand emptyPlayer = new EmptyCommand();
        emptyPlayer.setCommandName("player", ArgumentType.REQUIRED);
        emptyPlayer.setTabRunnable((args, player) -> {
            if (!this.emptyPlayerTPort.hasPermissionToRun(player, false)) {
                return Collections.emptyList();
            }
            Player p = Bukkit.getPlayer((String)args[2]);
            if (p == null || !Accept.getInstance().emptyPlayerTPort.hasPermissionToRun(p, false)) {
                return new ArrayList();
            }
            List list = TPortManager.getTPortList(player.getUniqueId()).stream().filter(tport -> !tport.isOffered()).map(TPort::getName).collect(Collectors.toList());
            TPortManager.getTPortList(p.getUniqueId()).stream().map(TPort::getName).forEach(s -> list.removeIf(ss -> ss.equalsIgnoreCase((String)s)));
            return list;
        });
        emptyPlayer.addAction(this.emptyPlayerTPort);
        this.addAction(emptyPlayer);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyPlayerTPort.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Bukkit.getOnlinePlayers().stream().filter(p -> !p.getName().equalsIgnoreCase(player.getName())).filter(p -> Accept.getInstance().emptyPlayerTPort.hasPermissionToRun((Player)p, false)).map(Player::getName).collect(Collectors.toList());
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length != 4) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport transfer offer <player> <TPort name>");
            return;
        }
        if (!this.emptyPlayerTPort.hasPermissionToRun(player, true)) {
            return;
        }
        UUID newPlayerUUID = PlayerUUID.getPlayerUUID(args[2], player);
        if (newPlayerUUID == null) {
            return;
        }
        Player toPlayer = Bukkit.getPlayer((UUID)newPlayerUUID);
        if (toPlayer == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.playerNotOnline", PlayerEncapsulation.asPlayer(newPlayerUUID));
            return;
        }
        TPort tport = TPortManager.getTPort(player.getUniqueId(), args[3]);
        if (tport == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[3]);
            return;
        }
        if (tport.isPublicTPort()) {
            ColorTheme.sendErrorTranslation(player, "tport.command.transfer.offer.player.tportName.isPublic", TPortEncapsulation.asTPort(tport));
            return;
        }
        if (tport.isOffered()) {
            ColorTheme.sendErrorTranslation(player, "tport.command.transfer.offer.player.tportName.isOffered", TPortEncapsulation.asTPort(tport), PlayerEncapsulation.asPlayer(tport.getOfferedTo()));
            return;
        }
        if (TPortManager.getTPort(toPlayer.getUniqueId(), tport.getName()) != null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.transfer.offer.player.tportName.alreadyHasName", PlayerEncapsulation.asPlayer(toPlayer), TPortEncapsulation.asTPort(tport));
            return;
        }
        tport.setOfferedTo(toPlayer.getUniqueId());
        tport.save();
        ColorTheme theme = ColorTheme.getTheme(toPlayer);
        ColorTheme.sendInfoTranslation(toPlayer, "tport.command.transfer.offer.player.tportName.succeededOtherPlayer", TPortEncapsulation.asTPort(tport), PlayerEncapsulation.asPlayer(player), TextComponent.textComponent("/tport transfer accept " + player.getName() + " " + tport.getName(), theme.getVarInfoColor(), new HoverEvent(TextComponent.textComponent("/tport transfer accept " + player.getName() + " " + tport.getName(), theme.getInfoColor())), ClickEvent.runCommand("/tport transfer accept " + player.getName() + " " + tport.getName())), TextComponent.textComponent("/tport transfer reject " + player.getName() + " " + tport.getName(), theme.getVarInfoColor(), new HoverEvent(TextComponent.textComponent("/tport transfer reject " + player.getName() + " " + tport.getName(), theme.getInfoColor())), ClickEvent.runCommand("/tport transfer reject " + player.getName() + " " + tport.getName())));
        ColorTheme ownTheme = ColorTheme.getTheme(player);
        ColorTheme.sendSuccessTranslation(player, "tport.command.transfer.offer.player.tportName.succeeded", TPortEncapsulation.asTPort(tport), PlayerEncapsulation.asPlayer(toPlayer), TextComponent.textComponent("/tport transfer revoke " + tport.getName(), ownTheme.getVarSuccessColor(), new HoverEvent(TextComponent.textComponent("/tport transfer revoke " + tport.getName(), ownTheme.getSuccessColor())), ClickEvent.runCommand("/tport transfer revoke " + tport.getName())));
    }
}

