/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.transfer;

import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.entity.Player;

public class List
extends SubCommand {
    public List() {
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.transfer.list.commandDescription", new Object[0]));
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            boolean color = true;
            ArrayList<Message> offered = new ArrayList<Message>();
            for (TPort tport : TPortManager.getTPortList(player.getUniqueId())) {
                if (!tport.isOffered()) continue;
                PlayerEncapsulation otherPlayer = PlayerEncapsulation.asPlayer(tport.getOfferedTo());
                HoverEvent hEvent = new HoverEvent();
                hEvent.addMessage(ColorTheme.formatInfoTranslation("tport.command.transfer.list.offeredHoverFormat", tport.getName(), tport, otherPlayer, "/tport transfer revoke " + tport.getName()));
                Message m = ColorTheme.formatTranslation(color ? ColorTheme.ColorType.varInfoColor : ColorTheme.ColorType.varInfo2Color, color ? ColorTheme.ColorType.varInfoColor : ColorTheme.ColorType.varInfo2Color, "tport.command.transfer.list.offeredFormat", tport.getName(), tport, otherPlayer, "/tport transfer revoke " + tport.getName());
                m.getText().forEach(t -> t.addTextEvent(hEvent).addTextEvent(ClickEvent.runCommand("/tport transfer revoke " + tport.getName())));
                offered.add(m);
                color = !color;
            }
            int offeredSize = offered.size();
            Message offeredMessage = new Message();
            for (int i = 0; i < offeredSize; ++i) {
                offeredMessage.addMessage((Message)offered.get(i));
                if (i + 2 == offeredSize) {
                    offeredMessage.addMessage(ColorTheme.formatInfoTranslation("tport.command.transfer.list.lastDelimiter", new Object[0]));
                    continue;
                }
                offeredMessage.addMessage(ColorTheme.formatInfoTranslation("tport.command.transfer.list.delimiter", new Object[0]));
            }
            offeredMessage.removeLast();
            color = true;
            ArrayList<Message> offers = new ArrayList<Message>();
            for (String uuidString : Files.tportData.getKeys("tport")) {
                UUID uuid = UUID.fromString(uuidString);
                for (TPort tport : TPortManager.getTPortList(uuid)) {
                    if (!player.getUniqueId().equals(tport.getOfferedTo())) continue;
                    PlayerEncapsulation otherPlayer = PlayerEncapsulation.asPlayer(tport.getOwner());
                    HoverEvent hEvent = new HoverEvent();
                    hEvent.addMessage(ColorTheme.formatInfoTranslation("tport.command.transfer.list.offerHoverFormat", tport.getName(), tport, otherPlayer, "/tport transfer accept " + otherPlayer.getName() + " " + tport.getName(), "/tport transfer reject " + otherPlayer.getName() + " " + tport.getName()));
                    Message m = ColorTheme.formatTranslation(color ? ColorTheme.ColorType.varInfoColor : ColorTheme.ColorType.varInfo2Color, color ? ColorTheme.ColorType.varInfoColor : ColorTheme.ColorType.varInfo2Color, "tport.command.transfer.list.offerFormat", tport.getName(), tport, otherPlayer, "/tport transfer accept " + tport.getName(), "/tport transfer reject " + tport.getName());
                    m.getText().forEach(t -> t.addTextEvent(hEvent).addTextEvent(ClickEvent.runCommand("/tport transfer accept " + otherPlayer.getName() + " " + tport.getName())).setInsertion("/tport transfer reject " + otherPlayer.getName() + " " + tport.getName()));
                    for (TextComponent t2 : m.getText()) {
                        for (Message with : t2.getTranslateWith()) {
                            for (TextComponent withT : with.getText()) {
                                withT.setInsertion("/tport transfer reject " + otherPlayer.getName() + " " + tport.getName());
                            }
                        }
                    }
                    offers.add(m);
                    color = !color;
                }
            }
            int offersSize = offers.size();
            Message offersMessage = new Message();
            for (int i = 0; i < offersSize; ++i) {
                offersMessage.addMessage((Message)offers.get(i));
                if (i + 2 == offersSize) {
                    offersMessage.addMessage(ColorTheme.formatInfoTranslation("tport.command.transfer.list.lastDelimiter", new Object[0]));
                    continue;
                }
                offersMessage.addMessage(ColorTheme.formatInfoTranslation("tport.command.transfer.list.delimiter", new Object[0]));
            }
            offersMessage.removeLast();
            Message offeredPrefix = switch (offeredSize) {
                case 0 -> ColorTheme.formatInfoTranslation("tport.command.transfer.list.noOffered", new Object[0]);
                case 1 -> ColorTheme.formatInfoTranslation("tport.command.transfer.list.singleOffered", new Object[0]);
                default -> ColorTheme.formatInfoTranslation("tport.command.transfer.list.multipleOffered", new Object[0]);
            };
            Message offersPrefix = switch (offersSize) {
                case 0 -> ColorTheme.formatInfoTranslation("tport.command.transfer.list.noOffers", new Object[0]);
                case 1 -> ColorTheme.formatInfoTranslation("tport.command.transfer.list.singleOffer", new Object[0]);
                default -> ColorTheme.formatInfoTranslation("tport.command.transfer.list.multipleOffers", new Object[0]);
            };
            ColorTheme.sendInfoTranslation(player, "tport.command.transfer.list.succeeded", offeredPrefix, offeredMessage, offersPrefix, offersMessage);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport transfer list");
        }
    }
}

