/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.teleporter.create;

import com.spaceman.tport.Pair;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.featureTP.Mode;
import com.spaceman.tport.commands.tport.teleporter.Create;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.entity.Player;

public class FeatureTP
extends SubCommand {
    public FeatureTP() {
        EmptyCommand emptyFeatureTPModeFeature = new EmptyCommand();
        emptyFeatureTPModeFeature.setCommandName("feature", ArgumentType.REQUIRED);
        emptyFeatureTPModeFeature.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.featureTP.mode.feature.commandDescription", new Object[0]));
        emptyFeatureTPModeFeature.setTabRunnable((args, player) -> {
            ArrayList<String> list = new ArrayList<String>(com.spaceman.tport.commands.tport.FeatureTP.getFeatures(player.getWorld()));
            com.spaceman.tport.commands.tport.FeatureTP.getTags(player.getWorld()).stream().map(Pair::getLeft).forEach(list::add);
            List<String> featureList = Arrays.asList(args).subList(3, args.length).stream().map(String::toLowerCase).toList();
            return list.stream().filter(name -> featureList.stream().noneMatch(name::equalsIgnoreCase)).toList();
        });
        emptyFeatureTPModeFeature.setLooped(true);
        emptyFeatureTPModeFeature.setPermissions("TPort.teleporter.create");
        EmptyCommand emptyFeatureTPMode = new EmptyCommand();
        emptyFeatureTPMode.setCommandName("mode", ArgumentType.OPTIONAL);
        emptyFeatureTPMode.addAction(emptyFeatureTPModeFeature);
        EmptyCommand emptyFeatureTPFeature = new EmptyCommand();
        emptyFeatureTPFeature.setCommandName("feature", ArgumentType.OPTIONAL);
        emptyFeatureTPFeature.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.featureTP.feature.commandDescription", new Object[0]));
        emptyFeatureTPFeature.setTabRunnable(emptyFeatureTPModeFeature.getTabRunnable());
        emptyFeatureTPFeature.setPermissions("TPort.teleporter.create");
        emptyFeatureTPFeature.setLooped(true);
        this.addAction(emptyFeatureTPMode);
        this.addAction(emptyFeatureTPFeature);
        this.setPermissions("TPort.teleporter.create");
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.featureTP.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        ArrayList<String> list = new ArrayList<String>(com.spaceman.tport.commands.tport.FeatureTP.getFeatures(player.getWorld()));
        com.spaceman.tport.commands.tport.FeatureTP.getTags(player.getWorld()).stream().map(Pair::getLeft).forEach(list::add);
        Arrays.stream(Mode.WorldSearchMode.values()).map(Enum::name).forEach(list::add);
        return list;
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length > 2) {
            int startArgumentAt = 4;
            Mode.WorldSearchMode mode = null;
            if (args.length > 3) {
                mode = Mode.WorldSearchMode.getForPlayer(args[3].toUpperCase(), player, false);
            }
            if (mode == null) {
                --startArgumentAt;
            } else if (args.length == 4) {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport teleporter create featureTP [[mode] <featureType...>]");
                return;
            }
            List<String> features = com.spaceman.tport.commands.tport.FeatureTP.getFeatures(player.getWorld());
            List<Pair<String, List<String>>> tags = com.spaceman.tport.commands.tport.FeatureTP.getTags(player.getWorld());
            ArrayList<String> selectedFeatures = new ArrayList<String>(args.length - 2);
            block0: for (int i = startArgumentAt; i < args.length; ++i) {
                String argument = args[i].toLowerCase();
                if (argument.charAt(0) == '#') {
                    for (Pair pair : tags) {
                        if (!((String)pair.getLeft()).equals(argument)) continue;
                        for (String feature : (List)pair.getRight()) {
                            if (selectedFeatures.contains(feature)) {
                                ColorTheme.sendInfoTranslation(player, "tport.command.featureTP.search.tag.featureAlreadySelected", pair.getLeft(), feature);
                                continue;
                            }
                            selectedFeatures.add(feature);
                        }
                        continue block0;
                    }
                    ColorTheme.sendErrorTranslation(player, "tport.command.featureTP.search.tag.tagNotExist", argument);
                    continue;
                }
                for (String string : features) {
                    if (!string.equals(argument)) continue;
                    if (selectedFeatures.contains(string)) {
                        ColorTheme.sendErrorTranslation(player, "tport.command.featureTP.search.feature.featureAlreadySelected", string);
                        continue block0;
                    }
                    selectedFeatures.add(string);
                    continue block0;
                }
                ColorTheme.sendErrorTranslation(player, "tport.command.featureTP.search.feature.featureNotExist", argument);
            }
            ArrayList<Message> addedLore = new ArrayList<Message>();
            Object command = "featureTP";
            if (mode != null) {
                command = (String)command + " search " + mode.name();
                addedLore.add(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.features.mode", new Object[]{mode}));
            }
            if (!selectedFeatures.isEmpty()) {
                if (mode == null) {
                    command = (String)command + " search";
                }
                command = (String)command + " " + String.join((CharSequence)" ", selectedFeatures);
                for (int i = 0; i < selectedFeatures.size(); i += 2) {
                    Message message = new Message();
                    message.addText(TextComponent.textComponent(((String)selectedFeatures.get(i)).toLowerCase(), ColorTheme.ColorType.varInfoColor));
                    if (i + 1 < selectedFeatures.size()) {
                        if (i + 2 == selectedFeatures.size()) {
                            message.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.teleporter.create.format.data.features.lastDelimiter", new Object[0]));
                        } else {
                            message.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.teleporter.create.format.data.features.delimiter", new Object[0]));
                        }
                        message.addText(TextComponent.textComponent(((String)selectedFeatures.get(i + 1)).toLowerCase(), ColorTheme.ColorType.varInfo2Color));
                        if (i + 3 == selectedFeatures.size()) {
                            message.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.teleporter.create.format.data.features.lastDelimiter", new Object[0]));
                        } else if (i + 2 < selectedFeatures.size()) {
                            message.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.teleporter.create.format.data.features.delimiter", new Object[0]));
                        }
                    }
                    if (i == 0) {
                        if (selectedFeatures.size() == 1) {
                            addedLore.add(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.features.singular", message));
                            continue;
                        }
                        addedLore.add(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.features.multiple", message));
                        continue;
                    }
                    addedLore.add(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.features.newLine", message));
                }
            }
            Create.createTeleporter(player, "FeatureTP", (String)command, addedLore);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport teleporter create featureTP [[mode] <featureType...>]");
        }
    }
}

