/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.teleporter.create;

import com.spaceman.tport.biomeTP.BiomePreset;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.teleporter.Create;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.BiomeEncapsulation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.Player;

public class BiomeTP
extends SubCommand {
    private final EmptyCommand emptyBiomeTPEmpty = new EmptyCommand(){

        @Override
        public String getName(String argument) {
            return "";
        }
    };

    public BiomeTP() {
        this.emptyBiomeTPEmpty.setCommandName("", ArgumentType.FIXED);
        this.emptyBiomeTPEmpty.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.biomeTP.commandDescription", new Object[0]));
        this.emptyBiomeTPEmpty.setPermissions("TPort.teleporter.create");
        EmptyCommand emptyBiomeTPWhiteListBiome = new EmptyCommand();
        emptyBiomeTPWhiteListBiome.setCommandName("biome", ArgumentType.REQUIRED);
        emptyBiomeTPWhiteListBiome.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.biomeTP.whitelist.commandDescription", new Object[0]));
        emptyBiomeTPWhiteListBiome.setTabRunnable((args, player) -> {
            List biomeList = Arrays.asList(args).subList(4, args.length).stream().toList();
            return com.spaceman.tport.commands.tport.BiomeTP.availableBiomes(player.getWorld()).stream().filter(name -> biomeList.stream().noneMatch(name::equalsIgnoreCase)).toList();
        });
        emptyBiomeTPWhiteListBiome.setLooped(true);
        emptyBiomeTPWhiteListBiome.setPermissions("TPort.teleporter.create");
        EmptyCommand emptyBiomeTPWhitelist = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return this.getCommandName();
            }
        };
        emptyBiomeTPWhitelist.setCommandName("whitelist", ArgumentType.FIXED);
        emptyBiomeTPWhitelist.setTabRunnable(emptyBiomeTPWhiteListBiome.getTabRunnable());
        emptyBiomeTPWhitelist.addAction(emptyBiomeTPWhiteListBiome);
        EmptyCommand emptyBiomeTPBlackListBiome = new EmptyCommand();
        emptyBiomeTPBlackListBiome.setCommandName("biome", ArgumentType.REQUIRED);
        emptyBiomeTPBlackListBiome.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.biomeTP.blacklist.commandDescription", new Object[0]));
        emptyBiomeTPBlackListBiome.setTabRunnable((args, player) -> emptyBiomeTPWhiteListBiome.tabList(player, args));
        emptyBiomeTPBlackListBiome.setLooped(true);
        emptyBiomeTPBlackListBiome.setPermissions("TPort.teleporter.create");
        EmptyCommand emptyBiomeTPBlacklist = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return this.getCommandName();
            }
        };
        emptyBiomeTPBlacklist.setCommandName("blacklist", ArgumentType.FIXED);
        emptyBiomeTPBlacklist.setTabRunnable((args, player) -> emptyBiomeTPWhiteListBiome.tabList(player, args));
        emptyBiomeTPBlacklist.addAction(emptyBiomeTPBlackListBiome);
        EmptyCommand emptyBiomeTPPresetPreset = new EmptyCommand();
        emptyBiomeTPPresetPreset.setCommandName("preset", ArgumentType.OPTIONAL);
        emptyBiomeTPPresetPreset.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.biomeTP.preset.preset.commandDescription", new Object[0]));
        emptyBiomeTPPresetPreset.setPermissions("TPort.teleporter.create");
        EmptyCommand emptyBiomeTPPreset = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return this.getCommandName();
            }
        };
        emptyBiomeTPPreset.setCommandName("preset", ArgumentType.FIXED);
        emptyBiomeTPPreset.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.biomeTP.preset.commandDescription", new Object[0]));
        emptyBiomeTPPreset.setTabRunnable((args, player) -> BiomePreset.getNames(player.getWorld()));
        emptyBiomeTPPreset.addAction(emptyBiomeTPPresetPreset);
        emptyBiomeTPPreset.setPermissions("TPort.teleporter.create");
        EmptyCommand emptyBiomeTPRandom = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return this.getCommandName();
            }
        };
        emptyBiomeTPRandom.setCommandName("random", ArgumentType.FIXED);
        emptyBiomeTPRandom.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.biomeTP.random.commandDescription", new Object[0]));
        emptyBiomeTPRandom.setPermissions("TPort.teleporter.create");
        this.addAction(this.emptyBiomeTPEmpty);
        this.addAction(emptyBiomeTPWhitelist);
        this.addAction(emptyBiomeTPBlacklist);
        this.addAction(emptyBiomeTPPreset);
        this.addAction(emptyBiomeTPRandom);
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 3) {
            if (!this.emptyBiomeTPEmpty.hasPermissionToRun(player, true)) {
                return;
            }
            Create.createTeleporter(player, "BiomeTP", "BiomeTP");
            return;
        }
        if (args[3].equalsIgnoreCase("whitelist")) {
            if (args.length > 4) {
                if (!this.emptyBiomeTPEmpty.hasPermissionToRun(player, true)) {
                    return;
                }
                List<String> possibleBiomes = com.spaceman.tport.commands.tport.BiomeTP.availableBiomes();
                ArrayList<String> whitelist = new ArrayList<String>();
                for (int i = 4; i < args.length; ++i) {
                    String biomeName = args[i].toLowerCase();
                    BiomeEncapsulation biome = new BiomeEncapsulation(biomeName);
                    if (!possibleBiomes.contains(biomeName)) {
                        ColorTheme.sendErrorTranslation(player, "tport.command.teleporter.create.biomeTP.whitelist.biomeNotExist", biomeName);
                        continue;
                    }
                    if (whitelist.contains(biomeName)) {
                        ColorTheme.sendErrorTranslation(player, "tport.command.teleporter.create.biomeTP.whitelist.biomeAlreadyInList", biome);
                        continue;
                    }
                    whitelist.add(biomeName);
                }
                ArrayList<Message> addedLore = new ArrayList<Message>();
                addedLore.add(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.biomes.type", ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.teleporter.create.format.data.biomes.type.whitelist", new Object[0])));
                for (int i = 0; i < whitelist.size(); i += 2) {
                    Message m = new Message();
                    m.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "%s", new BiomeEncapsulation(((String)whitelist.get(i)).toLowerCase())));
                    if (i + 1 < whitelist.size()) {
                        if (i + 2 == whitelist.size()) {
                            m.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.teleporter.create.format.data.biomes.lastDelimiter", new Object[0]));
                        } else {
                            m.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.teleporter.create.format.data.biomes.delimiter", new Object[0]));
                        }
                        m.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfo2Color, ColorTheme.ColorType.varInfo2Color, "%s", new BiomeEncapsulation(((String)whitelist.get(i + 1)).toLowerCase())));
                        if (i + 3 == whitelist.size()) {
                            m.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.teleporter.create.format.data.biomes.lastDelimiter", new Object[0]));
                        } else if (i + 2 < whitelist.size()) {
                            m.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.teleporter.create.format.data.biomes.delimiter", new Object[0]));
                        }
                    }
                    if (i == 0) {
                        if (whitelist.size() == 1) {
                            addedLore.add(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.biomes.singular", m));
                            continue;
                        }
                        addedLore.add(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.biomes.multiple", m));
                        continue;
                    }
                    addedLore.add(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.biomes.newLine", m));
                }
                Create.createTeleporter(player, "BiomeTP", "BiomeTP whitelist " + String.join((CharSequence)" ", whitelist), addedLore);
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport teleporter create biomeTP whitelist <biome...>");
            }
        } else if (args[3].equalsIgnoreCase("blacklist")) {
            if (args.length > 4) {
                if (!this.emptyBiomeTPEmpty.hasPermissionToRun(player, true)) {
                    return;
                }
                List<String> possibleBiomes = com.spaceman.tport.commands.tport.BiomeTP.availableBiomes();
                ArrayList<String> blacklist = new ArrayList<String>();
                for (int i = 4; i < args.length; ++i) {
                    String biomeName = args[i].toLowerCase();
                    BiomeEncapsulation biome = new BiomeEncapsulation(biomeName);
                    if (!possibleBiomes.contains(biomeName)) {
                        ColorTheme.sendErrorTranslation(player, "tport.command.teleporter.create.biomeTP.blacklist.biomeNotExist", biomeName);
                        continue;
                    }
                    if (blacklist.contains(biomeName)) {
                        ColorTheme.sendErrorTranslation(player, "tport.command.teleporter.create.biomeTP.blacklist.biomeAlreadyInList", biome);
                        continue;
                    }
                    blacklist.add(biomeName);
                }
                ArrayList<Message> addedLore = new ArrayList<Message>();
                addedLore.add(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.biomes.type", ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.teleporter.create.format.data.biomes.type.blacklist", new Object[0])));
                for (int i = 0; i < blacklist.size(); i += 2) {
                    Message m = new Message();
                    m.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "%s", new BiomeEncapsulation(((String)blacklist.get(i)).toLowerCase())));
                    if (i + 1 < blacklist.size()) {
                        if (i + 2 == blacklist.size()) {
                            m.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.teleporter.create.format.data.biomes.lastDelimiter", new Object[0]));
                        } else {
                            m.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.teleporter.create.format.data.biomes.delimiter", new Object[0]));
                        }
                        m.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfo2Color, ColorTheme.ColorType.varInfo2Color, "%s", new BiomeEncapsulation(((String)blacklist.get(i + 1)).toLowerCase())));
                        if (i + 3 == blacklist.size()) {
                            m.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.teleporter.create.format.data.biomes.lastDelimiter", new Object[0]));
                        } else if (i + 2 < blacklist.size()) {
                            m.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.teleporter.create.format.data.biomes.delimiter", new Object[0]));
                        }
                    }
                    if (i == 0) {
                        if (blacklist.size() == 1) {
                            addedLore.add(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.biomes.singular", m));
                            continue;
                        }
                        addedLore.add(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.biomes.multiple", m));
                        continue;
                    }
                    addedLore.add(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.biomes.newLine", m));
                }
                Create.createTeleporter(player, "BiomeTP", "BiomeTP blacklist " + String.join((CharSequence)" ", blacklist), addedLore);
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport teleporter create biomeTP blacklist <biome...>");
            }
        } else if (args[3].equalsIgnoreCase("preset")) {
            if (args.length == 4) {
                if (!this.emptyBiomeTPEmpty.hasPermissionToRun(player, true)) {
                    return;
                }
                ArrayList<Message> pairs = new ArrayList<Message>();
                pairs.add(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.biomes.type", ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.teleporter.create.format.data.biomes.type.preset", new Object[0])));
                Create.createTeleporter(player, "BiomeTP", "BiomeTP preset", pairs);
            } else if (args.length == 5) {
                if (!this.emptyBiomeTPEmpty.hasPermissionToRun(player, true)) {
                    return;
                }
                BiomePreset preset = BiomePreset.getPreset(args[4], player.getWorld());
                if (preset != null) {
                    ArrayList<Message> pairs = new ArrayList<Message>();
                    pairs.add(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.biomes.type", ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.teleporter.create.format.data.biomes.type.preset", new Object[0])));
                    pairs.add(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.biomePreset", preset.name()));
                    Create.createTeleporter(player, "BiomeTP", "BiomeTP preset " + preset.name(), pairs);
                } else {
                    ColorTheme.sendErrorTranslation(player, "tport.command.teleporter.create.biomeTP.preset.preset.presetNotExist", args[4]);
                }
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport teleporter create biomeTP preset [preset]");
            }
        } else if (args[3].equalsIgnoreCase("random")) {
            if (args.length == 4) {
                if (!this.emptyBiomeTPEmpty.hasPermissionToRun(player, true)) {
                    return;
                }
                ArrayList<Message> pairs = new ArrayList<Message>();
                pairs.add(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.biomes.type", ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.teleporter.create.format.data.biomes.type.random", new Object[0])));
                Create.createTeleporter(player, "BiomeTP", "BiomeTP random", pairs);
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport teleporter create biomeTP random");
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport teleporter create biomeTP [whitelist|blacklist|preset|random]");
        }
    }
}

