/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.tag;

import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.commands.tport.Tag;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import java.util.ArrayList;
import org.bukkit.entity.Player;

public class List
extends SubCommand {
    public List() {
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.tag.list.commandDescription", new Object[0]));
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            ArrayList<String> tags = Tag.getTags();
            int size = tags.size();
            if (size == 0) {
                ColorTheme.sendInfoTranslation(player, "tport.command.tag.list.empty", "/tport tag reset", "/tport tag create <tag>");
                return;
            }
            Message tagsMessage = new Message();
            Message delimiter = ColorTheme.formatInfoTranslation("tport.command.tag.list.delimiter", new Object[0]);
            boolean color = true;
            for (int i = 0; i < size; ++i) {
                String tag = tags.get(i);
                TextComponent tagMessage = color ? TextComponent.textComponent(tag, ColorTheme.ColorType.varInfoColor) : TextComponent.textComponent(tag, ColorTheme.ColorType.varInfo2Color);
                if (Features.Feature.Permissions.isEnabled()) {
                    tagMessage.addTextEvent(new HoverEvent(ColorTheme.formatInfoTranslation("tport.command.tag.list.hoverText", "TPort.tags.type." + tag)));
                }
                color = !color;
                tagsMessage.addText(tagMessage);
                if (i + 2 == size) {
                    tagsMessage.addMessage(ColorTheme.formatInfoTranslation("tport.command.tag.list.lastDelimiter", new Object[0]));
                    continue;
                }
                tagsMessage.addMessage(delimiter);
            }
            tagsMessage.removeLast();
            ColorTheme.sendInfoTranslation(player, "tport.command.tag.list.succeeded", tagsMessage);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport tag list");
        }
    }
}

