/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.publc;

import com.spaceman.tport.Main;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.inventories.TPortInventories;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.stream.IntStream;
import org.bukkit.entity.Player;

public class Open
extends SubCommand {
    private final EmptyCommand emptyPage = new EmptyCommand();
    private final EmptyCommand emptyTPort;

    public Open() {
        this.emptyPage.setCommandName("page", ArgumentType.REQUIRED);
        this.emptyPage.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.public.open.page.commandDescription", new Object[0]));
        this.emptyPage.setPermissions("TPort.public.open.page", "TPort.basic");
        EmptyCommand emptyTPortSafetyCheck = new EmptyCommand(){

            @Override
            public Message permissionsHover() {
                return ColorTheme.formatInfoTranslation("tport.command.public.open.tport.safetyCheck.permissionHover", "TPort.public.open.tp", SafetyCheck.SafetyCheckSource.TPORT_PUBLIC.getPermission(), "TPort.basic");
            }
        };
        emptyTPortSafetyCheck.setCommandName("safetyCheck", ArgumentType.OPTIONAL);
        emptyTPortSafetyCheck.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.public.open.tport.safetyCheck.commandDescription", new Object[0]));
        emptyTPortSafetyCheck.setPermissions("TPort.public.open.tp", SafetyCheck.SafetyCheckSource.TPORT_PUBLIC.getPermission(), "TPort.basic");
        this.emptyTPort = new EmptyCommand();
        this.emptyTPort.setCommandName("TPort name", ArgumentType.REQUIRED);
        this.emptyTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.public.open.tport.commandDescription", new Object[0]));
        this.emptyTPort.setPermissions("TPort.public.open.tp", "TPort.basic");
        this.emptyTPort.addAction(emptyTPortSafetyCheck);
        this.emptyTPort.setTabRunnable((args, player) -> {
            if (!this.emptyTPort.hasPermissionToRun(player, false)) {
                return Collections.emptyList();
            }
            try {
                Integer.parseInt(args[args.length - 2]);
                return new ArrayList();
            }
            catch (NumberFormatException nfe) {
                return Arrays.asList("true", "false");
            }
        });
        this.addAction(this.emptyPage);
        this.addAction(this.emptyTPort);
    }

    public static TPort getPublicTPort(String name) {
        for (String publicTPortSlot : Files.tportData.getKeys("public.tports")) {
            String tportID = Files.tportData.getConfig().getString("public.tports." + publicTPortSlot, TPortManager.defUUID.toString());
            TPort tport = TPortManager.getTPort(UUID.fromString(tportID));
            if (tport == null || !tport.getName().equalsIgnoreCase(name)) continue;
            return tport;
        }
        return null;
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.emptyTPort.hasPermissionToRun(player, false)) {
            for (String publicTPortSlot : Files.tportData.getKeys("public.tports")) {
                String tportID = Files.tportData.getConfig().getString("public.tports." + publicTPortSlot, TPortManager.defUUID.toString());
                TPort tport = TPortManager.getTPort(UUID.fromString(tportID));
                if (tport == null) continue;
                list.add(tport.getName());
            }
        }
        if (this.emptyPage.hasPermissionToRun(player, false)) {
            IntStream.range(Math.min(1, list.size() / 7), Math.max(1, list.size() / 7)).mapToObj(i -> String.valueOf(i + 1)).forEach(list::add);
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(String[] args, Player player) {
        if (args.length == 3 || args.length == 4) {
            try {
                int page = Integer.parseInt(args[2]);
                if (args.length == 4) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport public open <page>");
                    return;
                }
                if (!this.emptyPage.hasPermissionToRun(player, true)) return;
                TPortInventories.openPublicTPortGUI(player, page - 1, null);
                return;
            }
            catch (NumberFormatException page) {
                Boolean safetyCheckState;
                if (!this.emptyTPort.hasPermissionToRun(player, true)) {
                    return;
                }
                TPort publicTPort = Open.getPublicTPort(args[2]);
                if (publicTPort == null) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.public.open.noPublicTPortFound", args[2]);
                    return;
                }
                if (args.length == 4) {
                    if (!SafetyCheck.SafetyCheckSource.TPORT_PUBLIC.hasPermission(player, true)) return;
                    safetyCheckState = Main.toBoolean(args[3]);
                    if (safetyCheckState == null) {
                        ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport public open <TPort name> [true|false]");
                        return;
                    }
                } else {
                    safetyCheckState = SafetyCheck.SafetyCheckSource.TPORT_PUBLIC.getState(player);
                }
                TPortAdvancement advancement = null;
                if (!publicTPort.getOwner().equals(player.getUniqueId())) {
                    advancement = TPortAdvancement.Advancement_whatsYoursIsMine;
                }
                publicTPort.teleport(player, safetyCheckState, advancement);
                return;
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport public open <TPort name|page>");
        }
    }
}

