/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.publc;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.entity.Player;

public class Move
extends SubCommand {
    private static final Move instance = new Move();
    public final EmptyCommand emptySlot = new EmptyCommand();

    public static Move getInstance() {
        return instance;
    }

    public Move() {
        this.emptySlot.setTabRunnable((args, player) -> {
            ArrayList<String> list = new ArrayList<String>();
            if (!this.emptySlot.hasPermissionToRun(player, false)) {
                return list;
            }
            for (String publicTPortSlot : Files.tportData.getKeys("public.tports")) {
                String tportID = Files.tportData.getConfig().getString("public.tports." + publicTPortSlot, TPortManager.defUUID.toString());
                TPort tport = TPortManager.getTPort(UUID.fromString(tportID));
                if (tport == null || tport.getName().equalsIgnoreCase(args[2])) continue;
                list.add(tport.getName());
                try {
                    int slot = Integer.parseInt(publicTPortSlot) + 1;
                    list.add(String.valueOf(slot));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return list;
        });
        this.emptySlot.setCommandName("slot", ArgumentType.REQUIRED);
        this.emptySlot.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.public.move.slot.commandDescription", new Object[0]));
        this.emptySlot.setPermissions("TPort.public.move", "TPort.admin.public");
        EmptyCommand emptyTPortTport = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return "";
            }
        };
        emptyTPortTport.setCommandName("TPort name", ArgumentType.REQUIRED);
        emptyTPortTport.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.public.move.TPort.commandDescription", new Object[0]));
        emptyTPortTport.setPermissions(this.emptySlot.getPermissions());
        EmptyCommand emptyTPort = new EmptyCommand();
        emptyTPort.setCommandName("TPort name", ArgumentType.REQUIRED);
        emptyTPort.addAction(this.emptySlot);
        emptyTPort.addAction(emptyTPortTport);
        this.addAction(emptyTPort);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.emptySlot.hasPermissionToRun(player, false)) {
            return list;
        }
        for (String publicTPortSlot : Files.tportData.getKeys("public.tports")) {
            String tportID = Files.tportData.getConfig().getString("public.tports." + publicTPortSlot, TPortManager.defUUID.toString());
            TPort tport = TPortManager.getTPort(UUID.fromString(tportID));
            if (tport == null) continue;
            list.add(tport.getName());
        }
        return list;
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length != 4) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport public move <TPort name> <slot|TPort name>");
            return;
        }
        if (!this.emptySlot.hasPermissionToRun(player, true)) {
            return;
        }
        for (String publicTPortSlot : Files.tportData.getKeys("public.tports")) {
            String tportID = Files.tportData.getConfig().getString("public.tports." + publicTPortSlot, TPortManager.defUUID.toString());
            TPort tport = TPortManager.getTPort(UUID.fromString(tportID));
            if (tport == null || !tport.getName().equalsIgnoreCase(args[2])) continue;
            try {
                int slot = Integer.parseInt(args[3]) - 1;
                if (!Files.tportData.getConfig().contains("public.tports." + slot)) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.public.move.TPortSlotNotFound", String.valueOf(slot + 1));
                    continue;
                }
                String tportID2 = Files.tportData.getConfig().getString("public.tports." + slot, TPortManager.defUUID.toString());
                TPort tport2 = TPortManager.getTPort(UUID.fromString(tportID2));
                if (tport2 == null) {
                    Files.tportData.getConfig().set("public.tports." + slot, (Object)tportID);
                    ColorTheme.sendSuccessTranslation(player, "tport.command.public.move.succeededMoved", TPortEncapsulation.asTPort(tport), String.valueOf(slot + 1));
                } else {
                    Files.tportData.getConfig().set("public.tports." + publicTPortSlot, (Object)Files.tportData.getConfig().getString("public.tports." + slot));
                    Files.tportData.getConfig().set("public.tports." + slot, (Object)tportID);
                    ColorTheme.sendSuccessTranslation(player, "tport.command.public.move.succeeded", TPortEncapsulation.asTPort(tport.parseAsPublic(true)), TPortEncapsulation.asTPort(tport2.parseAsPublic(true)));
                }
                Files.tportData.saveConfig();
                return;
            }
            catch (NumberFormatException nfe) {
                for (String publicTPortSlot2 : Files.tportData.getKeys("public.tports")) {
                    String tportID2 = Files.tportData.getConfig().getString("public.tports." + publicTPortSlot2, TPortManager.defUUID.toString());
                    TPort tport2 = TPortManager.getTPort(UUID.fromString(tportID2));
                    if (tport2 == null || !tport2.getName().equalsIgnoreCase(args[3])) continue;
                    Files.tportData.getConfig().set("public.tports." + publicTPortSlot, (Object)Files.tportData.getConfig().getString("public.tports." + publicTPortSlot2));
                    Files.tportData.getConfig().set("public.tports." + publicTPortSlot2, (Object)tportID);
                    ColorTheme.sendSuccessTranslation(player, "tport.command.public.move.succeeded", TPortEncapsulation.asTPort(tport.parseAsPublic(true)), TPortEncapsulation.asTPort(tport2.parseAsPublic(true)));
                    Files.tportData.saveConfig();
                    return;
                }
                ColorTheme.sendErrorTranslation(player, "tport.command.public.TPortNotFound", args[3]);
                return;
            }
        }
        ColorTheme.sendErrorTranslation(player, "tport.command.public.TPortNotFound", args[2]);
    }
}

