/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.publc;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.entity.Player;

public class List
extends SubCommand {
    public List() {
        EmptyCommand emptyOwn = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return "Own";
            }
        };
        emptyOwn.setCommandName("own", ArgumentType.FIXED);
        emptyOwn.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.public.list.own.commandDescription", new Object[0]));
        EmptyCommand emptyAll = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return "All";
            }
        };
        emptyAll.setCommandName("all", ArgumentType.FIXED);
        emptyAll.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.public.list.all.commandDescription", new Object[0]));
        EmptyCommand empty = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return "";
            }
        };
        empty.setCommandName("", ArgumentType.FIXED);
        empty.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.public.list.all.commandDescription", new Object[0]));
        this.addAction(empty);
        this.addAction(emptyOwn);
        this.addAction(emptyAll);
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            this.sendPublicTPorts(player, false);
        } else if (args.length == 3) {
            if (args[2].equalsIgnoreCase("all")) {
                this.sendPublicTPorts(player, false);
            } else if (args[2].equalsIgnoreCase("own")) {
                this.sendPublicTPorts(player, true);
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport public list [own|all]");
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport public list [own|all]");
        }
    }

    private void sendPublicTPorts(Player player, boolean filterOwn) {
        String t;
        Message publicTPortList = new Message();
        boolean hasPublicTPorts = false;
        boolean color = true;
        Collection<String> keys = Files.tportData.getKeys("public.tports");
        int lastDelimiterIndex = keys.size() - 1;
        Message delimiter = ColorTheme.formatInfoTranslation("tport.command.public.list.delimiter", new Object[0]);
        int index = 0;
        for (String publicTPortSlot : Files.tportData.getKeys("public.tports")) {
            String tportID = Files.tportData.getConfig().getString("public.tports." + publicTPortSlot, TPortManager.defUUID.toString());
            TPort tport = TPortManager.getTPort(UUID.fromString(tportID));
            if (tport != null && (!filterOwn || tport.getOwner().equals(player.getUniqueId()))) {
                hasPublicTPorts = true;
                if (color) {
                    publicTPortList.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "%s", TPortEncapsulation.asTPort(tport.parseAsPublic(true))));
                } else {
                    publicTPortList.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfo2Color, ColorTheme.ColorType.varInfo2Color, "%s", TPortEncapsulation.asTPort(tport.parseAsPublic(true))));
                }
                boolean bl = color = !color;
                if (index + 1 == lastDelimiterIndex) {
                    publicTPortList.addMessage(ColorTheme.formatInfoTranslation("tport.command.public.list.lastDelimiter", new Object[0]));
                } else {
                    publicTPortList.addMessage(delimiter);
                }
            }
            ++index;
        }
        publicTPortList.removeLast();
        String string = t = filterOwn ? "own" : "all";
        if (!hasPublicTPorts) {
            ColorTheme.sendInfoTranslation(player, "tport.command.public.list." + t + ".hasNone", new Object[0]);
        } else {
            ColorTheme.sendInfoTranslation(player, "tport.command.public.list." + t + ".succeeded", publicTPortList);
        }
    }
}

