/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.pltp;

import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.commands.tport.pltp.Consent;
import com.spaceman.tport.commands.tport.pltp.Offset;
import com.spaceman.tport.commands.tport.pltp.State;
import com.spaceman.tport.commands.tport.pltp.Whitelist;
import com.spaceman.tport.cooldown.CooldownManager;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tpEvents.TPEManager;
import com.spaceman.tport.tpEvents.TPRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TP
extends SubCommand {
    private final EmptyCommand emptyPlayer;

    public TP() {
        EmptyCommand emptyPlayerSafetyCheck = new EmptyCommand(){

            @Override
            public Message permissionsHover() {
                return ColorTheme.formatInfoTranslation("tport.command.PLTP.TP.player.safetyCheck.permissionHover", "TPort.PLTP.tp", SafetyCheck.SafetyCheckSource.PLTP.getPermission(), "TPort.basic");
            }
        };
        emptyPlayerSafetyCheck.setCommandName("safetyCheck", ArgumentType.OPTIONAL);
        emptyPlayerSafetyCheck.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.PLTP.TP.player.safetyCheck.commandDescription", new Object[0]));
        emptyPlayerSafetyCheck.setPermissions("TPort.own", SafetyCheck.SafetyCheckSource.PLTP.getPermission(), "TPort.basic");
        this.emptyPlayer = new EmptyCommand();
        this.emptyPlayer.setCommandName("player", ArgumentType.REQUIRED);
        this.emptyPlayer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.PLTP.TP.player.commandDescription", new Object[0]));
        this.emptyPlayer.setPermissions("TPort.PLTP.tp", "TPort.basic");
        this.emptyPlayer.setTabRunnable((args, player) -> {
            if (emptyPlayerSafetyCheck.hasPermissionToRun(player, false)) {
                return List.of("true", "false");
            }
            return Collections.emptyList();
        });
        this.emptyPlayer.addAction(emptyPlayerSafetyCheck);
        this.addAction(this.emptyPlayer);
    }

    @Override
    public String getName(String arg) {
        return "tp";
    }

    public List<String> tabList(Player player, String[] args) {
        if (!this.emptyPlayer.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(String[] args, Player player) {
        Boolean safetyCheckState;
        if (args.length != 3 && args.length != 4) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport PLTP tp <player> [safetyCheck]");
            return;
        }
        if (!this.emptyPlayer.hasPermissionToRun(player, true)) {
            return;
        }
        UUID newPlayerUUID = PlayerUUID.getPlayerUUID(args[2], player);
        if (newPlayerUUID == null) {
            return;
        }
        Player warpTo = Bukkit.getPlayer((UUID)newPlayerUUID);
        if (warpTo == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.playerNotOnline", PlayerEncapsulation.asPlayer(newPlayerUUID));
            return;
        }
        ArrayList<String> whitelist = Whitelist.getPLTPWhitelist(warpTo);
        if (!State.getPLTPState(warpTo) && !whitelist.contains(player.getUniqueId().toString())) {
            ColorTheme.sendErrorTranslation(player, "tport.command.PLTP.TP.player.setOffNotWhitelisted", warpTo);
            return;
        }
        if (args.length == 4) {
            if (!SafetyCheck.SafetyCheckSource.PLTP.hasPermission(player, true)) return;
            safetyCheckState = Main.toBoolean(args[3]);
            if (safetyCheckState == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport PLTP tp <player> [true|false]");
                return;
            }
        } else {
            safetyCheckState = SafetyCheck.SafetyCheckSource.PLTP.getState(player);
        }
        if (Consent.shouldAskConsent(warpTo) && !whitelist.contains(player.getUniqueId().toString())) {
            if (!CooldownManager.PlayerTP.hasCooled(player, true)) {
                return;
            }
            if (TPRequest.hasRequest(player, true)) {
                return;
            }
            TPRequest.createPLTPRequest(player.getUniqueId(), warpTo.getUniqueId(), safetyCheckState);
            Message accept = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.requests.here", new Object[0]);
            accept.addTextEvent(ClickEvent.runCommand("/tport requests accept " + player.getName()));
            accept.addTextEvent(new HoverEvent(TextComponent.textComponent("/tport requests accept " + player.getName(), ColorTheme.ColorType.infoColor)));
            Message reject = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.requests.here", new Object[0]);
            reject.addTextEvent(ClickEvent.runCommand("/tport requests reject " + player.getName()));
            reject.addTextEvent(new HoverEvent(TextComponent.textComponent("/tport requests reject " + player.getName(), ColorTheme.ColorType.infoColor)));
            Message revoke = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.requests.here", new Object[0]);
            revoke.addTextEvent(ClickEvent.runCommand("/tport requests revoke"));
            revoke.addTextEvent(new HoverEvent(TextComponent.textComponent("/tport requests revoke", ColorTheme.ColorType.infoColor)));
            ColorTheme.sendInfoTranslation(warpTo, "tport.command.PLTP.TP.player.askConsent", player, accept, reject);
            ColorTheme.sendInfoTranslation(player, "tport.command.PLTP.TP.player.consentAsked", warpTo, "true", revoke);
            return;
        }
        TP.tp(player, warpTo, safetyCheckState, false);
    }

    public static boolean tp(Player player, Player toPlayer, boolean safetyCheck, boolean requested) {
        if (!CooldownManager.PlayerTP.hasCooled(player)) {
            return false;
        }
        if (safetyCheck && !SafetyCheck.isSafe(Offset.getPLTPOffset(player).applyOffset(toPlayer.getLocation()))) {
            ColorTheme.sendErrorTranslation(player, "tport.command.PLTP.TP.player.notSafe", PlayerEncapsulation.asPlayer(toPlayer));
            if (requested) {
                ColorTheme.sendErrorTranslation(toPlayer, "tport.command.PLTP.TP.player.notSafeOtherPlayer", PlayerEncapsulation.asPlayer(player));
            }
            return false;
        }
        TPEManager.tpPlayerToPlayer(player, toPlayer, () -> {
            ColorTheme.sendSuccessTranslation(Bukkit.getPlayer((UUID)player.getUniqueId()), "tport.command.PLTP.TP.player.succeeded", PlayerEncapsulation.asPlayer(toPlayer));
            ColorTheme.sendInfoTranslation(Bukkit.getPlayer((UUID)toPlayer.getUniqueId()), "tport.command.PLTP.TP.player.succeededOtherPlayer", PlayerEncapsulation.asPlayer(player));
        }, (p, delay, tickMessage, seconds, secondMessage) -> {
            ColorTheme.sendSuccessTranslation(p, "tport.command.PLTP.TP.player.succeededRequested", PlayerEncapsulation.asPlayer(toPlayer), delay, tickMessage, seconds, secondMessage);
            ColorTheme.sendInfoTranslation(toPlayer, "tport.command.PLTP.TP.player.succeededOtherPlayerRequested", p, delay, tickMessage, seconds, secondMessage);
        });
        CooldownManager.PlayerTP.update(player);
        return true;
    }
}

