/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.pltp;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.MessageUtils;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.inventories.SettingsInventories;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class Preview
extends SubCommand {
    private final EmptyCommand emptyPreviewState = new EmptyCommand();

    public Preview() {
        this.emptyPreviewState.setCommandName("state", ArgumentType.OPTIONAL);
        this.emptyPreviewState.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.pltp.preview.state.commandDescription", new Object[0]));
        this.emptyPreviewState.setPermissions("TPort.pltp.preview.set", "TPort.basic");
        this.addAction(this.emptyPreviewState);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.pltp.preview.commandDescription", new Object[0]));
    }

    public List<String> tabList(Player player, String[] args) {
        if (!this.emptyPreviewState.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Arrays.stream(PreviewState.values()).map(s -> s.name().toLowerCase()).collect(Collectors.toList());
    }

    public static PreviewState getPreviewState(UUID uuid) {
        PreviewState def = PreviewState.ON;
        return PreviewState.get(Files.tportData.getConfig().getString("tport." + String.valueOf(uuid) + ".tp.previewState", def.name()), def);
    }

    public static void setPreviewState(UUID uuid, PreviewState previewState) {
        Files.tportData.getConfig().set("tport." + String.valueOf(uuid) + ".tp.previewState", (Object)previewState.name());
        Files.tportData.saveConfig();
    }

    @Override
    public void run(String[] args, Player player) {
        if (Features.Feature.Preview.isDisabled()) {
            Features.Feature.Preview.sendDisabledMessage(player);
            return;
        }
        if (args.length == 2) {
            ColorTheme.sendInfoTranslation(player, "tport.command.pltp.preview.succeeded", Preview.getPreviewState(player.getUniqueId()));
        } else if (args.length == 3) {
            if (!this.emptyPreviewState.hasPermissionToRun(player, true)) {
                return;
            }
            PreviewState previewState = PreviewState.get(args[2], null);
            if (previewState == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.pltp.preview.state.stateNotFound", args[2]);
                return;
            }
            Preview.setPreviewState(player.getUniqueId(), previewState);
            ColorTheme.sendSuccessTranslation(player, "tport.command.pltp.preview.state.succeeded", previewState);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport PLTP preview [state]");
        }
    }

    public static enum PreviewState implements MessageUtils.MessageDescription
    {
        ON(String.valueOf(ChatColor.GREEN) + "on", SettingsInventories.settings_pltp_preview_on_model),
        OFF(String.valueOf(ChatColor.RED) + "off", SettingsInventories.settings_pltp_preview_off_model),
        NOTIFIED(String.valueOf(ChatColor.YELLOW) + "notified", SettingsInventories.settings_pltp_preview_notified_model);

        private final String displayName;
        private final InventoryModel model;

        private PreviewState(String displayName, InventoryModel model) {
            this.displayName = displayName;
            this.model = model;
        }

        public InventoryModel getModel() {
            if (Features.Feature.PLTP.isDisabled() || Features.Feature.Preview.isDisabled()) {
                return SettingsInventories.settings_pltp_preview_grayed_model;
            }
            return this.model;
        }

        @Nullable
        public static PreviewState get(@Nullable String name, PreviewState def) {
            try {
                return PreviewState.valueOf(name != null ? name.toUpperCase() : ON.name());
            }
            catch (IllegalArgumentException | NullPointerException iae) {
                return def;
            }
        }

        public PreviewState getNext() {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> OFF;
                case 1 -> NOTIFIED;
                case 2 -> ON;
            };
        }

        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public Message getDescription() {
            return ColorTheme.formatInfoTranslation("tport.command.pltp.previewState." + this.name() + ".description", this.getDisplayName());
        }

        @Override
        public Message getName(String ignore_color, String ignore_varColor) {
            return new Message(new TextComponent(this.getDisplayName()));
        }

        @Override
        public String getInsertion() {
            return this.name();
        }
    }
}

