/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.pltp;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.MessageUtils;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.inventories.SettingsInventories;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class Offset
extends SubCommand {
    public Offset() {
        EmptyCommand emptyOffset = new EmptyCommand();
        emptyOffset.setCommandName("offset", ArgumentType.OPTIONAL);
        emptyOffset.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.PLTP.offset.offset.commandDescription", new Object[0]));
        this.addAction(emptyOffset);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.PLTP.offset.commandDescription", "IN", "BEHIND"));
    }

    public static PLTPOffset getPLTPOffset(Player player) {
        return PLTPOffset.valueOf(Files.tportData.getConfig().getString("tport." + String.valueOf(player.getUniqueId()) + ".tp.offset", "IN"));
    }

    public static void setPLTPOffset(Player player, PLTPOffset offset) {
        Files.tportData.getConfig().set("tport." + String.valueOf(player.getUniqueId()) + ".tp.offset", (Object)offset.name());
        Files.tportData.saveConfig();
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return Arrays.stream(PLTPOffset.values()).map(Enum::name).collect(Collectors.toList());
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            ColorTheme.sendInfoTranslation(player, "tport.command.PLTP.offset.succeeded", Offset.getPLTPOffset(player));
        } else if (args.length == 3) {
            PLTPOffset newOffset = PLTPOffset.get(args[2]);
            if (newOffset == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.PLTP.offset.offset.offsetNotExist", args[2]);
                return;
            }
            Offset.setPLTPOffset(player, newOffset);
            ColorTheme.sendSuccessTranslation(player, "tport.command.PLTP.offset.offset.succeeded", newOffset);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport PLTP offset [offset]");
        }
    }

    public static enum PLTPOffset implements MessageUtils.MessageDescription
    {
        IN(origin -> origin, SettingsInventories.settings_pltp_offset_in_model),
        BEHIND(origin -> {
            Location location = origin.clone();
            location.setPitch(0.0f);
            location = location.add(location.getDirection().multiply(-1));
            location.setPitch(origin.getPitch());
            return SafetyCheck.isSafe(location) ? location : origin;
        }, SettingsInventories.settings_pltp_offset_behind_model);

        private final OffsetApplier offsetApplier;
        private final InventoryModel model;

        private PLTPOffset(OffsetApplier offsetApplier, InventoryModel model) {
            this.offsetApplier = offsetApplier;
            this.model = model;
        }

        public Location applyOffset(Location origin) {
            return this.offsetApplier.ApplyOffset(origin);
        }

        public static PLTPOffset get(String name) {
            for (PLTPOffset offset : PLTPOffset.values()) {
                if (!offset.name().equalsIgnoreCase(name)) continue;
                return offset;
            }
            return null;
        }

        public PLTPOffset getNext() {
            boolean next = false;
            for (PLTPOffset offset : PLTPOffset.values()) {
                if (offset.equals(this)) {
                    next = true;
                    continue;
                }
                if (!next) continue;
                return offset;
            }
            return Arrays.asList(PLTPOffset.values()).get(0);
        }

        @Override
        public Message getDescription() {
            return ColorTheme.formatInfoTranslation("tport.command.PLTP.offset.PLTPOffset." + this.name() + ".description", this.name());
        }

        @Override
        public Message getName(String color, String varColor) {
            return new Message(new TextComponent(this.name(), varColor));
        }

        @Override
        public String getInsertion() {
            return this.name();
        }

        public InventoryModel getModel() {
            if (Features.Feature.PLTP.isDisabled()) {
                return SettingsInventories.settings_pltp_offset_grayed_model;
            }
            return this.model;
        }

        @FunctionalInterface
        private static interface OffsetApplier {
            public Location ApplyOffset(Location var1);
        }
    }
}

