/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.pa;

import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.tpEvents.ParticleAnimation;
import java.util.Set;
import org.bukkit.entity.Player;

public class List
extends SubCommand {
    public List() {
        this.setPermissions("TPort.particleAnimation.list");
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.particleAnimationCommand.list.commandDescription", new Object[0]));
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            if (!this.hasPermissionToRun(player, true)) {
                return;
            }
            Message animationsMessage = new Message();
            boolean color = true;
            Set<String> particleAnimations = ParticleAnimation.getAnimations();
            int i = particleAnimations.size();
            for (String pa : particleAnimations) {
                ParticleAnimation particleAnimation = ParticleAnimation.getNewAnimation(pa);
                HoverEvent hEvent = new HoverEvent(particleAnimation.getDescription());
                animationsMessage.addText(TextComponent.textComponent(pa, color ? ColorTheme.ColorType.varInfoColor : ColorTheme.ColorType.varInfo2Color, hEvent));
                if (i == 2) {
                    animationsMessage.addMessage(ColorTheme.formatInfoTranslation("tport.command.particleAnimationCommand.list.lastDelimiter", new Object[0]));
                } else {
                    animationsMessage.addMessage(ColorTheme.formatInfoTranslation("tport.command.particleAnimationCommand.list.delimiter", new Object[0]));
                }
                --i;
                color = !color;
            }
            animationsMessage.removeLast();
            ColorTheme.sendInfoTranslation(player, "tport.command.particleAnimationCommand.list.succeeded", animationsMessage);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport particleAnimation list");
        }
    }
}

