/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.mainLayout;

import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.MainLayout;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.bukkit.entity.Player;

public class Players
extends SubCommand {
    private static final Players instance = new Players();
    public final EmptyCommand emptyPlayersState = new EmptyCommand();

    public static Players getInstance() {
        return instance;
    }

    private Players() {
        this.emptyPlayersState.setCommandName("state", ArgumentType.OPTIONAL);
        this.emptyPlayersState.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.mainLayout.players.state.commandDescription", new Object[0]));
        this.emptyPlayersState.setPermissions("TPort.mainLayout.players");
        this.addAction(this.emptyPlayersState);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.mainLayout.players.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyPlayersState.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Arrays.asList("true", "false");
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            ColorTheme.sendInfoTranslation(player, "tport.command.mainLayout.players.succeeded", ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.mainLayout." + (MainLayout.showPlayers(player) ? "show" : "hide"), new Object[0]));
        } else if (args.length == 3) {
            if (!this.emptyPlayersState.hasPermissionToRun(player, true)) {
                return;
            }
            Boolean state = Main.toBoolean(args[2]);
            if (state == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport mainLayout players [true|false]");
                return;
            }
            MainLayout.showPlayers(player, state);
            ColorTheme.sendSuccessTranslation(player, "tport.command.mainLayout.players.state.succeeded", ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.mainLayout." + (state != false ? "show" : "hide"), new Object[0]));
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport mainLayout players [state]");
        }
    }
}

