/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.log;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.TextType;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fileHander.Files;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.bukkit.entity.Player;

public class TimeFormat
extends SubCommand {
    public static final String defaultTimeFormat = "EEE MMM dd HH:mm:ss zzz yyyy";

    public TimeFormat() {
        EmptyCommand emptyFormat = new EmptyCommand();
        emptyFormat.setCommandName("format...", ArgumentType.OPTIONAL);
        emptyFormat.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.log.timeFormat.format.commandDescription", new Object[0]));
        this.addAction(emptyFormat);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.log.timeFormat.commandDescription", new Object[0]));
    }

    public static String getFormatExample(Player player, String timeFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(timeFormat);
        sdf.setTimeZone(TimeZone.getTimeZone(Files.tportData.getConfig().getString("tport." + String.valueOf(player.getUniqueId()) + ".timeZone", TimeZone.getDefault().getID())));
        return sdf.format(Calendar.getInstance().getTime());
    }

    public static String getTimeFormat(Player player) {
        return Files.tportData.getConfig().getString("tport." + String.valueOf(player.getUniqueId()) + ".timeFormat", defaultTimeFormat);
    }

    public static void setTimeFormat(Player player, String format) {
        Files.tportData.getConfig().set("tport." + String.valueOf(player.getUniqueId()) + ".timeFormat", (Object)format);
        Files.tportData.saveConfig();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            String timeFormat = TimeFormat.getTimeFormat(player);
            Message here = new Message();
            here.addText(TextComponent.textComponent("tport.command.log.timeFormat.here", ColorTheme.ColorType.varInfoColor, ClickEvent.runCommand("/tport log timeFormat EEE MMM dd HH:mm:ss zzz yyyy"), new HoverEvent(TextComponent.textComponent("/tport log timeFormat EEE MMM dd HH:mm:ss zzz yyyy", ColorTheme.ColorType.infoColor))).setType(TextType.TRANSLATE));
            ColorTheme.sendInfoTranslation(player, "tport.command.log.timeFormat.succeeded", timeFormat, TimeFormat.getFormatExample(player, timeFormat), here);
        } else if (args.length > 2) {
            StringBuilder str = new StringBuilder();
            for (int i = 2; i < args.length; ++i) {
                str.append(args[i]).append(" ");
            }
            String format = str.toString().trim();
            try {
                new SimpleDateFormat(format);
            }
            catch (IllegalArgumentException iae) {
                Message here = new Message();
                here.addText(TextComponent.textComponent("tport.command.log.timeFormat.format.here", ColorTheme.ColorType.varInfoColor, ClickEvent.openUrl("https://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html"), new HoverEvent(TextComponent.textComponent("https://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html", ColorTheme.ColorType.infoColor))).setType(TextType.TRANSLATE));
                ColorTheme.sendErrorTranslation(player, "tport.command.log.timeFormat.format.invalidFormat", here);
                return;
            }
            TimeFormat.setTimeFormat(player, format);
            ColorTheme.sendSuccessTranslation(player, "tport.command.log.timeFormat.format.succeeded", format, TimeFormat.getFormatExample(player, format));
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport log timeFormat [format...]");
        }
    }
}

